/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sam;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class SAMInfoViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 202015030001L;
    private JComponent header;
    private JTextArea content;
    private int studyDesign;

    public SAMInfoViewer(int[][] nArray, int n, int n2) {
        this.studyDesign = n2;
        this.header = this.createHeader();
        this.content = this.createContent(nArray, n);
        this.setMaxWidth(this.content, this.header);
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Cluster Information</b></font></body></html>"), gridBagConstraints);
        return jPanel;
    }

    private JTextArea createContent(int[][] nArray, int n) {
        JTextArea jTextArea = new JTextArea(nArray.length * 3, 20);
        jTextArea.setEditable(false);
        jTextArea.setMargin(new Insets(0, 10, 0, 0));
        StringBuffer stringBuffer = new StringBuffer(nArray.length * 3 * 10);
        if (this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 7 || this.studyDesign == 8) {
            for (int i = 0; i < nArray.length; ++i) {
                if (i == 0) {
                    stringBuffer.append("Positive Significant Genes ");
                    stringBuffer.append("\t");
                    stringBuffer.append("# of Positive Significant Genes: " + nArray[i].length);
                    stringBuffer.append("\n\t\t");
                    stringBuffer.append("% of Positive Significant Genes: " + Math.round((float)nArray[i].length / (float)n * 100.0f) + "%");
                    stringBuffer.append("\n\n");
                    continue;
                }
                if (i == 1) {
                    stringBuffer.append("Negative Significant Genes ");
                    stringBuffer.append("\t");
                    stringBuffer.append("# of Negative Significant Genes: " + nArray[i].length);
                    stringBuffer.append("\n\t\t");
                    stringBuffer.append("% of Negative Significant Genes: " + Math.round((float)nArray[i].length / (float)n * 100.0f) + "%");
                    stringBuffer.append("\n\n");
                    continue;
                }
                if (i == 2) {
                    stringBuffer.append("All Significant Genes ");
                    stringBuffer.append("\t");
                    stringBuffer.append("Total # of Significant Genes: " + nArray[i].length);
                    stringBuffer.append("\n\t\t");
                    stringBuffer.append("% of Genes that are Significant: " + Math.round((float)nArray[i].length / (float)n * 100.0f) + "%");
                    stringBuffer.append("\n\n");
                    continue;
                }
                if (i != 3) continue;
                stringBuffer.append("Non-Significant Genes ");
                stringBuffer.append("\t");
                stringBuffer.append("Total # of Non-Significant Genes: " + nArray[i].length);
                stringBuffer.append("\n\t\t");
                stringBuffer.append("% of Genes that are Not Significant: " + Math.round((float)nArray[i].length / (float)n * 100.0f) + "%");
                stringBuffer.append("\n\n");
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                if (i == 0) {
                    stringBuffer.append("Significant Genes ");
                    stringBuffer.append("\t");
                    stringBuffer.append("# of Significant Genes: " + nArray[i].length);
                    stringBuffer.append("\n\t\t");
                    stringBuffer.append("% of Significant Genes: " + Math.round((float)nArray[i].length / (float)n * 100.0f) + "%");
                    stringBuffer.append("\n\n");
                    continue;
                }
                if (i != 1) continue;
                stringBuffer.append("Non-significant Genes ");
                stringBuffer.append("\t");
                stringBuffer.append("# of Non-significant Genes: " + nArray[i].length);
                stringBuffer.append("\n\t\t");
                stringBuffer.append("% of Non-significant Genes: " + Math.round((float)nArray[i].length / (float)n * 100.0f) + "%");
                stringBuffer.append("\n\n");
            }
        }
        jTextArea.setText(stringBuffer.toString());
        jTextArea.setCaretPosition(0);
        return jTextArea;
    }

    private void setMaxWidth(JComponent jComponent, JComponent jComponent2) {
        int n = jComponent.getPreferredSize().width;
        int n2 = jComponent2.getPreferredSize().width;
        if (n > n2) {
            jComponent2.setPreferredSize(new Dimension(n, jComponent2.getPreferredSize().height));
        } else {
            jComponent.setPreferredSize(new Dimension(n2, jComponent.getPreferredSize().height));
        }
    }
}

