/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.qtc;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.qtc.QTCCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.qtc.QTCCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.qtc.QTCExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.qtc.QTCExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.qtc.QTCExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.qtc.QTCExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.qtc.QTCInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.qtc.QTCInitDialog;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class QTCGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private IData data;
    private Experiment experiment;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    private boolean clusterGenes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block12: {
            AlgorithmParameters algorithmParameters;
            long l;
            AlgorithmData algorithmData;
            Object object;
            boolean bl;
            boolean bl2;
            int n;
            boolean bl3;
            int n2;
            IDistanceMenu iDistanceMenu;
            boolean bl4;
            float f;
            int n3;
            block10: {
                DefaultMutableTreeNode defaultMutableTreeNode2;
                block11: {
                    this.data = iFramework.getData();
                    n3 = 5;
                    f = 0.2f;
                    bl4 = false;
                    boolean bl5 = true;
                    iDistanceMenu = iFramework.getDistanceMenu();
                    n2 = iDistanceMenu.getDistanceFunction();
                    if (n2 == 0) {
                        n2 = 1;
                    }
                    QTCInitDialog qTCInitDialog = new QTCInitDialog((JFrame)iFramework.getFrame(), bl5, iDistanceMenu.getFunctionName(n2), iDistanceMenu.isAbsoluteDistance());
                    qTCInitDialog.setVisible(true);
                    if (!qTCInitDialog.isOkPressed()) {
                        return null;
                    }
                    this.clusterGenes = qTCInitDialog.isClusterGenesSelected();
                    n3 = Integer.parseInt(qTCInitDialog.clusterTextField.getText());
                    f = Float.parseFloat(qTCInitDialog.diameterTextField.getText());
                    bl4 = qTCInitDialog.isAbsoluteDistance();
                    bl3 = qTCInitDialog.isHCLSelected();
                    n = 0;
                    bl2 = false;
                    bl = false;
                    int n4 = 4;
                    boolean bl6 = false;
                    if (bl3) {
                        object = new HCLInitDialog(iFramework.getFrame(), iDistanceMenu.getFunctionName(qTCInitDialog.getDistanceMetric()), qTCInitDialog.isAbsoluteDistance(), true);
                        if (((HCLInitDialog)object).showModal() != 0) {
                            return null;
                        }
                        n = ((HCLInitDialog)object).getMethod();
                        bl2 = ((HCLInitDialog)object).isClusterExperiments();
                        bl = ((HCLInitDialog)object).isClusterGenes();
                        n4 = ((HCLInitDialog)object).getDistanceMetric();
                        bl6 = ((HCLInitDialog)object).getAbsoluteSelection();
                    }
                    this.experiment = iFramework.getData().getExperiment();
                    object = new Listener();
                    this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("QTC");
                    this.algorithm.addAlgorithmListener((AlgorithmListener)object);
                    int n5 = this.experiment.getNumberOfGenes();
                    AlgorithmData algorithmData2 = new AlgorithmData();
                    FloatMatrix floatMatrix = this.experiment.getMatrix();
                    if (!this.clusterGenes) {
                        floatMatrix = floatMatrix.transpose();
                    }
                    algorithmData2.addMatrix("experiment", floatMatrix);
                    algorithmData2.addParam("qtc-cluster-genes", String.valueOf(this.clusterGenes));
                    algorithmData2.addParam("distance-factor", String.valueOf(1.0f));
                    n2 = qTCInitDialog.getDistanceMetric();
                    algorithmData2.addParam("use-absolute", String.valueOf(bl4));
                    algorithmData2.addParam("distance-function", String.valueOf(n2));
                    algorithmData2.addParam("min-cluster-size", String.valueOf(n3));
                    algorithmData2.addParam("diameter", String.valueOf(f));
                    if (bl3) {
                        algorithmData2.addParam("hierarchical-tree", String.valueOf(true));
                        algorithmData2.addParam("method-linkage", String.valueOf(n));
                        algorithmData2.addParam("calculate-genes", String.valueOf(bl));
                        algorithmData2.addParam("calculate-experiments", String.valueOf(bl2));
                        algorithmData2.addParam("hcl-distance-function", String.valueOf(n4));
                        algorithmData2.addParam("hcl-distance-absolute", String.valueOf(bl6));
                    }
                    long l2 = System.currentTimeMillis();
                    algorithmData = this.algorithm.execute(algorithmData2);
                    l = System.currentTimeMillis() - l2;
                    algorithmParameters = algorithmData.getParams();
                    if (!algorithmParameters.getBoolean("aborted")) break block10;
                    defaultMutableTreeNode2 = null;
                    Object var31_25 = null;
                    if (this.algorithm == null) break block11;
                    this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
                }
                return defaultMutableTreeNode2;
            }
            try {
                Cluster cluster = algorithmData.getCluster("cluster");
                NodeList nodeList = cluster.getNodeList();
                int n6 = algorithmParameters.getInt("number-of-clusters");
                this.clusters = new int[n6][];
                for (int i = 0; i < n6; ++i) {
                    this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
                }
                this.means = algorithmData.getMatrix("clusters_means");
                this.variances = algorithmData.getMatrix("clusters_variances");
                GeneralInfo generalInfo = new GeneralInfo();
                generalInfo.clusters = n6;
                generalInfo.minClustSize = n3;
                generalInfo.diameter = f;
                generalInfo.useAbsolute = bl4;
                generalInfo.time = l;
                generalInfo.function = iDistanceMenu.getFunctionName(n2);
                generalInfo.hcl = bl3;
                generalInfo.hcl_genes = bl;
                generalInfo.hcl_samples = bl2;
                generalInfo.hcl_method = n;
                defaultMutableTreeNode = this.createResultTree(cluster, generalInfo);
                Object var31_26 = null;
                if (this.algorithm == null) break block12;
            }
            catch (Throwable throwable) {
                block13: {
                    Object var31_27 = null;
                    if (this.algorithm == null) break block13;
                    this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
                }
                throw throwable;
            }
            this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
        }
        return defaultMutableTreeNode;
    }

    public AlgorithmData getScriptParameters(IFramework iFramework) {
        this.data = iFramework.getData();
        int n = 5;
        float f = 0.2f;
        boolean bl = false;
        boolean bl2 = true;
        IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
        int n2 = iDistanceMenu.getDistanceFunction();
        if (n2 == 0) {
            n2 = 1;
        }
        QTCInitDialog qTCInitDialog = new QTCInitDialog((JFrame)iFramework.getFrame(), bl2, iDistanceMenu.getFunctionName(n2), iDistanceMenu.isAbsoluteDistance());
        qTCInitDialog.setVisible(true);
        if (!qTCInitDialog.isOkPressed()) {
            return null;
        }
        this.clusterGenes = qTCInitDialog.isClusterGenesSelected();
        n = Integer.parseInt(qTCInitDialog.clusterTextField.getText());
        f = Float.parseFloat(qTCInitDialog.diameterTextField.getText());
        bl = qTCInitDialog.isAbsoluteDistance();
        boolean bl3 = qTCInitDialog.isHCLSelected();
        int n3 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        int n4 = 4;
        boolean bl6 = false;
        if (bl3) {
            HCLInitDialog hCLInitDialog = new HCLInitDialog(iFramework.getFrame(), iDistanceMenu.getFunctionName(qTCInitDialog.getDistanceMetric()), qTCInitDialog.isAbsoluteDistance(), true);
            if (hCLInitDialog.showModal() != 0) {
                return null;
            }
            n3 = hCLInitDialog.getMethod();
            bl4 = hCLInitDialog.isClusterExperiments();
            bl5 = hCLInitDialog.isClusterGenes();
            n4 = hCLInitDialog.getDistanceMetric();
            bl6 = hCLInitDialog.getAbsoluteSelection();
        }
        this.experiment = iFramework.getData().getExperiment();
        int n5 = this.experiment.getNumberOfGenes();
        AlgorithmData algorithmData = new AlgorithmData();
        algorithmData.addParam("qtc-cluster-genes", String.valueOf(this.clusterGenes));
        algorithmData.addParam("distance-factor", String.valueOf(1.0f));
        n2 = qTCInitDialog.getDistanceMetric();
        algorithmData.addParam("use-absolute", String.valueOf(bl));
        algorithmData.addParam("distance-function", String.valueOf(n2));
        algorithmData.addParam("min-cluster-size", String.valueOf(n));
        algorithmData.addParam("diameter", String.valueOf(f));
        if (bl3) {
            algorithmData.addParam("hierarchical-tree", String.valueOf(true));
            algorithmData.addParam("method-linkage", String.valueOf(n3));
            algorithmData.addParam("calculate-genes", String.valueOf(bl5));
            algorithmData.addParam("calculate-experiments", String.valueOf(bl4));
            algorithmData.addParam("hcl-distance-function", String.valueOf(n4));
            algorithmData.addParam("hcl-distance-absolute", String.valueOf(bl6));
        }
        algorithmData.addParam("name", "QTC");
        if (this.clusterGenes) {
            algorithmData.addParam("alg-type", "cluster-genes");
        } else {
            algorithmData.addParam("alg-type", "cluster-experiments");
        }
        if (this.clusterGenes) {
            algorithmData.addParam("output-class", "multi-gene-cluster-output");
        } else {
            algorithmData.addParam("output-class", "multi-experiment-cluster-output");
        }
        String[] stringArray = new String[]{"Multi-cluster"};
        algorithmData.addStringArray("output-nodes", stringArray);
        return algorithmData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework iFramework, AlgorithmData algorithmData, Experiment experiment) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block8: {
            AlgorithmParameters algorithmParameters;
            long l;
            AlgorithmData algorithmData2;
            Listener listener;
            block6: {
                DefaultMutableTreeNode defaultMutableTreeNode2;
                block7: {
                    this.experiment = experiment;
                    this.data = iFramework.getData();
                    listener = new Listener();
                    this.clusterGenes = algorithmData.getParams().getBoolean("qtc-cluster-genes");
                    this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("QTC");
                    this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
                    int n = experiment.getNumberOfGenes();
                    FloatMatrix floatMatrix = experiment.getMatrix();
                    if (!this.clusterGenes) {
                        floatMatrix = floatMatrix.transpose();
                    }
                    algorithmData.addMatrix("experiment", floatMatrix);
                    long l2 = System.currentTimeMillis();
                    algorithmData2 = this.algorithm.execute(algorithmData);
                    l = System.currentTimeMillis() - l2;
                    algorithmParameters = algorithmData2.getParams();
                    if (!algorithmParameters.getBoolean("aborted")) break block6;
                    defaultMutableTreeNode2 = null;
                    Object var22_13 = null;
                    if (this.algorithm == null) break block7;
                    this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                }
                return defaultMutableTreeNode2;
            }
            try {
                Cluster cluster = algorithmData2.getCluster("cluster");
                NodeList nodeList = cluster.getNodeList();
                int n = algorithmParameters.getInt("number-of-clusters");
                this.clusters = new int[n][];
                for (int i = 0; i < n; ++i) {
                    this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
                }
                this.means = algorithmData2.getMatrix("clusters_means");
                this.variances = algorithmData2.getMatrix("clusters_variances");
                AlgorithmParameters algorithmParameters2 = algorithmData.getParams();
                GeneralInfo generalInfo = new GeneralInfo();
                generalInfo.clusters = n;
                generalInfo.minClustSize = algorithmParameters2.getInt("min-cluster-size");
                generalInfo.diameter = algorithmParameters2.getFloat("diameter");
                generalInfo.useAbsolute = algorithmParameters2.getBoolean("use-absolute");
                generalInfo.time = l;
                int n2 = algorithmParameters2.getInt("distance-function");
                generalInfo.function = iFramework.getDistanceMenu().getFunctionName(n2);
                boolean bl = algorithmParameters2.getBoolean("hierarchical-tree");
                generalInfo.hcl = bl;
                if (generalInfo.hcl) {
                    generalInfo.hcl_genes = algorithmParameters2.getBoolean("calculate-genes");
                    generalInfo.hcl_samples = algorithmParameters2.getBoolean("calculate-experiments");
                    generalInfo.hcl_method = algorithmParameters2.getInt("method-linkage");
                }
                defaultMutableTreeNode = this.createResultTree(cluster, generalInfo);
                Object var22_14 = null;
                if (this.algorithm == null) break block8;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var22_15 = null;
                    if (this.algorithm == null) break block9;
                    this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                }
                throw throwable;
            }
            this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
        }
        return defaultMutableTreeNode;
    }

    private HCLTreeData getResult(Node node, int n) {
        HCLTreeData hCLTreeData = new HCLTreeData();
        NodeValueList nodeValueList = node.getValues();
        hCLTreeData.child_1_array = (int[])nodeValueList.getNodeValue((int)n).value;
        hCLTreeData.child_2_array = (int[])nodeValueList.getNodeValue((int)(n + 1)).value;
        hCLTreeData.node_order = (int[])nodeValueList.getNodeValue((int)(n + 2)).value;
        hCLTreeData.height = (float[])nodeValueList.getNodeValue((int)(n + 3)).value;
        return hCLTreeData;
    }

    private DefaultMutableTreeNode createResultTree(Cluster cluster, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.clusterGenes ? new DefaultMutableTreeNode("QTC - genes") : new DefaultMutableTreeNode("QTC - samples");
        this.addResultNodes(defaultMutableTreeNode, cluster, generalInfo);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        this.addExpressionImages(defaultMutableTreeNode);
        this.addHierarchicalTrees(defaultMutableTreeNode, cluster, generalInfo);
        this.addCentroidViews(defaultMutableTreeNode);
        this.addTableViews(defaultMutableTreeNode);
        this.addClusterInfo(defaultMutableTreeNode);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addTableViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Table views");
        Object object = this.clusterGenes ? new ClusterTableViewer(this.experiment, this.clusters, this.data) : new ExperimentClusterTableViewer(this.experiment, this.clusters, this.data);
        for (int i = 0; i < this.clusters.length - 1; ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)object, (Object)new Integer(i))));
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned ", (IViewer)object, (Object)new Integer(this.clusters.length - 1))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        Object object = this.clusterGenes ? new QTCExperimentViewer(this.experiment, this.clusters) : new QTCExperimentClusterViewer(this.experiment, this.clusters);
        for (int i = 0; i < this.clusters.length - 1; ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)object, (Object)new Integer(i))));
        }
        if (this.clusterGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Genes", (IViewer)object, (Object)new Integer(this.clusters.length - 1))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Experiments", (IViewer)object, (Object)new Integer(this.clusters.length - 1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        int n;
        if (!generalInfo.hcl) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = cluster.getNodeList();
        Object object = null;
        int n2 = this.clusters.length;
        if (!this.clusterGenes) {
            object = new int[n2][];
            for (n = 0; n < n2; ++n) {
                object[n] = nodeList.getNode(n).getFeaturesIndexes();
            }
            if (generalInfo.hcl_samples) {
                object = this.getOrderedIndices(nodeList, (int[][])object, generalInfo.hcl_genes);
            }
        }
        for (n = 0; n < nodeList.getSize() - 1; ++n) {
            if (this.clusterGenes) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1), this.createHCLViewer(nodeList.getNode(n), generalInfo, null))));
                continue;
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1), this.createHCLViewer(nodeList.getNode(n), generalInfo, (int[][])object), (Object)new Integer(n))));
        }
        if (this.clusterGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Genes", this.createHCLViewer(nodeList.getNode(nodeList.getSize() - 1), generalInfo, null))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Experiments", this.createHCLViewer(nodeList.getNode(nodeList.getSize() - 1), generalInfo, (int[][])object), (Object)new Integer(nodeList.getSize() - 1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private IViewer createHCLViewer(Node node, GeneralInfo generalInfo, int[][] nArray) {
        HCLTreeData hCLTreeData;
        HCLTreeData hCLTreeData2;
        HCLTreeData hCLTreeData3 = hCLTreeData2 = generalInfo.hcl_genes ? this.getResult(node, 0) : null;
        HCLTreeData hCLTreeData4 = generalInfo.hcl_samples ? this.getResult(node, generalInfo.hcl_genes ? 4 : 0) : (hCLTreeData = null);
        if (this.clusterGenes) {
            return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData);
        }
        return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData, nArray, true);
    }

    private void addClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        if (this.clusterGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Clusters (#,%)", (IViewer)new QTCInfoViewer(this.clusters, this.experiment.getNumberOfGenes()))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Samples in Clusters (#,%)", (IViewer)new QTCInfoViewer(this.clusters, this.experiment.getNumberOfSamples(), false))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        if (this.clusterGenes) {
            QTCCentroidViewer qTCCentroidViewer = new QTCCentroidViewer(this.experiment, this.clusters);
            qTCCentroidViewer.setMeans(this.means.A);
            qTCCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length - 1; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)qTCCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)qTCCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Genes ", (IViewer)qTCCentroidViewer, (Object)new CentroidUserObject(this.clusters.length - 1, 0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Genes ", (IViewer)qTCCentroidViewer, (Object)new CentroidUserObject(this.clusters.length - 1, 1))));
            QTCCentroidsViewer qTCCentroidsViewer = new QTCCentroidsViewer(this.experiment, this.clusters);
            qTCCentroidsViewer.setMeans(this.means.A);
            qTCCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)qTCCentroidsViewer, (Object)new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)qTCCentroidsViewer, (Object)new Integer(1))));
        } else {
            QTCExperimentCentroidViewer qTCExperimentCentroidViewer = new QTCExperimentCentroidViewer(this.experiment, this.clusters);
            qTCExperimentCentroidViewer.setMeans(this.means.A);
            qTCExperimentCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length - 1; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)qTCExperimentCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)qTCExperimentCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Experiments", (IViewer)qTCExperimentCentroidViewer, (Object)new CentroidUserObject(this.clusters.length - 1, 0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Experiments", (IViewer)qTCExperimentCentroidViewer, (Object)new CentroidUserObject(this.clusters.length - 1, 1))));
            QTCExperimentCentroidsViewer qTCExperimentCentroidsViewer = new QTCExperimentCentroidsViewer(this.experiment, this.clusters);
            qTCExperimentCentroidsViewer.setMeans(this.means.A);
            qTCExperimentCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)qTCExperimentCentroidsViewer, (Object)new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)qTCExperimentCentroidsViewer, (Object)new Integer(1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Clusters: " + String.valueOf(generalInfo.clusters - 1)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Diameter: " + String.valueOf(generalInfo.diameter)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Minimum cluster size: " + String.valueOf(generalInfo.minClustSize)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Absolute distance: " + String.valueOf(generalInfo.useAbsolute)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("HCL: " + generalInfo.getMethodName()));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.function));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private int[][] getOrderedIndices(NodeList nodeList, int[][] nArray, boolean bl) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i].length <= 0) continue;
            HCLTreeData hCLTreeData = this.getResult(nodeList.getNode(i), bl ? 4 : 0);
            nArray[i] = this.getSampleOrder(hCLTreeData, nArray[i]);
        }
        return nArray;
    }

    private int[] getSampleOrder(HCLTreeData hCLTreeData, int[] nArray) {
        return this.getLeafOrder(hCLTreeData.node_order, hCLTreeData.child_1_array, hCLTreeData.child_2_array, nArray);
    }

    private int[] getLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = new int[nArray.length];
        Arrays.fill(nArray5, -1);
        this.fillLeafOrder(nArray5, nArray2, nArray3, 0, nArray2.length - 2, nArray4);
        return nArray5;
    }

    private int fillLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int[] nArray4) {
        if (nArray2[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray2[n2], nArray4);
        }
        if (nArray3[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray3[n2], nArray4);
        } else {
            nArray[n] = nArray4 == null ? n2 : nArray4[n2];
            ++n;
        }
        return n;
    }

    private class GeneralInfo {
        public int clusters;
        public long time;
        public String function;
        public int minClustSize;
        public float diameter;
        public boolean useAbsolute;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                QTCGUI.this.algorithm.abort();
                this.cleanUp();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            QTCGUI.this.algorithm.abort();
            this.cleanUp();
        }

        public void cleanUp() {
        }
    }
}

