/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ptm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tigr.graph.GraphCanvas;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphPoint;
import org.tigr.microarray.mev.TMEV;
import org.tigr.util.FloatMatrix;

public class PavlidisTemplateInitBox
extends JPanel {
    String[] SampleNames;
    Vector sampleNamesVector;
    Vector uniqueIDs;
    Vector clusters;
    Color[] clusterColors;
    UniqueIDSelector uidSelectPanel;
    ClusterSelector clusterSelectPanel;
    SavedTemplateSelector templateSelectPanel;
    BottomPanel bott;
    TemplatePanel tempPanel;
    AbsolutePanel abs;
    ThresholdPanel thresh;
    FloatMatrix expMatrix;
    JCheckBox drawTreesBox;
    JPanel drawTreesPane;
    JTabbedPane tabbedPane;
    Vector template;
    FloatMatrix templateMatrix;
    private boolean okPressed = false;

    public PavlidisTemplateInitBox(JFrame jFrame, boolean bl, FloatMatrix floatMatrix, Vector vector, Vector vector2, Vector vector3, Color[] colorArray) {
        this.expMatrix = floatMatrix;
        this.sampleNamesVector = vector;
        this.uniqueIDs = vector2;
        this.clusters = vector3;
        this.clusterColors = colorArray;
        this.SampleNames = this.getSampleNames();
        this.setBounds(0, 0, 1000, 800);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.buildConstraints(gridBagConstraints, 0, 0, 2, 1, 0, 25);
        this.tabbedPane = new JTabbedPane();
        this.uidSelectPanel = new UniqueIDSelector();
        this.clusterSelectPanel = new ClusterSelector();
        this.templateSelectPanel = new SavedTemplateSelector();
        this.tabbedPane.addTab("Select a gene as template", this.uidSelectPanel);
        this.tabbedPane.addTab("Select a cluster mean as template", this.clusterSelectPanel);
        this.tabbedPane.addTab("Select a saved template", this.templateSelectPanel);
        gridBagLayout.setConstraints(this.tabbedPane, gridBagConstraints);
        jPanel.add(this.tabbedPane);
        this.buildConstraints(gridBagConstraints, 0, 1, 2, 1, 0, 55);
        this.tempPanel = new TemplatePanel();
        gridBagLayout.setConstraints(this.tempPanel, gridBagConstraints);
        jPanel.add(this.tempPanel);
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 70, 5);
        this.abs = new AbsolutePanel();
        gridBagLayout.setConstraints(this.abs, gridBagConstraints);
        jPanel.add(this.abs);
        this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 0, 10);
        this.thresh = new ThresholdPanel();
        gridBagLayout.setConstraints(this.thresh, gridBagConstraints);
        jPanel.add(this.thresh);
        this.buildConstraints(gridBagConstraints, 0, 4, 1, 1, 0, 5);
        this.drawTreesPane = new JPanel();
        this.drawTreesBox = new JCheckBox("Draw hierarchical trees?");
        this.drawTreesPane.add(this.drawTreesBox);
        gridBagLayout.setConstraints(this.drawTreesPane, gridBagConstraints);
        jPanel.add(this.drawTreesPane);
        this.buildConstraints(gridBagConstraints, 1, 2, 1, 3, 30, 0);
        this.bott = new BottomPanel();
        this.bott.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == PavlidisTemplateInitBox.this.bott.cancelButton) {
                    // empty if block
                }
            }
        });
        gridBagLayout.setConstraints(this.bott, gridBagConstraints);
        jPanel.add(this.bott);
        this.add(jPanel);
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    String[] getSampleNames() {
        String[] stringArray = new String[this.sampleNamesVector.size()];
        for (int i = 0; i < this.sampleNamesVector.size(); ++i) {
            stringArray[i] = (String)this.sampleNamesVector.get(i);
        }
        return stringArray;
    }

    private Vector getGene(int n) {
        Vector<Float> vector = new Vector<Float>();
        for (int i = 0; i < this.sampleNamesVector.size(); ++i) {
            vector.add(new Float(this.expMatrix.get(n, i)));
        }
        return vector;
    }

    private float getMax(Vector vector) {
        float f = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < vector.size(); ++i) {
            float f2;
            if (Float.isNaN(((Float)vector.get(i)).floatValue()) || !((f2 = ((Float)vector.get(i)).floatValue()) > f)) continue;
            f = f2;
        }
        return f;
    }

    private float getMin(Vector vector) {
        float f = Float.MAX_VALUE;
        for (int i = 0; i < vector.size(); ++i) {
            float f2;
            if (Float.isNaN(((Float)vector.get(i)).floatValue()) || !((f2 = ((Float)vector.get(i)).floatValue()) < f)) continue;
            f = f2;
        }
        return f;
    }

    public Vector getTemplate() {
        Vector<Float> vector = new Vector<Float>();
        for (int i = 0; i < this.sampleNamesVector.size(); ++i) {
            String string = this.tempPanel.tempScr.tempGrid[i].templateField.getText();
            if (string.equals("NaN") || string.equals("NULL") || !this.tempPanel.tempScr.tempGrid[i].activeBox.isSelected()) {
                vector.add(new Float(Float.NaN));
                continue;
            }
            vector.add(new Float(string));
        }
        return vector;
    }

    public FloatMatrix convertTemplateVectorToFloatMatrix() {
        this.template = this.getTemplate();
        FloatMatrix floatMatrix = new FloatMatrix(1, this.template.size());
        for (int i = 0; i < this.template.size(); ++i) {
            floatMatrix.A[0][i] = ((Float)this.template.get(i)).floatValue();
        }
        return floatMatrix;
    }

    protected void fireOkButtonEvent() {
        this.templateMatrix = this.convertTemplateVectorToFloatMatrix();
        boolean bl = this.abs.absBox.isSelected();
        boolean bl2 = this.drawTreesBox.isSelected();
        boolean bl3 = this.thresh.chooseR.isSelected();
        String string = this.thresh.threshInputField.getText();
        double d = Double.parseDouble(string);
        Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
        hashtable.put(new String("drawTrees"), new Boolean(bl2));
        hashtable.put(new String("useAbsolute"), new Boolean(bl));
        hashtable.put(new String("useR"), new Boolean(bl3));
        hashtable.put(new String("template"), this.template);
        hashtable.put(new String("thresholdR"), new Double(d));
    }

    public boolean isDrawTrees() {
        return this.drawTreesBox.isSelected();
    }

    public boolean isUseAbsolute() {
        return this.abs.absBox.isSelected();
    }

    public boolean isUseR() {
        return this.thresh.chooseR.isSelected();
    }

    public FloatMatrix getTemplateMatrix() {
        return this.convertTemplateVectorToFloatMatrix();
    }

    public double getThresholdR() {
        return Double.parseDouble(this.thresh.threshInputField.getText());
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    protected class EventListener
    implements ActionListener {
        protected EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == PavlidisTemplateInitBox.this.bott.okButton) {
                try {
                    String string = PavlidisTemplateInitBox.this.thresh.threshInputField.getText();
                    double d = Double.parseDouble(string);
                    if (d > 1.0 || d < 0.0) {
                        JOptionPane.showMessageDialog(null, "Threshold R value must be between 0 and 1 (inclusive)");
                        PavlidisTemplateInitBox.this.thresh.threshInputField.setText("0.80");
                    } else {
                        PavlidisTemplateInitBox.this.setVisible(false);
                        PavlidisTemplateInitBox.this.fireOkButtonEvent();
                        PavlidisTemplateInitBox.this.okPressed = true;
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "Threshold R value must be between 0 and 1 (inclusive)");
                    PavlidisTemplateInitBox.this.thresh.threshInputField.setText("0.80");
                }
            }
        }
    }

    class TemplatePanel
    extends JPanel {
        TemplateScroller tempScr;

        TemplatePanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            this.setLayout(gridBagLayout);
            this.tempScr = new TemplateScroller();
            JScrollPane jScrollPane = this.tempScr.createTemplateScroller();
            PavlidisTemplateInitBox.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 95);
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
            PavlidisTemplateInitBox.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100, 5);
            gridBagConstraints.fill = 0;
        }

        class TemplateScroller
        extends JPanel {
            TemplateElementGrid[] tempGrid;

            TemplateScroller() {
                this.tempGrid = new TemplateElementGrid[((TemplatePanel)TemplatePanel.this).PavlidisTemplateInitBox.this.SampleNames.length];
            }

            JScrollPane createTemplateScroller() {
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 1;
                this.setLayout(gridBagLayout);
                for (int i = 0; i < ((TemplatePanel)TemplatePanel.this).PavlidisTemplateInitBox.this.SampleNames.length; ++i) {
                    this.tempGrid[i] = new TemplateElementGrid(((TemplatePanel)TemplatePanel.this).PavlidisTemplateInitBox.this.SampleNames[i]);
                    PavlidisTemplateInitBox.this.buildConstraints(gridBagConstraints, i, 0, 1, 1, 100, 100);
                    gridBagLayout.setConstraints(this.tempGrid[i], gridBagConstraints);
                    this.add(this.tempGrid[i]);
                }
                JScrollPane jScrollPane = new JScrollPane(this);
                jScrollPane.setHorizontalScrollBarPolicy(30);
                jScrollPane.setVerticalScrollBarPolicy(20);
                return jScrollPane;
            }

            class TemplateElementGrid
            extends JPanel {
                JLabel exptName;
                JTextField templateField;
                JSlider templateSlider;
                JCheckBox activeBox;

                TemplateElementGrid(String string) {
                    GridBagLayout gridBagLayout = new GridBagLayout();
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.fill = 1;
                    this.setLayout(gridBagLayout);
                    PavlidisTemplateInitBox.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 10);
                    this.exptName = new JLabel(string, 0);
                    gridBagLayout.setConstraints(this.exptName, gridBagConstraints);
                    this.add(this.exptName);
                    PavlidisTemplateInitBox.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
                    this.activeBox = new JCheckBox();
                    this.activeBox.setSelected(true);
                    this.activeBox.addItemListener(new ItemListener(this){
                        private final /* synthetic */ TemplateElementGrid this$3;
                        {
                            this.this$3 = templateElementGrid;
                        }

                        public void itemStateChanged(ItemEvent itemEvent) {
                            if (itemEvent.getStateChange() == 2) {
                                this.this$3.templateField.setBackground(Color.gray);
                                this.this$3.templateField.setEnabled(false);
                                this.this$3.templateSlider.setEnabled(false);
                            }
                            if (itemEvent.getStateChange() == 1) {
                                this.this$3.templateField.setBackground(Color.white);
                                this.this$3.templateField.setEnabled(true);
                                this.this$3.templateSlider.setEnabled(true);
                            }
                        }
                    });
                    gridBagLayout.setConstraints(this.activeBox, gridBagConstraints);
                    this.add(this.activeBox);
                    PavlidisTemplateInitBox.this.buildConstraints(gridBagConstraints, 0, 1, 2, 1, 0, 5);
                    this.templateField = new JTextField("0.5", 4);
                    this.templateField.addActionListener(new ActionListener(this){
                        private final /* synthetic */ TemplateElementGrid this$3;
                        {
                            this.this$3 = templateElementGrid;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            if (actionEvent.getSource() == this.this$3.templateField) {
                                int n;
                                try {
                                    String string = this.this$3.templateField.getText();
                                    double d = Double.parseDouble(string);
                                    n = (int)Math.floor(d * 100.0);
                                    if (d > 1.0 || d < 0.0) {
                                        n = 50;
                                        this.this$3.templateField.setText("0.5");
                                        JOptionPane.showMessageDialog(null, "Template values must be between 0 and 1 (inclusive)");
                                    }
                                }
                                catch (Exception exception) {
                                    this.this$3.templateField.setText("0.5");
                                    n = 50;
                                    JOptionPane.showMessageDialog(null, "Template values must be between 0 and 1 (inclusive)");
                                }
                                this.this$3.templateSlider.setValue(n);
                            }
                        }
                    });
                    this.templateField.addFocusListener(new FocusListener(this){
                        private final /* synthetic */ TemplateElementGrid this$3;
                        {
                            this.this$3 = templateElementGrid;
                        }

                        public void focusLost(FocusEvent focusEvent) {
                            if (focusEvent.getSource() == this.this$3.templateField) {
                                int n;
                                try {
                                    String string = this.this$3.templateField.getText();
                                    double d = Double.parseDouble(string);
                                    n = (int)Math.floor(d * 100.0);
                                    if (d > 1.0 || d < 0.0) {
                                        n = 50;
                                        this.this$3.templateField.setText("0.5");
                                        JOptionPane.showMessageDialog(null, "Template values must be between 0 and 1 (inclusive)");
                                    }
                                }
                                catch (Exception exception) {
                                    this.this$3.templateField.setText("0.5");
                                    n = 50;
                                    JOptionPane.showMessageDialog(null, "Template values must be between 0 and 1 (inclusive)");
                                }
                                this.this$3.templateSlider.setValue(n);
                            }
                        }

                        public void focusGained(FocusEvent focusEvent) {
                        }
                    });
                    gridBagLayout.setConstraints(this.templateField, gridBagConstraints);
                    this.add(this.templateField);
                    PavlidisTemplateInitBox.this.buildConstraints(gridBagConstraints, 0, 2, 1, 2, 0, 85);
                    this.templateSlider = new JSlider(1, 0, 100, 50);
                    this.templateSlider.setMajorTickSpacing(20);
                    this.templateSlider.setMinorTickSpacing(10);
                    Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
                    hashtable.put(new Integer(0), new JLabel("Min"));
                    hashtable.put(new Integer(100), new JLabel("Max"));
                    this.templateSlider.setLabelTable(hashtable);
                    this.templateSlider.setPaintLabels(true);
                    this.templateSlider.addChangeListener(new ChangeListener(this){
                        private final /* synthetic */ TemplateElementGrid this$3;
                        {
                            this.this$3 = templateElementGrid;
                        }

                        public void stateChanged(ChangeEvent changeEvent) {
                            JSlider jSlider = (JSlider)changeEvent.getSource();
                            if (!jSlider.getValueIsAdjusting()) {
                                int n = jSlider.getValue();
                                if (n == 100) {
                                    this.this$3.templateField.setText("1.0");
                                } else if (n > 0 && n < 10) {
                                    this.this$3.templateField.setText("0.0" + n);
                                } else {
                                    this.this$3.templateField.setText("0." + n);
                                }
                            }
                        }
                    });
                    gridBagLayout.setConstraints(this.templateSlider, gridBagConstraints);
                    this.add(this.templateSlider);
                }

                public void reset() {
                    this.templateSlider.setValue(50);
                    this.templateField.setText("0.5");
                }
            }
        }
    }

    class BottomPanel
    extends JPanel {
        JButton resetButton;
        JButton okButton;
        JButton cancelButton;
        JButton saveButton;

        BottomPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            this.setLayout(gridBagLayout);
            PavlidisTemplateInitBox.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 100);
            this.saveButton = new JButton("Save template to file");
            gridBagLayout.setConstraints(this.saveButton, gridBagConstraints);
            this.saveButton.setEnabled(false);
            this.add(this.saveButton);
            this.saveButton.addActionListener(new ActionListener(this, PavlidisTemplateInitBox.this){
                private final /* synthetic */ PavlidisTemplateInitBox val$this$0;
                private final /* synthetic */ BottomPanel this$1;
                {
                    this.this$1 = bottomPanel;
                    this.val$this$0 = pavlidisTemplateInitBox;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser;
                    int n;
                    if (actionEvent.getSource() == this.this$1.saveButton && (n = (jFileChooser = new JFileChooser(TMEV.getFile((String)"data/"))).showSaveDialog(this.this$1)) == 0) {
                        File file = jFileChooser.getSelectedFile();
                        try {
                            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file.getName(), true));
                            for (int i = 0; i < BottomPanel.access$700((BottomPanel)this.this$1).tempPanel.tempScr.tempGrid.length; ++i) {
                                String string = BottomPanel.access$700((BottomPanel)this.this$1).tempPanel.tempScr.tempGrid[i].templateField.getText();
                                float f = Float.parseFloat(string);
                                dataOutputStream.writeFloat(f);
                            }
                            dataOutputStream.close();
                        }
                        catch (IOException iOException) {
                            System.out.println("Error: " + iOException.toString());
                        }
                    }
                }
            });
            PavlidisTemplateInitBox.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100, 100);
            this.resetButton = new JButton("Reset");
            this.resetButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ BottomPanel this$1;
                {
                    this.this$1 = bottomPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == this.this$1.resetButton) {
                        for (int i = 0; i < BottomPanel.access$700((BottomPanel)this.this$1).tempPanel.tempScr.tempGrid.length; ++i) {
                            BottomPanel.access$700((BottomPanel)this.this$1).tempPanel.tempScr.tempGrid[i].reset();
                        }
                        BottomPanel.access$700((BottomPanel)this.this$1).thresh.threshInputField.setText("");
                        BottomPanel.access$700((BottomPanel)this.this$1).abs.absBox.setSelected(false);
                    }
                }
            });
            gridBagLayout.setConstraints(this.resetButton, gridBagConstraints);
            this.add(this.resetButton);
            PavlidisTemplateInitBox.this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 100, 100);
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new EventListener());
            gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
            this.add(this.okButton);
            PavlidisTemplateInitBox.this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 100, 100);
            this.cancelButton = new JButton("Cancel");
            gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
            this.add(this.cancelButton);
        }

        static /* synthetic */ PavlidisTemplateInitBox access$700(BottomPanel bottomPanel) {
            return bottomPanel.PavlidisTemplateInitBox.this;
        }
    }

    class ThresholdPanel
    extends JPanel {
        JLabel threshLabel1;
        JLabel threshLabel2;
        JTextField threshInputField;
        JRadioButton chooseR;
        JRadioButton chooseP;

        ThresholdPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            this.setLayout(gridBagLayout);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.chooseR = new JRadioButton("Use Threshold R", false);
            buttonGroup.add(this.chooseR);
            this.chooseP = new JRadioButton("Use Threshold p-Value", true);
            buttonGroup.add(this.chooseP);
            PavlidisTemplateInitBox.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 10, 50);
            gridBagConstraints.anchor = 16;
            gridBagLayout.setConstraints(this.chooseR, gridBagConstraints);
            this.add(this.chooseR);
            PavlidisTemplateInitBox.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 50);
            gridBagConstraints.anchor = 18;
            gridBagLayout.setConstraints(this.chooseP, gridBagConstraints);
            this.add(this.chooseP);
            PavlidisTemplateInitBox.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 80, 0);
            gridBagConstraints.anchor = 16;
            this.threshLabel1 = new JLabel("Enter magnitude of threshold R or p-Value (between 0 and 1 inclusive)");
            gridBagLayout.setConstraints(this.threshLabel1, gridBagConstraints);
            this.add(this.threshLabel1);
            PavlidisTemplateInitBox.this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 0, 0);
            gridBagConstraints.anchor = 18;
            this.threshLabel2 = new JLabel("at which selected profiles should be correlated to template");
            gridBagLayout.setConstraints(this.threshLabel2, gridBagConstraints);
            this.add(this.threshLabel2);
            PavlidisTemplateInitBox.this.buildConstraints(gridBagConstraints, 2, 0, 1, 2, 10, 0);
            gridBagConstraints.anchor = 17;
            this.threshInputField = new JTextField("", 7);
            this.threshInputField.addActionListener(new ActionListener(this){
                private final /* synthetic */ ThresholdPanel this$1;
                {
                    this.this$1 = thresholdPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == this.this$1.threshInputField) {
                        try {
                            System.out.println("in gene dialog, ptm");
                            String string = this.this$1.threshInputField.getText();
                            double d = Double.parseDouble(string);
                            if (d > 1.0 || d < 0.0) {
                                JOptionPane.showMessageDialog(null, "Threshold R value must be between 0 and 1 (inclusive)");
                                this.this$1.threshInputField.setText("");
                            }
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(null, "Threshold R value must be between 0 and 1 (inclusive)");
                            this.this$1.threshInputField.setText("");
                        }
                    }
                }
            });
            gridBagLayout.setConstraints(this.threshInputField, gridBagConstraints);
            this.add(this.threshInputField);
        }
    }

    class SavedTemplateSelector
    extends JPanel {
        JList templateList;
        GraphCanvas profileDisplayPanel;
        JScrollPane listScrollPane;
        JButton selectButton;
        JButton loadButton;
        Vector templatesVector = new Vector();
        DefaultListModel listModel;
        Vector templates;
        JSplitPane templateSplitPane;
        JPanel templateButtonPanel;

        SavedTemplateSelector() {
        }

        private void refreshGraph() {
            GraphPoint graphPoint;
            int n;
            int n2 = this.templateList.getSelectedIndex();
            if (n2 < 0) {
                return;
            }
            Vector vector = (Vector)((Vector)this.templatesVector.get(n2)).clone();
            this.profileDisplayPanel.removeAllGraphElements();
            for (n = 0; n < vector.size(); ++n) {
                graphPoint = new GraphPoint((double)(n + 1), (double)((Float)vector.elementAt(n)).floatValue(), Color.red, 2);
                this.profileDisplayPanel.addGraphElement((GraphElement)graphPoint);
            }
            for (n = 0; n < vector.size() - 1; ++n) {
                graphPoint = new GraphLine((double)(n + 1), (double)((Float)vector.elementAt(n)).floatValue(), (double)(n + 2), (double)((Float)vector.elementAt(n + 1)).floatValue(), Color.blue);
                this.profileDisplayPanel.addGraphElement((GraphElement)graphPoint);
            }
            this.profileDisplayPanel.repaint();
        }
    }

    class AbsolutePanel
    extends JPanel {
        JCheckBox absBox;
        JLabel absLabel1;
        JLabel absLabel2;

        AbsolutePanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            this.setLayout(gridBagLayout);
            PavlidisTemplateInitBox.this.buildConstraints(gridBagConstraints, 0, 0, 1, 2, 30, 0);
            this.absBox = new JCheckBox("Match to Absolute R?");
            gridBagLayout.setConstraints(this.absBox, gridBagConstraints);
            this.add(this.absBox);
            PavlidisTemplateInitBox.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 70, 50);
            this.absLabel1 = new JLabel("Yes: both +vely and -vely correlated expression profiles will be matched");
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.absLabel1, gridBagConstraints);
            this.add(this.absLabel1);
            PavlidisTemplateInitBox.this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 0, 50);
            this.absLabel2 = new JLabel("No: only +vely correlated expression profiles will be matched");
            gridBagConstraints.anchor = 18;
            gridBagLayout.setConstraints(this.absLabel2, gridBagConstraints);
            this.add(this.absLabel2);
        }
    }

    class ClusterSelector
    extends JPanel {
        JList clusterList;
        GraphCanvas profileDisplayPanel;
        JScrollPane listScrollPane;
        JButton selectButton;
        Vector clusterNames = new Vector();
        Vector geneDataInClusters;
        Vector averageClusterProfiles;
        JSplitPane clusterSplitPane;

        ClusterSelector() {
            Cloneable cloneable;
            Cloneable cloneable2;
            if (PavlidisTemplateInitBox.this.clusters.size() == 0) {
                this.clusterNames.add("No clusters to show");
            } else {
                int n;
                for (n = 0; n < PavlidisTemplateInitBox.this.clusters.size(); ++n) {
                    this.clusterNames.add("Cluster " + (n + 1));
                }
                this.geneDataInClusters = new Vector();
                this.averageClusterProfiles = new Vector();
                for (n = 0; n < PavlidisTemplateInitBox.this.clusters.size(); ++n) {
                    cloneable2 = (Vector)PavlidisTemplateInitBox.this.clusters.get(n);
                    for (int i = 0; i < ((Vector)cloneable2).size(); ++i) {
                        int n2 = (Integer)((Vector)cloneable2).get(i);
                        Vector vector = PavlidisTemplateInitBox.this.getGene(n2);
                        ((Vector)cloneable2).set(i, vector);
                    }
                    this.geneDataInClusters.add(cloneable2);
                    cloneable = this.getMeanProfile((Vector)cloneable2);
                    this.averageClusterProfiles.add(cloneable);
                }
            }
            GridBagLayout gridBagLayout = new GridBagLayout();
            cloneable2 = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.clusterList = new JList(this.clusterNames);
            this.clusterList.setSelectionMode(0);
            this.clusterList.setSelectedIndex(0);
            this.profileDisplayPanel = new GraphCanvas();
            this.profileDisplayPanel.setGraphBounds(0.0, (double)PavlidisTemplateInitBox.this.sampleNamesVector.size(), -3.0, 3.0);
            this.profileDisplayPanel.setGraphSpacing(20, 20, 20, 20);
            this.profileDisplayPanel.setXAxisValue(0.0);
            this.profileDisplayPanel.setYAxisValue(0.0);
            this.clusterList.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ ClusterSelector this$1;
                {
                    this.this$1 = clusterSelector;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ClusterSelector.access$500(this.this$1);
                }
            });
            this.listScrollPane = new JScrollPane(this.clusterList);
            this.clusterSplitPane = new JSplitPane(1, this.listScrollPane, (Component)this.profileDisplayPanel);
            this.clusterSplitPane.setOneTouchExpandable(true);
            this.clusterSplitPane.setDividerLocation(200);
            cloneable = new Dimension(100, 50);
            this.clusterList.setMinimumSize((Dimension)cloneable);
            this.profileDisplayPanel.setMinimumSize((Dimension)cloneable);
            PavlidisTemplateInitBox.this.buildConstraints((GridBagConstraints)cloneable2, 0, 0, 1, 1, 1, 80);
            ((GridBagConstraints)cloneable2).fill = 1;
            gridBagLayout.setConstraints(this.clusterSplitPane, (GridBagConstraints)cloneable2);
            this.add(this.clusterSplitPane);
            PavlidisTemplateInitBox.this.buildConstraints((GridBagConstraints)cloneable2, 0, 1, 1, 1, 0, 20);
            ((GridBagConstraints)cloneable2).fill = 0;
            this.selectButton = new JButton("Select highlighted cluster from above list to use its mean as template");
            this.selectButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ClusterSelector this$1;
                {
                    this.this$1 = clusterSelector;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ClusterSelector.access$600((ClusterSelector)this.this$1).clusters.size() == 0) {
                        JOptionPane.showMessageDialog(null, "No clusters to select");
                    } else {
                        int n;
                        float f;
                        int n2 = this.this$1.clusterList.getSelectedIndex();
                        Vector vector = (Vector)((Vector)this.this$1.averageClusterProfiles.get(n2)).clone();
                        float f2 = PavlidisTemplateInitBox.access$300(ClusterSelector.access$600(this.this$1), vector);
                        if (f2 - (f = PavlidisTemplateInitBox.access$400(ClusterSelector.access$600(this.this$1), vector)) == 0.0f) {
                            for (n = 0; n < vector.size(); ++n) {
                                vector.set(n, new Float(0.5));
                            }
                        } else {
                            for (n = 0; n < vector.size(); ++n) {
                                float f3 = (((Float)vector.get(n)).floatValue() - f) / (f2 - f);
                                vector.set(n, new Float(f3));
                            }
                        }
                        for (n = 0; n < ClusterSelector.access$600((ClusterSelector)this.this$1).tempPanel.tempScr.tempGrid.length; ++n) {
                            ClusterSelector.access$600((ClusterSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateSlider.setValue((int)Math.floor(((Float)vector.get(n)).floatValue() * 100.0f));
                            ClusterSelector.access$600((ClusterSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateField.setText("" + ((Float)vector.get(n)).floatValue());
                        }
                    }
                }
            });
            gridBagLayout.setConstraints(this.selectButton, (GridBagConstraints)cloneable2);
            this.add(this.selectButton);
            this.refreshGraph();
        }

        private void refreshGraph() {
            Vector vector;
            int n;
            int n2 = this.clusterList.getSelectedIndex();
            if (PavlidisTemplateInitBox.this.clusters.size() <= 0) {
                return;
            }
            Vector vector2 = (Vector)this.averageClusterProfiles.elementAt(n2);
            this.profileDisplayPanel.removeAllGraphElements();
            Vector vector3 = (Vector)this.geneDataInClusters.get(n2);
            for (n = 0; n < vector3.size(); ++n) {
                int n3;
                vector = (Vector)vector3.get(n);
                for (n3 = 0; n3 < vector.size(); ++n3) {
                }
                for (n3 = 0; n3 < vector.size() - 1; ++n3) {
                    if (Float.isNaN(((Float)vector.elementAt(n3)).floatValue()) || Float.isNaN(((Float)vector.elementAt(n3 + 1)).floatValue())) continue;
                    GraphLine graphLine = new GraphLine((double)n3, (double)((Float)vector.elementAt(n3)).floatValue(), (double)(n3 + 1), (double)((Float)vector.elementAt(n3 + 1)).floatValue(), PavlidisTemplateInitBox.this.clusterColors[n2]);
                    this.profileDisplayPanel.addGraphElement((GraphElement)graphLine);
                }
            }
            for (n = 0; n < vector2.size(); ++n) {
                if (Float.isNaN(((Float)vector2.elementAt(n)).floatValue())) continue;
                vector = new GraphPoint((double)n, (double)((Float)vector2.elementAt(n)).floatValue(), Color.red, 5);
                this.profileDisplayPanel.addGraphElement((GraphElement)vector);
            }
            for (n = 0; n < vector2.size() - 1; ++n) {
                vector = new GraphLine((double)n, (double)((Float)vector2.elementAt(n)).floatValue(), (double)(n + 1), (double)((Float)vector2.elementAt(n + 1)).floatValue(), Color.blue);
                this.profileDisplayPanel.addGraphElement((GraphElement)vector);
            }
            this.profileDisplayPanel.repaint();
        }

        Vector getMeanProfile(Vector vector) {
            Vector<Float> vector2 = new Vector<Float>();
            float[][] fArray = this.convertToFloatMatrix(vector);
            for (int i = 0; i < fArray[0].length; ++i) {
                float f = 0.0f;
                for (int j = 0; j < fArray.length; ++j) {
                    if (Float.isNaN(fArray[j][i])) continue;
                    f += fArray[j][i];
                }
                float f2 = f / (float)fArray.length;
                vector2.add(new Float(f2));
            }
            return vector2;
        }

        float[][] convertToFloatMatrix(Vector vector) {
            float[][] fArrayArray = new float[vector.size()][];
            for (int i = 0; i < vector.size(); ++i) {
                Vector vector2 = (Vector)((Vector)vector.get(i)).clone();
                fArrayArray[i] = new float[vector2.size()];
                for (int j = 0; j < vector2.size(); ++j) {
                    fArrayArray[i][j] = ((Float)vector2.get(j)).floatValue();
                }
            }
            return fArrayArray;
        }

        static /* synthetic */ void access$500(ClusterSelector clusterSelector) {
            clusterSelector.refreshGraph();
        }

        static /* synthetic */ PavlidisTemplateInitBox access$600(ClusterSelector clusterSelector) {
            return clusterSelector.PavlidisTemplateInitBox.this;
        }
    }

    class UniqueIDSelector
    extends JPanel {
        JList uniqueIDList;
        GraphCanvas profileDisplayPanel;
        JScrollPane listScrollPane;
        JButton selectButton;
        int maxIndex = -1;
        int minIndex = -1;
        JSplitPane uIDSplitPane;

        UniqueIDSelector() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.uniqueIDList = new JList(PavlidisTemplateInitBox.this.uniqueIDs);
            this.uniqueIDList.setSelectionMode(0);
            this.uniqueIDList.setSelectedIndex(0);
            this.profileDisplayPanel = new GraphCanvas();
            this.profileDisplayPanel.setGraphBounds(0.0, (double)PavlidisTemplateInitBox.this.sampleNamesVector.size(), -3.0, 3.0);
            this.profileDisplayPanel.setGraphSpacing(20, 20, 20, 20);
            this.profileDisplayPanel.setXAxisValue(0.0);
            this.profileDisplayPanel.setYAxisValue(0.0);
            this.uniqueIDList.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ UniqueIDSelector this$1;
                {
                    this.this$1 = uniqueIDSelector;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    UniqueIDSelector.access$000(this.this$1);
                }
            });
            this.listScrollPane = new JScrollPane(this.uniqueIDList);
            this.uIDSplitPane = new JSplitPane(1, this.listScrollPane, (Component)this.profileDisplayPanel);
            this.uIDSplitPane.setOneTouchExpandable(true);
            this.uIDSplitPane.setDividerLocation(200);
            Dimension dimension = new Dimension(100, 50);
            this.uniqueIDList.setMinimumSize(dimension);
            this.profileDisplayPanel.setMinimumSize(dimension);
            PavlidisTemplateInitBox.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1, 80);
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints(this.uIDSplitPane, gridBagConstraints);
            this.add(this.uIDSplitPane);
            PavlidisTemplateInitBox.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 20);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 15;
            this.selectButton = new JButton("Select highlighted gene from above list to use as template");
            this.selectButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ UniqueIDSelector this$1;
                {
                    this.this$1 = uniqueIDSelector;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    float f;
                    int n2 = this.this$1.uniqueIDList.getSelectedIndex();
                    Vector vector = PavlidisTemplateInitBox.access$200(UniqueIDSelector.access$100(this.this$1), n2);
                    float f2 = PavlidisTemplateInitBox.access$300(UniqueIDSelector.access$100(this.this$1), vector);
                    if (f2 - (f = PavlidisTemplateInitBox.access$400(UniqueIDSelector.access$100(this.this$1), vector)) == 0.0f) {
                        for (n = 0; n < vector.size(); ++n) {
                            vector.set(n, new Float(0.5));
                        }
                    } else {
                        for (n = 0; n < vector.size(); ++n) {
                            float f3 = (((Float)vector.get(n)).floatValue() - f) / (f2 - f);
                            vector.set(n, new Float(f3));
                        }
                    }
                    for (n = 0; n < UniqueIDSelector.access$100((UniqueIDSelector)this.this$1).tempPanel.tempScr.tempGrid.length; ++n) {
                        if (!Float.isNaN(((Float)vector.get(n)).floatValue())) {
                            UniqueIDSelector.access$100((UniqueIDSelector)this.this$1).tempPanel.tempScr.tempGrid[n].activeBox.setSelected(true);
                            UniqueIDSelector.access$100((UniqueIDSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateSlider.setEnabled(true);
                            UniqueIDSelector.access$100((UniqueIDSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateSlider.setValue((int)Math.floor(((Float)vector.get(n)).floatValue() * 100.0f));
                            UniqueIDSelector.access$100((UniqueIDSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateField.setEnabled(true);
                            UniqueIDSelector.access$100((UniqueIDSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateField.setBackground(Color.white);
                            UniqueIDSelector.access$100((UniqueIDSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateField.setText("" + ((Float)vector.get(n)).floatValue());
                            continue;
                        }
                        UniqueIDSelector.access$100((UniqueIDSelector)this.this$1).tempPanel.tempScr.tempGrid[n].activeBox.setSelected(false);
                        UniqueIDSelector.access$100((UniqueIDSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateSlider.setEnabled(false);
                        UniqueIDSelector.access$100((UniqueIDSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateField.setText("NULL");
                        UniqueIDSelector.access$100((UniqueIDSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateField.setBackground(Color.gray);
                        UniqueIDSelector.access$100((UniqueIDSelector)this.this$1).tempPanel.tempScr.tempGrid[n].templateField.setEnabled(false);
                    }
                }
            });
            gridBagLayout.setConstraints(this.selectButton, gridBagConstraints);
            this.add(this.selectButton);
            this.refreshGraph();
        }

        private void refreshGraph() {
            GraphPoint graphPoint;
            int n;
            int n2 = this.uniqueIDList.getSelectedIndex();
            Vector vector = PavlidisTemplateInitBox.this.getGene(n2);
            float f = PavlidisTemplateInitBox.this.getMax(vector);
            float f2 = PavlidisTemplateInitBox.this.getMin(vector);
            this.profileDisplayPanel.removeAllGraphElements();
            for (n = 0; n < vector.size(); ++n) {
                if (Float.isNaN(((Float)vector.elementAt(n)).floatValue())) continue;
                graphPoint = new GraphPoint((double)n, (double)((Float)vector.elementAt(n)).floatValue(), Color.red, 5);
                this.profileDisplayPanel.addGraphElement((GraphElement)graphPoint);
            }
            for (n = 0; n < vector.size() - 1; ++n) {
                if (Float.isNaN(((Float)vector.elementAt(n)).floatValue()) || Float.isNaN(((Float)vector.elementAt(n + 1)).floatValue())) continue;
                graphPoint = new GraphLine((double)n, (double)((Float)vector.elementAt(n)).floatValue(), (double)(n + 1), (double)((Float)vector.elementAt(n + 1)).floatValue(), Color.blue);
                this.profileDisplayPanel.addGraphElement((GraphElement)graphPoint);
            }
            this.profileDisplayPanel.repaint();
        }

        static /* synthetic */ void access$000(UniqueIDSelector uniqueIDSelector) {
            uniqueIDSelector.refreshGraph();
        }

        static /* synthetic */ PavlidisTemplateInitBox access$100(UniqueIDSelector uniqueIDSelector) {
            return uniqueIDSelector.PavlidisTemplateInitBox.this;
        }
    }
}

