/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.util.FloatMatrix;

public class PlotVectorViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 202011030001L;
    private JComponent content;
    private int current = -1;

    public PlotVectorViewer(FloatMatrix floatMatrix) {
        this.content = this.createContent(floatMatrix);
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    public void onSelected(IFramework iFramework) {
        Object object = iFramework.getUserObject();
        if (object instanceof Integer) {
            this.current = (Integer)object;
            return;
        }
        this.current = -1;
    }

    private JComponent createContent(FloatMatrix floatMatrix) {
        return new Plot(floatMatrix);
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    private class Plot
    extends JPanel {
        private static final int left = 40;
        private static final int top = 40;
        private FloatMatrix T;
        private Font font = new Font("monospaced", 1, 10);

        public Plot(FloatMatrix floatMatrix) {
            this.setBackground(Color.white);
            this.setFont(this.font);
            this.T = floatMatrix;
        }

        public void paint(Graphics graphics) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            super.paint(graphics);
            int n6 = this.T.getRowDimension();
            if (n6 < 1) {
                return;
            }
            int n7 = this.getWidth() - 80;
            int n8 = this.getHeight() - 80;
            if (PlotVectorViewer.this.current == -1 || n7 < 5 || n8 < 5) {
                return;
            }
            double d = 1.0;
            double d2 = n8;
            double d3 = (double)n7 / ((double)n6 - 1.0);
            double d4 = this.T.get(0, PlotVectorViewer.this.current);
            if (Double.isNaN(d4)) {
                return;
            }
            for (int i = 0; i < n6; ++i) {
                if (!((double)Math.abs(this.T.get(i, PlotVectorViewer.this.current)) > d4)) continue;
                d4 = Math.abs(this.T.get(i, PlotVectorViewer.this.current));
            }
            double d5 = 1.0;
            int n9 = 1;
            int n10 = 1;
            if (d4 >= 1.0) {
                while (d4 >= 10.0) {
                    d4 /= 10.0;
                    n9 *= 10;
                }
                n10 = (int)Math.round(d4 + 0.5);
                d = n8 / n10;
                d2 /= d5 * 2.0;
            } else {
                while (d4 <= 1.0) {
                    d4 *= 10.0;
                    n9 = (int)((double)n9 * 10.0);
                }
                d5 = (int)Math.round(d4 + 0.5);
                n10 = (int)Math.round(d4 + 0.5);
                d = n8 / (n10 * 2);
            }
            d2 = d2 / (d5 * 2.0) * (double)n9;
            int n11 = 40 + n8 / 2;
            graphics.setColor(Color.black);
            graphics.drawRect(40, 40, n7, n8);
            graphics.drawLine(40, 40 + n8 / 2, 40 + n7, 40 + n8 / 2);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n12 = fontMetrics.getHeight();
            for (n5 = 1; n5 < n10; ++n5) {
                graphics.drawLine(40, 40 + (int)Math.round((double)n5 * d), 45, 40 + (int)Math.round((double)n5 * d));
            }
            for (n5 = n10 + 1; n5 < n10 * 2; ++n5) {
                graphics.drawLine(40, 40 + (int)Math.round((double)n5 * d), 45, 40 + (int)Math.round((double)n5 * d));
            }
            for (n5 = 1; n5 < n6; ++n5) {
                graphics.drawLine(40 + (int)Math.round((double)n5 * d3), 40 + n8 - 5, 40 + (int)Math.round((double)n5 * d3), 40 + n8);
            }
            graphics.setColor(Color.magenta);
            graphics.clipRect(40, 40, n7, n8);
            n5 = -((int)Math.round((double)this.T.get(0, PlotVectorViewer.this.current) * d2));
            for (n4 = 1; n4 < n6; ++n4) {
                n3 = -((int)Math.round((double)this.T.get(n4, PlotVectorViewer.this.current) * d2));
                graphics.drawLine(40 + (int)Math.round((double)(n4 - 1) * d3), n11 + n5, 40 + (int)Math.round((double)n4 * d3), n11 + n3);
                n5 = n3;
            }
            graphics.setColor(new Color(0, 0, 128));
            for (n4 = 0; n4 < n6; ++n4) {
                n3 = -((int)Math.round((double)this.T.get(n4, PlotVectorViewer.this.current) * d2));
                graphics.fillOval(40 + (int)Math.round((double)n4 * d3) - 3, n11 + n3 - 3, 6, 6);
            }
            graphics.setClip(0, 0, this.getWidth(), this.getHeight());
            for (n2 = 0; n2 <= n10 * 2; ++n2) {
                String string = String.valueOf((d5 - (double)n2) / (double)n9);
                n = fontMetrics.stringWidth(string);
                graphics.drawString(string, 30 - n, 40 + (int)Math.round((double)n2 * d) + 5);
            }
            ((Graphics2D)graphics).rotate(-1.5707963267948966);
            for (n2 = 0; n2 < n6; ++n2) {
                String string = String.valueOf(n2 + 1);
                n = fontMetrics.stringWidth(string);
                graphics.drawString(string, -40 - n8 - 10 - n, 45 + (int)Math.round((double)n2 * d3));
            }
            ((Graphics2D)graphics).rotate(1.5707963267948966);
        }
    }
}

