/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Logger;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCA2DViewer;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCA3DViewer;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCAAdditional3DAxesDialog;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCADummyViewer;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCASelectionDialog;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PlotVectorViewer;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PlotViewer;
import org.tigr.microarray.mev.cluster.gui.impl.pca.ValuesViewer;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class PCAGUI
implements IClusterGUI,
IScriptGUI {
    private static final String ADD_NEW_3D_CMD = "add-new-3d-cmd";
    private static final String ADD_NEW_2D_CMD = "add-new-2d-cmd";
    private int mode;
    private int numNeibs;
    private FloatMatrix T;
    private FloatMatrix V;
    private FloatMatrix S;
    private FloatMatrix U;
    private Algorithm algorithm;
    private Logger logger;
    private IFramework currFramework;
    private DefaultMutableTreeNode projectionNode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block13: {
            PCASelectionDialog pCASelectionDialog;
            Listener listener;
            block11: {
                DefaultMutableTreeNode defaultMutableTreeNode2;
                block12: {
                    listener = new Listener();
                    try {
                        pCASelectionDialog = new PCASelectionDialog(iFramework.getFrame());
                        if (pCASelectionDialog.showModal() != 2) break block11;
                        defaultMutableTreeNode2 = null;
                        Object var17_5 = null;
                        if (this.algorithm == null) break block12;
                    }
                    catch (Throwable throwable) {
                        block14: {
                            Object var17_7 = null;
                            if (this.algorithm != null) {
                                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                            }
                            if (this.logger == null) break block14;
                            this.logger.dispose();
                        }
                        throw throwable;
                    }
                    this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                }
                if (this.logger != null) {
                    this.logger.dispose();
                }
                return defaultMutableTreeNode2;
            }
            this.mode = pCASelectionDialog.isClusterGenesSelected() ? 1 : 3;
            this.numNeibs = pCASelectionDialog.getNumNeighbors();
            this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("PCA");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.logger = new Logger(iFramework.getFrame(), "PCA Log Window", listener);
            this.logger.show();
            this.logger.append("Starting SVD calculation\n");
            this.currFramework = iFramework;
            AlgorithmData algorithmData = new AlgorithmData();
            Experiment experiment = iFramework.getData().getExperiment();
            algorithmData.addMatrix("experiment", experiment.getMatrix());
            algorithmData.addParam("distance-factor", String.valueOf(1.0f));
            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
            algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
            int n = iDistanceMenu.getDistanceFunction();
            if (n == 0) {
                n = 3;
            }
            algorithmData.addParam("distance-function", String.valueOf(n));
            algorithmData.addParam("pca-mode", String.valueOf(this.mode));
            algorithmData.addParam("numNeighbors", String.valueOf(this.numNeibs));
            AlgorithmData algorithmData2 = null;
            DefaultMutableTreeNode defaultMutableTreeNode3 = null;
            long l = System.currentTimeMillis();
            switch (this.mode) {
                case 1: {
                    algorithmData.addParam("distance-function", String.valueOf(n));
                    algorithmData2 = this.algorithm.execute(algorithmData);
                    this.T = algorithmData2.getMatrix("T");
                    this.V = algorithmData2.getMatrix("V");
                    this.S = algorithmData2.getMatrix("S");
                    this.U = algorithmData2.getMatrix("U");
                    defaultMutableTreeNode3 = new DefaultMutableTreeNode("PCA - genes");
                    break;
                }
                case 3: {
                    algorithmData2 = this.algorithm.execute(algorithmData);
                    this.T = algorithmData2.getMatrix("T");
                    this.V = algorithmData2.getMatrix("V");
                    this.S = algorithmData2.getMatrix("S");
                    this.U = algorithmData2.getMatrix("U");
                    defaultMutableTreeNode3 = new DefaultMutableTreeNode("PCA - samples");
                    break;
                }
            }
            this.logger.append("Creating the result viewers");
            long l2 = System.currentTimeMillis() - l;
            this.addResultNodes(iFramework.getFrame(), defaultMutableTreeNode3, l2, iDistanceMenu.getFunctionName(n), experiment);
            defaultMutableTreeNode = defaultMutableTreeNode3;
            Object var17_6 = null;
            if (this.algorithm == null) break block13;
            this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
        }
        if (this.logger != null) {
            this.logger.dispose();
        }
        return defaultMutableTreeNode;
    }

    public AlgorithmData getScriptParameters(IFramework iFramework) {
        PCASelectionDialog pCASelectionDialog = new PCASelectionDialog(iFramework.getFrame());
        if (pCASelectionDialog.showModal() == 2) {
            return null;
        }
        this.mode = pCASelectionDialog.isClusterGenesSelected() ? 1 : 3;
        this.numNeibs = pCASelectionDialog.getNumNeighbors();
        AlgorithmData algorithmData = new AlgorithmData();
        algorithmData.addParam("distance-factor", String.valueOf(1.0f));
        IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
        algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
        int n = iDistanceMenu.getDistanceFunction();
        if (n == 0) {
            n = 3;
        }
        algorithmData.addParam("distance-function", String.valueOf(n));
        algorithmData.addParam("pca-mode", String.valueOf(this.mode));
        algorithmData.addParam("numNeighbors", String.valueOf(this.numNeibs));
        algorithmData.addParam("name", "PCA");
        algorithmData.addParam("alg-type", "data-visualization");
        algorithmData.addParam("output-class", "single-output");
        String[] stringArray = new String[]{"Data Visualization"};
        algorithmData.addStringArray("output-nodes", stringArray);
        return algorithmData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework iFramework, AlgorithmData algorithmData, Experiment experiment) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block8: {
            Listener listener = new Listener();
            try {
                this.mode = algorithmData.getParams().getInt("pca-mode");
                this.numNeibs = algorithmData.getParams().getInt("numNeighbors");
                int n = algorithmData.getParams().getInt("distance-function");
                AlgorithmData algorithmData2 = null;
                DefaultMutableTreeNode defaultMutableTreeNode2 = null;
                algorithmData.addMatrix("experiment", experiment.getMatrix());
                this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("PCA");
                this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
                this.logger = new Logger(iFramework.getFrame(), "PCA Log Window", listener);
                this.logger.show();
                this.logger.append("Starting SVD calculation\n");
                this.currFramework = iFramework;
                long l = System.currentTimeMillis();
                switch (this.mode) {
                    case 1: {
                        algorithmData2 = this.algorithm.execute(algorithmData);
                        this.T = algorithmData2.getMatrix("T");
                        this.V = algorithmData2.getMatrix("V");
                        this.S = algorithmData2.getMatrix("S");
                        this.U = algorithmData2.getMatrix("U");
                        defaultMutableTreeNode2 = new DefaultMutableTreeNode("PCA - genes");
                        break;
                    }
                    case 3: {
                        algorithmData2 = this.algorithm.execute(algorithmData);
                        this.T = algorithmData2.getMatrix("T");
                        this.V = algorithmData2.getMatrix("V");
                        this.S = algorithmData2.getMatrix("S");
                        this.U = algorithmData2.getMatrix("U");
                        defaultMutableTreeNode2 = new DefaultMutableTreeNode("PCA - samples");
                        break;
                    }
                }
                this.logger.append("Creating the result viewers");
                long l2 = System.currentTimeMillis() - l;
                this.addResultNodes(iFramework.getFrame(), defaultMutableTreeNode2, l2, iFramework.getDistanceMenu().getFunctionName(n), experiment);
                defaultMutableTreeNode = defaultMutableTreeNode2;
                Object var14_11 = null;
                if (this.algorithm == null) break block8;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var14_12 = null;
                    if (this.algorithm != null) {
                        this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                    }
                    if (this.logger == null) break block9;
                    this.logger.dispose();
                }
                throw throwable;
            }
            this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
        }
        if (this.logger != null) {
            this.logger.dispose();
        }
        return defaultMutableTreeNode;
    }

    private void addResultNodes(Frame frame, DefaultMutableTreeNode defaultMutableTreeNode, long l, String string, Experiment experiment) {
        Listener listener = new Listener();
        PCADummyViewer pCADummyViewer = new PCADummyViewer(this.U, this.S, this.mode);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Components 1, 2, 3");
        this.add3DViewNode(frame, defaultMutableTreeNode2, experiment, 0, 1, 2);
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("2D Views");
        this.add2DViewNode(defaultMutableTreeNode3, experiment, 0, 1, 2);
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Add new 3-axis projections");
        jMenuItem.setActionCommand(ADD_NEW_3D_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Add new 2-axis projections");
        jMenuItem.setActionCommand(ADD_NEW_2D_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        this.projectionNode = new DefaultMutableTreeNode(new LeafInfo("Projections on PC axes", (IViewer)pCADummyViewer, pCADummyViewer.getJPopupMenu()));
        this.projectionNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(this.projectionNode);
        this.addPCPlotsNode(defaultMutableTreeNode);
        this.addPCInfoNode(defaultMutableTreeNode);
        this.addEigenNode(defaultMutableTreeNode);
        this.addGeneralInfoNode(defaultMutableTreeNode, l, string);
    }

    private void add2DViewNode(DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment) {
        boolean bl = false;
        if (this.mode == 1) {
            bl = true;
        } else if (this.mode == 3) {
            bl = false;
        }
        PCA2DViewer pCA2DViewer = new PCA2DViewer(experiment, this.U, bl, 0, 1);
        PCA2DViewer pCA2DViewer2 = new PCA2DViewer(experiment, this.U, bl, 1, 2);
        PCA2DViewer pCA2DViewer3 = new PCA2DViewer(experiment, this.U, bl, 0, 2);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("1, 2", (IViewer)pCA2DViewer, pCA2DViewer.getJPopupMenu())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("2, 3", (IViewer)pCA2DViewer2, pCA2DViewer2.getJPopupMenu())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("1, 3", (IViewer)pCA2DViewer3, pCA2DViewer3.getJPopupMenu())));
    }

    private void add2DViewNode(DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment, int n, int n2, int n3) {
        boolean bl = false;
        if (this.mode == 1) {
            bl = true;
        } else if (this.mode == 3) {
            bl = false;
        }
        PCA2DViewer pCA2DViewer = new PCA2DViewer(experiment, this.U, bl, n, n2);
        PCA2DViewer pCA2DViewer2 = new PCA2DViewer(experiment, this.U, bl, n2, n3);
        PCA2DViewer pCA2DViewer3 = new PCA2DViewer(experiment, this.U, bl, n, n3);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("" + (n + 1) + ", " + (n2 + 1), (IViewer)pCA2DViewer, pCA2DViewer.getJPopupMenu())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("" + (n2 + 1) + ", " + (n3 + 1), (IViewer)pCA2DViewer2, pCA2DViewer2.getJPopupMenu())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("" + (n + 1) + ", " + (n3 + 1), (IViewer)pCA2DViewer3, pCA2DViewer3.getJPopupMenu())));
    }

    private void add3DViewNode(Frame frame, DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment) {
        if (this.U == null || this.U.getColumnDimension() < 3) {
            return;
        }
        PCA3DViewer pCA3DViewer = this.mode == 1 ? new PCA3DViewer(frame, this.mode, this.U, experiment, true, 0, 1, 2) : new PCA3DViewer(frame, this.mode, this.U, experiment, false, 0, 1, 2);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("3D view", (IViewer)pCA3DViewer, pCA3DViewer.getJPopupMenu())));
    }

    private void add3DViewNode(Frame frame, DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment, int n, int n2, int n3) {
        if (this.U == null || this.U.getColumnDimension() < 3) {
            return;
        }
        PCA3DViewer pCA3DViewer = this.mode == 1 ? new PCA3DViewer(frame, this.mode, this.U, experiment, true, n, n2, n3) : new PCA3DViewer(frame, this.mode, this.U, experiment, false, n, n2, n3);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("3D view", (IViewer)pCA3DViewer, pCA3DViewer.getJPopupMenu())));
    }

    private void addPCPlotsNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.S == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("PC Plots");
        PlotVectorViewer plotVectorViewer = new PlotVectorViewer(this.T);
        for (int i = 0; i < this.S.getRowDimension(); ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Component " + (i + 1), (IViewer)plotVectorViewer, (Object)new Integer(i))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addPCInfoNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.S == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("PC Information");
        PCInfoViewer pCInfoViewer = new PCInfoViewer(this.T);
        for (int i = 0; i < this.S.getRowDimension(); ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Component " + (i + 1), (IViewer)pCInfoViewer, (Object)new Integer(i))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addEigenNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Eigenvalues");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Plot", (IViewer)new PlotViewer(this.S))));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Values", (IViewer)new ValuesViewer(this.S))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addGeneralInfoNode(DefaultMutableTreeNode defaultMutableTreeNode, long l, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        if (this.S != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Components: " + this.S.getColumnDimension()));
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(l) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(string));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Number of neighbors for KNN imputation: " + this.numNeibs));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addNew3DNode() {
        if (this.S == null) {
            return;
        }
        PCAAdditional3DAxesDialog pCAAdditional3DAxesDialog = new PCAAdditional3DAxesDialog((JFrame)this.currFramework.getFrame(), true, this.S.getRowDimension());
        pCAAdditional3DAxesDialog.setVisible(true);
        if (!pCAAdditional3DAxesDialog.isOkPressed()) {
            return;
        }
        int n = pCAAdditional3DAxesDialog.getXAxis();
        int n2 = pCAAdditional3DAxesDialog.getYAxis();
        int n3 = pCAAdditional3DAxesDialog.getZAxis();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Components " + (n + 1) + ", " + (n2 + 1) + ", " + (n3 + 1));
        this.add3DViewNode(this.currFramework.getFrame(), defaultMutableTreeNode, this.currFramework.getData().getExperiment(), n, n2, n3);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("2D Views");
        this.add2DViewNode(defaultMutableTreeNode2, this.currFramework.getData().getExperiment(), n, n2, n3);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.currFramework.addNode(this.projectionNode, defaultMutableTreeNode);
    }

    private void addNew2DNode() {
        if (this.S == null) {
            return;
        }
        PCAAdditional3DAxesDialog pCAAdditional3DAxesDialog = new PCAAdditional3DAxesDialog((JFrame)this.currFramework.getFrame(), true, this.S.getRowDimension());
        pCAAdditional3DAxesDialog.setZBoxInvisible(true);
        pCAAdditional3DAxesDialog.setVisible(true);
        if (!pCAAdditional3DAxesDialog.isOkPressed()) {
            return;
        }
        int n = pCAAdditional3DAxesDialog.getXAxis();
        int n2 = pCAAdditional3DAxesDialog.getYAxis();
        boolean bl = false;
        if (this.mode == 1) {
            bl = true;
        } else if (this.mode == 3) {
            bl = false;
        }
        PCA2DViewer pCA2DViewer = new PCA2DViewer(this.currFramework.getData().getExperiment(), this.U, bl, n, n2);
        this.currFramework.addNode(this.projectionNode, new DefaultMutableTreeNode(new LeafInfo("Components " + (n + 1) + ", " + (n2 + 1), (IViewer)pCA2DViewer, pCA2DViewer.getJPopupMenu())));
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            PCAGUI.this.logger.append(algorithmEvent.getDescription());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                PCAGUI.this.algorithm.abort();
                PCAGUI.this.logger.dispose();
            } else if (string.equals(PCAGUI.ADD_NEW_3D_CMD)) {
                PCAGUI.this.addNew3DNode();
            } else if (string.equals(PCAGUI.ADD_NEW_2D_CMD)) {
                PCAGUI.this.addNew2DNode();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            PCAGUI.this.algorithm.abort();
            PCAGUI.this.logger.dispose();
        }
    }
}

