/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCA2DViewer;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCA3DViewer;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCAAdditional3DAxesDialog;
import org.tigr.util.FloatMatrix;

public class PCADummyViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 202011070001L;
    private static final String ADD_NEW_3D_CMD = "add-new-3d-cmd";
    private static final String ADD_NEW_2D_CMD = "add-new-2d-cmd";
    private JPopupMenu popup;
    private IFramework framework;
    private FloatMatrix U;
    private FloatMatrix S;
    private int mode;

    public PCADummyViewer(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n) {
        this.U = floatMatrix;
        this.S = floatMatrix2;
        this.mode = n;
        this.popup = this.createJPopupMenu();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.U);
        objectOutputStream.writeObject(this.S);
        objectOutputStream.writeInt(this.mode);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.U = (FloatMatrix)objectInputStream.readObject();
        this.S = (FloatMatrix)objectInputStream.readObject();
        this.mode = objectInputStream.readInt();
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        if (this.popup == null) {
            this.popup = this.createJPopupMenu();
            DefaultMutableTreeNode defaultMutableTreeNode = iFramework.getCurrentNode();
            if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() instanceof LeafInfo) {
                LeafInfo leafInfo = (LeafInfo)defaultMutableTreeNode.getUserObject();
                leafInfo.setPopupMenu(this.popup);
            }
        }
    }

    public JPopupMenu getJPopupMenu() {
        return this.popup;
    }

    private JPopupMenu createJPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu);
        return jPopupMenu;
    }

    private void addMenuItems(JPopupMenu jPopupMenu) {
        Listener listener = new Listener();
        JMenuItem jMenuItem = new JMenuItem("Add new 3-axis projections");
        jMenuItem.setActionCommand(ADD_NEW_3D_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Add new 2-axis projections");
        jMenuItem.setActionCommand(ADD_NEW_2D_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
    }

    private JMenuItem getJMenuItem(String string) {
        Component[] componentArray = this.popup.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JMenuItem) || !((JMenuItem)componentArray[i]).getActionCommand().equals(string)) continue;
            return (JMenuItem)componentArray[i];
        }
        return null;
    }

    private void add2DViewNode(DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment, int n, int n2, int n3) {
        boolean bl = false;
        if (this.mode == 1) {
            bl = true;
        } else if (this.mode == 3) {
            bl = false;
        }
        PCA2DViewer pCA2DViewer = new PCA2DViewer(experiment, this.U, bl, n, n2);
        PCA2DViewer pCA2DViewer2 = new PCA2DViewer(experiment, this.U, bl, n2, n3);
        PCA2DViewer pCA2DViewer3 = new PCA2DViewer(experiment, this.U, bl, n, n3);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("" + (n + 1) + ", " + (n2 + 1), (IViewer)pCA2DViewer, pCA2DViewer.getJPopupMenu())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("" + (n2 + 1) + ", " + (n3 + 1), (IViewer)pCA2DViewer2, pCA2DViewer2.getJPopupMenu())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("" + (n + 1) + ", " + (n3 + 1), (IViewer)pCA2DViewer3, pCA2DViewer3.getJPopupMenu())));
    }

    private void add3DViewNode(Frame frame, DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment, int n, int n2, int n3) {
        if (this.U == null || this.U.getColumnDimension() < 3) {
            return;
        }
        PCA3DViewer pCA3DViewer = this.mode == 1 ? new PCA3DViewer(frame, this.mode, this.U, experiment, true, n, n2, n3) : new PCA3DViewer(frame, this.mode, this.U, experiment, false, n, n2, n3);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("3D view", (IViewer)pCA3DViewer, pCA3DViewer.getJPopupMenu())));
    }

    private void addNew3DNode() {
        if (this.S == null) {
            return;
        }
        PCAAdditional3DAxesDialog pCAAdditional3DAxesDialog = new PCAAdditional3DAxesDialog((JFrame)this.framework.getFrame(), true, this.S.getRowDimension());
        pCAAdditional3DAxesDialog.setVisible(true);
        if (!pCAAdditional3DAxesDialog.isOkPressed()) {
            return;
        }
        int n = pCAAdditional3DAxesDialog.getXAxis();
        int n2 = pCAAdditional3DAxesDialog.getYAxis();
        int n3 = pCAAdditional3DAxesDialog.getZAxis();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Components " + (n + 1) + ", " + (n2 + 1) + ", " + (n3 + 1));
        this.add3DViewNode(this.framework.getFrame(), defaultMutableTreeNode, this.framework.getData().getExperiment(), n, n2, n3);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("2D Views");
        this.add2DViewNode(defaultMutableTreeNode2, this.framework.getData().getExperiment(), n, n2, n3);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.framework.addNode(this.framework.getCurrentNode(), defaultMutableTreeNode);
    }

    private void addNew2DNode() {
        if (this.S == null) {
            return;
        }
        PCAAdditional3DAxesDialog pCAAdditional3DAxesDialog = new PCAAdditional3DAxesDialog((JFrame)this.framework.getFrame(), true, this.S.getRowDimension());
        pCAAdditional3DAxesDialog.setZBoxInvisible(true);
        pCAAdditional3DAxesDialog.setVisible(true);
        if (!pCAAdditional3DAxesDialog.isOkPressed()) {
            return;
        }
        int n = pCAAdditional3DAxesDialog.getXAxis();
        int n2 = pCAAdditional3DAxesDialog.getYAxis();
        boolean bl = false;
        if (this.mode == 1) {
            bl = true;
        } else if (this.mode == 3) {
            bl = false;
        }
        PCA2DViewer pCA2DViewer = new PCA2DViewer(this.framework.getData().getExperiment(), this.U, bl, n, n2);
        this.framework.addNode(this.framework.getCurrentNode(), new DefaultMutableTreeNode(new LeafInfo("Components " + (n + 1) + ", " + (n2 + 1), (IViewer)pCA2DViewer, pCA2DViewer.getJPopupMenu())));
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(PCADummyViewer.ADD_NEW_3D_CMD)) {
                PCADummyViewer.this.addNew3DNode();
            } else if (string.equals(PCADummyViewer.ADD_NEW_2D_CMD)) {
                PCADummyViewer.this.addNew2DNode();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            PCADummyViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

