/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.cluster.gui.impl.pca.Content3D;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCAResultConfigDialog;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCASelectionAreaDialog;
import org.tigr.util.FloatMatrix;

public class PCA3DViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 202011010001L;
    private static final String RESET_CMD = "reset-cmd";
    private static final String OPTIONS_CMD = "options-cmd";
    private static final String SELECTION_AREA_CMD = "select-cmd";
    private static final String SAVE_CMD = "save-cmd";
    private static final String SHOW_SELECTION_CMD = "show-selection-cmd";
    private static final String HIDE_SELECTION_BOX_CMD = "hide-selection-box-cmd";
    private static final String SHOW_SPHERES_CMD = "show-spheres-cmd";
    private static final String SHOW_TEXT_CMD = "show-text-cmd";
    private static final String WHITE_CMD = "white-cmd";
    private static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    private static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    private IData data;
    private Experiment experiment;
    private Content3D content;
    private JPopupMenu popup;
    private Frame frame;
    private boolean geneViewer;
    private IFramework framework;
    private FloatMatrix U;
    private int mode;
    private int xAxis;
    private int yAxis;
    private int zAxis;
    private int labelIndex = -1;
    private PCASelectionAreaDialog dlg;

    public PCA3DViewer(Frame frame, int n, FloatMatrix floatMatrix, Experiment experiment, boolean bl) {
        this.frame = frame;
        this.experiment = experiment;
        this.geneViewer = bl;
        this.U = floatMatrix;
        this.mode = n;
        this.content = this.createContent(n, floatMatrix, experiment, bl);
        this.dlg = new PCASelectionAreaDialog(this.content, frame, this.content.getPositionX(), this.content.getPositionY(), this.content.getPositionZ(), this.content.getSizeX(), this.content.getSizeY(), this.content.getSizeZ(), this.content.getMaxValue());
        this.popup = this.createJPopupMenu();
    }

    public PCA3DViewer(Frame frame, int n, FloatMatrix floatMatrix, Experiment experiment, boolean bl, int n2, int n3, int n4) {
        this.frame = frame;
        this.experiment = experiment;
        this.geneViewer = bl;
        this.U = floatMatrix;
        this.mode = n;
        this.xAxis = n2;
        this.yAxis = n3;
        this.zAxis = n4;
        this.content = this.createContent(n, floatMatrix, experiment, bl, n2, n3, n4);
        this.dlg = new PCASelectionAreaDialog(this.content, frame, this.content.getPositionX(), this.content.getPositionY(), this.content.getPositionZ(), this.content.getSizeX(), this.content.getSizeY(), this.content.getSizeZ(), this.content.getMaxValue());
        this.popup = this.createJPopupMenu();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.experiment);
        objectOutputStream.writeBoolean(this.geneViewer);
        objectOutputStream.writeObject(this.U);
        objectOutputStream.writeInt(this.mode);
        objectOutputStream.writeInt(this.xAxis);
        objectOutputStream.writeInt(this.yAxis);
        objectOutputStream.writeInt(this.zAxis);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.experiment = (Experiment)objectInputStream.readObject();
        this.geneViewer = objectInputStream.readBoolean();
        this.U = (FloatMatrix)objectInputStream.readObject();
        this.mode = objectInputStream.readInt();
        this.xAxis = objectInputStream.readInt();
        this.yAxis = objectInputStream.readInt();
        this.zAxis = objectInputStream.readInt();
        this.content = this.createContent(this.mode, this.U, this.experiment, this.geneViewer, this.xAxis, this.yAxis, this.zAxis);
        this.dlg = new PCASelectionAreaDialog(this.content, this.frame, this.content.getPositionX(), this.content.getPositionY(), this.content.getPositionZ(), this.content.getSizeX(), this.content.getSizeY(), this.content.getSizeZ(), this.content.getMaxValue());
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.frame = iFramework.getFrame();
        this.data = iFramework.getData();
        IDisplayMenu iDisplayMenu = iFramework.getDisplayMenu();
        this.labelIndex = iDisplayMenu.getLabelIndex();
        this.content.setData(this.data);
        this.content.setGeneLabelIndex(this.labelIndex);
        this.onMenuChanged(iDisplayMenu);
        this.content.updateScene();
        if (this.popup == null) {
            this.popup = this.createJPopupMenu();
            DefaultMutableTreeNode defaultMutableTreeNode = iFramework.getCurrentNode();
            if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() instanceof LeafInfo) {
                LeafInfo leafInfo = (LeafInfo)defaultMutableTreeNode.getUserObject();
                leafInfo.setPopupMenu(this.popup);
            }
        }
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.labelIndex = iDisplayMenu.getLabelIndex();
        this.content.setGeneLabelIndex(this.labelIndex);
        this.content.updateScene();
    }

    public void onDataChanged(IData iData) {
        this.data = iData;
        this.content.setData(iData);
        this.content.updateScene();
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    public BufferedImage getImage() {
        return this.content.createImage();
    }

    private Content3D createContent(int n, FloatMatrix floatMatrix, Experiment experiment, boolean bl) {
        return new Content3D(n, floatMatrix, experiment, bl);
    }

    private Content3D createContent(int n, FloatMatrix floatMatrix, Experiment experiment, boolean bl, int n2, int n3, int n4) {
        return new Content3D(n, floatMatrix, experiment, bl, n2, n3, n4);
    }

    public JPopupMenu getJPopupMenu() {
        return this.popup;
    }

    private JPopupMenu createJPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu);
        return jPopupMenu;
    }

    private void addMenuItems(JPopupMenu jPopupMenu) {
        Listener listener = new Listener();
        JMenuItem jMenuItem = new JMenuItem("Reset", GUIFactory.getIcon("refresh16.gif"));
        jMenuItem.setActionCommand(RESET_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Options...", GUIFactory.getIcon("edit16.gif"));
        jMenuItem.setActionCommand(OPTIONS_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Selection area...", GUIFactory.getIcon("edit16.gif"));
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(SELECTION_AREA_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Store cluster...", GUIFactory.getIcon("new16.gif"));
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(STORE_CLUSTER_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("launch_new_mav.gif"));
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(SAVE_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JCheckBoxMenuItem("Show selection area");
        jMenuItem.setActionCommand(SHOW_SELECTION_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("Hide selection box");
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(HIDE_SELECTION_BOX_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("Show spheres");
        jMenuItem.setActionCommand(SHOW_SPHERES_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("Show text");
        jMenuItem.setEnabled(true);
        jMenuItem.setActionCommand(SHOW_TEXT_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("White background");
        jMenuItem.setActionCommand(WHITE_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
    }

    private JMenuItem getJMenuItem(String string) {
        Component[] componentArray = this.popup.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JMenuItem) || !((JMenuItem)componentArray[i]).getActionCommand().equals(string)) continue;
            return (JMenuItem)componentArray[i];
        }
        return null;
    }

    private void setEnableMenuItem(String string, boolean bl) {
        JMenuItem jMenuItem = this.getJMenuItem(string);
        if (jMenuItem == null) {
            return;
        }
        jMenuItem.setEnabled(bl);
    }

    private void onReset() {
        this.content.reset();
    }

    private void onOptions() {
        PCAResultConfigDialog pCAResultConfigDialog = new PCAResultConfigDialog(this.frame, this.content.getPointSize(), this.content.getSelectedPointSize(), this.content.getScaleAxisX(), this.content.getScaleAxisY(), this.content.getScaleAxisZ());
        if (pCAResultConfigDialog.showModal() == 0) {
            this.content.setPointSize(pCAResultConfigDialog.getPointSize());
            this.content.setSelectedPointSize(pCAResultConfigDialog.getSelectedPointSize());
            this.content.setScale(pCAResultConfigDialog.getScaleAxisX(), pCAResultConfigDialog.getScaleAxisY(), pCAResultConfigDialog.getScaleAxisZ());
            this.content.updateScene();
        }
    }

    private void onSelectionArea() {
        if (this.dlg.showModal() == 0) {
            this.content.setBoxPosition(this.dlg.getPositionX(), this.dlg.getPositionY(), this.dlg.getPositionZ());
            this.content.setBoxSize(this.dlg.getSizeX(), this.dlg.getSizeY(), this.dlg.getSizeZ());
            this.content.updateScene();
        }
    }

    private void onSave() {
        try {
            if (this.geneViewer) {
                ExperimentUtil.saveExperiment((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.content.getSelectedGenes());
            } else {
                ExperimentUtil.saveExperimentCluster((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.content.getSelectedGenes());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.frame, "Can not save matrix!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void storeCluster() {
        if (this.geneViewer) {
            this.framework.storeSubCluster(this.content.getSelectedGenes(), this.experiment, 0);
        } else {
            this.framework.storeSubCluster(this.content.getSelectedGenes(), this.experiment, 1);
        }
        this.content.setSelection(false);
        this.onDataChanged(this.data);
        this.content.updateScene();
    }

    private void launchNewSession() {
        if (this.geneViewer) {
            this.framework.launchNewMAV(this.content.getSelectedGenes(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
        } else {
            this.framework.launchNewMAV(this.content.getSelectedGenes(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
        }
    }

    private void onShowSelection() {
        JMenuItem jMenuItem = this.getJMenuItem(SHOW_SELECTION_CMD);
        JMenuItem jMenuItem2 = this.getJMenuItem(HIDE_SELECTION_BOX_CMD);
        JMenuItem jMenuItem3 = this.getJMenuItem(SELECTION_AREA_CMD);
        JMenuItem jMenuItem4 = this.getJMenuItem(SAVE_CMD);
        JMenuItem jMenuItem5 = this.getJMenuItem(STORE_CLUSTER_CMD);
        JMenuItem jMenuItem6 = this.getJMenuItem(LAUNCH_NEW_SESSION_CMD);
        if (jMenuItem.isSelected()) {
            this.content.setSelection(true);
            this.content.setSelectionBox(!jMenuItem2.isSelected());
            jMenuItem3.setEnabled(true);
            jMenuItem4.setEnabled(true);
            jMenuItem2.setEnabled(true);
            jMenuItem5.setEnabled(true);
            jMenuItem6.setEnabled(true);
        } else {
            this.content.setSelection(false);
            this.content.setSelectionBox(false);
            jMenuItem3.setEnabled(false);
            jMenuItem4.setEnabled(false);
            jMenuItem2.setEnabled(false);
            jMenuItem5.setEnabled(false);
            jMenuItem6.setEnabled(false);
        }
        this.content.updateScene();
    }

    private void onHideSelection() {
        this.content.setSelectionBox(!this.content.isSelectionBox());
        this.content.updateScene();
    }

    private void onShowSphere() {
        this.content.setShowSpheres(!this.content.isShowSpheres());
        this.content.updateScene();
        JMenuItem jMenuItem = this.getJMenuItem(SHOW_SPHERES_CMD);
        JMenuItem jMenuItem2 = this.getJMenuItem(SHOW_TEXT_CMD);
        if (jMenuItem.isSelected()) {
            this.content.setShowSpheres(true);
            this.content.setShowText(jMenuItem2.isSelected());
            jMenuItem2.setEnabled(true);
        } else {
            this.content.setShowSpheres(false);
            this.content.setShowText(jMenuItem2.isSelected());
            jMenuItem2.setEnabled(true);
        }
        this.content.updateScene();
    }

    private void onShowText() {
        this.content.setShowText(!this.content.isShowText());
        this.content.updateScene();
    }

    private void onWhiteBackground() {
        this.content.setWhiteBackround(!this.content.isWhiteBackground());
        this.content.updateScene();
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(PCA3DViewer.RESET_CMD)) {
                PCA3DViewer.this.onReset();
            } else if (string.equals(PCA3DViewer.OPTIONS_CMD)) {
                PCA3DViewer.this.onOptions();
            } else if (string.equals(PCA3DViewer.SELECTION_AREA_CMD)) {
                PCA3DViewer.this.onSelectionArea();
            } else if (string.equals(PCA3DViewer.SAVE_CMD)) {
                PCA3DViewer.this.onSave();
            } else if (string.equals(PCA3DViewer.SHOW_SELECTION_CMD)) {
                PCA3DViewer.this.onShowSelection();
            } else if (string.equals(PCA3DViewer.HIDE_SELECTION_BOX_CMD)) {
                PCA3DViewer.this.onHideSelection();
            } else if (string.equals(PCA3DViewer.SHOW_SPHERES_CMD)) {
                PCA3DViewer.this.onShowSphere();
            } else if (string.equals(PCA3DViewer.SHOW_TEXT_CMD)) {
                PCA3DViewer.this.onShowText();
            } else if (string.equals(PCA3DViewer.WHITE_CMD)) {
                PCA3DViewer.this.onWhiteBackground();
            } else if (string.equals(PCA3DViewer.STORE_CLUSTER_CMD)) {
                PCA3DViewer.this.storeCluster();
            } else if (string.equals(PCA3DViewer.LAUNCH_NEW_SESSION_CMD)) {
                PCA3DViewer.this.launchNewSession();
            }
        }
    }
}

