/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.util.FloatMatrix;

public class PCA2DViewer
extends JPanel
implements IViewer,
Serializable {
    public static final long serialVersionUID = 202011060001L;
    private static final String SAVE_CMD = "save-cmd";
    private static final String SHOW_TEXT_CMD = "show-text-cmd";
    private static final String SHOW_TICK_LABELS_CMD = "show-tick-labels-cmd";
    private static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    private static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    private static final String DISPLAY_EXPT_NAMES_CMD = "display-expt-names-cmd";
    private static final String SHOW_LARGER_POINTS_CMD = "show-larger-points-cmd";
    private float[] yArray;
    private float[] xArray;
    private int axis1;
    private int axis2;
    private FloatMatrix UMatrix;
    private Experiment experiment;
    private IFramework framework;
    private Frame frame;
    private IData data;
    private JPopupMenu popup;
    private Ellipse2D.Double ellipse;
    private boolean displayExptNames;
    private boolean showLargePoints;
    private boolean geneViewer;
    private boolean showTickLabels;
    Rectangle currentRect = null;
    Rectangle rectToDraw = null;
    Rectangle previousRectDrawn = new Rectangle();

    public PCA2DViewer(Experiment experiment, float[] fArray, float[] fArray2, boolean bl, int n, int n2) {
        this.yArray = fArray2;
        this.xArray = fArray;
        this.displayExptNames = false;
        this.showLargePoints = false;
        this.showTickLabels = true;
        this.geneViewer = bl;
        this.axis1 = n;
        this.axis2 = n2;
        this.experiment = experiment;
        this.ellipse = new Ellipse2D.Double();
        this.setBackground(Color.white);
        this.popup = this.createJPopupMenu();
        GraphListener graphListener = new GraphListener();
        this.addMouseListener(graphListener);
        this.addMouseMotionListener(graphListener);
    }

    public PCA2DViewer(Experiment experiment, FloatMatrix floatMatrix, boolean bl, int n, int n2) {
        this.UMatrix = floatMatrix;
        this.axis1 = n;
        this.axis2 = n2;
        this.xArray = this.getFloatArray(floatMatrix, n);
        this.yArray = this.getFloatArray(floatMatrix, n2);
        this.displayExptNames = false;
        this.showLargePoints = false;
        this.showTickLabels = true;
        this.geneViewer = bl;
        this.experiment = experiment;
        this.ellipse = new Ellipse2D.Double();
        this.setBackground(Color.white);
        this.popup = this.createJPopupMenu();
        GraphListener graphListener = new GraphListener();
        this.addMouseListener(graphListener);
        this.addMouseMotionListener(graphListener);
    }

    private float[] getFloatArray(FloatMatrix floatMatrix, int n) {
        float[] fArray = new float[floatMatrix.getRowDimension()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = floatMatrix.A[i][n];
        }
        return fArray;
    }

    public void paint(Graphics graphics) {
        int n;
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = (int)Math.round((double)(this.getWidth() / 2));
        int n5 = (int)Math.round((double)(this.getHeight() / 2));
        double d = this.getMax(this.xArray);
        double d2 = this.getMax(this.yArray);
        double d3 = this.getMin(this.xArray);
        double d4 = this.getMin(this.yArray);
        double d5 = this.getXScalingFactor(d, d3);
        double d6 = this.getYScalingFactor(d2, d4);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.drawLine(0, (int)Math.round((double)(this.getHeight() / 2)), this.getWidth(), (int)Math.round((double)(this.getHeight() / 2)));
        graphics2D.drawLine((int)Math.round((double)(this.getWidth() / 2)), 0, (int)Math.round((double)(this.getWidth() / 2)), this.getHeight());
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        double d7 = 0.0;
        double d8 = 0.0;
        d7 = Math.abs(d) > Math.abs(d3) ? Math.abs(d / 5.0) : Math.abs(d3 / 5.0);
        d8 = Math.abs(d2) > Math.abs(d4) ? Math.abs(d2 / 5.0) : Math.abs(d4 / 5.0);
        double d9 = 0.0;
        double d10 = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = d9;
            d9 += d7;
            dArray2[n] = d10;
            d10 += d8;
        }
        if (this.showTickLabels) {
            double d11;
            int n6;
            for (n = 1; n < dArray.length; ++n) {
                graphics2D.drawLine((int)Math.round(dArray[n] * d5) + this.getWidth() / 2, this.getHeight() / 2 - 5, (int)Math.round(dArray[n] * d5) + this.getWidth() / 2, this.getHeight() / 2 + 5);
            }
            for (n = 1; n < dArray.length; ++n) {
                graphics2D.drawLine(this.getWidth() / 2 - (int)Math.round(dArray[n] * d5), this.getHeight() / 2 - 5, this.getWidth() / 2 - (int)Math.round(dArray[n] * d5), this.getHeight() / 2 + 5);
            }
            for (n = 1; n < dArray2.length; ++n) {
                graphics2D.drawLine(this.getWidth() / 2 - 5, this.getHeight() / 2 + (int)Math.round(dArray2[n] * d6), this.getWidth() / 2 + 5, this.getHeight() / 2 + (int)Math.round(dArray2[n] * d6));
            }
            for (n = 1; n < dArray2.length; ++n) {
                graphics2D.drawLine(this.getWidth() / 2 - 5, this.getHeight() / 2 - (int)Math.round(dArray2[n] * d6), this.getWidth() / 2 + 5, this.getHeight() / 2 - (int)Math.round(dArray2[n] * d6));
            }
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setColor(Color.black);
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setMaximumFractionDigits(2);
            for (n6 = 1; n6 < dArray.length; ++n6) {
                d11 = graphics2D.getFontMetrics().stringWidth(decimalFormat.format(dArray[n6]));
                graphics2D.drawString(decimalFormat.format(dArray[n6]), (int)Math.round(dArray[n6] * d5) + this.getWidth() / 2 - (int)Math.round(0.5 * d11), this.getHeight() / 2 + 20);
            }
            for (n6 = 1; n6 < dArray.length; ++n6) {
                d11 = graphics2D.getFontMetrics().stringWidth("-" + decimalFormat.format(dArray[n6]));
                graphics2D.drawString("-" + decimalFormat.format(dArray[n6]), this.getWidth() / 2 - (int)Math.round(dArray[n6] * d5) - (int)Math.round(0.5 * d11), this.getHeight() / 2 + 20);
            }
            for (n6 = 1; n6 < dArray2.length; ++n6) {
                graphics2D.drawString(decimalFormat.format(dArray2[n6]), this.getWidth() / 2 + 10, this.getHeight() / 2 - (int)Math.round(dArray2[n6] * d6));
            }
            for (n6 = 1; n6 < dArray2.length; ++n6) {
                graphics2D.drawString("-" + decimalFormat.format(dArray2[n6]), this.getWidth() / 2 + 10, this.getHeight() / 2 + (int)Math.round(dArray2[n6] * d6));
            }
        }
        for (n = 0; n < this.xArray.length; ++n) {
            Color color = Color.black;
            if (this.geneViewer) {
                color = this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(n));
                if (color == null) {
                    color = Color.black;
                }
            } else {
                color = this.data.getExperimentColor(n);
                if (color == null) {
                    color = Color.black;
                }
            }
            graphics2D.setColor(color);
            if (this.showLargePoints) {
                this.drawRectPoint(graphics2D, this.xArray[n], this.yArray[n], this.getXScalingFactor(d, d3), this.getYScalingFactor(d2, d4), 8);
            } else {
                this.drawPoint(graphics2D, this.xArray[n], this.yArray[n], this.getXScalingFactor(d, d3), this.getYScalingFactor(d2, d4), 5);
            }
            graphics2D.setColor(Color.black);
        }
        graphics2D.drawString("X axis = " + (this.axis1 + 1) + ", Y axis = " + (this.axis2 + 1), this.getWidth() / 2 + 25, this.getHeight() - 25);
        if (!this.geneViewer && this.displayExptNames) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(graphics2D.getFont());
            double d12 = fontMetrics.getAscent();
            double d13 = fontMetrics.getMaxAdvance();
            for (int i = 0; i < this.xArray.length; ++i) {
                String string;
                double d14;
                double[] dArray3 = this.getCoords(this.xArray[i], this.yArray[i]);
                if (dArray3[0] + 0.5 * d13 + (d14 = (double)fontMetrics.stringWidth(string = this.data.getSampleName(i))) > (double)this.getWidth()) {
                    graphics2D.drawString(string, (float)(dArray3[0] - d14 - 0.25 * d13), (float)(dArray3[1] + 0.5 * d12));
                    continue;
                }
                graphics2D.drawString(string, (float)(dArray3[0] + 0.5 * d13), (float)(dArray3[1] + 0.5 * d12));
            }
        }
        if (this.currentRect != null) {
            graphics2D.setXORMode(Color.white);
            graphics2D.draw(this.ellipse);
        }
    }

    private void drawPoint(Graphics2D graphics2D, double d, double d2, double d3, double d4, int n) {
        int n2 = (int)Math.round(d * d3);
        int n3 = (int)Math.round(d2 * d4);
        int n4 = (int)Math.round((double)(this.getWidth() / 2)) + n2;
        int n5 = (int)Math.round((double)(this.getHeight() / 2)) - n3;
        graphics2D.fillOval(n4, n5, n, n);
    }

    private void drawRectPoint(Graphics2D graphics2D, double d, double d2, double d3, double d4, int n) {
        int n2 = (int)Math.round(d * d3);
        int n3 = (int)Math.round(d2 * d4);
        int n4 = (int)Math.round((double)(this.getWidth() / 2)) + n2;
        int n5 = (int)Math.round((double)(this.getHeight() / 2)) - n3;
        graphics2D.fillRect(n4, n5, n, n);
    }

    private double getMax(float[] fArray) {
        float f = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < fArray.length; ++i) {
            if (!(f < fArray[i])) continue;
            f = fArray[i];
        }
        return f;
    }

    private double getMin(float[] fArray) {
        float f = Float.POSITIVE_INFINITY;
        for (int i = 0; i < fArray.length; ++i) {
            if (!(f > fArray[i])) continue;
            f = fArray[i];
        }
        return f;
    }

    private double getXScalingFactor(double d, double d2) {
        double d3 = 1.0;
        if (d > 0.0 && d2 > 0.0) {
            d3 = d;
        } else if (d > 0.0 && d2 < 0.0) {
            d3 = d > Math.abs(d2) ? d : Math.abs(d2);
        } else if (d <= 0.0) {
            d3 = Math.abs(d2);
        } else if (d2 == 0.0) {
            d3 = d;
        }
        double d4 = 0.0;
        d4 = (double)(this.getWidth() / 2 - 50) / d3;
        return d4;
    }

    private double getYScalingFactor(double d, double d2) {
        double d3 = 1.0;
        if (d > 0.0 && d2 > 0.0) {
            d3 = d;
        } else if (d > 0.0 && d2 < 0.0) {
            d3 = d > Math.abs(d2) ? d : Math.abs(d2);
        } else if (d <= 0.0) {
            d3 = Math.abs(d2);
        } else if (d2 == 0.0) {
            d3 = d;
        }
        double d4 = 0.0;
        d4 = (double)(this.getHeight() / 2 - 50) / d3;
        return d4;
    }

    public int[][] getClusters() {
        return null;
    }

    public int[] getSelectedPoints() {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.UMatrix.getRowDimension(); ++i) {
            double[] dArray = this.getCoords(this.xArray[i], this.yArray[i]);
            if (!this.ellipse.contains(dArray[0], dArray[1])) continue;
            if (this.geneViewer) {
                vector.add(new Integer(this.experiment.getGeneIndexMappedToData(i)));
                continue;
            }
            vector.add(new Integer(this.experiment.getSampleIndex(i)));
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    private double[] getCoords(double d, double d2) {
        double d3 = this.getMax(this.xArray);
        double d4 = this.getMax(this.yArray);
        double d5 = this.getMin(this.xArray);
        double d6 = this.getMin(this.yArray);
        double d7 = this.getXScalingFactor(d3, d5);
        double d8 = this.getYScalingFactor(d4, d6);
        double d9 = Math.round(d * d7);
        double d10 = Math.round(d2 * d8);
        double d11 = (double)Math.round((double)(this.getWidth() / 2)) + d9;
        double d12 = (double)Math.round((double)(this.getHeight() / 2)) - d10;
        double[] dArray = new double[]{d11, d12};
        return dArray;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public BufferedImage getImage() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public void onClosed() {
    }

    public void onDataChanged(IData iData) {
        this.setData(iData);
    }

    public void onDeselected() {
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.frame = iFramework.getFrame();
        this.setData(iFramework.getData());
        if (this.popup == null) {
            this.popup = this.createJPopupMenu();
            DefaultMutableTreeNode defaultMutableTreeNode = iFramework.getCurrentNode();
            if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() instanceof LeafInfo) {
                LeafInfo leafInfo = (LeafInfo)defaultMutableTreeNode.getUserObject();
                leafInfo.setPopupMenu(this.popup);
            }
        }
    }

    public void setData(IData iData) {
        this.data = iData;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.experiment);
        objectOutputStream.writeBoolean(this.geneViewer);
        objectOutputStream.writeObject(this.UMatrix);
        objectOutputStream.writeInt(this.axis1);
        objectOutputStream.writeInt(this.axis2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.experiment = (Experiment)objectInputStream.readObject();
        this.geneViewer = objectInputStream.readBoolean();
        this.UMatrix = (FloatMatrix)objectInputStream.readObject();
        this.axis1 = objectInputStream.readInt();
        this.axis2 = objectInputStream.readInt();
        this.xArray = this.getFloatArray(this.UMatrix, this.axis1);
        this.yArray = this.getFloatArray(this.UMatrix, this.axis2);
        this.displayExptNames = false;
        this.showLargePoints = false;
        this.showTickLabels = true;
        this.ellipse = new Ellipse2D.Double();
        this.setBackground(Color.white);
        this.currentRect = null;
        this.rectToDraw = null;
        this.previousRectDrawn = new Rectangle();
        GraphListener graphListener = new GraphListener();
        this.addMouseListener(graphListener);
        this.addMouseMotionListener(graphListener);
    }

    public JPopupMenu getJPopupMenu() {
        return this.popup;
    }

    private JPopupMenu createJPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu);
        return jPopupMenu;
    }

    private void addMenuItems(JPopupMenu jPopupMenu) {
        Listener listener = new Listener();
        JMenuItem jMenuItem = new JMenuItem("Store cluster...", GUIFactory.getIcon("new16.gif"));
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(STORE_CLUSTER_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("launch_new_mav.gif"));
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(SAVE_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        if (!this.geneViewer) {
            jPopupMenu.addSeparator();
            jMenuItem = new JCheckBoxMenuItem("Show sample names");
            jMenuItem.setEnabled(true);
            jMenuItem.setActionCommand(DISPLAY_EXPT_NAMES_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
        }
        jMenuItem = new JCheckBoxMenuItem("Larger point size");
        jMenuItem.setEnabled(true);
        jMenuItem.setActionCommand(SHOW_LARGER_POINTS_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("Show tick marks and labels");
        jMenuItem.setEnabled(true);
        jMenuItem.setSelected(true);
        jMenuItem.setActionCommand(SHOW_TICK_LABELS_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
    }

    private JMenuItem getJMenuItem(String string) {
        Component[] componentArray = this.popup.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JMenuItem) || !((JMenuItem)componentArray[i]).getActionCommand().equals(string)) continue;
            return (JMenuItem)componentArray[i];
        }
        return null;
    }

    private void setEnableMenuItem(String string, boolean bl) {
        JMenuItem jMenuItem = this.getJMenuItem(string);
        if (jMenuItem == null) {
            return;
        }
        jMenuItem.setEnabled(bl);
    }

    private void onSave() {
        try {
            if (this.geneViewer) {
                ExperimentUtil.saveExperiment((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.getSelectedPoints());
            } else {
                ExperimentUtil.saveExperimentCluster((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.getSelectedPoints());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.frame, "Can not save matrix!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void storeCluster() {
        if (this.geneViewer) {
            this.framework.storeSubCluster(this.getSelectedPoints(), this.experiment, 0);
        } else {
            this.framework.storeSubCluster(this.getSelectedPoints(), this.experiment, 1);
        }
        this.onDataChanged(this.data);
        this.repaint();
    }

    private void launchNewSession() {
        if (this.geneViewer) {
            this.framework.launchNewMAV(this.getSelectedPoints(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
        } else {
            this.framework.launchNewMAV(this.getSelectedPoints(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
        }
    }

    private void onShowSelection() {
        JMenuItem jMenuItem = this.getJMenuItem(SAVE_CMD);
        JMenuItem jMenuItem2 = this.getJMenuItem(STORE_CLUSTER_CMD);
        JMenuItem jMenuItem3 = this.getJMenuItem(LAUNCH_NEW_SESSION_CMD);
        if (!this.ellipse.isEmpty()) {
            jMenuItem.setEnabled(true);
            jMenuItem2.setEnabled(true);
            jMenuItem3.setEnabled(true);
        } else {
            jMenuItem.setEnabled(false);
            jMenuItem2.setEnabled(false);
            jMenuItem3.setEnabled(false);
        }
    }

    private void showExptNames() {
        this.displayExptNames = !this.displayExptNames;
        this.repaint();
    }

    private void displayLargePoints() {
        this.showLargePoints = !this.showLargePoints;
        this.repaint();
    }

    private void displayTickLabels() {
        this.showTickLabels = !this.showTickLabels;
        this.repaint();
    }

    public int getViewerType() {
        return -1;
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(PCA2DViewer.SAVE_CMD)) {
                PCA2DViewer.this.onSave();
            } else if (string.equals(PCA2DViewer.STORE_CLUSTER_CMD)) {
                PCA2DViewer.this.storeCluster();
            } else if (string.equals(PCA2DViewer.LAUNCH_NEW_SESSION_CMD)) {
                PCA2DViewer.this.launchNewSession();
            } else if (string.equals(PCA2DViewer.DISPLAY_EXPT_NAMES_CMD)) {
                PCA2DViewer.this.showExptNames();
            } else if (string.equals(PCA2DViewer.SHOW_LARGER_POINTS_CMD)) {
                PCA2DViewer.this.displayLargePoints();
            } else if (string.equals(PCA2DViewer.SHOW_TICK_LABELS_CMD)) {
                PCA2DViewer.this.displayTickLabels();
            }
        }
    }

    private class GraphListener
    extends MouseInputAdapter {
        private GraphListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            PCA2DViewer.this.currentRect = new Rectangle(n, n2, 0, 0);
            this.updateDrawableRect(PCA2DViewer.this.getWidth(), PCA2DViewer.this.getHeight());
            PCA2DViewer.this.repaint();
            PCA2DViewer.this.onShowSelection();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.updateSize(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.updateSize(mouseEvent);
        }

        void updateSize(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            PCA2DViewer.this.currentRect.setSize(n - PCA2DViewer.this.currentRect.x, n2 - PCA2DViewer.this.currentRect.y);
            this.updateDrawableRect(PCA2DViewer.this.getWidth(), PCA2DViewer.this.getHeight());
            Rectangle rectangle = PCA2DViewer.this.rectToDraw.union(PCA2DViewer.this.previousRectDrawn);
            PCA2DViewer.this.ellipse.setFrame(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
            PCA2DViewer.this.repaint();
            PCA2DViewer.this.onShowSelection();
        }

        private void updateDrawableRect(int n, int n2) {
            int n3 = PCA2DViewer.this.currentRect.x;
            int n4 = PCA2DViewer.this.currentRect.y;
            int n5 = PCA2DViewer.this.currentRect.width;
            int n6 = PCA2DViewer.this.currentRect.height;
            if (n5 < 0 && (n3 = n3 - (n5 = 0 - n5) + 1) < 0) {
                n5 += n3;
                n3 = 0;
            }
            if (n6 < 0 && (n4 = n4 - (n6 = 0 - n6) + 1) < 0) {
                n6 += n4;
                n4 = 0;
            }
            if (n3 + n5 > n) {
                n5 = n - n3;
            }
            if (n4 + n6 > n2) {
                n6 = n2 - n4;
            }
            if (PCA2DViewer.this.rectToDraw != null) {
                PCA2DViewer.this.previousRectDrawn.setBounds(PCA2DViewer.this.rectToDraw.x, PCA2DViewer.this.rectToDraw.y, PCA2DViewer.this.rectToDraw.width, PCA2DViewer.this.rectToDraw.height);
                PCA2DViewer.this.rectToDraw.setBounds(n3, n4, n5, n6);
            } else {
                PCA2DViewer.this.rectToDraw = new Rectangle(n3, n4, n5, n6);
            }
        }
    }
}

