/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.owa;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.owa.OWACentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.owa.OWACentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.owa.OWAExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.owa.OWAInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.owa.OneWayANOVAInitBox;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class OWAGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private Progress progress;
    private Experiment experiment;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    private String[] auxTitles;
    private Object[][] auxData;
    private Vector fValues;
    private Vector rawPValues;
    private Vector adjPValues;
    private Vector dfNumValues;
    private Vector dfDenomValues;
    private Vector ssGroups;
    private Vector ssError;
    private float[][] geneGroupMeans;
    private float[][] geneGroupSDs;
    private boolean drawSigTreesOnly;
    Vector exptNamesVector;
    int[] groupAssignments;
    private int falseNum;
    private int correctionMethod;
    private double falseProp;
    private IData data;
    private int numGroups;
    private int numPerms;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block27: {
            Object object;
            IDistanceMenu iDistanceMenu;
            int n;
            this.experiment = iFramework.getData().getExperiment();
            this.data = iFramework.getData();
            this.exptNamesVector = new Vector();
            int n2 = this.experiment.getNumberOfSamples();
            int n3 = this.experiment.getNumberOfGenes();
            int[] nArray = this.experiment.getColumnIndicesCopy();
            for (int i = 0; i < n2; ++i) {
                this.exptNamesVector.add(iFramework.getData().getFullSampleName(nArray[i]));
            }
            OneWayANOVAInitBox oneWayANOVAInitBox = new OneWayANOVAInitBox((JFrame)iFramework.getFrame(), true, this.exptNamesVector);
            oneWayANOVAInitBox.setVisible(true);
            if (!oneWayANOVAInitBox.isOkPressed()) {
                return null;
            }
            double d = oneWayANOVAInitBox.getPValue();
            this.numGroups = oneWayANOVAInitBox.getNumGroups();
            this.groupAssignments = oneWayANOVAInitBox.getGroupAssignments();
            boolean bl = oneWayANOVAInitBox.usePerms();
            int n4 = 0;
            if (bl) {
                n4 = oneWayANOVAInitBox.getNumPerms();
            }
            this.correctionMethod = oneWayANOVAInitBox.getCorrectionMethod();
            if (this.correctionMethod == 12) {
                this.falseNum = oneWayANOVAInitBox.getFalseNum();
            }
            if (this.correctionMethod == 13) {
                this.falseProp = oneWayANOVAInitBox.getFalseProp();
            }
            boolean bl2 = oneWayANOVAInitBox.drawTrees();
            this.drawSigTreesOnly = true;
            if (bl2) {
                this.drawSigTreesOnly = oneWayANOVAInitBox.drawSigTreesOnly();
            }
            if ((n = (iDistanceMenu = iFramework.getDistanceMenu()).getDistanceFunction()) == 0) {
                n = 4;
            }
            int n5 = 0;
            boolean bl3 = false;
            boolean bl4 = false;
            int n6 = 4;
            boolean bl5 = false;
            if (bl2) {
                object = new HCLInitDialog(iFramework.getFrame(), iDistanceMenu.getFunctionName(n), iDistanceMenu.isAbsoluteDistance(), true);
                if (((HCLInitDialog)object).showModal() != 0) {
                    return null;
                }
                n5 = ((HCLInitDialog)object).getMethod();
                bl3 = ((HCLInitDialog)object).isClusterExperiments();
                bl4 = ((HCLInitDialog)object).isClusterGenes();
                n6 = ((HCLInitDialog)object).getDistanceMetric();
                bl5 = ((HCLInitDialog)object).getAbsoluteSelection();
            }
            object = new Listener();
            try {
                int n7;
                int n8;
                this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("OWA");
                this.algorithm.addAlgorithmListener((AlgorithmListener)object);
                this.progress = new Progress(iFramework.getFrame(), "Finding significant genes", (DialogListener)object);
                this.progress.show();
                AlgorithmData algorithmData = new AlgorithmData();
                algorithmData.addMatrix("experiment", this.experiment.getMatrix());
                algorithmData.addParam("distance-factor", String.valueOf(1.0f));
                algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
                algorithmData.addParam("distance-function", String.valueOf(n));
                algorithmData.addIntArray("group-assignments", this.groupAssignments);
                algorithmData.addParam("usePerms", String.valueOf(bl));
                algorithmData.addParam("numPerms", String.valueOf(n4));
                algorithmData.addParam("alpha", String.valueOf(d));
                algorithmData.addParam("correction-method", String.valueOf(this.correctionMethod));
                algorithmData.addParam("numGroups", String.valueOf(this.numGroups));
                if (this.correctionMethod == 12) {
                    algorithmData.addParam("falseNum", String.valueOf(this.falseNum));
                }
                if (this.correctionMethod == 13) {
                    algorithmData.addParam("falseProp", String.valueOf((float)this.falseProp));
                }
                if (bl2) {
                    algorithmData.addParam("hierarchical-tree", String.valueOf(true));
                    algorithmData.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
                    algorithmData.addParam("method-linkage", String.valueOf(n5));
                    algorithmData.addParam("calculate-genes", String.valueOf(bl4));
                    algorithmData.addParam("calculate-experiments", String.valueOf(bl3));
                    algorithmData.addParam("hcl-distance-function", String.valueOf(n6));
                    algorithmData.addParam("hcl-distance-absolute", String.valueOf(bl5));
                }
                long l = System.currentTimeMillis();
                AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
                long l2 = System.currentTimeMillis() - l;
                Cluster cluster = algorithmData2.getCluster("cluster");
                NodeList nodeList = cluster.getNodeList();
                AlgorithmParameters algorithmParameters = algorithmData2.getParams();
                int n9 = 2;
                this.clusters = new int[n9][];
                for (int i = 0; i < n9; ++i) {
                    this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
                }
                this.means = algorithmData2.getMatrix("clusters_means");
                this.variances = algorithmData2.getMatrix("clusters_variances");
                FloatMatrix floatMatrix = algorithmData2.getMatrix("rawPValues");
                FloatMatrix floatMatrix2 = algorithmData2.getMatrix("adjPValues");
                FloatMatrix floatMatrix3 = algorithmData2.getMatrix("fValues");
                FloatMatrix floatMatrix4 = algorithmData2.getMatrix("dfNumMatrix");
                FloatMatrix floatMatrix5 = algorithmData2.getMatrix("dfDenomMatrix");
                FloatMatrix floatMatrix6 = algorithmData2.getMatrix("ssGroupsMatrix");
                FloatMatrix floatMatrix7 = algorithmData2.getMatrix("ssErrorMatrix");
                FloatMatrix floatMatrix8 = algorithmData2.getMatrix("geneGroupMeansMatrix");
                FloatMatrix floatMatrix9 = algorithmData2.getMatrix("geneGroupSDsMatrix");
                this.rawPValues = new Vector();
                this.adjPValues = new Vector();
                this.fValues = new Vector();
                this.ssGroups = new Vector();
                this.ssError = new Vector();
                this.geneGroupMeans = new float[floatMatrix8.getRowDimension()][floatMatrix8.getColumnDimension()];
                this.geneGroupSDs = new float[floatMatrix9.getRowDimension()][floatMatrix9.getColumnDimension()];
                for (n8 = 0; n8 < this.geneGroupMeans.length; ++n8) {
                    for (int i = 0; i < this.geneGroupMeans[n8].length; ++i) {
                        this.geneGroupMeans[n8][i] = floatMatrix8.A[n8][i];
                        this.geneGroupSDs[n8][i] = floatMatrix9.A[n8][i];
                    }
                }
                for (n8 = 0; n8 < floatMatrix.getRowDimension(); ++n8) {
                    this.rawPValues.add(new Float(floatMatrix.A[n8][0]));
                    this.adjPValues.add(new Float(floatMatrix2.A[n8][0]));
                }
                for (n8 = 0; n8 < floatMatrix3.getRowDimension(); ++n8) {
                    this.fValues.add(new Float(floatMatrix3.A[n8][0]));
                }
                this.dfNumValues = new Vector();
                this.dfDenomValues = new Vector();
                for (n8 = 0; n8 < floatMatrix4.getRowDimension(); ++n8) {
                    this.dfNumValues.add(new Float(floatMatrix4.A[n8][0]));
                    this.dfDenomValues.add(new Float(floatMatrix5.A[n8][0]));
                    this.ssGroups.add(new Float(floatMatrix6.A[n8][0]));
                    this.ssError.add(new Float(floatMatrix7.A[n8][0]));
                }
                GeneralInfo generalInfo = new GeneralInfo();
                generalInfo.time = l2;
                generalInfo.alpha = d;
                generalInfo.usePerms = bl;
                generalInfo.numPerms = n4;
                generalInfo.correctionMethod = this.getSigMethod(this.correctionMethod);
                generalInfo.function = iDistanceMenu.getFunctionName(n);
                generalInfo.hcl = bl2;
                generalInfo.hcl_genes = bl4;
                generalInfo.hcl_samples = bl3;
                generalInfo.hcl_method = n5;
                Vector<String> vector = new Vector<String>();
                for (n7 = 0; n7 < this.geneGroupMeans[0].length; ++n7) {
                    vector.add("Group" + (n7 + 1) + " mean");
                    vector.add("Group" + (n7 + 1) + " std.dev");
                }
                vector.add("F ratio");
                vector.add("SS(Groups)");
                vector.add("SS(Error)");
                vector.add("df (Groups)");
                vector.add("df (Error)");
                vector.add("Raw p value");
                if (this.correctionMethod != 12 && this.correctionMethod != 13) {
                    vector.add("Adj. p value");
                }
                this.auxTitles = new String[vector.size()];
                for (n7 = 0; n7 < this.auxTitles.length; ++n7) {
                    this.auxTitles[n7] = (String)vector.get(n7);
                }
                this.auxData = new Object[this.experiment.getNumberOfGenes()][this.auxTitles.length];
                for (n7 = 0; n7 < this.auxData.length; ++n7) {
                    int n10 = 0;
                    for (int i = 0; i < this.geneGroupMeans[n7].length; ++i) {
                        this.auxData[n7][n10++] = new Float(this.geneGroupMeans[n7][i]);
                        this.auxData[n7][n10++] = new Float(this.geneGroupSDs[n7][i]);
                    }
                    this.auxData[n7][n10++] = this.fValues.get(n7);
                    this.auxData[n7][n10++] = this.ssGroups.get(n7);
                    this.auxData[n7][n10++] = this.ssError.get(n7);
                    this.auxData[n7][n10++] = this.dfNumValues.get(n7);
                    this.auxData[n7][n10++] = this.dfDenomValues.get(n7);
                    this.auxData[n7][n10++] = this.rawPValues.get(n7);
                    if (this.correctionMethod == 12 || this.correctionMethod == 13) continue;
                    this.auxData[n7][n10++] = this.adjPValues.get(n7);
                }
                defaultMutableTreeNode = this.createResultTree(cluster, generalInfo);
                Object var44_45 = null;
                if (this.algorithm == null) break block27;
            }
            catch (Throwable throwable) {
                block28: {
                    Object var44_46 = null;
                    if (this.algorithm != null) {
                        this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
                    }
                    if (this.progress == null) break block28;
                    this.progress.dispose();
                }
                throw throwable;
            }
            this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
        }
        if (this.progress != null) {
            this.progress.dispose();
        }
        return defaultMutableTreeNode;
    }

    public AlgorithmData getScriptParameters(IFramework iFramework) {
        Object object;
        IDistanceMenu iDistanceMenu;
        int n;
        this.experiment = iFramework.getData().getExperiment();
        this.exptNamesVector = new Vector();
        int n2 = this.experiment.getNumberOfSamples();
        int n3 = this.experiment.getNumberOfGenes();
        for (int i = 0; i < n2; ++i) {
            this.exptNamesVector.add(iFramework.getData().getFullSampleName(this.experiment.getSampleIndex(i)));
        }
        OneWayANOVAInitBox oneWayANOVAInitBox = new OneWayANOVAInitBox((JFrame)iFramework.getFrame(), true, this.exptNamesVector);
        oneWayANOVAInitBox.setVisible(true);
        if (!oneWayANOVAInitBox.isOkPressed()) {
            return null;
        }
        double d = oneWayANOVAInitBox.getPValue();
        this.numGroups = oneWayANOVAInitBox.getNumGroups();
        this.groupAssignments = oneWayANOVAInitBox.getGroupAssignments();
        boolean bl = oneWayANOVAInitBox.usePerms();
        int n4 = 0;
        if (bl) {
            n4 = oneWayANOVAInitBox.getNumPerms();
        }
        this.correctionMethod = oneWayANOVAInitBox.getCorrectionMethod();
        if (this.correctionMethod == 12) {
            this.falseNum = oneWayANOVAInitBox.getFalseNum();
        }
        if (this.correctionMethod == 13) {
            this.falseProp = oneWayANOVAInitBox.getFalseProp();
        }
        boolean bl2 = oneWayANOVAInitBox.drawTrees();
        this.drawSigTreesOnly = true;
        if (bl2) {
            this.drawSigTreesOnly = oneWayANOVAInitBox.drawSigTreesOnly();
        }
        if ((n = (iDistanceMenu = iFramework.getDistanceMenu()).getDistanceFunction()) == 0) {
            n = 4;
        }
        int n5 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        int n6 = 4;
        boolean bl5 = false;
        if (bl2) {
            object = new HCLInitDialog(iFramework.getFrame(), iDistanceMenu.getFunctionName(n), iDistanceMenu.isAbsoluteDistance(), true);
            if (((HCLInitDialog)object).showModal() != 0) {
                return null;
            }
            n5 = ((HCLInitDialog)object).getMethod();
            bl3 = ((HCLInitDialog)object).isClusterExperiments();
            bl4 = ((HCLInitDialog)object).isClusterGenes();
            n6 = ((HCLInitDialog)object).getDistanceMetric();
            bl5 = ((HCLInitDialog)object).getAbsoluteSelection();
        }
        object = new AlgorithmData();
        object.addParam("distance-factor", String.valueOf(1.0f));
        object.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
        object.addParam("distance-function", String.valueOf(n));
        object.addIntArray("group-assignments", this.groupAssignments);
        object.addParam("usePerms", String.valueOf(bl));
        object.addParam("numPerms", String.valueOf(n4));
        object.addParam("alpha", String.valueOf(d));
        object.addParam("correction-method", String.valueOf(this.correctionMethod));
        object.addParam("numGroups", String.valueOf(this.numGroups));
        if (this.correctionMethod == 12) {
            object.addParam("falseNum", String.valueOf(this.falseNum));
        }
        if (this.correctionMethod == 13) {
            object.addParam("falseProp", String.valueOf((float)this.falseProp));
        }
        if (bl2) {
            object.addParam("hierarchical-tree", String.valueOf(true));
            object.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
            object.addParam("method-linkage", String.valueOf(n5));
            object.addParam("calculate-genes", String.valueOf(bl4));
            object.addParam("calculate-experiments", String.valueOf(bl3));
            object.addParam("hcl-distance-function", String.valueOf(n6));
            object.addParam("hcl-distance-absolute", String.valueOf(bl5));
        }
        object.addParam("name", "ANOVA");
        object.addParam("alg-type", "cluster-genes");
        object.addParam("output-class", "partition-output");
        String[] stringArray = new String[]{"Significant Genes", "Non-significant Genes"};
        object.addStringArray("output-nodes", stringArray);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework iFramework, AlgorithmData algorithmData, Experiment experiment) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block19: {
            Listener listener = new Listener();
            this.experiment = experiment;
            this.data = iFramework.getData();
            this.groupAssignments = algorithmData.getIntArray("group-assignments");
            this.correctionMethod = algorithmData.getParams().getInt("correction-method");
            if (this.correctionMethod == 12) {
                this.falseNum = algorithmData.getParams().getInt("falseNum");
            }
            if (this.correctionMethod == 13) {
                this.falseProp = algorithmData.getParams().getFloat("falseProp");
            }
            this.drawSigTreesOnly = algorithmData.getParams().getBoolean("draw-sig-trees-only");
            this.rawPValues = new Vector();
            this.adjPValues = new Vector();
            this.exptNamesVector = new Vector();
            int n = experiment.getNumberOfSamples();
            for (int i = 0; i < n; ++i) {
                this.exptNamesVector.add(this.data.getFullSampleName(i));
            }
            try {
                int n2;
                int n3;
                algorithmData.addMatrix("experiment", experiment.getMatrix());
                this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("OWA");
                this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
                this.progress = new Progress(iFramework.getFrame(), "Finding significant genes", listener);
                this.progress.show();
                long l = System.currentTimeMillis();
                AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
                long l2 = System.currentTimeMillis() - l;
                Cluster cluster = algorithmData2.getCluster("cluster");
                NodeList nodeList = cluster.getNodeList();
                AlgorithmParameters algorithmParameters = algorithmData2.getParams();
                int n4 = 2;
                this.clusters = new int[n4][];
                for (int i = 0; i < n4; ++i) {
                    this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
                }
                this.means = algorithmData2.getMatrix("clusters_means");
                this.variances = algorithmData2.getMatrix("clusters_variances");
                FloatMatrix floatMatrix = algorithmData2.getMatrix("rawPValues");
                FloatMatrix floatMatrix2 = algorithmData2.getMatrix("adjPValues");
                FloatMatrix floatMatrix3 = algorithmData2.getMatrix("fValues");
                FloatMatrix floatMatrix4 = algorithmData2.getMatrix("dfNumMatrix");
                FloatMatrix floatMatrix5 = algorithmData2.getMatrix("dfDenomMatrix");
                FloatMatrix floatMatrix6 = algorithmData2.getMatrix("ssGroupsMatrix");
                FloatMatrix floatMatrix7 = algorithmData2.getMatrix("ssErrorMatrix");
                FloatMatrix floatMatrix8 = algorithmData2.getMatrix("geneGroupMeansMatrix");
                FloatMatrix floatMatrix9 = algorithmData2.getMatrix("geneGroupSDsMatrix");
                this.fValues = new Vector();
                this.ssGroups = new Vector();
                this.ssError = new Vector();
                this.geneGroupMeans = new float[floatMatrix8.getRowDimension()][floatMatrix8.getColumnDimension()];
                this.geneGroupSDs = new float[floatMatrix9.getRowDimension()][floatMatrix9.getColumnDimension()];
                for (n3 = 0; n3 < this.geneGroupMeans.length; ++n3) {
                    for (int i = 0; i < this.geneGroupMeans[n3].length; ++i) {
                        this.geneGroupMeans[n3][i] = floatMatrix8.A[n3][i];
                        this.geneGroupSDs[n3][i] = floatMatrix9.A[n3][i];
                    }
                }
                for (n3 = 0; n3 < floatMatrix.getRowDimension(); ++n3) {
                    this.rawPValues.add(new Float(floatMatrix.A[n3][0]));
                    this.adjPValues.add(new Float(floatMatrix2.A[n3][0]));
                }
                for (n3 = 0; n3 < floatMatrix3.getRowDimension(); ++n3) {
                    this.fValues.add(new Float(floatMatrix3.A[n3][0]));
                }
                this.dfNumValues = new Vector();
                this.dfDenomValues = new Vector();
                for (n3 = 0; n3 < floatMatrix4.getRowDimension(); ++n3) {
                    this.dfNumValues.add(new Float(floatMatrix4.A[n3][0]));
                    this.dfDenomValues.add(new Float(floatMatrix5.A[n3][0]));
                    this.ssGroups.add(new Float(floatMatrix6.A[n3][0]));
                    this.ssError.add(new Float(floatMatrix7.A[n3][0]));
                }
                AlgorithmParameters algorithmParameters2 = algorithmData.getParams();
                GeneralInfo generalInfo = new GeneralInfo();
                generalInfo.time = l2;
                generalInfo.alpha = algorithmParameters2.getFloat("alpha");
                this.numGroups = algorithmParameters2.getInt("numGroups");
                generalInfo.correctionMethod = this.getSigMethod(algorithmParameters2.getInt("correction-method"));
                generalInfo.usePerms = algorithmParameters2.getBoolean("usePerms");
                generalInfo.numPerms = algorithmParameters2.getInt("numPerms");
                generalInfo.function = iFramework.getDistanceMenu().getFunctionName(algorithmParameters2.getInt("distance-function"));
                generalInfo.hcl = algorithmParameters2.getBoolean("hierarchical-tree");
                generalInfo.hcl_genes = algorithmParameters2.getBoolean("calculate-genes");
                generalInfo.hcl_samples = algorithmParameters2.getBoolean("calculate-experiments");
                if (generalInfo.hcl) {
                    generalInfo.hcl_method = algorithmParameters2.getInt("method-linkage");
                }
                Vector<String> vector = new Vector<String>();
                for (n2 = 0; n2 < this.geneGroupMeans[0].length; ++n2) {
                    vector.add("Group" + (n2 + 1) + " mean");
                    vector.add("Group" + (n2 + 1) + " std.dev");
                }
                vector.add("F ratio");
                vector.add("SS(Groups)");
                vector.add("SS(Error)");
                vector.add("df (Groups)");
                vector.add("df (Error)");
                vector.add("Raw p value");
                if (this.correctionMethod != 12 && this.correctionMethod != 13) {
                    vector.add("Adj. p value");
                }
                this.auxTitles = new String[vector.size()];
                for (n2 = 0; n2 < this.auxTitles.length; ++n2) {
                    this.auxTitles[n2] = (String)vector.get(n2);
                }
                this.auxData = new Object[experiment.getNumberOfGenes()][this.auxTitles.length];
                for (n2 = 0; n2 < this.auxData.length; ++n2) {
                    int n5 = 0;
                    for (int i = 0; i < this.geneGroupMeans[n2].length; ++i) {
                        this.auxData[n2][n5++] = new Float(this.geneGroupMeans[n2][i]);
                        this.auxData[n2][n5++] = new Float(this.geneGroupSDs[n2][i]);
                    }
                    this.auxData[n2][n5++] = this.fValues.get(n2);
                    this.auxData[n2][n5++] = this.ssGroups.get(n2);
                    this.auxData[n2][n5++] = this.ssError.get(n2);
                    this.auxData[n2][n5++] = this.dfNumValues.get(n2);
                    this.auxData[n2][n5++] = this.dfDenomValues.get(n2);
                    this.auxData[n2][n5++] = this.rawPValues.get(n2);
                    if (this.correctionMethod == 12 || this.correctionMethod == 13) continue;
                    this.auxData[n2][n5++] = this.adjPValues.get(n2);
                }
                defaultMutableTreeNode = this.createResultTree(cluster, generalInfo);
                Object var31_33 = null;
                if (this.algorithm == null) break block19;
            }
            catch (Throwable throwable) {
                block20: {
                    Object var31_34 = null;
                    if (this.algorithm != null) {
                        this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                    }
                    if (this.progress == null) break block20;
                    this.progress.dispose();
                }
                throw throwable;
            }
            this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
        }
        if (this.progress != null) {
            this.progress.dispose();
        }
        return defaultMutableTreeNode;
    }

    private String getSigMethod(int n) {
        String string = "";
        if (n == 1) {
            string = "Just alpha (uncorrected)";
        } else if (n == 2) {
            string = "Standard Bonferroni correction";
        } else if (n == 3) {
            string = "Adjusted Bonferroni correction";
        } else if (n == 9) {
            string = "Westfall Young stepdown - MaxT";
        } else if (n == 12) {
            string = "False significant number: " + this.falseNum + " or less";
        } else if (n == 13) {
            string = "False significant proportion: " + this.falseProp + " or less";
        }
        return string;
    }

    private DefaultMutableTreeNode createResultTree(Cluster cluster, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("One-way ANOVA");
        this.addResultNodes(defaultMutableTreeNode, cluster, generalInfo);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        this.addExpressionImages(defaultMutableTreeNode);
        this.addHierarchicalTrees(defaultMutableTreeNode, cluster, generalInfo);
        this.addCentroidViews(defaultMutableTreeNode);
        this.addTableViews(defaultMutableTreeNode);
        this.addClusterInfo(defaultMutableTreeNode);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addTableViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Table Views");
        ClusterTableViewer clusterTableViewer = new ClusterTableViewer(this.experiment, this.clusters, this.data, this.auxTitles, this.auxData);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (i < this.clusters.length - 1) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)clusterTableViewer, (Object)new Integer(i))));
                continue;
            }
            if (i != this.clusters.length - 1) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)clusterTableViewer, (Object)new Integer(i))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        OWAExperimentViewer oWAExperimentViewer = new OWAExperimentViewer(this.experiment, this.clusters, this.geneGroupMeans, this.geneGroupSDs, this.rawPValues, this.adjPValues, this.fValues, this.ssGroups, this.ssError, this.dfNumValues, this.dfDenomValues);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (i < this.clusters.length - 1) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)oWAExperimentViewer, (Object)new Integer(i))));
                continue;
            }
            if (i != this.clusters.length - 1) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)oWAExperimentViewer, (Object)new Integer(i))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        if (!generalInfo.hcl) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = cluster.getNodeList();
        if (!this.drawSigTreesOnly) {
            for (int i = 0; i < nodeList.getSize(); ++i) {
                if (i < nodeList.getSize() - 1) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", this.createHCLViewer(nodeList.getNode(i), generalInfo))));
                    continue;
                }
                if (i != nodeList.getSize() - 1) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", this.createHCLViewer(nodeList.getNode(i), generalInfo))));
            }
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", this.createHCLViewer(nodeList.getNode(0), generalInfo))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private IViewer createHCLViewer(Node node, GeneralInfo generalInfo) {
        HCLTreeData hCLTreeData;
        HCLTreeData hCLTreeData2 = hCLTreeData = generalInfo.hcl_genes ? this.getResult(node, 0) : null;
        HCLTreeData hCLTreeData3 = generalInfo.hcl_samples ? this.getResult(node, generalInfo.hcl_genes ? 4 : 0) : null;
        return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData, hCLTreeData3);
    }

    private HCLTreeData getResult(Node node, int n) {
        HCLTreeData hCLTreeData = new HCLTreeData();
        NodeValueList nodeValueList = node.getValues();
        hCLTreeData.child_1_array = (int[])nodeValueList.getNodeValue((int)n).value;
        hCLTreeData.child_2_array = (int[])nodeValueList.getNodeValue((int)(n + 1)).value;
        hCLTreeData.node_order = (int[])nodeValueList.getNodeValue((int)(n + 2)).value;
        hCLTreeData.height = (float[])nodeValueList.getNodeValue((int)(n + 3)).value;
        return hCLTreeData;
    }

    private void addClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Results (#,%)", (IViewer)new OWAInfoViewer(this.clusters, this.experiment.getNumberOfGenes()))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        OWACentroidViewer oWACentroidViewer = new OWACentroidViewer(this.experiment, this.clusters, this.geneGroupMeans, this.geneGroupSDs, this.rawPValues, this.adjPValues, this.fValues, this.ssGroups, this.ssError, this.dfNumValues, this.dfDenomValues);
        oWACentroidViewer.setMeans(this.means.A);
        oWACentroidViewer.setVariances(this.variances.A);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (i == 0) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)oWACentroidViewer, (Object)new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)oWACentroidViewer, (Object)new CentroidUserObject(i, 1))));
                continue;
            }
            if (i != 1) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)oWACentroidViewer, (Object)new CentroidUserObject(i, 0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)oWACentroidViewer, (Object)new CentroidUserObject(i, 1))));
        }
        OWACentroidsViewer oWACentroidsViewer = new OWACentroidsViewer(this.experiment, this.clusters, this.geneGroupMeans, this.geneGroupSDs, this.rawPValues, this.adjPValues, this.fValues, this.ssGroups, this.ssError, this.dfNumValues, this.dfDenomValues);
        oWACentroidsViewer.setMeans(this.means.A);
        oWACentroidsViewer.setVariances(this.variances.A);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)oWACentroidsViewer, (Object)new Integer(0))));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)oWACentroidsViewer, (Object)new Integer(1))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        defaultMutableTreeNode2.add(this.getGroupAssignmentInfo());
        if (generalInfo.correctionMethod.startsWith("False")) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Confidence (1 - alpha) : " + (1.0 - generalInfo.alpha) * 100.0 + " %"));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Alpha (overall threshold p-value): " + generalInfo.alpha));
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Used permutation test? " + generalInfo.usePerms));
        if (generalInfo.usePerms) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Number of permutations " + generalInfo.numPerms));
        }
        if (generalInfo.correctionMethod.startsWith("False")) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.correctionMethod));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Significance determined by: " + generalInfo.correctionMethod));
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("HCL: " + generalInfo.getMethodName()));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.function));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private DefaultMutableTreeNode getGroupAssignmentInfo() {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Group assignments ");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Not in groups");
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[this.numGroups];
        for (n = 0; n < this.numGroups; ++n) {
            defaultMutableTreeNodeArray[n] = new DefaultMutableTreeNode("Group " + (n + 1));
        }
        for (n = 0; n < this.groupAssignments.length; ++n) {
            int n2 = this.groupAssignments[n];
            if (n2 == 0) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(n)));
                continue;
            }
            defaultMutableTreeNodeArray[n2 - 1].add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(n)));
        }
        for (n = 0; n < defaultMutableTreeNodeArray.length; ++n) {
            defaultMutableTreeNode.add(defaultMutableTreeNodeArray[n]);
        }
        if (defaultMutableTreeNode2.getChildCount() > 0) {
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    private class GeneralInfo {
        public int clusters;
        public String correctionMethod;
        public double alpha;
        public long time;
        public String function;
        private boolean hcl;
        private boolean usePerms;
        private int hcl_method;
        private int numPerms;
        private boolean hcl_genes;
        private boolean hcl_samples;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            switch (algorithmEvent.getId()) {
                case 1: {
                    OWAGUI.this.progress.setUnits(algorithmEvent.getIntValue());
                    OWAGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 2: {
                    OWAGUI.this.progress.setValue(algorithmEvent.getIntValue());
                    OWAGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 3: {
                    int n = algorithmEvent.getIntValue();
                    if (n != -1) break;
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                OWAGUI.this.algorithm.abort();
                OWAGUI.this.progress.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            OWAGUI.this.algorithm.abort();
            OWAGUI.this.progress.dispose();
        }
    }
}

