/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.owa;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.util.QSort;

public class FStatsTableViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 202010010001L;
    private JComponent header;
    private JComponent content;
    private Experiment experiment;
    private int[][] clusters;
    private boolean sig;
    private int[] rows;
    private String[] fieldNames;
    private FValuesTableModel fModel;
    private JTable fValuesTable;
    private Vector pValues;
    private Vector fValues;
    private Vector dfNumValues;
    private Vector dfDenomValues;
    private Vector ssGroups;
    private Vector ssError;
    private float[][] geneGroupMeans;
    private float[][] geneGroupSDs;
    private IData data;
    private JPopupMenu popup;
    private Object[][] origData;
    private int univCnt;
    private int univCnt2;
    private int univCnt3;
    private boolean[] sortedAscending;

    public FStatsTableViewer(Experiment experiment, int[][] nArray, IData iData, float[][] fArray, float[][] fArray2, Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5, Vector vector6, boolean bl) {
        int n;
        int n2;
        this.experiment = experiment;
        this.clusters = nArray;
        this.data = iData;
        this.fieldNames = iData.getFieldNames();
        this.geneGroupMeans = fArray;
        this.geneGroupSDs = fArray2;
        this.pValues = vector;
        this.fValues = vector2;
        this.ssGroups = vector3;
        this.ssError = vector4;
        this.dfNumValues = vector5;
        this.dfDenomValues = vector6;
        this.sig = bl;
        this.rows = bl ? nArray[0] : nArray[1];
        this.fModel = new FValuesTableModel();
        this.fValuesTable = new JTable(this.fModel);
        this.origData = new Object[this.fModel.getRowCount()][this.fModel.getColumnCount()];
        for (n2 = 0; n2 < this.origData.length; ++n2) {
            for (n = 0; n < this.origData[n2].length; ++n) {
                this.origData[n2][n] = this.fModel.getValueAt(n2, n);
            }
        }
        this.sortedAscending = new boolean[this.fModel.getColumnCount()];
        for (n2 = 0; n2 < this.sortedAscending.length; ++n2) {
            this.sortedAscending[n2] = false;
        }
        TableColumn tableColumn = null;
        for (n = 0; n < this.fModel.getColumnCount(); ++n) {
            tableColumn = this.fValuesTable.getColumnModel().getColumn(n);
            tableColumn.setMinWidth(30);
        }
        this.addMouseListenerToHeaderInTable(this.fValuesTable);
        this.header = this.fValuesTable.getTableHeader();
        this.setMaxWidth(this.getContentComponent(), this.getHeaderComponent());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.experiment);
        objectOutputStream.writeObject(this.clusters);
        objectOutputStream.writeObject(this.fieldNames);
        objectOutputStream.writeObject(this.geneGroupMeans);
        objectOutputStream.writeObject(this.geneGroupSDs);
        objectOutputStream.writeObject(this.pValues);
        objectOutputStream.writeObject(this.fValues);
        objectOutputStream.writeObject(this.dfNumValues);
        objectOutputStream.writeObject(this.dfDenomValues);
        objectOutputStream.writeObject(this.ssError);
        objectOutputStream.writeObject(this.ssGroups);
        objectOutputStream.writeBoolean(this.sig);
        objectOutputStream.writeObject(this.rows);
        objectOutputStream.writeObject(this.fModel);
        objectOutputStream.writeObject(this.origData);
        objectOutputStream.writeObject(this.fValuesTable);
        objectOutputStream.writeObject(this.header);
        objectOutputStream.writeObject(this.sortedAscending);
        objectOutputStream.writeInt(this.univCnt);
        objectOutputStream.writeInt(this.univCnt2);
        objectOutputStream.writeInt(this.univCnt3);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.experiment = (Experiment)objectInputStream.readObject();
        this.clusters = (int[][])objectInputStream.readObject();
        this.fieldNames = (String[])objectInputStream.readObject();
        this.geneGroupMeans = (float[][])objectInputStream.readObject();
        this.geneGroupSDs = (float[][])objectInputStream.readObject();
        this.pValues = (Vector)objectInputStream.readObject();
        this.fValues = (Vector)objectInputStream.readObject();
        this.dfNumValues = (Vector)objectInputStream.readObject();
        this.dfDenomValues = (Vector)objectInputStream.readObject();
        this.ssError = (Vector)objectInputStream.readObject();
        this.ssGroups = (Vector)objectInputStream.readObject();
        this.sig = objectInputStream.readBoolean();
        this.rows = (int[])objectInputStream.readObject();
        this.fModel = (FValuesTableModel)objectInputStream.readObject();
        this.origData = (Object[][])objectInputStream.readObject();
        this.fValuesTable = (JTable)objectInputStream.readObject();
        this.header = (JComponent)objectInputStream.readObject();
        this.sortedAscending = (boolean[])objectInputStream.readObject();
        this.univCnt = objectInputStream.readInt();
        this.univCnt2 = objectInputStream.readInt();
        this.univCnt3 = objectInputStream.readInt();
        this.addMouseListenerToHeaderInTable(this.fValuesTable);
        this.header = this.header = this.fValuesTable.getTableHeader();
        this.getContentComponent();
    }

    public JComponent getContentComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 100);
        gridBagLayout.setConstraints(this.fValuesTable, gridBagConstraints);
        jPanel.add(this.fValuesTable);
        final JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File("Data"));
        jFileChooser.setDialogTitle("Save F-Ratio information");
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Save F-Ratio information", GUIFactory.getIcon("save16.gif"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jFileChooser.showSaveDialog(FStatsTableViewer.this.getHeaderComponent());
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    try {
                        int n2;
                        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                        for (n2 = 0; n2 < FStatsTableViewer.this.fieldNames.length; ++n2) {
                            printWriter.print(FStatsTableViewer.this.fieldNames[n2]);
                            printWriter.print("\t");
                        }
                        for (n2 = 0; n2 < FStatsTableViewer.this.geneGroupMeans[0].length; ++n2) {
                            printWriter.print("Group" + (n2 + 1) + " mean\t");
                            printWriter.print("Group" + (n2 + 1) + " std.dev.\t");
                        }
                        printWriter.print("F-ratio\tSS(Groups)\tSS(Error)\tdf(Groups)\tdf(Error)\tp-value\n");
                        for (n2 = 0; n2 < FStatsTableViewer.this.rows.length; ++n2) {
                            int n3;
                            for (n3 = 0; n3 < FStatsTableViewer.this.fieldNames.length; ++n3) {
                                printWriter.print(FStatsTableViewer.this.data.getElementAttribute(FStatsTableViewer.this.experiment.getGeneIndexMappedToData(FStatsTableViewer.this.rows[n2]), n3));
                                printWriter.print("\t");
                            }
                            for (n3 = 0; n3 < FStatsTableViewer.this.geneGroupMeans[n2].length; ++n3) {
                                printWriter.print(FStatsTableViewer.this.geneGroupMeans[FStatsTableViewer.this.rows[n2]][n3] + "\t");
                                printWriter.print(FStatsTableViewer.this.geneGroupSDs[FStatsTableViewer.this.rows[n2]][n3] + "\t");
                            }
                            printWriter.print(((Float)FStatsTableViewer.this.fValues.get(FStatsTableViewer.this.rows[n2])).floatValue());
                            printWriter.print("\t" + ((Float)FStatsTableViewer.this.ssGroups.get(FStatsTableViewer.this.rows[n2])).floatValue());
                            printWriter.print("\t" + ((Float)FStatsTableViewer.this.ssError.get(FStatsTableViewer.this.rows[n2])).floatValue());
                            printWriter.print("\t" + ((Float)FStatsTableViewer.this.dfNumValues.get(FStatsTableViewer.this.rows[n2])).intValue());
                            printWriter.print("\t" + ((Float)FStatsTableViewer.this.dfDenomValues.get(FStatsTableViewer.this.rows[n2])).intValue());
                            printWriter.print("\t" + ((Float)FStatsTableViewer.this.pValues.get(FStatsTableViewer.this.rows[n2])).floatValue());
                            printWriter.print("\n");
                        }
                        printWriter.println();
                        printWriter.flush();
                        printWriter.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.popup.add(jMenuItem);
        this.fValuesTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    FStatsTableViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        return jPanel;
    }

    public JComponent getHeaderComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 100);
        gridBagLayout.setConstraints(this.header, gridBagConstraints);
        jPanel.add(this.header);
        return jPanel;
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    private void setMaxWidth(JComponent jComponent, JComponent jComponent2) {
        int n = jComponent.getPreferredSize().width;
        int n2 = jComponent2.getPreferredSize().width;
        if (n > n2) {
            jComponent2.setPreferredSize(new Dimension(n, jComponent2.getPreferredSize().height));
        } else {
            jComponent.setPreferredSize(new Dimension(n2, jComponent.getPreferredSize().height));
        }
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        final JTable jTable2 = jTable;
        jTable2.setColumnSelectionAllowed(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = jTable2.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = jTable2.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    int n3 = mouseEvent.getModifiers() & 1;
                    int n4 = mouseEvent.getModifiers() & 2;
                    boolean bl = n4 != 0;
                    FStatsTableViewer.this.sortByColumn(n2, !FStatsTableViewer.this.sortedAscending[n2], bl);
                    boolean bl2 = ((FStatsTableViewer)FStatsTableViewer.this).sortedAscending[n2] = !FStatsTableViewer.this.sortedAscending[n2];
                    if (bl) {
                        for (int i = 0; i < FStatsTableViewer.this.fModel.getColumnCount(); ++i) {
                            ((FStatsTableViewer)FStatsTableViewer.this).sortedAscending[i] = false;
                        }
                    }
                }
            }
        };
        JTableHeader jTableHeader = jTable2.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
    }

    public void sortByColumn(int n, boolean bl, boolean bl2) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (bl2) {
            for (int i = 0; i < this.fModel.getRowCount(); ++i) {
                for (int j = 0; j < this.fModel.getColumnCount(); ++j) {
                    this.fModel.setValueAt(this.origData[i][j], i, j);
                }
            }
            return;
        }
        Object[][] objectArray = new Object[this.fValuesTable.getRowCount()][this.fValuesTable.getColumnCount()];
        float[] fArray = new float[this.rows.length];
        Object[] objectArray2 = new SortableField[this.rows.length];
        if (n < this.fieldNames.length) {
            for (n5 = 0; n5 < objectArray2.length; ++n5) {
                objectArray2[n5] = new SortableField(n5, n);
            }
            Arrays.sort(objectArray2);
        } else if (n == this.univCnt3) {
            for (n5 = 0; n5 < fArray.length; ++n5) {
                fArray[n5] = ((Float)this.fValues.get(this.rows[n5])).floatValue();
            }
        } else if (n == this.univCnt3 + 1) {
            for (n5 = 0; n5 < fArray.length; ++n5) {
                fArray[n5] = ((Float)this.ssGroups.get(this.rows[n5])).floatValue();
            }
        } else if (n == this.univCnt3 + 2) {
            for (n5 = 0; n5 < fArray.length; ++n5) {
                fArray[n5] = ((Float)this.ssError.get(this.rows[n5])).floatValue();
            }
        } else if (n == this.univCnt3 + 3) {
            for (n5 = 0; n5 < fArray.length; ++n5) {
                fArray[n5] = ((Float)this.dfNumValues.get(this.rows[n5])).floatValue();
            }
        } else if (n == this.univCnt3 + 4) {
            for (n5 = 0; n5 < fArray.length; ++n5) {
                fArray[n5] = ((Float)this.dfDenomValues.get(this.rows[n5])).floatValue();
            }
        } else if (n == this.univCnt3 + 5) {
            for (n5 = 0; n5 < fArray.length; ++n5) {
                fArray[n5] = ((Float)this.pValues.get(this.rows[n5])).floatValue();
            }
        } else {
            n5 = n - this.fieldNames.length;
            n4 = 0;
            if (n5 % 2 == 0) {
                n4 = n5 / 2;
                for (n3 = 0; n3 < fArray.length; ++n3) {
                    fArray[n3] = this.geneGroupMeans[this.rows[n3]][n4];
                }
            } else {
                n4 = (n5 - 1) / 2;
                for (n3 = 0; n3 < fArray.length; ++n3) {
                    fArray[n3] = this.geneGroupSDs[this.rows[n3]][n4];
                }
            }
        }
        int[] nArray = new int[this.rows.length];
        if (n >= this.fieldNames.length) {
            QSort qSort = new QSort(fArray);
            nArray = qSort.getOrigIndx();
        } else {
            for (n4 = 0; n4 < nArray.length; ++n4) {
                nArray[n4] = ((SortableField)objectArray2[n4]).getIndex();
            }
        }
        if (!bl) {
            nArray = this.reverse(nArray);
        }
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            for (n3 = 0; n3 < objectArray[n2].length; ++n3) {
                objectArray[n2][n3] = this.origData[nArray[n2]][n3];
            }
        }
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            for (n3 = 0; n3 < objectArray[n2].length; ++n3) {
                this.fModel.setValueAt(objectArray[n2][n3], n2, n3);
            }
        }
    }

    private int[] reverse(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        int n2 = nArray.length - 1;
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[n] = nArray[n2];
            ++n;
            --n2;
        }
        return nArray2;
    }

    private class SortableField
    implements Comparable {
        private String field;
        private int index;

        SortableField(int n, int n2) {
            this.index = n;
            this.field = (String)FStatsTableViewer.this.origData[n][n2];
        }

        public int compareTo(Object object) {
            SortableField sortableField = (SortableField)object;
            return this.field.compareTo(sortableField.getField());
        }

        public int getIndex() {
            return this.index;
        }

        public String getField() {
            return this.field;
        }
    }

    class FValuesTableModel
    extends AbstractTableModel {
        String[] columnNames;
        Object[][] tableData;

        public FValuesTableModel() {
            int n;
            int n2;
            int n3;
            int n4;
            this.columnNames = new String[FStatsTableViewer.this.fieldNames.length + 2 * FStatsTableViewer.this.geneGroupMeans[0].length + 6];
            for (n4 = 0; n4 < FStatsTableViewer.this.fieldNames.length; ++n4) {
                this.columnNames[n4] = FStatsTableViewer.this.fieldNames[n4];
            }
            FStatsTableViewer.this.univCnt = n4;
            int n5 = 1;
            for (n3 = 0; n3 < 2 * FStatsTableViewer.this.geneGroupMeans[0].length; ++n3) {
                this.columnNames[n4 + n3] = "Group" + n5 + " mean";
                this.columnNames[n4 + ++n3] = "Group" + n5 + " std.dev.";
                ++n5;
            }
            FStatsTableViewer.this.univCnt2 = n3;
            int n6 = n4 + n3;
            FStatsTableViewer.this.univCnt3 = n6;
            this.columnNames[n6] = "F-Ratio";
            this.columnNames[n6 + 1] = "SS (Groups)";
            this.columnNames[n6 + 2] = "SS (Error)";
            this.columnNames[n6 + 3] = "df (Groups)";
            this.columnNames[n6 + 4] = "df (Error)";
            this.columnNames[n6 + 5] = "p-value";
            this.tableData = new Object[FStatsTableViewer.this.rows.length][this.columnNames.length];
            for (n2 = 0; n2 < this.tableData.length; ++n2) {
                n5 = 0;
                for (n = n4; n < n6; ++n) {
                    this.tableData[n2][n] = Float.isNaN(FStatsTableViewer.this.geneGroupMeans[FStatsTableViewer.this.rows[n2]][n5]) ? "N/A" : new Float(FStatsTableViewer.this.geneGroupMeans[FStatsTableViewer.this.rows[n2]][n5]);
                    this.tableData[n2][++n] = Float.isNaN(FStatsTableViewer.this.geneGroupSDs[FStatsTableViewer.this.rows[n2]][n5]) ? "N/A" : new Float(FStatsTableViewer.this.geneGroupSDs[FStatsTableViewer.this.rows[n2]][n5]);
                    ++n5;
                }
            }
            for (n2 = 0; n2 < this.tableData.length; ++n2) {
                for (n = 0; n < this.tableData[n2].length; ++n) {
                    float f;
                    if (n < n4) {
                        this.tableData[n2][n] = FStatsTableViewer.this.data.getElementAttribute(FStatsTableViewer.this.experiment.getGeneIndexMappedToData(FStatsTableViewer.this.rows[n2]), n);
                        continue;
                    }
                    if (n >= n4 && n < n6) continue;
                    if (n == n6) {
                        f = ((Float)FStatsTableViewer.this.fValues.get(FStatsTableViewer.this.rows[n2])).floatValue();
                        if (Float.isNaN(f)) {
                            this.tableData[n2][n] = "N/A";
                            continue;
                        }
                        this.tableData[n2][n] = (Float)FStatsTableViewer.this.fValues.get(FStatsTableViewer.this.rows[n2]);
                        continue;
                    }
                    if (n == n6 + 1) {
                        f = ((Float)FStatsTableViewer.this.ssGroups.get(FStatsTableViewer.this.rows[n2])).floatValue();
                        if (Float.isNaN(f)) {
                            this.tableData[n2][n] = "N/A";
                            continue;
                        }
                        this.tableData[n2][n] = (Float)FStatsTableViewer.this.ssGroups.get(FStatsTableViewer.this.rows[n2]);
                        continue;
                    }
                    if (n == n6 + 2) {
                        f = ((Float)FStatsTableViewer.this.ssError.get(FStatsTableViewer.this.rows[n2])).floatValue();
                        if (Float.isNaN(f)) {
                            this.tableData[n2][n] = "N/A";
                            continue;
                        }
                        this.tableData[n2][n] = (Float)FStatsTableViewer.this.ssError.get(FStatsTableViewer.this.rows[n2]);
                        continue;
                    }
                    if (n == n6 + 3) {
                        f = ((Float)FStatsTableViewer.this.dfNumValues.get(FStatsTableViewer.this.rows[n2])).floatValue();
                        if (Float.isNaN(f)) {
                            this.tableData[n2][n] = "N/A";
                            continue;
                        }
                        this.tableData[n2][n] = (Float)FStatsTableViewer.this.dfNumValues.get(FStatsTableViewer.this.rows[n2]);
                        continue;
                    }
                    if (n == n6 + 4) {
                        f = ((Float)FStatsTableViewer.this.dfDenomValues.get(FStatsTableViewer.this.rows[n2])).floatValue();
                        if (Float.isNaN(f)) {
                            this.tableData[n2][n] = "N/A";
                            continue;
                        }
                        this.tableData[n2][n] = (Float)FStatsTableViewer.this.dfDenomValues.get(FStatsTableViewer.this.rows[n2]);
                        continue;
                    }
                    if (n != n6 + 5) continue;
                    f = ((Float)FStatsTableViewer.this.pValues.get(FStatsTableViewer.this.rows[n2])).floatValue();
                    this.tableData[n2][n] = Float.isNaN(f) ? "N/A" : (Float)FStatsTableViewer.this.pValues.get(FStatsTableViewer.this.rows[n2]);
                }
            }
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.tableData.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return this.tableData[n][n2];
        }

        public void setValueAt(Object object, int n, int n2) {
            this.tableData[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }
    }
}

