/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.knnc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class KNNClassifyOrValidateDialog
extends AlgorithmDialog {
    boolean okPressed = false;
    JRadioButton classifyButton;
    JRadioButton validateButton;

    public KNNClassifyOrValidateDialog(JFrame jFrame, boolean bl) {
        super(jFrame, "KNN classify or validate", bl);
        this.okButton.setText("Next >");
        this.setBounds(0, 0, 500, 200);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setBorder(new EtchedBorder());
        jPanel.setLayout(gridBagLayout);
        this.classifyButton = new JRadioButton("Classify", true);
        this.classifyButton.setBackground(Color.white);
        this.validateButton = new JRadioButton("Validate", false);
        this.validateButton.setBackground(Color.white);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.classifyButton);
        buttonGroup.add(this.validateButton);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 100);
        gridBagLayout.setConstraints(this.classifyButton, gridBagConstraints);
        jPanel.add(this.classifyButton);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
        gridBagLayout.setConstraints(this.validateButton, gridBagConstraints);
        jPanel.add(this.validateButton);
        this.addContent(jPanel);
        EventListener eventListener = new EventListener();
        this.setActionListeners(eventListener);
        this.addWindowListener(eventListener);
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean classify() {
        return this.classifyButton.isSelected();
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                KNNClassifyOrValidateDialog.this.okPressed = true;
                KNNClassifyOrValidateDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                KNNClassifyOrValidateDialog.this.okPressed = false;
                KNNClassifyOrValidateDialog.this.classifyButton.setSelected(true);
                KNNClassifyOrValidateDialog.this.validateButton.setSelected(false);
            } else if (string.equals("cancel-command")) {
                KNNClassifyOrValidateDialog.this.okPressed = false;
                KNNClassifyOrValidateDialog.this.dispose();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(KNNClassifyOrValidateDialog.this, "KNNC Mode Selection");
                KNNClassifyOrValidateDialog.this.okPressed = false;
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 600);
                    helpWindow.setLocation();
                    helpWindow.show();
                    return;
                }
                helpWindow.setVisible(false);
                helpWindow.dispose();
                return;
            }
        }
    }
}

