/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.knnc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class KNNCValidationInfoViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 202009020001L;
    private JComponent header;
    private JTextArea content;
    private int[] origNumInFiltTrgSetByClass;
    private int[] numberCorrectlyClassifiedByClass;
    private int[] numberIncorrectlyClassifiedByClass;

    public KNNCValidationInfoViewer(int[] nArray, int[] nArray2, int[] nArray3) {
        this.origNumInFiltTrgSetByClass = nArray;
        this.numberCorrectlyClassifiedByClass = nArray2;
        this.numberIncorrectlyClassifiedByClass = nArray3;
        this.header = this.createHeader();
        this.content = this.createContent();
        this.setMaxWidth(this.content, this.header);
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Leave one out cross-validation (LOOCV) statistics</b></font></body></html>"), gridBagConstraints);
        return jPanel;
    }

    private JTextArea createContent() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setMargin(new Insets(0, 10, 0, 0));
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < this.origNumInFiltTrgSetByClass.length; ++i) {
            stringBuffer.append("Class " + i + ":\n\t");
            stringBuffer.append("Original number* of training set elements in class = " + this.origNumInFiltTrgSetByClass[i] + "\n\t");
            stringBuffer.append("Number of training set elements correctly assigned to class by LOOCV = " + this.numberCorrectlyClassifiedByClass[i] + "\n\t");
            stringBuffer.append("Number of training set elements falsely assigned to class by LOOCV = " + this.numberIncorrectlyClassifiedByClass[i] + "\n");
        }
        stringBuffer.append("\n\n*Indicates number of training set elements in a given class after variance filtering, if applied.");
        jTextArea.setText(stringBuffer.toString());
        jTextArea.setCaretPosition(0);
        return jTextArea;
    }

    private void setMaxWidth(JComponent jComponent, JComponent jComponent2) {
        int n = jComponent.getPreferredSize().width;
        int n2 = jComponent2.getPreferredSize().width;
        if (n > n2) {
            jComponent2.setPreferredSize(new Dimension(n, jComponent2.getPreferredSize().height));
        } else {
            jComponent.setPreferredSize(new Dimension(n2, jComponent.getPreferredSize().height));
        }
    }
}

