/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.knnc;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCFirstDialog;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCStatusDialog;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCValidationFirstDialog;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCValidationInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNClassificationEditor;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNClassifyOrValidateDialog;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class KNNCGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private Progress progress;
    private Experiment experiment;
    private IData data;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    private int k;
    private int usedNumNeibs;
    KNNClassificationEditor kcEditor;
    boolean validate;
    boolean classifyGenes;
    boolean useVarianceFilter;
    boolean useCorrelFilter;
    int numClasses;
    int numVarFilteredVectors;
    int numNeighbors;
    int numPerms;
    double correlPValue;
    Vector[] classificationVector;
    int[] classIndices;
    int[] classes;
    int[] origNumInFiltTrgSetByClass;
    int[] numberCorrectlyClassifiedByClass;
    int[] numberIncorrectlyClassifiedByClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        boolean bl;
        this.data = iFramework.getData();
        this.experiment = iFramework.getData().getExperiment();
        int n = this.experiment.getNumberOfSamples();
        int n2 = this.experiment.getNumberOfGenes();
        KNNClassifyOrValidateDialog kNNClassifyOrValidateDialog = new KNNClassifyOrValidateDialog((JFrame)iFramework.getFrame(), true);
        kNNClassifyOrValidateDialog.setVisible(true);
        boolean bl2 = this.validate = !kNNClassifyOrValidateDialog.classify();
        if (!kNNClassifyOrValidateDialog.isOkPressed()) {
            return null;
        }
        if (!this.validate) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            Object object2;
            boolean bl3;
            KNNCStatusDialog kNNCStatusDialog = new KNNCStatusDialog((JFrame)iFramework.getFrame(), false);
            kNNCStatusDialog.setVisible(true);
            KNNCFirstDialog kNNCFirstDialog = new KNNCFirstDialog((JFrame)iFramework.getFrame(), true, iFramework);
            kNNCFirstDialog.setVisible(true);
            if (!kNNCFirstDialog.isOkPressed()) {
                kNNCStatusDialog.dispose();
                return null;
            }
            this.classifyGenes = kNNCFirstDialog.classifyGenes();
            this.numClasses = kNNCFirstDialog.getNumClasses();
            this.numNeighbors = kNNCFirstDialog.getNumNeighbors();
            this.useVarianceFilter = kNNCFirstDialog.useVarianceFilter();
            if (this.useVarianceFilter) {
                this.numVarFilteredVectors = kNNCFirstDialog.getNumVectors();
            }
            this.useCorrelFilter = kNNCFirstDialog.useCorrelFilter();
            if (this.useCorrelFilter) {
                this.correlPValue = kNNCFirstDialog.getCorrPValue();
                this.numPerms = kNNCFirstDialog.getNumPerms();
            }
            this.k = this.numClasses * 4 + 1;
            this.kcEditor = new KNNClassificationEditor(iFramework, this.classifyGenes, this.numClasses);
            if (kNNCFirstDialog.createNewTrgSet()) {
                this.kcEditor.showModal(true);
            } else {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setCurrentDirectory(new File("Data"));
                int n3 = jFileChooser.showOpenDialog(iFramework.getFrame());
                if (n3 == 0) {
                    this.kcEditor.loadFromFile(jFileChooser.getSelectedFile());
                } else {
                    kNNCStatusDialog.dispose();
                    return null;
                }
            }
            if (this.kcEditor.fileIsIncompatible()) {
                kNNCStatusDialog.dispose();
                return null;
            }
            while (!this.kcEditor.isNextPressed()) {
            }
            if (!this.kcEditor.proceed()) {
                kNNCStatusDialog.dispose();
                return null;
            }
            this.classificationVector = this.kcEditor.getClassification();
            this.classIndices = new int[this.classificationVector[0].size()];
            this.classes = new int[this.classificationVector[1].size()];
            for (bl3 = false; bl3 < this.classIndices.length; bl3 += 1) {
                this.classIndices[bl3] = (Integer)this.classificationVector[0].get(bl3 ? 1 : 0);
                this.classes[bl3] = (Integer)this.classificationVector[1].get(bl3 ? 1 : 0);
            }
            bl3 = kNNCFirstDialog.drawTrees();
            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
            int n4 = iDistanceMenu.getDistanceFunction();
            if (n4 == 0) {
                n4 = 4;
            }
            int n5 = 0;
            boolean bl4 = false;
            boolean bl5 = false;
            int n6 = 4;
            boolean bl6 = false;
            if (bl3) {
                object2 = new HCLInitDialog(iFramework.getFrame(), iDistanceMenu.getFunctionName(n4), iDistanceMenu.isAbsoluteDistance(), true);
                if (((HCLInitDialog)object2).showModal() != 0) {
                    return null;
                }
                n5 = ((HCLInitDialog)object2).getMethod();
                bl4 = ((HCLInitDialog)object2).isClusterExperiments();
                bl5 = ((HCLInitDialog)object2).isClusterGenes();
                n6 = ((HCLInitDialog)object2).getDistanceMetric();
                bl6 = ((HCLInitDialog)object2).getAbsoluteSelection();
            }
            object2 = new Listener();
            try {
                this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("KNNC");
                this.algorithm.addAlgorithmListener((AlgorithmListener)object2);
                this.progress = new Progress(iFramework.getFrame(), "KNN classification", (DialogListener)object2);
                this.progress.show();
                AlgorithmData algorithmData = new AlgorithmData();
                algorithmData.addMatrix("experiment", this.experiment.getMatrix());
                algorithmData.addParam("distance-factor", String.valueOf(1.0f));
                algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
                algorithmData.addParam("distance-function", String.valueOf(n4));
                algorithmData.addParam("validate", String.valueOf(this.validate));
                algorithmData.addParam("classifyGenes", String.valueOf(this.classifyGenes));
                if (this.classifyGenes) {
                    algorithmData.addMatrix("experiment", this.experiment.getMatrix());
                } else {
                    algorithmData.addMatrix("experiment", this.experiment.getMatrix().transpose());
                }
                algorithmData.addParam("useVarianceFilter", String.valueOf(this.useVarianceFilter));
                algorithmData.addParam("useCorrelFilter", String.valueOf(this.useCorrelFilter));
                algorithmData.addParam("numClasses", String.valueOf(this.numClasses));
                algorithmData.addParam("numNeighbors", String.valueOf(this.numNeighbors));
                if (this.useVarianceFilter) {
                    algorithmData.addParam("numVarFilteredVectors", String.valueOf(this.numVarFilteredVectors));
                }
                if (this.useCorrelFilter) {
                    algorithmData.addParam("correlPValue", String.valueOf((float)this.correlPValue));
                    algorithmData.addParam("numPerms", String.valueOf(this.numPerms));
                }
                algorithmData.addIntArray("classIndices", this.classIndices);
                algorithmData.addIntArray("classes", this.classes);
                if (bl3) {
                    algorithmData.addParam("hierarchical-tree", String.valueOf(true));
                    algorithmData.addParam("method-linkage", String.valueOf(n5));
                    algorithmData.addParam("calculate-genes", String.valueOf(bl5));
                    algorithmData.addParam("calculate-experiments", String.valueOf(bl4));
                    algorithmData.addParam("hcl-distance-function", String.valueOf(n6));
                    algorithmData.addParam("hcl-distance-absolute", String.valueOf(bl6));
                }
                long l = System.currentTimeMillis();
                AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
                long l2 = System.currentTimeMillis() - l;
                Cluster cluster = algorithmData2.getCluster("cluster");
                NodeList nodeList = cluster.getNodeList();
                this.clusters = new int[this.k][];
                for (int i = 0; i < this.k; ++i) {
                    this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
                }
                this.means = algorithmData2.getMatrix("clusters_means");
                this.variances = algorithmData2.getMatrix("clusters_variances");
                this.numberCorrectlyClassifiedByClass = algorithmData2.getIntArray("numberCorrectlyClassifiedByClass");
                this.numberIncorrectlyClassifiedByClass = algorithmData2.getIntArray("numberIncorrectlyClassifiedByClass");
                this.origNumInFiltTrgSetByClass = algorithmData2.getIntArray("origNumInFiltTrgSetByClass");
                GeneralInfo generalInfo = new GeneralInfo();
                generalInfo.time = l2;
                generalInfo.hcl = bl3;
                generalInfo.hcl_genes = bl5;
                generalInfo.hcl_samples = bl4;
                generalInfo.hcl_method = n5;
                generalInfo.numClasses = this.numClasses;
                generalInfo.numNeighbors = this.numNeighbors;
                generalInfo.usedVarFilter = this.useVarianceFilter;
                if (this.useVarianceFilter) {
                    generalInfo.numVarFiltered = this.numVarFilteredVectors;
                    generalInfo.postVarDataSetSize = algorithmData2.getParams().getInt("postVarDataSetSize");
                    generalInfo.postVarClassSetSize = algorithmData2.getParams().getInt("postVarClassSetSize");
                }
                generalInfo.usedCorrelFilter = this.useCorrelFilter;
                if (this.useCorrelFilter) {
                    generalInfo.correlPvalue = this.correlPValue;
                    generalInfo.numPerms = this.numPerms;
                    generalInfo.postCorrDataSetSize = algorithmData2.getParams().getInt("postCorrDataSetSize");
                }
                generalInfo.usedNumNeibs = algorithmData2.getParams().getInt("usedNumNeibs");
                generalInfo.origDataSetSize = algorithmData2.getParams().getInt("origDataSetSize");
                generalInfo.origClassSetSize = algorithmData2.getParams().getInt("origClassSetSize");
                defaultMutableTreeNode2 = this.createResultTree(cluster, generalInfo);
                Object var27_49 = null;
            }
            catch (Throwable throwable) {
                Object var27_50 = null;
                kNNCStatusDialog.dispose();
                if (this.algorithm != null) {
                    this.algorithm.removeAlgorithmListener((AlgorithmListener)object2);
                }
                if (this.progress != null) {
                    this.progress.dispose();
                }
                throw throwable;
            }
            kNNCStatusDialog.dispose();
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)object2);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
            return defaultMutableTreeNode2;
        }
        KNNCStatusDialog kNNCStatusDialog = new KNNCStatusDialog((JFrame)iFramework.getFrame(), false);
        kNNCStatusDialog.setVisible(true);
        KNNCValidationFirstDialog kNNCValidationFirstDialog = new KNNCValidationFirstDialog((JFrame)iFramework.getFrame(), true, iFramework);
        kNNCValidationFirstDialog.setVisible(true);
        if (!kNNCValidationFirstDialog.isOkPressed()) {
            kNNCStatusDialog.dispose();
            return null;
        }
        this.classifyGenes = kNNCValidationFirstDialog.classifyGenes();
        this.numClasses = kNNCValidationFirstDialog.getNumClasses();
        this.numNeighbors = kNNCValidationFirstDialog.getNumNeighbors();
        this.useCorrelFilter = kNNCValidationFirstDialog.useCorrelFilter();
        if (this.useCorrelFilter) {
            this.correlPValue = kNNCValidationFirstDialog.getCorrPValue();
            this.numPerms = kNNCValidationFirstDialog.getNumPerms();
        }
        this.k = this.numClasses * 4 + 1;
        this.kcEditor = new KNNClassificationEditor(iFramework, this.classifyGenes, this.numClasses);
        if (kNNCValidationFirstDialog.createNewTrgSet()) {
            this.kcEditor.showModal(true);
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File("Data"));
            int n7 = jFileChooser.showOpenDialog(iFramework.getFrame());
            if (n7 == 0) {
                this.kcEditor.loadFromFile(jFileChooser.getSelectedFile());
            } else {
                kNNCStatusDialog.dispose();
                return null;
            }
        }
        if (this.kcEditor.fileIsIncompatible()) {
            kNNCStatusDialog.dispose();
            return null;
        }
        while (!this.kcEditor.isNextPressed()) {
        }
        if (!this.kcEditor.proceed()) {
            kNNCStatusDialog.dispose();
            return null;
        }
        this.classificationVector = this.kcEditor.getClassification();
        this.classIndices = new int[this.classificationVector[0].size()];
        this.classes = new int[this.classificationVector[1].size()];
        for (bl = false; bl < this.classIndices.length; bl += 1) {
            this.classIndices[bl] = (Integer)this.classificationVector[0].get(bl ? 1 : 0);
            this.classes[bl] = (Integer)this.classificationVector[1].get(bl ? 1 : 0);
        }
        bl = kNNCValidationFirstDialog.drawTrees();
        IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
        int n8 = iDistanceMenu.getDistanceFunction();
        if (n8 == 0) {
            n8 = 4;
        }
        int n9 = 0;
        boolean bl7 = false;
        boolean bl8 = false;
        int n10 = 4;
        boolean bl9 = false;
        if (bl) {
            object = new HCLInitDialog(iFramework.getFrame(), iDistanceMenu.getFunctionName(n8), iDistanceMenu.isAbsoluteDistance(), true);
            if (((HCLInitDialog)object).showModal() != 0) {
                return null;
            }
            n9 = ((HCLInitDialog)object).getMethod();
            bl7 = ((HCLInitDialog)object).isClusterExperiments();
            bl8 = ((HCLInitDialog)object).isClusterGenes();
            n10 = ((HCLInitDialog)object).getDistanceMetric();
            bl9 = ((HCLInitDialog)object).getAbsoluteSelection();
        }
        object = new Listener();
        try {
            this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("KNNC");
            this.algorithm.addAlgorithmListener((AlgorithmListener)object);
            this.progress = new Progress(iFramework.getFrame(), "KNN classification", (DialogListener)object);
            this.progress.show();
            AlgorithmData algorithmData = new AlgorithmData();
            algorithmData.addMatrix("experiment", this.experiment.getMatrix());
            algorithmData.addParam("distance-factor", String.valueOf(1.0f));
            algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
            algorithmData.addParam("distance-function", String.valueOf(n8));
            algorithmData.addParam("validate", String.valueOf(this.validate));
            algorithmData.addParam("classifyGenes", String.valueOf(this.classifyGenes));
            if (this.classifyGenes) {
                algorithmData.addMatrix("experiment", this.experiment.getMatrix());
            } else {
                algorithmData.addMatrix("experiment", this.experiment.getMatrix().transpose());
            }
            algorithmData.addParam("useCorrelFilter", String.valueOf(this.useCorrelFilter));
            algorithmData.addParam("numClasses", String.valueOf(this.numClasses));
            algorithmData.addParam("numNeighbors", String.valueOf(this.numNeighbors));
            if (this.useCorrelFilter) {
                algorithmData.addParam("correlPValue", String.valueOf((float)this.correlPValue));
                algorithmData.addParam("numPerms", String.valueOf(this.numPerms));
            }
            algorithmData.addIntArray("classIndices", this.classIndices);
            algorithmData.addIntArray("classes", this.classes);
            if (bl) {
                algorithmData.addParam("hierarchical-tree", String.valueOf(true));
                algorithmData.addParam("method-linkage", String.valueOf(n9));
                algorithmData.addParam("calculate-genes", String.valueOf(bl8));
                algorithmData.addParam("calculate-experiments", String.valueOf(bl7));
                algorithmData.addParam("hcl-distance-function", String.valueOf(n10));
                algorithmData.addParam("hcl-distance-absolute", String.valueOf(bl9));
            }
            long l = System.currentTimeMillis();
            AlgorithmData algorithmData3 = this.algorithm.execute(algorithmData);
            long l3 = System.currentTimeMillis() - l;
            Cluster cluster = algorithmData3.getCluster("cluster");
            NodeList nodeList = cluster.getNodeList();
            this.k = this.numClasses + 1;
            this.clusters = new int[this.k][];
            for (int i = 0; i < this.k; ++i) {
                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.means = algorithmData3.getMatrix("clusters_means");
            this.variances = algorithmData3.getMatrix("clusters_variances");
            this.numberCorrectlyClassifiedByClass = algorithmData3.getIntArray("numberCorrectlyClassifiedByClass");
            this.numberIncorrectlyClassifiedByClass = algorithmData3.getIntArray("numberIncorrectlyClassifiedByClass");
            this.origNumInFiltTrgSetByClass = algorithmData3.getIntArray("origNumInFiltTrgSetByClass");
            GeneralInfo generalInfo = new GeneralInfo();
            generalInfo.time = l3;
            generalInfo.hcl = bl;
            generalInfo.hcl_genes = bl8;
            generalInfo.hcl_samples = bl7;
            generalInfo.hcl_method = n9;
            generalInfo.numClasses = this.numClasses;
            generalInfo.numNeighbors = this.numNeighbors;
            generalInfo.usedCorrelFilter = this.useCorrelFilter;
            if (this.useCorrelFilter) {
                generalInfo.correlPvalue = this.correlPValue;
                generalInfo.numPerms = this.numPerms;
            }
            generalInfo.usedNumNeibs = algorithmData3.getParams().getInt("usedNumNeibs");
            defaultMutableTreeNode = this.createValidationResultTree(cluster, generalInfo);
            Object var29_52 = null;
        }
        catch (Throwable throwable) {
            block54: {
                Object var29_53 = null;
                kNNCStatusDialog.dispose();
                if (this.algorithm != null) {
                    this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
                }
                if (this.progress == null) break block54;
                this.progress.dispose();
            }
            throw throwable;
        }
        kNNCStatusDialog.dispose();
        if (this.algorithm != null) {
            this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
        }
        if (this.progress != null) {
            this.progress.dispose();
        }
        return defaultMutableTreeNode;
    }

    public AlgorithmData getScriptParameters(IFramework iFramework) {
        AlgorithmData algorithmData = new AlgorithmData();
        this.data = iFramework.getData();
        this.experiment = iFramework.getData().getExperiment();
        int n = this.experiment.getNumberOfSamples();
        int n2 = this.experiment.getNumberOfGenes();
        KNNClassifyOrValidateDialog kNNClassifyOrValidateDialog = new KNNClassifyOrValidateDialog((JFrame)iFramework.getFrame(), true);
        kNNClassifyOrValidateDialog.setVisible(true);
        boolean bl = this.validate = !kNNClassifyOrValidateDialog.classify();
        if (!kNNClassifyOrValidateDialog.isOkPressed()) {
            return null;
        }
        if (!this.validate) {
            String[] stringArray;
            int n3;
            KNNCStatusDialog kNNCStatusDialog = new KNNCStatusDialog((JFrame)iFramework.getFrame(), false);
            kNNCStatusDialog.setVisible(true);
            KNNCFirstDialog kNNCFirstDialog = new KNNCFirstDialog((JFrame)iFramework.getFrame(), true, iFramework);
            kNNCFirstDialog.setVisible(true);
            if (!kNNCFirstDialog.isOkPressed()) {
                kNNCStatusDialog.dispose();
                return null;
            }
            this.classifyGenes = kNNCFirstDialog.classifyGenes();
            this.numClasses = kNNCFirstDialog.getNumClasses();
            this.numNeighbors = kNNCFirstDialog.getNumNeighbors();
            this.useVarianceFilter = kNNCFirstDialog.useVarianceFilter();
            if (this.useVarianceFilter) {
                this.numVarFilteredVectors = kNNCFirstDialog.getNumVectors();
            }
            this.useCorrelFilter = kNNCFirstDialog.useCorrelFilter();
            if (this.useCorrelFilter) {
                this.correlPValue = kNNCFirstDialog.getCorrPValue();
                this.numPerms = kNNCFirstDialog.getNumPerms();
            }
            this.k = this.numClasses * 4 + 1;
            this.kcEditor = new KNNClassificationEditor(iFramework, this.classifyGenes, this.numClasses);
            if (kNNCFirstDialog.createNewTrgSet()) {
                this.kcEditor.showModal(true);
            } else {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setCurrentDirectory(new File("Data"));
                int n4 = jFileChooser.showOpenDialog(iFramework.getFrame());
                if (n4 == 0) {
                    this.kcEditor.loadFromFile(jFileChooser.getSelectedFile());
                } else {
                    kNNCStatusDialog.dispose();
                    return null;
                }
            }
            this.kcEditor.dispose();
            this.classificationVector = this.kcEditor.getClassification();
            this.classIndices = new int[this.classificationVector[0].size()];
            this.classes = new int[this.classificationVector[1].size()];
            for (n3 = 0; n3 < this.classIndices.length; ++n3) {
                this.classIndices[n3] = (Integer)this.classificationVector[0].get(n3);
                this.classes[n3] = (Integer)this.classificationVector[1].get(n3);
            }
            n3 = kNNCFirstDialog.drawTrees() ? 1 : 0;
            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
            int n5 = iDistanceMenu.getDistanceFunction();
            if (n5 == 0) {
                n5 = 4;
            }
            int n6 = 0;
            boolean bl2 = false;
            boolean bl3 = false;
            int n7 = 4;
            boolean bl4 = false;
            if (n3 != 0) {
                stringArray = new HCLInitDialog(iFramework.getFrame(), iDistanceMenu.getFunctionName(n5), iDistanceMenu.isAbsoluteDistance(), true);
                if (stringArray.showModal() != 0) {
                    return null;
                }
                n6 = stringArray.getMethod();
                bl2 = stringArray.isClusterExperiments();
                bl3 = stringArray.isClusterGenes();
                n7 = stringArray.getDistanceMetric();
                bl4 = stringArray.getAbsoluteSelection();
            }
            algorithmData.addParam("distance-factor", String.valueOf(1.0f));
            algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
            algorithmData.addParam("distance-function", String.valueOf(n5));
            algorithmData.addParam("validate", String.valueOf(this.validate));
            algorithmData.addParam("classifyGenes", String.valueOf(this.classifyGenes));
            algorithmData.addParam("useVarianceFilter", String.valueOf(this.useVarianceFilter));
            algorithmData.addParam("useCorrelFilter", String.valueOf(this.useCorrelFilter));
            algorithmData.addParam("numClasses", String.valueOf(this.numClasses));
            algorithmData.addParam("numNeighbors", String.valueOf(this.numNeighbors));
            if (this.useVarianceFilter) {
                algorithmData.addParam("numVarFilteredVectors", String.valueOf(this.numVarFilteredVectors));
            }
            if (this.useCorrelFilter) {
                algorithmData.addParam("correlPValue", String.valueOf((float)this.correlPValue));
                algorithmData.addParam("numPerms", String.valueOf(this.numPerms));
            }
            algorithmData.addIntArray("classIndices", this.classIndices);
            algorithmData.addIntArray("classes", this.classes);
            if (n3 != 0) {
                algorithmData.addParam("hierarchical-tree", String.valueOf(true));
                algorithmData.addParam("method-linkage", String.valueOf(n6));
                algorithmData.addParam("calculate-genes", String.valueOf(bl3));
                algorithmData.addParam("calculate-experiments", String.valueOf(bl2));
                algorithmData.addParam("hcl-distance-function", String.valueOf(n7));
                algorithmData.addParam("hcl-distance-absolute", String.valueOf(bl4));
            }
            algorithmData.addParam("name", "KNNC");
            if (this.classifyGenes) {
                algorithmData.addParam("alg-type", "cluster-genes");
            } else {
                algorithmData.addParam("alg-type", "cluster-experiments");
            }
            algorithmData.addParam("output-class", "partition-output");
            stringArray = new String[4 * this.numClasses + 1];
            for (int i = 0; i < this.numClasses; ++i) {
                String string = String.valueOf(i + 1) + "  ";
                stringArray[i] = "Used classifiers: Class " + string;
                stringArray[this.numClasses + i] = "Unused classifiers: Class " + string;
                stringArray[2 * this.numClasses + i] = "Classified: Class " + string;
                stringArray[3 * this.numClasses + i] = "Used classifiers + classified: Class " + string;
            }
            stringArray[4 * this.numClasses] = "Unclassified";
            algorithmData.addStringArray("output-nodes", stringArray);
            kNNCStatusDialog.dispose();
        } else {
            String[] stringArray;
            int n8;
            KNNCStatusDialog kNNCStatusDialog = new KNNCStatusDialog((JFrame)iFramework.getFrame(), false);
            kNNCStatusDialog.setVisible(true);
            KNNCValidationFirstDialog kNNCValidationFirstDialog = new KNNCValidationFirstDialog((JFrame)iFramework.getFrame(), true, iFramework);
            kNNCValidationFirstDialog.setVisible(true);
            if (!kNNCValidationFirstDialog.isOkPressed()) {
                kNNCStatusDialog.dispose();
                return null;
            }
            this.classifyGenes = kNNCValidationFirstDialog.classifyGenes();
            this.numClasses = kNNCValidationFirstDialog.getNumClasses();
            this.numNeighbors = kNNCValidationFirstDialog.getNumNeighbors();
            this.useCorrelFilter = kNNCValidationFirstDialog.useCorrelFilter();
            if (this.useCorrelFilter) {
                this.correlPValue = kNNCValidationFirstDialog.getCorrPValue();
                this.numPerms = kNNCValidationFirstDialog.getNumPerms();
            }
            this.k = this.numClasses * 4 + 1;
            this.kcEditor = new KNNClassificationEditor(iFramework, this.classifyGenes, this.numClasses);
            if (kNNCValidationFirstDialog.createNewTrgSet()) {
                this.kcEditor.showModal(true);
            } else {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setCurrentDirectory(new File("Data"));
                int n9 = jFileChooser.showOpenDialog(iFramework.getFrame());
                if (n9 == 0) {
                    this.kcEditor.loadFromFile(jFileChooser.getSelectedFile());
                } else {
                    kNNCStatusDialog.dispose();
                    return null;
                }
            }
            if (this.kcEditor.fileIsIncompatible()) {
                kNNCStatusDialog.dispose();
                return null;
            }
            while (!this.kcEditor.isNextPressed()) {
            }
            if (!this.kcEditor.proceed()) {
                kNNCStatusDialog.dispose();
                return null;
            }
            this.classificationVector = this.kcEditor.getClassification();
            this.classIndices = new int[this.classificationVector[0].size()];
            this.classes = new int[this.classificationVector[1].size()];
            for (n8 = 0; n8 < this.classIndices.length; ++n8) {
                this.classIndices[n8] = (Integer)this.classificationVector[0].get(n8);
                this.classes[n8] = (Integer)this.classificationVector[1].get(n8);
            }
            n8 = kNNCValidationFirstDialog.drawTrees() ? 1 : 0;
            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
            int n10 = iDistanceMenu.getDistanceFunction();
            if (n10 == 0) {
                n10 = 4;
            }
            int n11 = 0;
            boolean bl5 = false;
            boolean bl6 = false;
            int n12 = 4;
            boolean bl7 = false;
            if (n8 != 0) {
                stringArray = new HCLInitDialog(iFramework.getFrame(), iDistanceMenu.getFunctionName(n10), iDistanceMenu.isAbsoluteDistance(), true);
                if (stringArray.showModal() != 0) {
                    return null;
                }
                n11 = stringArray.getMethod();
                bl5 = stringArray.isClusterExperiments();
                bl6 = stringArray.isClusterGenes();
                n12 = stringArray.getDistanceMetric();
                bl7 = stringArray.getAbsoluteSelection();
            }
            algorithmData.addParam("distance-factor", String.valueOf(1.0f));
            algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
            algorithmData.addParam("distance-function", String.valueOf(n10));
            algorithmData.addParam("validate", String.valueOf(this.validate));
            algorithmData.addParam("classifyGenes", String.valueOf(this.classifyGenes));
            algorithmData.addParam("useCorrelFilter", String.valueOf(this.useCorrelFilter));
            algorithmData.addParam("numClasses", String.valueOf(this.numClasses));
            algorithmData.addParam("numNeighbors", String.valueOf(this.numNeighbors));
            if (this.useCorrelFilter) {
                algorithmData.addParam("correlPValue", String.valueOf((float)this.correlPValue));
                algorithmData.addParam("numPerms", String.valueOf(this.numPerms));
            }
            algorithmData.addIntArray("classIndices", this.classIndices);
            algorithmData.addIntArray("classes", this.classes);
            if (n8 != 0) {
                algorithmData.addParam("hierarchical-tree", String.valueOf(true));
                algorithmData.addParam("method-linkage", String.valueOf(n11));
                algorithmData.addParam("calculate-genes", String.valueOf(bl6));
                algorithmData.addParam("calculate-experiments", String.valueOf(bl5));
                algorithmData.addParam("hcl-distance-function", String.valueOf(n12));
                algorithmData.addParam("hcl-distance-absolute", String.valueOf(bl7));
            }
            this.k = this.numClasses + 1;
            algorithmData.addParam("name", "KNNC");
            if (this.classifyGenes) {
                algorithmData.addParam("alg-type", "cluster-genes");
            } else {
                algorithmData.addParam("alg-type", "cluster-experiments");
            }
            algorithmData.addParam("output-class", "partition-output");
            stringArray = new String[this.numClasses + 1];
            for (int i = 0; i < this.numClasses; ++i) {
                stringArray[i] = "Training Class " + String.valueOf(i + 1) + "  ";
            }
            stringArray[this.numClasses] = "Not in Training Set  ";
            algorithmData.addStringArray("output-nodes", stringArray);
            kNNCStatusDialog.dispose();
        }
        return algorithmData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework iFramework, AlgorithmData algorithmData, Experiment experiment) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block24: {
            AlgorithmParameters algorithmParameters = algorithmData.getParams();
            Listener listener = new Listener();
            this.data = iFramework.getData();
            this.experiment = experiment;
            this.classifyGenes = algorithmParameters.getBoolean("classifyGenes");
            this.numClasses = algorithmParameters.getInt("numClasses");
            this.numNeighbors = algorithmParameters.getInt("numNeighbors");
            this.useCorrelFilter = algorithmParameters.getBoolean("useCorrelFilter");
            this.validate = algorithmParameters.getBoolean("validate");
            int n = experiment.getNumberOfSamples();
            int n2 = experiment.getNumberOfGenes();
            if (this.useCorrelFilter) {
                this.correlPValue = algorithmParameters.getFloat("correlPValue");
                this.numPerms = algorithmParameters.getInt("numPerms");
            }
            if (!this.validate) {
                DefaultMutableTreeNode defaultMutableTreeNode2;
                block23: {
                    this.useVarianceFilter = algorithmParameters.getBoolean("useVarianceFilter");
                    if (this.useVarianceFilter) {
                        this.numVarFilteredVectors = algorithmParameters.getInt("numVarFilteredVectors");
                    }
                    try {
                        this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("KNNC");
                        this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
                        this.progress = new Progress(iFramework.getFrame(), "KNN classification", listener);
                        this.progress.show();
                        if (this.classifyGenes) {
                            algorithmData.addMatrix("experiment", experiment.getMatrix());
                        } else {
                            algorithmData.addMatrix("experiment", experiment.getMatrix().transpose());
                        }
                        long l = System.currentTimeMillis();
                        AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
                        long l2 = System.currentTimeMillis() - l;
                        Cluster cluster = algorithmData2.getCluster("cluster");
                        NodeList nodeList = cluster.getNodeList();
                        this.k = this.numClasses * 4 + 1;
                        this.clusters = new int[this.k][];
                        for (int i = 0; i < this.k; ++i) {
                            this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
                        }
                        this.means = algorithmData2.getMatrix("clusters_means");
                        this.variances = algorithmData2.getMatrix("clusters_variances");
                        this.numberCorrectlyClassifiedByClass = algorithmData2.getIntArray("numberCorrectlyClassifiedByClass");
                        this.numberIncorrectlyClassifiedByClass = algorithmData2.getIntArray("numberIncorrectlyClassifiedByClass");
                        this.origNumInFiltTrgSetByClass = algorithmData2.getIntArray("origNumInFiltTrgSetByClass");
                        GeneralInfo generalInfo = new GeneralInfo();
                        generalInfo.time = l2;
                        generalInfo.hcl = algorithmParameters.getBoolean("hierarchical-tree");
                        generalInfo.hcl_genes = algorithmParameters.getBoolean("calculate-genes");
                        generalInfo.hcl_samples = algorithmParameters.getBoolean("calculate-experiments");
                        if (generalInfo.hcl) {
                            generalInfo.hcl_method = algorithmParameters.getInt("method-linkage");
                        }
                        generalInfo.numClasses = this.numClasses;
                        generalInfo.numNeighbors = this.numNeighbors;
                        generalInfo.usedVarFilter = this.useVarianceFilter;
                        if (this.useVarianceFilter) {
                            generalInfo.numVarFiltered = this.numVarFilteredVectors;
                            generalInfo.postVarDataSetSize = algorithmData2.getParams().getInt("postVarDataSetSize");
                            generalInfo.postVarClassSetSize = algorithmData2.getParams().getInt("postVarClassSetSize");
                        }
                        generalInfo.usedCorrelFilter = this.useCorrelFilter;
                        if (this.useCorrelFilter) {
                            generalInfo.correlPvalue = this.correlPValue;
                            generalInfo.numPerms = this.numPerms;
                            generalInfo.postCorrDataSetSize = algorithmData2.getParams().getInt("postCorrDataSetSize");
                        }
                        generalInfo.usedNumNeibs = algorithmData2.getParams().getInt("usedNumNeibs");
                        generalInfo.origDataSetSize = algorithmData2.getParams().getInt("origDataSetSize");
                        generalInfo.origClassSetSize = algorithmData2.getParams().getInt("origClassSetSize");
                        defaultMutableTreeNode2 = this.createResultTree(cluster, generalInfo);
                        Object var18_24 = null;
                        if (this.algorithm == null) break block23;
                    }
                    catch (Throwable throwable) {
                        Object var18_25 = null;
                        if (this.algorithm != null) {
                            this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                        }
                        if (this.progress != null) {
                            this.progress.dispose();
                        }
                        throw throwable;
                    }
                    this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                }
                if (this.progress != null) {
                    this.progress.dispose();
                }
                return defaultMutableTreeNode2;
            }
            try {
                this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("KNNC");
                this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
                this.progress = new Progress(iFramework.getFrame(), "KNN classification", listener);
                this.progress.show();
                if (this.classifyGenes) {
                    algorithmData.addMatrix("experiment", experiment.getMatrix());
                } else {
                    algorithmData.addMatrix("experiment", experiment.getMatrix().transpose());
                }
                long l = System.currentTimeMillis();
                AlgorithmData algorithmData3 = this.algorithm.execute(algorithmData);
                long l3 = System.currentTimeMillis() - l;
                Cluster cluster = algorithmData3.getCluster("cluster");
                NodeList nodeList = cluster.getNodeList();
                this.k = this.numClasses + 1;
                this.clusters = new int[this.k][];
                for (int i = 0; i < this.k; ++i) {
                    this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
                }
                this.means = algorithmData3.getMatrix("clusters_means");
                this.variances = algorithmData3.getMatrix("clusters_variances");
                this.numberCorrectlyClassifiedByClass = algorithmData3.getIntArray("numberCorrectlyClassifiedByClass");
                this.numberIncorrectlyClassifiedByClass = algorithmData3.getIntArray("numberIncorrectlyClassifiedByClass");
                this.origNumInFiltTrgSetByClass = algorithmData3.getIntArray("origNumInFiltTrgSetByClass");
                GeneralInfo generalInfo = new GeneralInfo();
                generalInfo.time = l3;
                generalInfo.hcl = algorithmParameters.getBoolean("hierarchical-tree");
                generalInfo.hcl_genes = algorithmParameters.getBoolean("calculate-genes");
                generalInfo.hcl_samples = algorithmParameters.getBoolean("calculate-experiments");
                if (generalInfo.hcl) {
                    generalInfo.hcl_method = algorithmParameters.getInt("method-linkage");
                }
                generalInfo.numClasses = this.numClasses;
                generalInfo.numNeighbors = this.numNeighbors;
                generalInfo.usedCorrelFilter = this.useCorrelFilter;
                if (this.useCorrelFilter) {
                    generalInfo.correlPvalue = this.correlPValue;
                    generalInfo.numPerms = this.numPerms;
                }
                generalInfo.usedNumNeibs = algorithmData3.getParams().getInt("usedNumNeibs");
                defaultMutableTreeNode = this.createValidationResultTree(cluster, generalInfo);
                Object var20_27 = null;
                if (this.algorithm == null) break block24;
            }
            catch (Throwable throwable) {
                block25: {
                    Object var20_28 = null;
                    if (this.algorithm != null) {
                        this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                    }
                    if (this.progress == null) break block25;
                    this.progress.dispose();
                }
                throw throwable;
            }
            this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
        }
        if (this.progress != null) {
            this.progress.dispose();
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode createValidationResultTree(Cluster cluster, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.classifyGenes ? new DefaultMutableTreeNode("KNNC Validation - genes") : new DefaultMutableTreeNode("KNNC Validation - samples");
        this.addValidationExpressionImages(defaultMutableTreeNode);
        this.addValidationHierarchicalTrees(defaultMutableTreeNode, cluster, generalInfo);
        this.addValidationCentroidViews(defaultMutableTreeNode);
        this.addValidationTableViews(defaultMutableTreeNode);
        this.addValidationInfo(defaultMutableTreeNode);
        this.addValidationGeneralInfo(defaultMutableTreeNode, generalInfo);
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode createResultTree(Cluster cluster, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.classifyGenes ? new DefaultMutableTreeNode("KNNC - genes") : new DefaultMutableTreeNode("KNNC - samples");
        this.addResultNodes(defaultMutableTreeNode, cluster, generalInfo);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        this.addExpressionImages(defaultMutableTreeNode);
        this.addHierarchicalTrees(defaultMutableTreeNode, cluster, generalInfo);
        this.addCentroidViews(defaultMutableTreeNode);
        this.addTableViews(defaultMutableTreeNode);
        this.addClusterInfo(defaultMutableTreeNode);
        this.addValidationInfo(defaultMutableTreeNode);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addValidationTableViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Table views");
        Object object = this.classifyGenes ? new ClusterTableViewer(this.experiment, this.clusters, this.data) : new ExperimentClusterTableViewer(this.experiment, this.clusters, this.data);
        for (int i = 1; i < this.clusters.length; ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i), (IViewer)object, (Object)new Integer(i))));
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Not in training set ", (IViewer)object, (Object)new Integer(0))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addTableViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Table views");
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[]{new DefaultMutableTreeNode("Used classifiers"), new DefaultMutableTreeNode("Unused classifiers"), new DefaultMutableTreeNode("Classified"), new DefaultMutableTreeNode("Used classifiers + classified")};
        Object object = this.classifyGenes ? new ClusterTableViewer(this.experiment, this.clusters, this.data) : new ExperimentClusterTableViewer(this.experiment, this.clusters, this.data);
        for (n = 0; n < this.numClasses; ++n) {
            defaultMutableTreeNodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1), (IViewer)object, (Object)new Integer(n))));
        }
        for (n = this.numClasses; n < 2 * this.numClasses; ++n) {
            defaultMutableTreeNodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - this.numClasses), (IViewer)object, (Object)new Integer(n))));
        }
        for (n = 2 * this.numClasses; n < 3 * this.numClasses; ++n) {
            defaultMutableTreeNodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 2 * this.numClasses), (IViewer)object, (Object)new Integer(n))));
        }
        for (n = 3 * this.numClasses; n < 4 * this.numClasses; ++n) {
            defaultMutableTreeNodeArray[3].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 3 * this.numClasses), (IViewer)object, (Object)new Integer(n))));
        }
        for (n = 0; n < defaultMutableTreeNodeArray.length; ++n) {
            defaultMutableTreeNode2.add(defaultMutableTreeNodeArray[n]);
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unclassified ", (IViewer)object, (Object)new Integer(4 * this.numClasses))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addValidationExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        Object object = this.classifyGenes ? new KNNCExperimentViewer(this.experiment, this.clusters) : new KNNCExperimentClusterViewer(this.experiment, this.clusters);
        for (int i = 1; i < this.clusters.length; ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i), (IViewer)object, (Object)new Integer(i))));
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Not in training set ", (IViewer)object, (Object)new Integer(0))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[]{new DefaultMutableTreeNode("Used classifiers"), new DefaultMutableTreeNode("Unused classifiers"), new DefaultMutableTreeNode("Classified"), new DefaultMutableTreeNode("Used classifiers + classified")};
        Object object = this.classifyGenes ? new KNNCExperimentViewer(this.experiment, this.clusters) : new KNNCExperimentClusterViewer(this.experiment, this.clusters);
        for (n = 0; n < this.numClasses; ++n) {
            defaultMutableTreeNodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1), (IViewer)object, (Object)new Integer(n))));
        }
        for (n = this.numClasses; n < 2 * this.numClasses; ++n) {
            defaultMutableTreeNodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - this.numClasses), (IViewer)object, (Object)new Integer(n))));
        }
        for (n = 2 * this.numClasses; n < 3 * this.numClasses; ++n) {
            defaultMutableTreeNodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 2 * this.numClasses), (IViewer)object, (Object)new Integer(n))));
        }
        for (n = 3 * this.numClasses; n < 4 * this.numClasses; ++n) {
            defaultMutableTreeNodeArray[3].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 3 * this.numClasses), (IViewer)object, (Object)new Integer(n))));
        }
        for (n = 0; n < defaultMutableTreeNodeArray.length; ++n) {
            defaultMutableTreeNode2.add(defaultMutableTreeNodeArray[n]);
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unclassified ", (IViewer)object, (Object)new Integer(4 * this.numClasses))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addValidationHierarchicalTrees(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        int n;
        if (!generalInfo.hcl) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = cluster.getNodeList();
        Object object = null;
        if (!this.classifyGenes) {
            object = new int[this.k][];
            for (n = 0; n < this.k; ++n) {
                object[n] = nodeList.getNode(n).getFeaturesIndexes();
            }
            if (generalInfo.hcl_samples) {
                object = this.getOrderedIndices(nodeList, (int[][])object, generalInfo.hcl_genes);
            }
        }
        for (n = 1; n < nodeList.getSize(); ++n) {
            if (this.classifyGenes) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n), this.createHCLViewer(nodeList.getNode(n), generalInfo, null))));
                continue;
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n), this.createHCLViewer(nodeList.getNode(n), generalInfo, (int[][])object), (Object)new Integer(n))));
        }
        if (this.classifyGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Not in training set", this.createHCLViewer(nodeList.getNode(0), generalInfo, null))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Not in training set", this.createHCLViewer(nodeList.getNode(0), generalInfo, (int[][])object), (Object)new Integer(0))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        int n;
        if (!generalInfo.hcl) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = cluster.getNodeList();
        Object object = null;
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[]{new DefaultMutableTreeNode("Used classifiers"), new DefaultMutableTreeNode("Unused classifiers"), new DefaultMutableTreeNode("Classified"), new DefaultMutableTreeNode("Used classifiers + classified")};
        if (!this.classifyGenes) {
            object = new int[this.k][];
            for (n = 0; n < this.k; ++n) {
                object[n] = nodeList.getNode(n).getFeaturesIndexes();
            }
            if (generalInfo.hcl_samples) {
                object = this.getOrderedIndices(nodeList, (int[][])object, generalInfo.hcl_genes);
            }
        }
        if (this.classifyGenes) {
            for (n = 0; n < this.numClasses; ++n) {
                defaultMutableTreeNodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1), this.createHCLViewer(nodeList.getNode(n), generalInfo, null))));
            }
            for (n = this.numClasses; n < 2 * this.numClasses; ++n) {
                defaultMutableTreeNodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - this.numClasses), this.createHCLViewer(nodeList.getNode(n), generalInfo, null))));
            }
            for (n = 2 * this.numClasses; n < 3 * this.numClasses; ++n) {
                defaultMutableTreeNodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 2 * this.numClasses), this.createHCLViewer(nodeList.getNode(n), generalInfo, null))));
            }
            for (n = 3 * this.numClasses; n < 4 * this.numClasses; ++n) {
                defaultMutableTreeNodeArray[3].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 3 * this.numClasses), this.createHCLViewer(nodeList.getNode(n), generalInfo, null))));
            }
            for (n = 0; n < defaultMutableTreeNodeArray.length; ++n) {
                defaultMutableTreeNode2.add(defaultMutableTreeNodeArray[n]);
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unclassified ", this.createHCLViewer(nodeList.getNode(4 * this.numClasses), generalInfo, null))));
        } else {
            for (n = 0; n < this.numClasses; ++n) {
                defaultMutableTreeNodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1), this.createHCLViewer(nodeList.getNode(n), generalInfo, (int[][])object), (Object)new Integer(n))));
            }
            for (n = this.numClasses; n < 2 * this.numClasses; ++n) {
                defaultMutableTreeNodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - this.numClasses), this.createHCLViewer(nodeList.getNode(n), generalInfo, (int[][])object), (Object)new Integer(n))));
            }
            for (n = 2 * this.numClasses; n < 3 * this.numClasses; ++n) {
                defaultMutableTreeNodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 2 * this.numClasses), this.createHCLViewer(nodeList.getNode(n), generalInfo, (int[][])object), (Object)new Integer(n))));
            }
            for (n = 3 * this.numClasses; n < 4 * this.numClasses; ++n) {
                defaultMutableTreeNodeArray[3].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 3 * this.numClasses), this.createHCLViewer(nodeList.getNode(n), generalInfo, (int[][])object), (Object)new Integer(n))));
            }
            for (n = 0; n < defaultMutableTreeNodeArray.length; ++n) {
                defaultMutableTreeNode2.add(defaultMutableTreeNodeArray[n]);
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unclassified ", this.createHCLViewer(nodeList.getNode(4 * this.numClasses), generalInfo, (int[][])object), (Object)new Integer(4 * this.numClasses))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private IViewer createHCLViewer(Node node, GeneralInfo generalInfo, int[][] nArray) {
        HCLTreeData hCLTreeData;
        HCLTreeData hCLTreeData2;
        HCLTreeData hCLTreeData3 = hCLTreeData2 = generalInfo.hcl_genes ? this.getResult(node, 0) : null;
        HCLTreeData hCLTreeData4 = generalInfo.hcl_samples ? this.getResult(node, generalInfo.hcl_genes ? 4 : 0) : (hCLTreeData = null);
        if (this.classifyGenes) {
            return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData);
        }
        return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData, nArray, true);
    }

    private HCLTreeData getResult(Node node, int n) {
        HCLTreeData hCLTreeData = new HCLTreeData();
        NodeValueList nodeValueList = node.getValues();
        hCLTreeData.child_1_array = (int[])nodeValueList.getNodeValue((int)n).value;
        hCLTreeData.child_2_array = (int[])nodeValueList.getNodeValue((int)(n + 1)).value;
        hCLTreeData.node_order = (int[])nodeValueList.getNodeValue((int)(n + 2)).value;
        hCLTreeData.height = (float[])nodeValueList.getNodeValue((int)(n + 3)).value;
        return hCLTreeData;
    }

    private int[][] getOrderedIndices(NodeList nodeList, int[][] nArray, boolean bl) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i].length <= 0) continue;
            HCLTreeData hCLTreeData = this.getResult(nodeList.getNode(i), bl ? 4 : 0);
            nArray[i] = this.getSampleOrder(hCLTreeData, nArray[i]);
        }
        return nArray;
    }

    private int[] getSampleOrder(HCLTreeData hCLTreeData, int[] nArray) {
        return this.getLeafOrder(hCLTreeData.node_order, hCLTreeData.child_1_array, hCLTreeData.child_2_array, nArray);
    }

    private int[] getLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = new int[nArray.length];
        Arrays.fill(nArray5, -1);
        this.fillLeafOrder(nArray5, nArray2, nArray3, 0, nArray2.length - 2, nArray4);
        return nArray5;
    }

    private int fillLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int[] nArray4) {
        if (nArray2[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray2[n2], nArray4);
        }
        if (nArray3[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray3[n2], nArray4);
        } else {
            nArray[n] = nArray4 == null ? n2 : nArray4[n2];
            ++n;
        }
        return n;
    }

    private void addClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        if (this.classifyGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Classes (#,%)", (IViewer)new KNNCInfoViewer(this.clusters, this.experiment.getNumberOfGenes(), this.numClasses))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Samples in Classes (#,%)", (IViewer)new KNNCInfoViewer(this.clusters, this.experiment.getNumberOfSamples(), false, this.numClasses))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addValidationInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new LeafInfo("Validation Information", (IViewer)new KNNCValidationInfoViewer(this.origNumInFiltTrgSetByClass, this.numberCorrectlyClassifiedByClass, this.numberIncorrectlyClassifiedByClass)));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addValidationCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        int[][] nArrayArray = new int[this.clusters.length][];
        for (int i = 0; i < this.clusters.length - 1; ++i) {
            nArrayArray[i] = this.clusters[i + 1];
        }
        nArrayArray[this.clusters.length - 1] = this.clusters[0];
        FloatMatrix floatMatrix = new FloatMatrix(this.means.getRowDimension(), this.means.getColumnDimension());
        FloatMatrix floatMatrix2 = new FloatMatrix(this.variances.getRowDimension(), this.variances.getColumnDimension());
        for (n = 0; n < this.clusters.length - 1; ++n) {
            floatMatrix.A[n] = this.means.A[n + 1];
            floatMatrix2.A[n] = this.variances.A[n + 1];
        }
        floatMatrix.A[this.clusters.length - 1] = this.means.A[0];
        floatMatrix2.A[this.clusters.length - 1] = this.variances.A[0];
        if (this.classifyGenes) {
            KNNCCentroidViewer kNNCCentroidViewer = new KNNCCentroidViewer(this.experiment, this.clusters);
            kNNCCentroidViewer.setMeans(this.means.A);
            kNNCCentroidViewer.setVariances(this.variances.A);
            for (n = 1; n < this.clusters.length; ++n) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n), (IViewer)kNNCCentroidViewer, (Object)new CentroidUserObject(n, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n), (IViewer)kNNCCentroidViewer, (Object)new CentroidUserObject(n, 1))));
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Not in training set ", (IViewer)kNNCCentroidViewer, (Object)new CentroidUserObject(0, 0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Not in training set ", (IViewer)kNNCCentroidViewer, (Object)new CentroidUserObject(0, 1))));
            KNNCCentroidsViewer kNNCCentroidsViewer = new KNNCCentroidsViewer(this.experiment, nArrayArray);
            kNNCCentroidsViewer.setMeans(floatMatrix.A);
            kNNCCentroidsViewer.setVariances(floatMatrix2.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)kNNCCentroidsViewer, (Object)new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)kNNCCentroidsViewer, (Object)new Integer(1))));
        } else {
            KNNCExperimentCentroidViewer kNNCExperimentCentroidViewer = new KNNCExperimentCentroidViewer(this.experiment, this.clusters);
            kNNCExperimentCentroidViewer.setMeans(this.means.A);
            kNNCExperimentCentroidViewer.setVariances(this.variances.A);
            for (n = 1; n < this.clusters.length; ++n) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n), (IViewer)kNNCExperimentCentroidViewer, (Object)new CentroidUserObject(n, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n), (IViewer)kNNCExperimentCentroidViewer, (Object)new CentroidUserObject(n, 1))));
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Not in training set ", (IViewer)kNNCExperimentCentroidViewer, (Object)new CentroidUserObject(0, 0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Not in training set ", (IViewer)kNNCExperimentCentroidViewer, (Object)new CentroidUserObject(0, 1))));
            KNNCExperimentCentroidsViewer kNNCExperimentCentroidsViewer = new KNNCExperimentCentroidsViewer(this.experiment, nArrayArray);
            kNNCExperimentCentroidsViewer.setMeans(floatMatrix.A);
            kNNCExperimentCentroidsViewer.setVariances(floatMatrix2.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)kNNCExperimentCentroidsViewer, (Object)new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)kNNCExperimentCentroidsViewer, (Object)new Integer(1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[4];
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray2 = new DefaultMutableTreeNode[4];
        defaultMutableTreeNodeArray[0] = new DefaultMutableTreeNode("Used classifiers");
        defaultMutableTreeNodeArray[1] = new DefaultMutableTreeNode("Unused classifiers");
        defaultMutableTreeNodeArray[2] = new DefaultMutableTreeNode("Classified");
        defaultMutableTreeNodeArray[3] = new DefaultMutableTreeNode("Used classifiers + classified");
        defaultMutableTreeNodeArray2[0] = new DefaultMutableTreeNode("Used classifiers");
        defaultMutableTreeNodeArray2[1] = new DefaultMutableTreeNode("Unused classifiers");
        defaultMutableTreeNodeArray2[2] = new DefaultMutableTreeNode("Classified");
        defaultMutableTreeNodeArray2[3] = new DefaultMutableTreeNode("Used classifiers + classified");
        if (this.classifyGenes) {
            int n;
            KNNCCentroidViewer kNNCCentroidViewer = new KNNCCentroidViewer(this.experiment, this.clusters);
            kNNCCentroidViewer.setMeans(this.means.A);
            kNNCCentroidViewer.setVariances(this.variances.A);
            for (n = 0; n < this.numClasses; ++n) {
                defaultMutableTreeNodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1), (IViewer)kNNCCentroidViewer, (Object)new CentroidUserObject(n, 0))));
                defaultMutableTreeNodeArray2[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1), (IViewer)kNNCCentroidViewer, (Object)new CentroidUserObject(n, 1))));
            }
            for (n = this.numClasses; n < 2 * this.numClasses; ++n) {
                defaultMutableTreeNodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - this.numClasses), (IViewer)kNNCCentroidViewer, (Object)new CentroidUserObject(n, 0))));
                defaultMutableTreeNodeArray2[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - this.numClasses), (IViewer)kNNCCentroidViewer, (Object)new CentroidUserObject(n, 1))));
            }
            for (n = 2 * this.numClasses; n < 3 * this.numClasses; ++n) {
                defaultMutableTreeNodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 2 * this.numClasses), (IViewer)kNNCCentroidViewer, (Object)new CentroidUserObject(n, 0))));
                defaultMutableTreeNodeArray2[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 2 * this.numClasses), (IViewer)kNNCCentroidViewer, (Object)new CentroidUserObject(n, 1))));
            }
            for (n = 3 * this.numClasses; n < 4 * this.numClasses; ++n) {
                defaultMutableTreeNodeArray[3].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 3 * this.numClasses), (IViewer)kNNCCentroidViewer, (Object)new CentroidUserObject(n, 0))));
                defaultMutableTreeNodeArray2[3].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 3 * this.numClasses), (IViewer)kNNCCentroidViewer, (Object)new CentroidUserObject(n, 1))));
            }
            KNNCCentroidsViewer kNNCCentroidsViewer = new KNNCCentroidsViewer(this.experiment, this.clusters);
            kNNCCentroidsViewer.setMeans(this.means.A);
            kNNCCentroidsViewer.setVariances(this.variances.A);
            for (int i = 0; i < defaultMutableTreeNodeArray.length; ++i) {
                defaultMutableTreeNode2.add(defaultMutableTreeNodeArray[i]);
                defaultMutableTreeNode3.add(defaultMutableTreeNodeArray2[i]);
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unclassified ", (IViewer)kNNCCentroidViewer, (Object)new CentroidUserObject(4 * this.numClasses, 0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Unclassified ", (IViewer)kNNCCentroidViewer, (Object)new CentroidUserObject(4 * this.numClasses, 1))));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All ", (IViewer)kNNCCentroidsViewer, (Object)new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All ", (IViewer)kNNCCentroidsViewer, (Object)new Integer(1))));
        } else {
            int n;
            KNNCExperimentCentroidViewer kNNCExperimentCentroidViewer = new KNNCExperimentCentroidViewer(this.experiment, this.clusters);
            kNNCExperimentCentroidViewer.setMeans(this.means.A);
            kNNCExperimentCentroidViewer.setVariances(this.variances.A);
            for (n = 0; n < this.numClasses; ++n) {
                defaultMutableTreeNodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1), (IViewer)kNNCExperimentCentroidViewer, (Object)new CentroidUserObject(n, 0))));
                defaultMutableTreeNodeArray2[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1), (IViewer)kNNCExperimentCentroidViewer, (Object)new CentroidUserObject(n, 1))));
            }
            for (n = this.numClasses; n < 2 * this.numClasses; ++n) {
                defaultMutableTreeNodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - this.numClasses), (IViewer)kNNCExperimentCentroidViewer, (Object)new CentroidUserObject(n, 0))));
                defaultMutableTreeNodeArray2[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - this.numClasses), (IViewer)kNNCExperimentCentroidViewer, (Object)new CentroidUserObject(n, 1))));
            }
            for (n = 2 * this.numClasses; n < 3 * this.numClasses; ++n) {
                defaultMutableTreeNodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 2 * this.numClasses), (IViewer)kNNCExperimentCentroidViewer, (Object)new CentroidUserObject(n, 0))));
                defaultMutableTreeNodeArray2[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 2 * this.numClasses), (IViewer)kNNCExperimentCentroidViewer, (Object)new CentroidUserObject(n, 1))));
            }
            for (n = 3 * this.numClasses; n < 4 * this.numClasses; ++n) {
                defaultMutableTreeNodeArray[3].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 3 * this.numClasses), (IViewer)kNNCExperimentCentroidViewer, (Object)new CentroidUserObject(n, 0))));
                defaultMutableTreeNodeArray2[3].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 3 * this.numClasses), (IViewer)kNNCExperimentCentroidViewer, (Object)new CentroidUserObject(n, 1))));
            }
            KNNCExperimentCentroidsViewer kNNCExperimentCentroidsViewer = new KNNCExperimentCentroidsViewer(this.experiment, this.clusters);
            kNNCExperimentCentroidsViewer.setMeans(this.means.A);
            kNNCExperimentCentroidsViewer.setVariances(this.variances.A);
            for (int i = 0; i < defaultMutableTreeNodeArray.length; ++i) {
                defaultMutableTreeNode2.add(defaultMutableTreeNodeArray[i]);
                defaultMutableTreeNode3.add(defaultMutableTreeNodeArray2[i]);
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unclassified ", (IViewer)kNNCExperimentCentroidViewer, (Object)new CentroidUserObject(4 * this.numClasses, 0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Unclassified ", (IViewer)kNNCExperimentCentroidViewer, (Object)new CentroidUserObject(4 * this.numClasses, 1))));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All ", (IViewer)kNNCExperimentCentroidsViewer, (Object)new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All ", (IViewer)kNNCExperimentCentroidsViewer, (Object)new Integer(1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Original total data set size: " + generalInfo.origDataSetSize));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Original training set size: " + generalInfo.origClassSetSize));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Used variance filter: " + generalInfo.usedVarFilter));
        if (this.useVarianceFilter) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Total data set size after var. filtering: " + generalInfo.numVarFiltered));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Var. filtered training set size: " + generalInfo.postVarClassSetSize));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Size of set to classify after var. filtering: " + generalInfo.postVarDataSetSize));
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Used correlation filter: " + generalInfo.usedCorrelFilter));
        if (this.useCorrelFilter) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Threshold p-value: " + generalInfo.correlPvalue));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Number of permutations: " + generalInfo.numPerms));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Size of set to classify after corr. filtering: " + generalInfo.postCorrDataSetSize));
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Num. classes: " + generalInfo.numClasses));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Input num. neighbors: " + generalInfo.numNeighbors));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Num. neighbors used: " + generalInfo.usedNumNeibs));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("HCL: " + generalInfo.getMethodName()));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addValidationGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Used correlation filter: " + generalInfo.usedCorrelFilter));
        if (this.useCorrelFilter) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Threshold p-value: " + generalInfo.correlPvalue));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Number of permutations: " + generalInfo.numPerms));
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Num. classes: " + generalInfo.numClasses));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Input num. neighbors: " + generalInfo.numNeighbors));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Num. neighbors used: " + generalInfo.usedNumNeibs));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("HCL: " + generalInfo.getMethodName()));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private class GeneralInfo {
        public long time;
        public String function;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;
        private int numClasses;
        private int numNeighbors;
        private int numVarFiltered;
        private int numPerms;
        private int usedNumNeibs;
        private int postVarClassSetSize;
        private int postVarDataSetSize;
        private int postCorrDataSetSize;
        private int origDataSetSize;
        private int origClassSetSize;
        private boolean usedVarFilter;
        private boolean usedCorrelFilter;
        private double correlPvalue;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            switch (algorithmEvent.getId()) {
                case 1: {
                    KNNCGUI.this.progress.setUnits(algorithmEvent.getIntValue());
                    KNNCGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 2: {
                    KNNCGUI.this.progress.setValue(algorithmEvent.getIntValue());
                    KNNCGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 3: {
                    int n = algorithmEvent.getIntValue();
                    if (n != -1) break;
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                KNNCGUI.this.algorithm.abort();
                KNNCGUI.this.progress.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            KNNCGUI.this.algorithm.abort();
            KNNCGUI.this.progress.dispose();
        }
    }
}

