/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.kmcs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DistanceMetricPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class KMCSupportDialog
extends AlgorithmDialog {
    SampleSelectionPanel sPanel;
    MeansOrMediansPanel mPanel;
    TopPanel tPanel;
    KMCParameterPanel kPanel;
    HCLSelectionPanel hclOpsPanel;
    DistanceMetricPanel metricPanel;
    boolean okPressed = false;

    public KMCSupportDialog(JFrame jFrame, boolean bl, String string, boolean bl2) {
        super(jFrame, "KMS: K-Means/K-Medians Support", bl);
        this.setBounds(0, 0, 500, 550);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.sPanel = new SampleSelectionPanel(Color.white, UIManager.getColor("Label.foreground"), true, "Sample Selection");
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 10);
        gridBagLayout.setConstraints(this.sPanel, gridBagConstraints);
        jPanel.add(this.sPanel);
        this.metricPanel = new DistanceMetricPanel(string, bl2, "Euclidean Distance", "KMCS", true, true);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100, 10);
        gridBagLayout.setConstraints(this.metricPanel, gridBagConstraints);
        jPanel.add(this.metricPanel);
        this.mPanel = new MeansOrMediansPanel();
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 100, 10);
        gridBagLayout.setConstraints(this.mPanel, gridBagConstraints);
        jPanel.add(this.mPanel);
        this.tPanel = new TopPanel();
        this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 100, 30);
        gridBagLayout.setConstraints(this.tPanel, gridBagConstraints);
        jPanel.add(this.tPanel);
        this.kPanel = new KMCParameterPanel();
        this.buildConstraints(gridBagConstraints, 0, 4, 1, 1, 0, 30);
        gridBagLayout.setConstraints(this.kPanel, gridBagConstraints);
        jPanel.add(this.kPanel);
        this.hclOpsPanel = new HCLSelectionPanel();
        this.buildConstraints(gridBagConstraints, 0, 5, 1, 1, 0, 10);
        gridBagLayout.setConstraints(this.hclOpsPanel, gridBagConstraints);
        jPanel.add(this.hclOpsPanel);
        this.addContent(jPanel);
        this.setActionListeners(new Listener());
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
        if (bl) {
            // empty if block
        }
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public int getNumReps() {
        String string = this.tPanel.numRepsInputField.getText();
        int n = Integer.parseInt(string);
        return n;
    }

    public double getThresholdPercent() {
        String string = this.tPanel.thresholdInputField.getText();
        double d = Double.parseDouble(string);
        return d;
    }

    public int getNumClusters() {
        String string = this.kPanel.numClustersInputField.getText();
        int n = Integer.parseInt(string);
        return n;
    }

    public int getIterations() {
        String string = this.kPanel.numIterationsInputField.getText();
        int n = Integer.parseInt(string);
        return n;
    }

    public boolean isDrawTrees() {
        boolean bl = this.hclOpsPanel.isHCLSelected();
        return bl;
    }

    public boolean meansChosen() {
        return this.mPanel.meansButton.isSelected();
    }

    public boolean isClusterGenes() {
        return this.sPanel.isClusterGenesSelected();
    }

    public int getDistanceMetric() {
        return this.metricPanel.getMetricIndex();
    }

    public boolean getAbsoluteSelection() {
        return this.metricPanel.getAbsoluteSelection();
    }

    private void resetControls() {
        this.sPanel.setClusterGenesSelected(true);
        this.mPanel.meansButton.setSelected(true);
        this.tPanel.numRepsInputField.setText("10");
        this.tPanel.thresholdInputField.setText("80");
        this.kPanel.numClustersInputField.setText("10");
        this.kPanel.numIterationsInputField.setText("50");
        this.hclOpsPanel.setHCLSelected(false);
        this.metricPanel.reset();
    }

    private boolean validInput(int n, double d, int n2, int n3) {
        boolean bl = true;
        if (n < 1) {
            this.tPanel.numRepsInputField.requestFocus();
            this.tPanel.numRepsInputField.selectAll();
            JOptionPane.showMessageDialog(this, "Number of repetitions must be > 0", "Input Error!", 0);
            bl = false;
        } else if (d <= 0.0 || d > 100.0) {
            this.tPanel.thresholdInputField.requestFocus();
            this.tPanel.thresholdInputField.selectAll();
            JOptionPane.showMessageDialog(this, "Threshold % must be > 0 and <= 100", "Input Error!", 0);
            bl = false;
        } else if (n2 < 1) {
            this.kPanel.numClustersInputField.requestFocus();
            this.kPanel.numClustersInputField.selectAll();
            JOptionPane.showMessageDialog(this, "Number of clusters must be > 0", "Input Error!", 0);
            bl = false;
        } else if (n3 < 1) {
            JOptionPane.showMessageDialog(this, "Number of iterations must be > 0", "Input Error!", 0);
            this.kPanel.numIterationsInputField.requestFocus();
            this.kPanel.numIterationsInputField.selectAll();
            bl = false;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        KMCSupportDialog kMCSupportDialog = new KMCSupportDialog(jFrame, true, "Euclidean Distance", false);
        kMCSupportDialog.setVisible(true);
        System.exit(0);
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                int n;
                int n2;
                double d;
                int n3;
                KMCSupportDialog.this.okPressed = true;
                int n4 = 0;
                try {
                    n3 = Integer.parseInt(KMCSupportDialog.this.tPanel.numRepsInputField.getText());
                    ++n4;
                    d = Double.parseDouble(KMCSupportDialog.this.tPanel.thresholdInputField.getText());
                    ++n4;
                    n2 = Integer.parseInt(KMCSupportDialog.this.kPanel.numClustersInputField.getText());
                    ++n4;
                    n = Integer.parseInt(KMCSupportDialog.this.kPanel.numIterationsInputField.getText());
                    ++n4;
                }
                catch (NumberFormatException numberFormatException) {
                    switch (n4) {
                        case 0: {
                            KMCSupportDialog.this.tPanel.numRepsInputField.requestFocus();
                            KMCSupportDialog.this.tPanel.numRepsInputField.selectAll();
                            break;
                        }
                        case 1: {
                            KMCSupportDialog.this.tPanel.thresholdInputField.requestFocus();
                            KMCSupportDialog.this.tPanel.thresholdInputField.selectAll();
                            break;
                        }
                        case 2: {
                            KMCSupportDialog.this.kPanel.numClustersInputField.requestFocus();
                            KMCSupportDialog.this.kPanel.numClustersInputField.selectAll();
                            break;
                        }
                        case 3: {
                            KMCSupportDialog.this.kPanel.numIterationsInputField.requestFocus();
                            KMCSupportDialog.this.kPanel.numIterationsInputField.selectAll();
                        }
                    }
                    JOptionPane.showMessageDialog(KMCSupportDialog.this, "Entry format error.", "Error", 0);
                    return;
                }
                if (!KMCSupportDialog.this.validInput(n3, d, n2, n)) {
                    return;
                }
            } else if (string.equals("cancel-command")) {
                KMCSupportDialog.this.okPressed = false;
            } else {
                if (string.equals("reset-command")) {
                    KMCSupportDialog.this.resetControls();
                    return;
                }
                if (string.equals("info-command")) {
                    HelpWindow helpWindow = new HelpWindow(KMCSupportDialog.this, "KMS Initialization Dialog");
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(450, 650);
                        helpWindow.setLocation();
                        helpWindow.show();
                        return;
                    }
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                    return;
                }
            }
            KMCSupportDialog.this.dispose();
        }

        public void windowClosing(WindowEvent windowEvent) {
            KMCSupportDialog.this.okPressed = false;
            KMCSupportDialog.this.dispose();
        }
    }

    class KMCParameterPanel
    extends JPanel {
        JTextField numClustersInputField;
        JTextField numIterationsInputField;

        KMCParameterPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Parameters for each K-Means / K-Medians run", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            JLabel jLabel = new JLabel("Number of clusters ");
            KMCSupportDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 50);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            this.numClustersInputField = new JTextField("10", 7);
            KMCSupportDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
            gridBagLayout.setConstraints(this.numClustersInputField, gridBagConstraints);
            this.add(this.numClustersInputField);
            JLabel jLabel2 = new JLabel("Maximum number of iterations ");
            KMCSupportDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 50);
            gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
            this.add(jLabel2);
            this.numIterationsInputField = new JTextField("50", 7);
            KMCSupportDialog.this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 0, 0);
            gridBagLayout.setConstraints(this.numIterationsInputField, gridBagConstraints);
            this.add(this.numIterationsInputField);
        }
    }

    class TopPanel
    extends JPanel {
        JTextField numRepsInputField;
        JTextField thresholdInputField;

        TopPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Parameters for K-Means / K-Medians repetitions", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            JLabel jLabel = new JLabel("Number of k-means / k-medians runs ");
            KMCSupportDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 50);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            this.numRepsInputField = new JTextField("10", 7);
            KMCSupportDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
            gridBagLayout.setConstraints(this.numRepsInputField, gridBagConstraints);
            this.add(this.numRepsInputField);
            JLabel jLabel2 = new JLabel("Threshold % of occurrence in same cluster");
            KMCSupportDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 50);
            gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
            this.add(jLabel2);
            this.thresholdInputField = new JTextField("80", 7);
            KMCSupportDialog.this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 0, 0);
            gridBagLayout.setConstraints(this.thresholdInputField, gridBagConstraints);
            this.add(this.thresholdInputField);
        }
    }

    class MeansOrMediansPanel
    extends JPanel {
        JRadioButton meansButton;
        JRadioButton mediansButton;

        MeansOrMediansPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Means or Medians", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.meansButton = new JRadioButton("Calculate means", true);
            this.meansButton.setBackground(Color.white);
            this.meansButton.setForeground(UIManager.getColor("Label.foreground"));
            this.meansButton.setFocusPainted(false);
            this.meansButton.setHorizontalAlignment(0);
            this.mediansButton = new JRadioButton("Calculate medians", false);
            this.mediansButton.setBackground(Color.white);
            this.mediansButton.setForeground(UIManager.getColor("Label.foreground"));
            this.mediansButton.setFocusPainted(false);
            this.mediansButton.setHorizontalAlignment(0);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.meansButton);
            buttonGroup.add(this.mediansButton);
            KMCSupportDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 100);
            gridBagLayout.setConstraints(this.meansButton, gridBagConstraints);
            this.add(this.meansButton);
            KMCSupportDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
            gridBagLayout.setConstraints(this.mediansButton, gridBagConstraints);
            this.add(this.mediansButton);
        }
    }
}

