/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.hcl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLAnnotationBar;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLCluster;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLClusterInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLColorBar;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLConfigDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLExperimentHeader;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTree;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeListener;
import org.tigr.util.FloatMatrix;

public class HCLViewer
extends JPanel
implements IViewer {
    public static final long serialVersionUID = 202006080002L;
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String DELETE_CLUSTER_CMD = "delete-cluster-cmd";
    protected static final String DELETE_ALL_CLUSTERS_CMD = "delete-all-clusters-cmd";
    protected static final String GENE_TREE_PROPERTIES_CMD = "gene-tree-properties-cmd";
    protected static final String SAMPLE_TREE_PROPERTIES_CMD = "sample-tree-properties-cmd";
    protected static final String SAVE_GENE_ORDER_CMD = "save-gene-order-cmd";
    protected static final String SAVE_EXP_ORDER_CMD = "save-exp-order-cmd";
    protected static final String SAVE_GENE_HEIGHT_CMD = "save-gene-height-cmd";
    protected static final String SAVE_EXP_HEIGHT_CMD = "save-exp-height-cmd";
    protected static final String SAVE_GENE_NEWICK_CMD = "save-gene-newick-cmd";
    protected static final String SAVE_SAMPLE_NEWICK_CMD = "save-sample-newick-cmd";
    protected IViewer expViewer;
    protected HCLExperimentHeader header;
    protected HCLTree genesTree;
    protected HCLTree sampleTree;
    protected HCLColorBar colorBar;
    protected HCLAnnotationBar annotationBar;
    protected IData data;
    protected Experiment experiment;
    protected ArrayList clusters = new ArrayList();
    protected ArrayList experimentClusters = new ArrayList();
    protected int[][] sampleClusters;
    public HCLCluster selectedCluster;
    protected int[] genesOrder;
    protected int[] samplesOrder;
    protected boolean isExperimentCluster = false;
    protected boolean featureListIsEmpty = false;
    protected Dimension elementSize;
    protected int numberOfSamples;
    protected int offset = 0;
    protected int clusterIndex = 0;
    protected Listener listener;
    protected JPopupMenu popup;
    protected DefaultMutableTreeNode node;
    protected IFramework framework;

    public HCLViewer(Experiment experiment, int[] nArray, HCLTreeData hCLTreeData, HCLTreeData hCLTreeData2) {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.experiment = experiment;
        this.listener = new Listener();
        this.addMouseListener(this.listener);
        nArray = nArray == null ? this.createDefaultFeatures(experiment) : nArray;
        this.expViewer = this.createExperimentViewer(experiment, nArray, hCLTreeData, hCLTreeData2);
        this.expViewer.getContentComponent().addMouseListener(this.listener);
        this.header = new HCLExperimentHeader(this.expViewer.getHeaderComponent());
        this.header.addMouseListener(this.listener);
        this.colorBar = new HCLColorBar(this.clusters, nArray.length);
        this.colorBar.addMouseListener(this.listener);
        this.genesOrder = this.createGenesOrder(experiment, nArray, hCLTreeData);
        this.annotationBar = new HCLAnnotationBar(this.genesOrder);
        this.annotationBar.addMouseListener(this.listener);
        if (hCLTreeData != null && experiment.getNumberOfGenes() > 1 && hCLTreeData.node_order.length > 1) {
            this.genesTree = new HCLTree(hCLTreeData, 0);
            this.genesTree.addMouseListener(this.listener);
            this.genesTree.setListener(this.listener);
        }
        if (hCLTreeData2 != null && experiment.getNumberOfSamples() > 1 && hCLTreeData2.node_order.length > 1) {
            this.sampleTree = new HCLTree(hCLTreeData2, 1);
            this.samplesOrder = this.createSamplesOrder(hCLTreeData2);
            if (hCLTreeData == null) {
                this.sampleTree.setHorizontalOffset(10);
            }
            this.sampleTree.addMouseListener(this.listener);
            this.sampleTree.setListener(this.listener);
        }
        this.isExperimentCluster = false;
        this.numberOfSamples = experiment.getNumberOfSamples();
        this.addComponents(this.sampleTree, this.genesTree, this.expViewer.getContentComponent(), this.colorBar, this.annotationBar);
        this.popup = this.createJPopupMenu(this.listener);
    }

    public HCLViewer() {
    }

    public HCLViewer(Experiment experiment, int[] nArray, HCLTreeData hCLTreeData, HCLTreeData hCLTreeData2, int[][] nArray2, boolean bl) {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.experiment = experiment;
        this.listener = new Listener();
        this.addMouseListener(this.listener);
        nArray = nArray == null ? this.createDefaultFeatures(experiment) : nArray;
        this.isExperimentCluster = bl;
        this.numberOfSamples = this.isExperimentCluster ? nArray2[0].length : experiment.getNumberOfSamples();
        this.genesOrder = this.createGenesOrder(experiment, this.createDefaultFeatures(experiment), hCLTreeData);
        this.sampleClusters = nArray2;
        if (this.isExperimentCluster) {
            if (hCLTreeData != null) {
                this.offset = 0;
                this.expViewer = new ExperimentClusterViewer(experiment, nArray2, this.genesOrder, true, this.offset);
            } else {
                this.offset = 10;
                this.expViewer = new ExperimentClusterViewer(experiment, nArray2, this.genesOrder, true, this.offset);
            }
        } else {
            this.expViewer = this.createExperimentViewer(experiment, nArray, hCLTreeData, hCLTreeData2);
        }
        this.expViewer.getContentComponent().addMouseListener(this.listener);
        this.header = new HCLExperimentHeader(this.expViewer.getHeaderComponent());
        this.header.addMouseListener(this.listener);
        this.colorBar = new HCLColorBar(this.clusters, nArray.length);
        this.colorBar.addMouseListener(this.listener);
        this.annotationBar = new HCLAnnotationBar(this.genesOrder);
        this.annotationBar.addMouseListener(this.listener);
        if (hCLTreeData != null && experiment.getNumberOfGenes() > 1) {
            this.genesTree = new HCLTree(hCLTreeData, 0);
            this.genesTree.addMouseListener(this.listener);
            this.genesTree.setListener(this.listener);
        }
        if (hCLTreeData2 != null && experiment.getNumberOfSamples() > 1) {
            this.sampleTree = new HCLTree(hCLTreeData2, 1);
            if (hCLTreeData == null) {
                this.sampleTree.setHorizontalOffset(10);
            }
            this.sampleTree.addMouseListener(this.listener);
            this.sampleTree.setListener(this.listener);
        }
        this.addComponents(this.sampleTree, this.genesTree, this.expViewer.getContentComponent(), this.colorBar, this.annotationBar);
        this.popup = this.createJPopupMenu(this.listener);
    }

    public HCLViewer(Experiment experiment, int[] nArray, HCLTreeData hCLTreeData, HCLTreeData hCLTreeData2, DefaultMutableTreeNode defaultMutableTreeNode) {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.experiment = experiment;
        this.listener = new Listener();
        this.addMouseListener(this.listener);
        this.node = defaultMutableTreeNode;
        nArray = nArray == null ? this.createDefaultFeatures(experiment) : nArray;
        this.expViewer = this.createExperimentViewer(experiment, nArray, hCLTreeData, hCLTreeData2);
        this.expViewer.getContentComponent().addMouseListener(this.listener);
        this.header = new HCLExperimentHeader(this.expViewer.getHeaderComponent());
        this.header.addMouseListener(this.listener);
        this.colorBar = new HCLColorBar(this.clusters, nArray.length);
        this.colorBar.addMouseListener(this.listener);
        this.genesOrder = this.createGenesOrder(experiment, nArray, hCLTreeData);
        this.annotationBar = new HCLAnnotationBar(this.genesOrder);
        this.annotationBar.addMouseListener(this.listener);
        if (hCLTreeData != null && experiment.getNumberOfGenes() > 1 && hCLTreeData.node_order.length > 1) {
            this.genesTree = new HCLTree(hCLTreeData, 0);
            this.genesTree.addMouseListener(this.listener);
            this.genesTree.setListener(this.listener);
        }
        if (hCLTreeData2 != null && experiment.getNumberOfSamples() > 1 && hCLTreeData2.node_order.length > 1) {
            this.sampleTree = new HCLTree(hCLTreeData2, 1);
            this.samplesOrder = this.createSamplesOrder(hCLTreeData2);
            if (hCLTreeData == null) {
                this.sampleTree.setHorizontalOffset(10);
            }
            this.sampleTree.addMouseListener(this.listener);
            this.sampleTree.setListener(this.listener);
        }
        this.isExperimentCluster = false;
        this.numberOfSamples = experiment.getNumberOfSamples();
        this.addComponents(this.sampleTree, this.genesTree, this.expViewer.getContentComponent(), this.colorBar, this.annotationBar);
        this.popup = this.createJPopupMenu(this.listener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.expViewer);
        objectOutputStream.writeObject(this.header);
        objectOutputStream.writeBoolean(this.genesTree != null);
        if (this.genesTree != null) {
            objectOutputStream.writeObject(this.genesTree);
            objectOutputStream.writeObject(this.genesOrder);
        }
        objectOutputStream.writeBoolean(this.sampleTree != null);
        if (this.sampleTree != null) {
            objectOutputStream.writeObject(this.sampleTree);
            objectOutputStream.writeObject(this.samplesOrder);
        }
        objectOutputStream.writeObject(this.colorBar);
        objectOutputStream.writeObject(this.annotationBar);
        objectOutputStream.writeObject(this.experiment);
        objectOutputStream.writeObject(this.clusters);
        objectOutputStream.writeObject(this.experimentClusters);
        objectOutputStream.writeObject(this.sampleClusters);
        objectOutputStream.writeBoolean(this.isExperimentCluster);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.expViewer = (IViewer)objectInputStream.readObject();
        this.header = (HCLExperimentHeader)objectInputStream.readObject();
        this.listener = new Listener();
        this.addMouseListener(this.listener);
        this.header.addMouseListener(this.listener);
        if (objectInputStream.readBoolean()) {
            this.genesTree = (HCLTree)objectInputStream.readObject();
            this.genesOrder = (int[])objectInputStream.readObject();
            this.genesTree.addMouseListener(this.listener);
            this.genesTree.setListener(this.listener);
            this.genesTree.deselectAllNodes();
        }
        if (objectInputStream.readBoolean()) {
            this.sampleTree = (HCLTree)objectInputStream.readObject();
            this.samplesOrder = (int[])objectInputStream.readObject();
            this.sampleTree.addMouseListener(this.listener);
            this.sampleTree.setListener(this.listener);
            this.sampleTree.deselectAllNodes();
        }
        this.colorBar = (HCLColorBar)objectInputStream.readObject();
        this.annotationBar = (HCLAnnotationBar)objectInputStream.readObject();
        this.experiment = (Experiment)objectInputStream.readObject();
        this.clusters = (ArrayList)objectInputStream.readObject();
        this.experimentClusters = (ArrayList)objectInputStream.readObject();
        this.sampleClusters = (int[][])objectInputStream.readObject();
        this.isExperimentCluster = objectInputStream.readBoolean();
        this.popup = this.createJPopupMenu(this.listener);
    }

    protected void addComponents(JComponent jComponent, JComponent jComponent2, JComponent jComponent3, JComponent jComponent4, JComponent jComponent5) {
        int n;
        int n2 = jComponent == null ? 1 : 2;
        int n3 = n = jComponent2 == null ? 3 : 4;
        if (jComponent != null) {
            this.add((Component)jComponent, new GridBagConstraints(n - 3, n2 - 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (jComponent2 != null) {
            this.add((Component)jComponent2, new GridBagConstraints(n - 4, n2 - 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.add((Component)jComponent3, new GridBagConstraints(n - 3, n2 - 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected IViewer createExperimentViewer(Experiment experiment, int[] nArray, HCLTreeData hCLTreeData, HCLTreeData hCLTreeData2) {
        ExperimentViewer experimentViewer;
        int[][] nArray2 = this.createClusters(experiment, nArray, hCLTreeData);
        int[] nArray3 = this.getLeafOrder(hCLTreeData2, null);
        if (hCLTreeData != null) {
            this.offset = 0;
            experimentViewer = new ExperimentViewer(experiment, nArray2, nArray3, true, this.offset);
        } else {
            this.offset = 10;
            experimentViewer = new ExperimentViewer(experiment, nArray2, nArray3, true, this.offset);
        }
        return experimentViewer;
    }

    protected int[] createDefaultFeatures(Experiment experiment) {
        int[] nArray = new int[experiment.getNumberOfGenes()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private int[][] createClusters(Experiment experiment, int[] nArray, HCLTreeData hCLTreeData) {
        int[][] nArray2 = new int[1][nArray.length];
        nArray2[0] = this.createGenesOrder(experiment, nArray, hCLTreeData);
        return nArray2;
    }

    protected int[] createSamplesOrder(HCLTreeData hCLTreeData) {
        return this.createSamplesOrder(hCLTreeData, null);
    }

    protected int[] createSamplesOrder(HCLTreeData hCLTreeData, int[] nArray) {
        return this.getLeafOrder(hCLTreeData, nArray);
    }

    protected int[] createGenesOrder(Experiment experiment, int[] nArray, HCLTreeData hCLTreeData) {
        int[] nArray2 = this.getLeafOrder(hCLTreeData, nArray);
        if (nArray2 == null) {
            nArray2 = nArray;
        }
        return nArray2;
    }

    private int[] getLeafOrder(HCLTreeData hCLTreeData, int[] nArray) {
        if (hCLTreeData == null || hCLTreeData.node_order.length < 2) {
            return null;
        }
        return this.getLeafOrder(hCLTreeData.node_order, hCLTreeData.child_1_array, hCLTreeData.child_2_array, nArray);
    }

    private int[] getLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = new int[nArray.length];
        Arrays.fill(nArray5, -1);
        this.fillLeafOrder(nArray5, nArray2, nArray3, 0, nArray2.length - 2, nArray4);
        return nArray5;
    }

    private int fillLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int[] nArray4) {
        if (nArray2[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray2[n2], nArray4);
        }
        if (nArray3[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray3[n2], nArray4);
        } else {
            nArray[n] = nArray4 == null ? n2 : nArray4[n2];
            ++n;
        }
        return n;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.data = iFramework.getData();
        this.expViewer.onSelected(iFramework);
        Object object = iFramework.getUserObject();
        int n = this.clusterIndex = object != null ? (Integer)object : 0;
        if (this.genesTree != null) {
            this.genesTree.onSelected(iFramework);
        }
        if (this.sampleTree != null) {
            this.sampleTree.onSelected(iFramework);
        }
        this.annotationBar.onSelected(iFramework);
        this.colorBar.onSelected(iFramework);
        if (this.genesTree != null) {
            this.header.setHeaderPosition(this.genesTree.getWidth());
        }
        this.elementSize = iFramework.getDisplayMenu().getElementSize();
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
        if (this.node == null) {
            this.node = (DefaultMutableTreeNode)iFramework.getCurrentNode().getParent();
        }
        this.verifyClusterExistence(this.data);
        this.updateTrees();
        this.refreshViewer();
    }

    protected int getCommonWidth() {
        int n = 0;
        if (this.genesTree != null) {
            n += this.genesTree.getWidth();
        }
        n = this.isExperimentCluster ? (n += ((ExperimentClusterViewer)this.expViewer).getWidth()) : (n += ((ExperimentViewer)this.expViewer).getWidth());
        n += this.colorBar.getWidth();
        return (n += this.annotationBar.getWidth()) + this.offset;
    }

    public void onDataChanged(IData iData) {
        this.expViewer.onDataChanged(iData);
        this.data = iData;
        this.updateTrees();
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.expViewer.onMenuChanged(iDisplayMenu);
        if (this.genesTree != null) {
            this.genesTree.onMenuChanged(iDisplayMenu);
        }
        if (this.sampleTree != null) {
            this.sampleTree.onMenuChanged(iDisplayMenu);
        }
        this.annotationBar.onMenuChanged(iDisplayMenu);
        this.colorBar.onMenuChanged(iDisplayMenu);
        this.elementSize = iDisplayMenu.getElementSize();
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    public BufferedImage getImage() {
        return null;
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    protected void addMenuItems(JPopupMenu jPopupMenu, Listener listener) {
        JMenuItem jMenuItem = new JMenuItem("Store Cluster", GUIFactory.getIcon("new16.gif"));
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(STORE_CLUSTER_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("launch_new_mav.gif"));
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save_as16.gif"));
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(SAVE_CLUSTER_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete cluster", GUIFactory.getIcon("delete16.gif"));
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(DELETE_CLUSTER_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete all clusters", GUIFactory.getIcon("delete16.gif"));
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(DELETE_ALL_CLUSTERS_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("GeneTree properties...", GUIFactory.getIcon("edit16.gif"));
        jMenuItem.setEnabled(this.genesTree != null);
        jMenuItem.setActionCommand(GENE_TREE_PROPERTIES_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("SampleTree properties...", GUIFactory.getIcon("edit16.gif"));
        jMenuItem.setEnabled(this.sampleTree != null);
        jMenuItem.setActionCommand(SAMPLE_TREE_PROPERTIES_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Save Gene Node Heights", GUIFactory.getIcon("save_as16.gif"));
        jMenuItem.setEnabled(this.genesTree != null);
        jMenuItem.setActionCommand(SAVE_GENE_HEIGHT_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save Gene Order", GUIFactory.getIcon("save_as16.gif"));
        jMenuItem.setEnabled(this.genesTree != null);
        jMenuItem.setActionCommand(SAVE_GENE_ORDER_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save Sample Node Heights", GUIFactory.getIcon("save_as16.gif"));
        jMenuItem.setEnabled(this.sampleTree != null);
        jMenuItem.setActionCommand(SAVE_EXP_HEIGHT_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save Sample Order", GUIFactory.getIcon("save_as16.gif"));
        jMenuItem.setEnabled(this.sampleTree != null);
        jMenuItem.setActionCommand(SAVE_EXP_ORDER_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        if (this.genesTree != null) {
            jMenuItem = new JMenuItem("Save Gene Tree To Newick File", GUIFactory.getIcon("save_as16.gif"));
            jMenuItem.setActionCommand(SAVE_GENE_NEWICK_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
        }
        if (this.sampleTree != null) {
            jMenuItem = new JMenuItem("Save Sample Tree to Newick File", GUIFactory.getIcon("save_as16.gif"));
            jMenuItem.setActionCommand(SAVE_SAMPLE_NEWICK_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
        }
    }

    protected JMenuItem getJMenuItem(String string) {
        Component[] componentArray = this.popup.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JMenuItem) || !((JMenuItem)componentArray[i]).getActionCommand().equals(string)) continue;
            return (JMenuItem)componentArray[i];
        }
        return null;
    }

    protected void setEnableMenuItem(String string, boolean bl) {
        JMenuItem jMenuItem = this.getJMenuItem(string);
        if (jMenuItem == null) {
            return;
        }
        jMenuItem.setEnabled(bl);
    }

    protected void setSelectedCluster(HCLCluster hCLCluster) {
        this.selectedCluster = hCLCluster;
        if (this.isExperimentCluster) {
            if (hCLCluster.isGeneCluster) {
                ((ExperimentClusterViewer)this.expViewer).selectRows(hCLCluster.firstElem, hCLCluster.lastElem);
            } else {
                ((ExperimentClusterViewer)this.expViewer).selectColumns(hCLCluster.firstElem, hCLCluster.lastElem);
            }
        } else if (hCLCluster.isGeneCluster) {
            ((ExperimentViewer)this.expViewer).selectRows(hCLCluster.firstElem, hCLCluster.lastElem);
        } else {
            ((ExperimentViewer)this.expViewer).selectColumns(hCLCluster.firstElem, hCLCluster.lastElem);
        }
    }

    protected HCLCluster getCluster(HCLCluster hCLCluster) {
        int n = hCLCluster.root;
        if (hCLCluster.isGeneCluster) {
            for (int i = 0; i < this.clusters.size(); ++i) {
                HCLCluster hCLCluster2 = (HCLCluster)this.clusters.get(i);
                if (hCLCluster2.root != n) continue;
                return hCLCluster2;
            }
        } else {
            for (int i = 0; i < this.experimentClusters.size(); ++i) {
                HCLCluster hCLCluster3 = (HCLCluster)this.experimentClusters.get(i);
                if (hCLCluster3.root != n) continue;
                return hCLCluster3;
            }
        }
        return null;
    }

    public void updateTrees() {
        if (this.genesTree != null && this.data.getColors().length == 0) {
            this.genesTree.deselectAllNodes();
            this.genesTree.resetNodeColors();
            this.clusters.clear();
        }
        if (this.sampleTree != null && this.data.getExperimentColors().length == 0) {
            this.sampleTree.deselectAllNodes();
            this.sampleTree.resetNodeColors();
            this.experimentClusters.clear();
        }
    }

    protected HCLCluster getExperimentCluster(int n) {
        for (int i = 0; i < this.experimentClusters.size(); ++i) {
            HCLCluster hCLCluster = (HCLCluster)this.experimentClusters.get(i);
            if (hCLCluster.root != n) continue;
            return hCLCluster;
        }
        return null;
    }

    protected void removeCluster(HCLCluster hCLCluster) {
        if (hCLCluster.isGeneCluster) {
            int n = this.clusters.size();
            while (--n >= 0) {
                HCLCluster hCLCluster2 = (HCLCluster)this.clusters.get(n);
                if (hCLCluster2.root != hCLCluster.root) continue;
                this.clusters.remove(n);
                return;
            }
        } else {
            int n = this.experimentClusters.size();
            while (--n >= 0) {
                HCLCluster hCLCluster3 = (HCLCluster)this.experimentClusters.get(n);
                if (hCLCluster3.root != hCLCluster.root) continue;
                this.experimentClusters.remove(n);
                return;
            }
        }
    }

    protected boolean doesClusterExist() {
        if (this.selectedCluster == null) {
            return false;
        }
        return this.getCluster(this.selectedCluster) != null;
    }

    protected int getClustersCount() {
        return this.clusters.size() + this.experimentClusters.size();
    }

    private Frame getFrame() {
        return JOptionPane.getFrameForComponent(this);
    }

    public void onSetCluster() {
        Color color = Color.white;
        if (color == null || this.selectedCluster == null) {
            return;
        }
        HCLCluster hCLCluster = this.getCluster(this.selectedCluster);
        boolean bl = true;
        if (hCLCluster != null) {
            this.selectedCluster = hCLCluster;
            bl = false;
        } else if (this.selectedCluster.isGeneCluster) {
            this.clusters.add(this.selectedCluster);
        } else {
            this.experimentClusters.add(this.selectedCluster);
        }
        this.selectedCluster.color = color;
        this.selectedCluster.color = !this.isExperimentCluster ? (!this.selectedCluster.isGeneCluster ? ((ExperimentViewer)this.expViewer).setHCLClusterColor(this.getSubTreeElements(), this.selectedCluster.color, this.selectedCluster.isGeneCluster) : ((ExperimentViewer)this.expViewer).setHCLClusterColor(this.getArrayMappedToData(this.getSubTreeElements()), this.selectedCluster.color, this.selectedCluster.isGeneCluster)) : (!this.selectedCluster.isGeneCluster ? ((ExperimentClusterViewer)this.expViewer).setHCLClusterColor(this.getSubTreeElements(), this.selectedCluster.color, this.selectedCluster.isGeneCluster) : ((ExperimentClusterViewer)this.expViewer).setHCLClusterColor(this.getArrayMappedToData(this.getSubTreeElements()), this.selectedCluster.color, this.selectedCluster.isGeneCluster));
        this.removeSubTreeClusters(this.selectedCluster);
        if (this.selectedCluster.isGeneCluster) {
            this.colorBar.onClustersChanged(this.clusters);
        }
        this.refreshViewer();
        this.onDataChanged(this.data);
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
        this.revalidate();
    }

    private void removeSubTreeClusters(HCLCluster hCLCluster) {
        if (hCLCluster.isGeneCluster) {
            for (int i = this.clusters.size() - 1; i >= 0; --i) {
                HCLCluster hCLCluster2 = (HCLCluster)this.clusters.get(i);
                if (hCLCluster.equals(hCLCluster2) || !this.isSubTree(hCLCluster, hCLCluster2)) continue;
                this.removeCluster(hCLCluster2);
            }
        } else {
            for (int i = 0; i < this.experimentClusters.size(); ++i) {
                HCLCluster hCLCluster3 = (HCLCluster)this.experimentClusters.get(i);
                if (hCLCluster == hCLCluster3 || !this.isSubTree(hCLCluster, hCLCluster3)) continue;
                this.removeCluster(hCLCluster3);
            }
        }
    }

    private boolean isSubTree(HCLCluster hCLCluster, HCLCluster hCLCluster2) {
        if (hCLCluster.size < hCLCluster2.size) {
            return false;
        }
        return hCLCluster2.firstElem >= hCLCluster.firstElem && hCLCluster2.firstElem < hCLCluster.lastElem;
    }

    public void onSetClusterText() {
        HCLCluster hCLCluster = this.getCluster(this.selectedCluster);
        if (hCLCluster == null) {
            JOptionPane.showMessageDialog(this.getFrame(), "Not a cluster!", "Error", 0);
        } else {
            String string = JOptionPane.showInputDialog(this.getFrame(), (Object)"Cluster text");
            if (string != null && string.length() > 0) {
                hCLCluster.text = string;
                this.colorBar.onClustersChanged(this.clusters);
                this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
                this.revalidate();
            }
        }
    }

    public void verifyClusterExistence(IData iData) {
        int n;
        HCLCluster hCLCluster;
        int n2;
        boolean[] blArray = new boolean[this.clusters.size()];
        boolean[] blArray2 = new boolean[this.experimentClusters.size()];
        for (n2 = 0; n2 < this.clusters.size(); ++n2) {
            int n3;
            hCLCluster = (HCLCluster)this.clusters.get(n2);
            if (hCLCluster.firstElem == hCLCluster.lastElem || iData.getProbeColor(n3 = this.experiment.getGeneIndexMappedToData(this.genesOrder[hCLCluster.firstElem])) == hCLCluster.color) continue;
            blArray[n2] = true;
        }
        for (n2 = blArray.length - 1; n2 >= 0; --n2) {
            if (!blArray[n2]) continue;
            this.genesTree.setNodeColor(((HCLCluster)this.clusters.get((int)n2)).root, null);
        }
        for (n = 0; n < this.experimentClusters.size(); ++n) {
            hCLCluster = (HCLCluster)this.experimentClusters.get(n);
            if (hCLCluster.firstElem == hCLCluster.lastElem || iData.getExperimentColor(n2 = this.isExperimentCluster ? this.experiment.getSampleIndex(this.sampleClusters[this.clusterIndex][hCLCluster.firstElem]) : this.experiment.getSampleIndex(this.samplesOrder[hCLCluster.firstElem])) == hCLCluster.color) continue;
            blArray2[n] = true;
        }
        for (n = blArray2.length - 1; n >= 0; --n) {
            if (!blArray2[n]) continue;
            this.sampleTree.setNodeColor(((HCLCluster)this.experimentClusters.get((int)n)).root, null);
        }
    }

    private int[] getSubTreeElements() {
        return this.getSubTreeElements(this.selectedCluster);
    }

    private int[] getSubTreeElements(HCLCluster hCLCluster) {
        int n = hCLCluster.lastElem - hCLCluster.firstElem + 1;
        int[] nArray = new int[n];
        if (hCLCluster.isGeneCluster) {
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.genesOrder[hCLCluster.firstElem + i];
            }
        } else if (!this.isExperimentCluster) {
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.samplesOrder[hCLCluster.firstElem + i];
            }
        } else {
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.sampleClusters[this.clusterIndex][hCLCluster.firstElem + i];
            }
        }
        return nArray;
    }

    public void saveGenesOrder() {
        try {
            ExperimentUtil.saveExperiment((Frame)this.getFrame(), (Experiment)this.experiment, (IData)this.data, (int[])this.genesOrder);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.getFrame(), "Can not save data!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    public void saveExperimentOrder() {
        try {
            if (!this.isExperimentCluster) {
                ExperimentUtil.saveExperimentCluster((Frame)this.getFrame(), (Experiment)this.experiment, (IData)this.data, (int[])this.samplesOrder);
            } else {
                int[] nArray = new int[this.sampleClusters[this.clusterIndex].length];
                for (int i = 0; i < this.sampleClusters[this.clusterIndex].length; ++i) {
                    nArray[i] = this.sampleClusters[this.clusterIndex][i];
                }
                ExperimentUtil.saveExperimentCluster((Frame)this.getFrame(), (Experiment)this.experiment, (IData)this.data, (int[])nArray);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.getFrame(), "Can not save data!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    public void onSaveCluster() {
        if (this.selectedCluster == null) {
            return;
        }
        try {
            if (this.selectedCluster.isGeneCluster) {
                ExperimentUtil.saveExperiment((Frame)this.getFrame(), (Experiment)this.experiment, (IData)this.data, (int[])this.getSubTreeElements());
            } else {
                ExperimentUtil.saveExperimentCluster((Frame)this.getFrame(), (Experiment)this.experiment, (IData)this.data, (int[])this.getSubTreeElements());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.getFrame(), "Can not save cluster!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    public void onDeleteCluster() {
        this.removeCluster(this.selectedCluster);
        this.colorBar.onClustersChanged(this.clusters);
        if (this.selectedCluster.isGeneCluster) {
            this.genesTree.setNodeColor(this.selectedCluster.root, null);
            this.data.setProbesColor(this.getArrayMappedToData(this.getSubTreeElements()), null);
            this.framework.removeSubCluster(this.getArrayMappedToData(this.getSubTreeElements()), this.experiment, 0);
            for (int i = 0; i < this.clusters.size(); ++i) {
                HCLCluster hCLCluster = (HCLCluster)this.clusters.get(i);
                this.data.setProbesColor(this.getArrayMappedToData(this.getSubTreeElements(hCLCluster)), hCLCluster.color);
                this.genesTree.setNodeColor(hCLCluster.root, hCLCluster.color);
            }
        } else {
            this.sampleTree.setNodeColor(this.selectedCluster.root, null);
            this.data.setExperimentColor(this.getSubTreeElements(), null);
            this.framework.removeSubCluster(this.getSubTreeElements(), this.experiment, 1);
            for (int i = 0; i < this.experimentClusters.size(); ++i) {
                HCLCluster hCLCluster = (HCLCluster)this.experimentClusters.get(i);
                this.data.setExperimentColor(this.getSubTreeElements(hCLCluster), hCLCluster.color);
                this.sampleTree.setNodeColor(hCLCluster.root, hCLCluster.color);
            }
        }
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
        this.onDataChanged(this.data);
        this.refreshViewer();
        this.revalidate();
    }

    private void refreshViewer() {
        if (this.selectedCluster == null) {
            return;
        }
        if (this.selectedCluster.isGeneCluster) {
            for (int i = 0; i < this.clusters.size(); ++i) {
                HCLCluster hCLCluster = (HCLCluster)this.clusters.get(i);
                this.genesTree.setNodeColor(hCLCluster.root, hCLCluster.color);
                this.genesTree.deselectAllNodes();
            }
        } else {
            for (int i = 0; i < this.experimentClusters.size(); ++i) {
                HCLCluster hCLCluster = (HCLCluster)this.experimentClusters.get(i);
                this.sampleTree.setNodeColor(hCLCluster.root, hCLCluster.color);
                this.sampleTree.deselectAllNodes();
            }
        }
        if (this.isExperimentCluster) {
            ((ExperimentClusterViewer)this.expViewer).selectRows(-1, -1);
            ((ExperimentClusterViewer)this.expViewer).selectColumns(-1, -1);
        } else {
            ((ExperimentViewer)this.expViewer).selectRows(-1, -1);
            ((ExperimentViewer)this.expViewer).selectColumns(-1, -1);
        }
    }

    private int[] getArrayMappedToData(int[] nArray) {
        if (nArray == null || nArray.length < 1) {
            return nArray;
        }
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.experiment.getGeneIndexMappedToData(nArray[i]);
        }
        return nArray2;
    }

    private void createAndAddClusterViews(HCLTree hCLTree) {
        int n = hCLTree.getNumberOfTerminalNodes();
        DefaultMutableTreeNode defaultMutableTreeNode = hCLTree == this.genesTree ? new DefaultMutableTreeNode("Gene Tree Cut: " + String.valueOf(n) + " Clusters") : new DefaultMutableTreeNode("Sample Tree Cut: " + String.valueOf(n) + " Clusters");
        int[][] nArray = hCLTree.getClusterRowIndices();
        if (hCLTree == this.genesTree) {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray[i].length; ++j) {
                    nArray[i][j] = this.genesOrder[nArray[i][j]];
                }
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray[i].length; ++j) {
                    nArray[i][j] = this.samplesOrder[nArray[i][j]];
                }
            }
        }
        this.addExpressionImages(defaultMutableTreeNode, nArray, hCLTree == this.genesTree);
        this.addCentroidViews(defaultMutableTreeNode, nArray, hCLTree == this.genesTree);
        this.addClusterTableViews(defaultMutableTreeNode, nArray, hCLTree == this.genesTree);
        this.addClusterInfo(defaultMutableTreeNode, nArray, hCLTree == this.genesTree, hCLTree.getZeroThreshold());
        this.addGeneralInfo(defaultMutableTreeNode, hCLTree.getZeroThreshold(), n, hCLTree == this.genesTree);
        this.framework.addNode(this.node, defaultMutableTreeNode);
    }

    private void addClusterTableViews(DefaultMutableTreeNode defaultMutableTreeNode, int[][] nArray, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Table Views");
        Object object = bl ? new ClusterTableViewer(this.experiment, nArray, this.data) : new ExperimentClusterTableViewer(this.experiment, nArray, this.data);
        for (int i = 0; i < nArray.length; ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)object, (Object)new Integer(i))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode, int[][] nArray, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        Object object = bl ? new HCLExperimentViewer(this.experiment, nArray) : new HCLExperimentClusterViewer(this.experiment, nArray);
        for (int i = 0; i < nArray.length; ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)object, (Object)new Integer(i))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode, int[][] nArray, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        FloatMatrix floatMatrix = this.experiment.getMatrix();
        if (!bl) {
            floatMatrix = floatMatrix.transpose();
        }
        FloatMatrix floatMatrix2 = this.getMeans(floatMatrix, nArray);
        FloatMatrix floatMatrix3 = this.getVariances(floatMatrix, floatMatrix2, nArray);
        if (bl) {
            HCLCentroidViewer hCLCentroidViewer = new HCLCentroidViewer(this.experiment, nArray);
            hCLCentroidViewer.setMeans(floatMatrix2.A);
            hCLCentroidViewer.setVariances(floatMatrix3.A);
            for (int i = 0; i < nArray.length; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)hCLCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)hCLCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            HCLCentroidsViewer hCLCentroidsViewer = new HCLCentroidsViewer(this.experiment, nArray);
            hCLCentroidsViewer.setMeans(floatMatrix2.A);
            hCLCentroidsViewer.setVariances(floatMatrix3.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)hCLCentroidsViewer, (Object)new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)hCLCentroidsViewer, (Object)new Integer(1))));
        } else {
            HCLExperimentCentroidViewer hCLExperimentCentroidViewer = new HCLExperimentCentroidViewer(this.experiment, nArray);
            hCLExperimentCentroidViewer.setMeans(floatMatrix2.A);
            hCLExperimentCentroidViewer.setVariances(floatMatrix3.A);
            for (int i = 0; i < nArray.length; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)hCLExperimentCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)hCLExperimentCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            HCLExperimentCentroidsViewer hCLExperimentCentroidsViewer = new HCLExperimentCentroidsViewer(this.experiment, nArray);
            hCLExperimentCentroidsViewer.setMeans(floatMatrix2.A);
            hCLExperimentCentroidsViewer.setVariances(floatMatrix3.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)hCLExperimentCentroidsViewer, (Object)new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)hCLExperimentCentroidsViewer, (Object)new Integer(1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private FloatMatrix getMeans(FloatMatrix floatMatrix, int[][] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = this.getMeans(floatMatrix, nArray[i]);
        }
        return floatMatrix2;
    }

    private float[] getMeans(FloatMatrix floatMatrix, int[] nArray) {
        int n = floatMatrix.getColumnDimension();
        float[] fArray = new float[n];
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < n; ++i) {
            f2 = 0.0f;
            f = 0.0f;
            for (int j = 0; j < nArray.length; ++j) {
                float f3 = floatMatrix.get(nArray[j], i);
                if (Float.isNaN(f3)) continue;
                f += f3;
                f2 += 1.0f;
            }
            fArray[i] = f2 > 0.0f ? f / f2 : Float.NaN;
        }
        return fArray;
    }

    private FloatMatrix getVariances(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int[][] nArray) {
        int n = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix3 = new FloatMatrix(nArray.length, n);
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix3.A[i] = this.getVariances(floatMatrix, floatMatrix2, nArray[i], i);
        }
        return floatMatrix3;
    }

    private float[] getVariances(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int[] nArray, int n) {
        int n2 = floatMatrix.getColumnDimension();
        float[] fArray = new float[n2];
        float f = 0.0f;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            float f2 = floatMatrix2.get(n, i);
            n3 = 0;
            f = 0.0f;
            for (int j = 0; j < nArray.length; ++j) {
                float f3 = floatMatrix.get(nArray[j], i);
                if (Float.isNaN(f3)) continue;
                f += (float)Math.pow(f3 - f2, 2.0);
                ++n3;
            }
            fArray[i] = n3 > 1 ? (float)Math.sqrt(f / (float)(n3 - 1)) : 0.0f;
        }
        return fArray;
    }

    private void addClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode, int[][] nArray, boolean bl, float f) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        if (bl) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Clusters (#,%)", (IViewer)new HCLClusterInfoViewer(nArray, this.experiment.getNumberOfGenes(), f))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Sammples in Clusters (#,%)", (IViewer)new HCLClusterInfoViewer(nArray, this.experiment.getNumberOfSamples(), false, f))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, float f, int n, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Info");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Cluster Type: " + (bl ? "Gene Clusters" : "Sample Clusters")));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Distance Threshold: " + String.valueOf(f)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Number of Clusters: " + String.valueOf(n)));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    public void onDeleteAllClusters() {
        this.refreshViewer();
        this.clusters.clear();
        this.experimentClusters.clear();
        this.colorBar.onClustersChanged(this.clusters);
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
        if (this.genesTree != null) {
            this.genesTree.resetNodeColors();
        }
        if (this.sampleTree != null) {
            this.sampleTree.resetNodeColors();
        }
        this.data.deleteColors();
        this.data.deleteExperimentColors();
        this.onDataChanged(this.data);
        this.revalidate();
        this.repaint();
    }

    public void onGeneTreeProperties() {
        this.setTreeProperties(this.genesTree);
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
        this.header.setHeaderPosition(this.genesTree.getWidth());
        this.revalidate();
    }

    public void onSampleTreeProperties() {
        this.setTreeProperties(this.sampleTree);
        this.revalidate();
    }

    private void setTreeProperties(HCLTree hCLTree) {
        Frame frame = JOptionPane.getFrameForComponent(this);
        HCLConfigDialog hCLConfigDialog = new HCLConfigDialog(frame, this, hCLTree.getZeroThreshold(), hCLTree.getMinDistance(), hCLTree.getMaxDistance(), hCLTree.getMinNodeDistance(), hCLTree.getMaxNodeDistance());
        hCLConfigDialog.setTree(hCLTree);
        if (hCLConfigDialog.showModal() == 0) {
            hCLTree.setProperties(hCLConfigDialog.getZeroThreshold(), hCLConfigDialog.getMinDistance(), hCLConfigDialog.getMaxDistance());
            if (hCLConfigDialog.isCreateClusterViews()) {
                this.createAndAddClusterViews(hCLTree);
            }
        }
    }

    public void valueChanged(HCLTree hCLTree, HCLCluster hCLCluster) {
        this.setSelectedCluster(hCLCluster);
    }

    public void revalidateViewer() {
        if (this.genesTree != null) {
            this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
            this.header.setHeaderPosition(this.genesTree.getWidth());
        }
        this.revalidate();
    }

    public void launchNewSession() {
        if (this.selectedCluster == null) {
            return;
        }
        if (this.selectedCluster.isGeneCluster) {
            this.framework.launchNewMAV(this.getArrayMappedToData(this.getSubTreeElements()), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
        } else {
            this.framework.launchNewMAV(this.getSubTreeElements(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
        }
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public int[][] getClusters() {
        int[][] nArrayArray = new int[][]{(int[])(this.genesTree != null ? this.genesOrder : null), (int[])(this.sampleTree != null ? this.samplesOrder : null)};
        return nArrayArray;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public int getViewerType() {
        return -1;
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    HCLTreeListener,
    Serializable {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(HCLViewer.STORE_CLUSTER_CMD)) {
                HCLViewer.this.onSetCluster();
            } else if (string.equals(HCLViewer.LAUNCH_NEW_SESSION_CMD)) {
                HCLViewer.this.launchNewSession();
            }
            if (string.equals(HCLViewer.SAVE_CLUSTER_CMD)) {
                HCLViewer.this.onSaveCluster();
            } else if (string.equals(HCLViewer.DELETE_CLUSTER_CMD)) {
                HCLViewer.this.onDeleteCluster();
            } else if (string.equals(HCLViewer.DELETE_ALL_CLUSTERS_CMD)) {
                HCLViewer.this.onDeleteAllClusters();
            } else if (string.equals(HCLViewer.GENE_TREE_PROPERTIES_CMD)) {
                HCLViewer.this.onGeneTreeProperties();
            } else if (string.equals(HCLViewer.SAMPLE_TREE_PROPERTIES_CMD)) {
                HCLViewer.this.onSampleTreeProperties();
            } else if (string.equals(HCLViewer.SAVE_GENE_ORDER_CMD)) {
                HCLViewer.this.saveGenesOrder();
            } else if (string.equals(HCLViewer.SAVE_GENE_HEIGHT_CMD)) {
                HCLViewer.this.genesTree.saveGeneNodeHeights();
            } else if (string.equals(HCLViewer.SAVE_EXP_ORDER_CMD)) {
                HCLViewer.this.saveExperimentOrder();
            } else if (string.equals(HCLViewer.SAVE_EXP_HEIGHT_CMD)) {
                HCLViewer.this.sampleTree.saveExperimentNodeHeights();
            } else if (string.equals(HCLViewer.SAVE_GENE_NEWICK_CMD)) {
                HCLViewer.this.genesTree.saveAsNewickFile();
            } else if (string.equals(HCLViewer.SAVE_SAMPLE_NEWICK_CMD)) {
                HCLViewer.this.sampleTree.saveAsNewickFile();
            }
        }

        public void valueChanged(HCLTree hCLTree, HCLCluster hCLCluster) {
            if (hCLTree == HCLViewer.this.sampleTree) {
                hCLCluster.isGeneCluster = false;
            }
            HCLViewer.this.valueChanged(hCLTree, hCLCluster);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            this.deselect(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            int n = HCLViewer.this.selectedCluster == null ? -1 : HCLViewer.this.selectedCluster.root;
            HCLViewer.this.setEnableMenuItem(HCLViewer.STORE_CLUSTER_CMD, n >= 0);
            HCLViewer.this.setEnableMenuItem(HCLViewer.LAUNCH_NEW_SESSION_CMD, n >= 0);
            HCLViewer.this.setEnableMenuItem(HCLViewer.DELETE_CLUSTER_CMD, HCLViewer.this.doesClusterExist());
            HCLViewer.this.setEnableMenuItem(HCLViewer.DELETE_ALL_CLUSTERS_CMD, HCLViewer.this.doesClusterExist());
            HCLViewer.this.setEnableMenuItem(HCLViewer.SAVE_CLUSTER_CMD, HCLViewer.this.selectedCluster != null && HCLViewer.this.selectedCluster.root != -1);
            HCLViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        private void deselect(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof HCLTree) {
                if (object == HCLViewer.this.genesTree) {
                    if (HCLViewer.this.isExperimentCluster) {
                        ((ExperimentClusterViewer)HCLViewer.this.expViewer).selectColumns(-1, -1);
                    } else {
                        ((ExperimentViewer)HCLViewer.this.expViewer).selectColumns(-1, -1);
                    }
                    if (HCLViewer.this.sampleTree != null) {
                        HCLViewer.this.sampleTree.deselectAllNodes();
                    }
                } else {
                    if (HCLViewer.this.isExperimentCluster) {
                        ((ExperimentClusterViewer)HCLViewer.this.expViewer).selectRows(-1, -1);
                    } else {
                        ((ExperimentViewer)HCLViewer.this.expViewer).selectRows(-1, -1);
                    }
                    if (HCLViewer.this.genesTree != null) {
                        HCLViewer.this.genesTree.deselectAllNodes();
                    }
                }
                HCLViewer.this.repaint();
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (!(object instanceof HCLViewer) && object != HCLViewer.this.expViewer) {
                this.deselectAllNodes();
                HCLViewer.this.repaint();
            } else if (object instanceof HCLViewer && HCLViewer.this.sampleTree != null && n2 < HCLViewer.this.sampleTree.getHeight()) {
                this.deselectAllNodes();
                HCLViewer.this.repaint();
            } else if (object == HCLViewer.this.expViewer) {
                int n3 = HCLViewer.this.numberOfSamples;
                if (object instanceof ExperimentClusterViewer) {
                    n3 = ((ExperimentClusterViewer)HCLViewer.this.expViewer).getCurrentNumberOfExperiments();
                }
                if (n > HCLViewer.this.elementSize.width * n3 + HCLViewer.this.offset || n < HCLViewer.this.offset) {
                    this.deselectAllNodes();
                    HCLViewer.this.repaint();
                }
            } else if ((object == HCLViewer.this.expViewer || object instanceof ExperimentClusterViewer) && n < HCLViewer.this.offset) {
                this.deselectAllNodes();
                HCLViewer.this.repaint();
            }
        }

        private void deselectAllNodes() {
            if (HCLViewer.this.genesTree != null) {
                HCLViewer.this.genesTree.deselectAllNodes();
            }
            if (HCLViewer.this.sampleTree != null) {
                HCLViewer.this.sampleTree.deselectAllNodes();
            }
            if (HCLViewer.this.isExperimentCluster) {
                ((ExperimentClusterViewer)HCLViewer.this.expViewer).selectRows(-1, -1);
                ((ExperimentClusterViewer)HCLViewer.this.expViewer).selectColumns(-1, -1);
            } else {
                ((ExperimentViewer)HCLViewer.this.expViewer).selectRows(-1, -1);
                ((ExperimentViewer)HCLViewer.this.expViewer).selectColumns(-1, -1);
            }
        }
    }
}

