/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.hcl;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLCluster;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeListener;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.NewickFileOutputDialog;

public class HCLTree
extends JPanel
implements Serializable {
    public static final long serialVersionUID = 202006060001L;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    protected HCLTreeListener treeListener;
    protected int orientation = 0;
    protected int min_pixels = 2;
    protected int max_pixels = 10;
    protected float zero_threshold = 0.05f;
    protected Color lineColor = new Color(0, 0, 128);
    protected Color belowThrColor = Color.lightGray;
    protected Color selectedLineColor = Color.magenta;
    protected IData data;
    protected HCLTreeData treeData;
    protected float minHeight;
    protected int stepSize;
    protected int[] pHeights;
    protected float[] positions;
    protected boolean[] selected;
    protected Color[] nodesColors;
    protected final int xOrigin = 10;
    protected int[] parentNodes;
    protected boolean[] terminalNodes;
    protected float maxHeight;
    protected boolean flatTree = false;
    protected int horizontalOffset = 0;
    protected IFramework framework;

    public HCLTree(HCLTreeData hCLTreeData, int n) {
        this.setBackground(Color.white);
        this.treeData = hCLTreeData;
        this.orientation = n;
        this.flatTree = this.flatTreeCheck(hCLTreeData.height);
        this.minHeight = this.getMinHeight(hCLTreeData.node_order, hCLTreeData.height);
        this.maxHeight = this.getMaxHeight(this.treeData.node_order, hCLTreeData.height);
        this.zero_threshold = this.minHeight;
        this.terminalNodes = new boolean[this.treeData.height.length];
        this.pHeights = this.getPixelHeights(hCLTreeData.node_order, hCLTreeData.height);
        this.positions = this.getPositions(hCLTreeData.node_order, hCLTreeData.child_1_array, hCLTreeData.child_2_array);
        this.selected = new boolean[hCLTreeData.node_order.length * 2];
        this.nodesColors = new Color[hCLTreeData.node_order.length * 2];
        this.deselect(this.selected);
        if (hCLTreeData.node_order.length >= 1 && !this.flatTree) {
            switch (this.orientation) {
                case 0: {
                    this.setSizes(this.pHeights[hCLTreeData.node_order[hCLTreeData.node_order.length - 2]] + 10, 0);
                    break;
                }
                case 1: {
                    this.setSizes(0, this.pHeights[hCLTreeData.node_order[hCLTreeData.node_order.length - 2]]);
                }
            }
        } else {
            this.setSizes(0, 0);
        }
        this.initializeParentNodeArray();
        this.addMouseListener(new Listener());
    }

    private HCLTree() {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.orientation);
        objectOutputStream.writeInt(this.min_pixels);
        objectOutputStream.writeInt(this.max_pixels);
        objectOutputStream.writeFloat(this.zero_threshold);
        objectOutputStream.writeObject(this.lineColor);
        objectOutputStream.writeObject(this.belowThrColor);
        objectOutputStream.writeObject(this.selectedLineColor);
        objectOutputStream.writeObject(this.treeData);
        objectOutputStream.writeFloat(this.minHeight);
        objectOutputStream.writeInt(this.stepSize);
        objectOutputStream.writeObject(this.pHeights);
        objectOutputStream.writeObject(this.positions);
        objectOutputStream.writeObject(this.selected);
        objectOutputStream.writeObject(this.nodesColors);
        objectOutputStream.writeObject(this.parentNodes);
        objectOutputStream.writeObject(this.terminalNodes);
        objectOutputStream.writeFloat(this.maxHeight);
        objectOutputStream.writeBoolean(this.flatTree);
        objectOutputStream.writeInt(this.horizontalOffset);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.orientation = objectInputStream.readInt();
        this.min_pixels = objectInputStream.readInt();
        this.max_pixels = objectInputStream.readInt();
        this.zero_threshold = objectInputStream.readFloat();
        this.lineColor = (Color)objectInputStream.readObject();
        this.belowThrColor = (Color)objectInputStream.readObject();
        this.selectedLineColor = (Color)objectInputStream.readObject();
        this.treeData = (HCLTreeData)objectInputStream.readObject();
        this.minHeight = objectInputStream.readFloat();
        this.stepSize = objectInputStream.readInt();
        this.pHeights = (int[])objectInputStream.readObject();
        this.positions = (float[])objectInputStream.readObject();
        this.selected = (boolean[])objectInputStream.readObject();
        this.nodesColors = (Color[])objectInputStream.readObject();
        this.parentNodes = (int[])objectInputStream.readObject();
        this.terminalNodes = (boolean[])objectInputStream.readObject();
        this.maxHeight = objectInputStream.readFloat();
        this.flatTree = objectInputStream.readBoolean();
        this.horizontalOffset = objectInputStream.readInt();
        this.addMouseListener(new Listener());
    }

    public void setListener(HCLTreeListener hCLTreeListener) {
        this.treeListener = hCLTreeListener;
    }

    private void initializeParentNodeArray() {
        this.parentNodes = new int[this.treeData.height.length];
        for (int i = 0; i < this.treeData.node_order.length; ++i) {
            if (this.treeData.node_order[i] == -1) continue;
            this.parentNodes[this.treeData.node_order[i]] = this.findParent(i);
        }
    }

    private int findParent(int n) {
        int n2;
        int n3 = this.treeData.node_order[n];
        for (n2 = 0; n2 < this.treeData.child_1_array.length; ++n2) {
            if (this.treeData.child_1_array[n2] != n3) continue;
            return n2;
        }
        for (n2 = 0; n2 < this.treeData.child_2_array.length; ++n2) {
            if (this.treeData.child_2_array[n2] != n3) continue;
            return n2;
        }
        return 0;
    }

    public void setProperties(float f, int n, int n2) {
        this.zero_threshold = f;
        this.min_pixels = n;
        this.max_pixels = n2;
        this.pHeights = this.getPixelHeights(this.treeData.node_order, this.treeData.height);
        if (this.treeData.node_order.length > 1) {
            switch (this.orientation) {
                case 0: {
                    this.setSizes(this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]] + 10, this.getHeight());
                    break;
                }
                case 1: {
                    this.setSizes(this.getWidth(), this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]]);
                }
            }
        }
    }

    public void setZeroThreshold(float f) {
        this.zero_threshold = f;
    }

    public int[][] getClusterRowIndices() {
        int n;
        int n2 = this.getNumberOfTerminalNodes();
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.terminalNodes.length; ++n) {
            if (!this.terminalNodes[n]) continue;
            ++n4;
        }
        int[] nArray = new int[n4];
        n = 0;
        for (int i = 0; i < this.terminalNodes.length; ++i) {
            if (!this.terminalNodes[i]) continue;
            nArray[n] = i;
            ++n;
        }
        int[][] nArrayArray = new int[nArray.length][];
        for (int i = 0; i < nArrayArray.length; ++i) {
            int[] nArray2;
            n3 = nArray[i];
            if (n3 >= this.treeData.node_order.length) {
                nArray2 = this.getSubTreeEndPointElements(n3);
            } else {
                nArray2 = new int[2];
                nArray2[1] = (int)this.positions[n3];
                nArray2[0] = (int)this.positions[n3];
            }
            int[] nArray3 = new int[nArray2[1] - nArray2[0] + 1];
            for (int j = 0; j < nArray3.length; ++j) {
                nArray3[j] = nArray2[0] + j;
            }
            nArrayArray[i] = nArray3;
        }
        return nArrayArray;
    }

    public void setPixelHeightLimits(int n, int n2) {
        this.min_pixels = n;
        this.max_pixels = n2;
        this.pHeights = this.getPixelHeights(this.treeData.node_order, this.treeData.height);
        if (this.treeData.node_order.length > 1) {
            switch (this.orientation) {
                case 0: {
                    this.setSizes(this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]] + 10, this.getHeight());
                    break;
                }
                case 1: {
                    this.setSizes(this.getWidth(), this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]]);
                }
            }
        }
    }

    public void setHorizontalOffset(int n) {
        this.horizontalOffset = n;
    }

    private float findMinDistance() {
        float f = Float.POSITIVE_INFINITY;
        for (int i = 0; i < this.treeData.height.length; ++i) {
            f = Math.min(f, this.treeData.height[i]);
        }
        return f;
    }

    public void setNodeColor(int n, Color color) {
        this.setSubTreeColor(n, color);
        this.repaint();
    }

    private void setSubTreeColor(int n, Color color) {
        this.nodesColors[n] = color;
        if (this.treeData.child_1_array[n] != -1) {
            this.setNodeColor(this.treeData.child_1_array[n], color);
        }
        if (this.treeData.child_2_array[n] != -1) {
            this.setNodeColor(this.treeData.child_2_array[n], color);
        }
    }

    public void resetNodeColors() {
        int n = this.nodesColors.length;
        while (--n >= 0) {
            this.nodesColors[n] = null;
        }
        this.repaint();
    }

    public float getZeroThreshold() {
        return this.zero_threshold;
    }

    public int getMinDistance() {
        return this.min_pixels;
    }

    public int getMaxDistance() {
        return this.max_pixels;
    }

    public float getMinNodeDistance() {
        return this.minHeight;
    }

    public float getMaxNodeDistance() {
        return this.maxHeight;
    }

    public int getNumberOfTerminalNodes() {
        int n = 0;
        int n2 = 0;
        float[] fArray = this.treeData.height;
        int[] nArray = this.treeData.node_order;
        for (int i = 0; i < nArray.length; ++i) {
            n2 = nArray[i];
            if (n2 == -1 || fArray[n2] < this.zero_threshold) continue;
            ++n;
        }
        return n + 1;
    }

    public boolean[] getTerminalNodes() {
        return this.terminalNodes;
    }

    private float getMinHeight(int[] nArray, float[] fArray) {
        float f = Float.MAX_VALUE;
        for (int i = 0; i < nArray.length - 1; ++i) {
            f = Math.min(f, fArray[nArray[i]]);
        }
        return f;
    }

    private boolean flatTreeCheck(float[] fArray) {
        if (fArray.length == 1) {
            return false;
        }
        for (int i = 0; i < fArray.length - 1; ++i) {
            if (fArray[i] == fArray[i + 1]) continue;
            return false;
        }
        return true;
    }

    private float getMaxHeight(int[] nArray, float[] fArray) {
        float f = Float.MIN_VALUE;
        for (int i = 0; i < nArray.length - 1; ++i) {
            f = Math.max(f, fArray[nArray[i]]);
        }
        return f;
    }

    private void deselect(boolean[] blArray) {
        int n = blArray.length;
        while (--n >= 0) {
            blArray[n] = false;
        }
    }

    public void deselectAllNodes() {
        this.deselect(this.selected);
    }

    private void clear(int[] nArray) {
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = -1;
        }
    }

    private float getScale() {
        return (float)this.max_pixels / this.maxHeight;
    }

    private float[] getPositions(int[] nArray, int[] nArray2, int[] nArray3) {
        float[] fArray = new float[nArray2.length];
        Arrays.fill(fArray, -1.0f);
        if (nArray.length < 2) {
            return fArray;
        }
        this.fillPositions(fArray, nArray2, nArray3, 0, nArray2.length - 2);
        for (int i = 0; i < nArray.length - 1; ++i) {
            int n = nArray[i];
            fArray[n] = (fArray[nArray2[n]] + fArray[nArray3[n]]) / 2.0f;
        }
        return fArray;
    }

    private int fillPositions(float[] fArray, int[] nArray, int[] nArray2, int n, int n2) {
        if (nArray[n2] != -1) {
            n = this.fillPositions(fArray, nArray, nArray2, n, nArray[n2]);
        }
        if (nArray2[n2] != -1) {
            n = this.fillPositions(fArray, nArray, nArray2, n, nArray2[n2]);
        } else {
            fArray[n2] = n;
            ++n;
        }
        return n;
    }

    private float[] shiftHeights(float[] fArray, float f) {
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = fArray[i] - f;
        }
        return fArray;
    }

    private int[] getPixelHeights(int[] nArray, float[] fArray) {
        float f = this.getScale();
        int[] nArray2 = new int[nArray.length * 2];
        for (int i = 0; i < nArray.length - 1; ++i) {
            int n = nArray[i];
            int n2 = this.treeData.child_1_array[n];
            int n3 = this.treeData.child_2_array[n];
            nArray2[n] = Math.max(nArray2[n2], nArray2[n3]) + Math.max(Math.min(Math.round(fArray[n] * f), this.max_pixels), this.min_pixels);
        }
        return nArray2;
    }

    public void paint(Graphics graphics) {
        int n;
        super.paint(graphics);
        if (this.treeData.node_order.length == 1) {
            graphics.setColor(Color.black);
            graphics.drawLine(0, 0, 10, 0);
        }
        for (n = 0; n < this.terminalNodes.length; ++n) {
            this.terminalNodes[n] = false;
        }
        if (this.treeData.node_order.length < 2) {
            return;
        }
        n = 1;
        if (this.orientation == 1) {
            ((Graphics2D)graphics).rotate(-1.5707963267948966);
            n = -1;
        }
        int n2 = this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]];
        for (int i = 0; i < this.treeData.node_order.length - 1; ++i) {
            int n3 = this.treeData.node_order[i];
            int n4 = this.treeData.child_1_array[n3];
            int n5 = this.treeData.child_2_array[n3];
            int n6 = (n2 - this.pHeights[n3]) * n;
            int n7 = (n2 - this.pHeights[n4]) * n;
            int n8 = (int)(this.positions[n4] * (float)this.stepSize) + this.stepSize / 2;
            int n9 = (n2 - this.pHeights[n3]) * n;
            int n10 = (n2 - this.pHeights[n5]) * n;
            int n11 = (int)(this.positions[n5] * (float)this.stepSize) + this.stepSize / 2;
            if (this.nodesColors[n3] == null) {
                if (this.treeData.height[n3] >= this.zero_threshold) {
                    graphics.setColor(this.lineColor);
                    this.terminalNodes[n3] = false;
                    if (this.pHeights[n4] == 0) {
                        this.terminalNodes[n4] = true;
                    }
                    if (this.pHeights[n5] == 0) {
                        this.terminalNodes[n5] = true;
                    }
                } else {
                    graphics.setColor(this.belowThrColor);
                    this.terminalNodes[n3] = false;
                    if (this.treeData.height[this.parentNodes[n3]] >= this.zero_threshold) {
                        this.drawWedge(graphics, n3, n6 + 10, n9 + 10, n8, n11);
                        this.terminalNodes[n3] = true;
                        this.terminalNodes[n4] = false;
                        this.terminalNodes[n5] = false;
                    }
                }
            } else {
                graphics.setColor(this.nodesColors[n3]);
                if (this.treeData.height[n3] >= this.zero_threshold) {
                    this.terminalNodes[n3] = false;
                    if (this.pHeights[n4] == 0) {
                        this.terminalNodes[n4] = true;
                    }
                    if (this.pHeights[n5] == 0) {
                        this.terminalNodes[n5] = true;
                    }
                } else {
                    this.terminalNodes[n3] = false;
                    if (this.treeData.height[this.parentNodes[n3]] > this.zero_threshold) {
                        this.drawWedge(graphics, n3, n6 + 10, n9 + 10, n8, n11);
                        this.terminalNodes[n3] = true;
                        this.terminalNodes[n4] = false;
                        this.terminalNodes[n5] = false;
                    }
                }
            }
            if (this.selected[n3]) {
                graphics.setColor(this.selectedLineColor);
            }
            if (this.orientation == 0) {
                graphics.drawLine(n6 + 10, n8, n7 + 10, n8);
                graphics.drawLine(n9 + 10, n11, n10 + 10, n11);
                graphics.drawLine(n6 + 10, n8, n9 + 10, n11);
                continue;
            }
            graphics.drawLine(n6, n8 + this.horizontalOffset, n7, n8 + this.horizontalOffset);
            graphics.drawLine(n9, n11 + this.horizontalOffset, n10, n11 + this.horizontalOffset);
            graphics.drawLine(n6, n8 + this.horizontalOffset, n9, n11 + this.horizontalOffset);
        }
    }

    public void drawWedge(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        int n6 = n;
        int n7 = n;
        while (this.treeData.child_1_array[n6] != -1) {
            n6 = this.treeData.child_1_array[n6];
        }
        while (this.treeData.child_2_array[n7] != -1) {
            n7 = this.treeData.child_2_array[n7];
        }
        if (this.orientation == 0) {
            nArray2[0] = (n5 - n4) / 2 + n4;
            nArray2[1] = (int)(this.positions[n6] * (float)this.stepSize) + this.stepSize / 2;
            nArray2[2] = (int)(this.positions[n7] * (float)this.stepSize) + this.stepSize / 2;
            nArray[0] = n2;
            nArray[1] = this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]] + 10;
            nArray[2] = this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]] + 10;
        } else {
            nArray2[0] = (n5 - n4) / 2 + n4 + this.horizontalOffset;
            nArray2[1] = (int)(this.positions[n6] * (float)this.stepSize) + this.stepSize / 2 + this.horizontalOffset;
            nArray2[2] = (int)(this.positions[n7] * (float)this.stepSize) + this.stepSize / 2 + this.horizontalOffset;
            nArray[0] = n2 - 10;
            nArray[1] = -1 * this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]];
            nArray[2] = -1 * this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]];
        }
        Color color = graphics.getColor();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
        graphics.setColor(Color.blue);
        graphics.fillPolygon(new Polygon(nArray, nArray2, 3));
        graphics.setColor(color);
        graphics2D.setComposite(composite);
    }

    public void paintSubTree(Graphics graphics) {
        super.paint(graphics);
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.data = iFramework.getData();
        this.updateSize(iFramework.getDisplayMenu().getElementSize());
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.updateSize(iDisplayMenu.getElementSize());
    }

    protected void updateSize(Dimension dimension) {
        switch (this.orientation) {
            case 0: {
                if (this.flatTree || this.stepSize == dimension.height) {
                    return;
                }
                this.stepSize = dimension.height;
                this.setSizes(this.getPreferredSize().width, this.stepSize * this.treeData.node_order.length);
                break;
            }
            case 1: {
                if (this.flatTree || this.stepSize == dimension.width) {
                    return;
                }
                this.stepSize = dimension.width;
                this.setSizes(this.stepSize * this.treeData.node_order.length, this.getPreferredSize().height);
            }
        }
    }

    public void setSizes(int n, int n2) {
        if (this.orientation == 0) {
            this.setSize(n, n2);
            this.setPreferredSize(new Dimension(n, n2));
        } else {
            this.setSize(this.stepSize * this.treeData.node_order.length, n2);
            this.setPreferredSize(new Dimension(this.stepSize * this.treeData.node_order.length, n2));
        }
    }

    private int[] getSubTreeEndPointElements(int n) {
        int[] nArray = new int[]{(int)this.positions[n], (int)this.positions[n]};
        int n2 = n;
        while (this.treeData.child_1_array[n2] != -1) {
            n2 = this.treeData.child_1_array[n2];
        }
        nArray[0] = (int)this.positions[n2];
        n2 = n;
        while (this.treeData.child_2_array[n2] != -1) {
            n2 = this.treeData.child_2_array[n2];
        }
        nArray[1] = (int)this.positions[n2];
        return nArray;
    }

    private void selectNode(int n, int n2) {
        this.deselect(this.selected);
        HCLCluster hCLCluster = new HCLCluster(this.findNode(n, n2), Integer.MAX_VALUE, Integer.MIN_VALUE);
        this.selectNode(hCLCluster, hCLCluster.root);
        this.fireEvent(hCLCluster);
        this.repaint();
    }

    private void selectNode(HCLCluster hCLCluster, int n) {
        if (n == -1) {
            hCLCluster.firstElem = -1;
            hCLCluster.lastElem = -1;
            return;
        }
        this.selected[n] = true;
        if (this.treeData.child_1_array[n] != -1) {
            this.selectNode(hCLCluster, this.treeData.child_1_array[n]);
        } else {
            if (this.positions[n] < (float)hCLCluster.firstElem) {
                hCLCluster.firstElem = (int)this.positions[n];
            }
            if (this.positions[n] > (float)hCLCluster.lastElem) {
                hCLCluster.lastElem = (int)this.positions[n];
            }
            hCLCluster.setFinalSize();
        }
        if (this.treeData.child_2_array[n] != -1) {
            this.selectNode(hCLCluster, this.treeData.child_2_array[n]);
        }
    }

    private int findNode(int n, int n2) {
        if (this.orientation == 0) {
            n -= 10;
        }
        int n3 = this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]];
        block4: for (int i = 0; i < this.treeData.node_order.length - 1; ++i) {
            int n4 = this.treeData.node_order[i];
            int n5 = this.treeData.child_1_array[n4];
            int n6 = this.treeData.child_2_array[n4];
            int n7 = n3 - this.pHeights[n4];
            int n8 = (int)(this.positions[n5] * (float)this.stepSize) + this.stepSize / 2 + this.horizontalOffset;
            int n9 = n3 - this.pHeights[n4];
            int n10 = (int)(this.positions[n6] * (float)this.stepSize) + this.stepSize / 2 + this.horizontalOffset;
            switch (this.orientation) {
                case 0: {
                    if (n8 >= n2 || n10 <= n2 || n <= n7) continue block4;
                    return n4;
                }
                case 1: {
                    if (n8 >= n || n10 <= n || n2 <= n7) continue block4;
                    return n4;
                }
            }
        }
        return -1;
    }

    public void saveGeneNodeHeights() {
        boolean bl = false;
        File file = null;
        JFileChooser jFileChooser = new JFileChooser(TMEV.getFile((String)"data/"));
        int n = jFileChooser.showSaveDialog(new JFrame());
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            for (int i = 0; i < this.treeData.node_order.length - 1; ++i) {
                String string = "Node_" + String.valueOf(i) + "\t";
                int n2 = this.treeData.child_1_array[this.treeData.node_order[i]];
                int n3 = this.treeData.child_2_array[this.treeData.node_order[i]];
                string = n2 < this.treeData.height.length / 2 ? string + "Gene_" + String.valueOf(n2 + 1) + "\t" : string + "Node_" + String.valueOf(n2 - this.treeData.height.length / 2) + "\t";
                string = n3 < this.treeData.height.length / 2 ? string + "Gene_" + String.valueOf(n3 + 1) + "\t" : string + "Node_" + String.valueOf(n3 - this.treeData.height.length / 2) + "\t";
                string = string + String.valueOf(this.treeData.height[this.treeData.node_order[i]]);
                printWriter.println(string);
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Error saving node height file.", "Error", 2);
            iOException.printStackTrace();
        }
    }

    public void saveExperimentNodeHeights() {
        boolean bl = false;
        File file = null;
        JFileChooser jFileChooser = new JFileChooser(TMEV.getFile((String)"data/"));
        int n = jFileChooser.showSaveDialog(new JFrame());
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            for (int i = 0; i < this.treeData.node_order.length - 1; ++i) {
                String string = "Node_" + String.valueOf(i) + "\t";
                int n2 = this.treeData.child_1_array[this.treeData.node_order[i]];
                int n3 = this.treeData.child_2_array[this.treeData.node_order[i]];
                string = n2 < this.treeData.height.length / 2 ? string + "Exp_" + String.valueOf(n2 + 1) + "\t" : string + "Node_" + String.valueOf(n2 - this.treeData.height.length / 2) + "\t";
                string = n3 < this.treeData.height.length / 2 ? string + "Exp_" + String.valueOf(n3 + 1) + "\t" : string + "Node_" + String.valueOf(n3 - this.treeData.height.length / 2) + "\t";
                string = string + String.valueOf(this.treeData.height[this.treeData.node_order[i]]);
                printWriter.println(string);
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Error saving node height file.", "Error", 2);
            iOException.printStackTrace();
        }
    }

    public void saveAsNewickFile() {
        String[] stringArray;
        if (this.orientation == 0) {
            stringArray = this.data.getFieldNames();
        } else {
            Vector vector = this.data.getSampleAnnotationFieldNames();
            stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
        }
        NewickFileOutputDialog newickFileOutputDialog = new NewickFileOutputDialog(this.framework.getFrame(), stringArray, this.orientation);
        if (newickFileOutputDialog.showModal() == 0) {
            String string = this.orientation == 0 ? this.generateNewickStringForGeneTree(newickFileOutputDialog.getAnnotationKey()) : this.generateNewickStringForSampleTree(newickFileOutputDialog.getAnnotationKey());
            this.saveNewickString(string, newickFileOutputDialog.getOutputFile());
        }
    }

    private void saveNewickString(String string, File file) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(string);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Error saving Newick file: " + file.getAbsolutePath() + ".<BR>" + "Please check that file location is valid and permissions are open.", "IO Error Saving Newick File", 0);
        }
    }

    private String generateNewickStringForSampleTree(String string) {
        String string2 = new String("");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string3 = "";
        for (int i = 0; i < this.treeData.node_order.length - 1; ++i) {
            int n = this.treeData.node_order[i];
            int n2 = this.treeData.child_1_array[n];
            int n3 = this.treeData.child_2_array[n];
            float f = this.treeData.height[n2];
            float f2 = this.treeData.height[n3];
            int n4 = this.parentNodes[n];
            if (n2 < this.treeData.height.length / 2) {
                string2 = this.data.getSampleAnnotation(n2, string) + ":" + String.valueOf(this.treeData.height[n] / 2.0f);
                hashtable.put(String.valueOf(n2), string2);
            }
            if (n3 < this.treeData.height.length / 2) {
                string2 = this.data.getSampleAnnotation(n3, string) + ":" + String.valueOf(this.treeData.height[n] / 2.0f);
                hashtable.put(String.valueOf(n3), string2);
            }
            if (!hashtable.containsKey(String.valueOf(n2)) || !hashtable.containsKey(String.valueOf(n3))) continue;
            string2 = "(" + hashtable.get(String.valueOf(n2)) + "," + hashtable.get(String.valueOf(n3)) + "):" + String.valueOf(this.treeData.height[this.parentNodes[n]] / 2.0f);
            hashtable.put(String.valueOf(n), string2);
            hashtable.remove(String.valueOf(n2));
            hashtable.remove(String.valueOf(n3));
        }
        return string2 + ";";
    }

    private String generateNewickStringForGeneTree(String string) {
        String[] stringArray = this.data.getFieldNames();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            n = i;
            break;
        }
        String string2 = new String("");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string3 = "";
        for (int i = 0; i < this.treeData.node_order.length - 1; ++i) {
            int n2 = this.treeData.node_order[i];
            int n3 = this.treeData.child_1_array[n2];
            int n4 = this.treeData.child_2_array[n2];
            float f = this.treeData.height[n3];
            float f2 = this.treeData.height[n4];
            int n5 = this.parentNodes[n2];
            if (n3 < this.treeData.height.length / 2) {
                string2 = this.data.getElementAttribute(n3, n) + ":" + String.valueOf(this.treeData.height[n2] / 2.0f);
                hashtable.put(String.valueOf(n3), string2);
            }
            if (n4 < this.treeData.height.length / 2) {
                string2 = this.data.getElementAttribute(n4, n) + ":" + String.valueOf(this.treeData.height[n2] / 2.0f);
                hashtable.put(String.valueOf(n4), string2);
            }
            if (!hashtable.containsKey(String.valueOf(n3)) || !hashtable.containsKey(String.valueOf(n4))) continue;
            string2 = "(" + hashtable.get(String.valueOf(n3)) + "," + hashtable.get(String.valueOf(n4)) + "):" + String.valueOf(this.treeData.height[this.parentNodes[n2]] / 2.0f);
            hashtable.put(String.valueOf(n2), string2);
            hashtable.remove(String.valueOf(n3));
            hashtable.remove(String.valueOf(n4));
        }
        return string2 + ";";
    }

    private void fireEvent(HCLCluster hCLCluster) {
        if (this.treeListener != null) {
            this.treeListener.valueChanged(this, hCLCluster);
        }
    }

    private class Listener
    extends MouseAdapter {
        private Listener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            HCLTree.this.selectNode(mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

