/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gsh;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.gsh.GSHCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsh.GSHCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsh.GSHExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsh.GSHExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsh.GSHExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsh.GSHExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsh.GSHInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsh.GSHInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class GSHGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private IData data;
    private Experiment experiment;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    private boolean clusterGenes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block12: {
            Object object;
            this.data = iFramework.getData();
            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
            int n = iDistanceMenu.getDistanceFunction();
            if (n == 0) {
                n = 4;
            }
            int n2 = 10;
            int n3 = 20;
            int n4 = 5;
            GSHInitDialog gSHInitDialog = new GSHInitDialog(iFramework.getFrame(), n2, n3, n4);
            if (gSHInitDialog.showModal() != 0) {
                return null;
            }
            n2 = gSHInitDialog.getClusters();
            n3 = gSHInitDialog.getFM();
            n4 = gSHInitDialog.getST();
            this.clusterGenes = gSHInitDialog.isClusterGenesSelected();
            if (n2 < 1) {
                JOptionPane.showMessageDialog(iFramework.getFrame(), "Number of clusters must be greater than 0!", "Error", 0);
                return null;
            }
            if (n3 < 1) {
                JOptionPane.showMessageDialog(iFramework.getFrame(), "Number of faked matrix must be greater than 0!", "Error", 0);
                return null;
            }
            if (n4 < 1) {
                JOptionPane.showMessageDialog(iFramework.getFrame(), "Number of swap must be greater than 0!", "Error", 0);
                return null;
            }
            boolean bl = gSHInitDialog.isHierarchicalTree();
            int n5 = 0;
            boolean bl2 = false;
            boolean bl3 = false;
            int n6 = 4;
            boolean bl4 = false;
            if (bl) {
                object = new HCLInitDialog(iFramework.getFrame(), iDistanceMenu.getFunctionName(iDistanceMenu.getDistanceFunction()), iDistanceMenu.isAbsoluteDistance(), true);
                if (((HCLInitDialog)object).showModal() != 0) {
                    return null;
                }
                n5 = ((HCLInitDialog)object).getMethod();
                bl2 = ((HCLInitDialog)object).isClusterExperiments();
                bl3 = ((HCLInitDialog)object).isClusterGenes();
                n6 = ((HCLInitDialog)object).getDistanceMetric();
                bl4 = ((HCLInitDialog)object).getAbsoluteSelection();
            }
            this.experiment = iFramework.getData().getExperiment();
            object = new Listener();
            try {
                this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("GSH");
                this.algorithm.addAlgorithmListener((AlgorithmListener)object);
                int n7 = this.experiment.getNumberOfGenes();
                AlgorithmData algorithmData = new AlgorithmData();
                FloatMatrix floatMatrix = this.experiment.getMatrix();
                if (!this.clusterGenes) {
                    floatMatrix = floatMatrix.transpose();
                }
                algorithmData.addMatrix("experiment", floatMatrix);
                algorithmData.addParam("distance-factor", String.valueOf(1.0f));
                algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
                algorithmData.addParam("gsh-cluster-genes", String.valueOf(this.clusterGenes));
                algorithmData.addParam("distance-function", String.valueOf(n));
                algorithmData.addParam("number-of-clusters", String.valueOf(n2));
                algorithmData.addParam("number-of-fakedMatrix", String.valueOf(n3));
                algorithmData.addParam("number-of-swap", String.valueOf(n4));
                if (bl) {
                    algorithmData.addParam("hierarchical-tree", String.valueOf(true));
                    algorithmData.addParam("method-linkage", String.valueOf(n5));
                    algorithmData.addParam("calculate-genes", String.valueOf(bl3));
                    algorithmData.addParam("calculate-experiments", String.valueOf(bl2));
                    algorithmData.addParam("hcl-distance-function", String.valueOf(n6));
                    algorithmData.addParam("hcl-distance-absolute", String.valueOf(bl4));
                }
                long l = System.currentTimeMillis();
                AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
                long l2 = System.currentTimeMillis() - l;
                Cluster cluster = algorithmData2.getCluster("cluster");
                NodeList nodeList = cluster.getNodeList();
                AlgorithmParameters algorithmParameters = algorithmData2.getParams();
                n2 = algorithmParameters.getInt("number-of-clusters");
                this.clusters = new int[n2][];
                for (int i = 0; i < n2; ++i) {
                    this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
                }
                this.means = algorithmData2.getMatrix("clusters-means");
                this.variances = algorithmData2.getMatrix("clusters-variances");
                GeneralInfo generalInfo = new GeneralInfo();
                generalInfo.clusters = n2;
                generalInfo.time = l2;
                generalInfo.FM = n3;
                generalInfo.ST = n4;
                generalInfo.function = iDistanceMenu.getFunctionName(n);
                generalInfo.hcl = bl;
                generalInfo.hcl_genes = bl3;
                generalInfo.hcl_samples = bl2;
                generalInfo.hcl_method = n5;
                defaultMutableTreeNode = this.createResultTree(cluster, generalInfo);
                Object var29_27 = null;
                if (this.algorithm == null) break block12;
            }
            catch (Throwable throwable) {
                block13: {
                    Object var29_28 = null;
                    if (this.algorithm == null) break block13;
                    this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
                }
                throw throwable;
            }
            this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
        }
        return defaultMutableTreeNode;
    }

    public AlgorithmData getScriptParameters(IFramework iFramework) {
        Object object;
        GSHInitDialog gSHInitDialog;
        this.data = iFramework.getData();
        int n = 10;
        int n2 = 20;
        int n3 = 5;
        IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
        int n4 = iDistanceMenu.getDistanceFunction();
        if (n4 == 0) {
            n4 = 4;
        }
        if ((gSHInitDialog = new GSHInitDialog(iFramework.getFrame(), n, n2, n3)).showModal() != 0) {
            return null;
        }
        n = gSHInitDialog.getClusters();
        n2 = gSHInitDialog.getFM();
        n3 = gSHInitDialog.getST();
        this.clusterGenes = gSHInitDialog.isClusterGenesSelected();
        if (n < 1) {
            JOptionPane.showMessageDialog(iFramework.getFrame(), "Number of clusters must be greater than 0!", "Error", 0);
            return null;
        }
        if (n2 < 1) {
            JOptionPane.showMessageDialog(iFramework.getFrame(), "Number of faked matrix must be greater than 0!", "Error", 0);
            return null;
        }
        if (n3 < 1) {
            JOptionPane.showMessageDialog(iFramework.getFrame(), "Number of swap must be greater than 0!", "Error", 0);
            return null;
        }
        boolean bl = gSHInitDialog.isHierarchicalTree();
        int n5 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n6 = 4;
        boolean bl4 = false;
        if (bl) {
            object = new HCLInitDialog(iFramework.getFrame(), iDistanceMenu.getFunctionName(iDistanceMenu.getDistanceFunction()), iDistanceMenu.isAbsoluteDistance(), true);
            if (((HCLInitDialog)object).showModal() != 0) {
                return null;
            }
            n5 = ((HCLInitDialog)object).getMethod();
            bl2 = ((HCLInitDialog)object).isClusterExperiments();
            bl3 = ((HCLInitDialog)object).isClusterGenes();
            n6 = ((HCLInitDialog)object).getDistanceMetric();
            bl4 = ((HCLInitDialog)object).getAbsoluteSelection();
        }
        this.experiment = iFramework.getData().getExperiment();
        object = new Listener();
        int n7 = this.experiment.getNumberOfGenes();
        AlgorithmData algorithmData = new AlgorithmData();
        algorithmData.addParam("distance-factor", String.valueOf(1.0f));
        algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
        algorithmData.addParam("gsh-cluster-genes", String.valueOf(this.clusterGenes));
        algorithmData.addParam("distance-function", String.valueOf(n4));
        algorithmData.addParam("number-of-clusters", String.valueOf(n));
        algorithmData.addParam("number-of-fakedMatrix", String.valueOf(n2));
        algorithmData.addParam("number-of-swap", String.valueOf(n3));
        if (bl) {
            algorithmData.addParam("hierarchical-tree", String.valueOf(true));
            algorithmData.addParam("method-linkage", String.valueOf(n5));
            algorithmData.addParam("calculate-genes", String.valueOf(bl3));
            algorithmData.addParam("calculate-experiments", String.valueOf(bl2));
            algorithmData.addParam("hcl-distance-function", String.valueOf(n6));
            algorithmData.addParam("hcl-distance-absolute", String.valueOf(bl4));
        }
        algorithmData.addParam("name", "GSH");
        if (this.clusterGenes) {
            algorithmData.addParam("alg-type", "cluster-genes");
        } else {
            algorithmData.addParam("alg-type", "cluster-experiments");
        }
        if (this.clusterGenes) {
            algorithmData.addParam("output-class", "multi-gene-cluster-output");
        } else {
            algorithmData.addParam("output-class", "multi-experiment-cluster-output");
        }
        String[] stringArray = new String[]{"Multi-cluster"};
        algorithmData.addStringArray("output-nodes", stringArray);
        return algorithmData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework iFramework, AlgorithmData algorithmData, Experiment experiment) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block5: {
            this.data = iFramework.getData();
            this.experiment = experiment;
            this.clusterGenes = algorithmData.getParams().getBoolean("gsh-cluster-genes");
            Listener listener = new Listener();
            try {
                FloatMatrix floatMatrix = experiment.getMatrix();
                if (!this.clusterGenes) {
                    floatMatrix = floatMatrix.transpose();
                }
                algorithmData.addMatrix("experiment", floatMatrix);
                this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("GSH");
                this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
                int n = experiment.getNumberOfGenes();
                long l = System.currentTimeMillis();
                AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
                long l2 = System.currentTimeMillis() - l;
                Cluster cluster = algorithmData2.getCluster("cluster");
                NodeList nodeList = cluster.getNodeList();
                AlgorithmParameters algorithmParameters = algorithmData2.getParams();
                int n2 = algorithmParameters.getInt("number-of-clusters");
                this.clusters = new int[n2][];
                for (int i = 0; i < n2; ++i) {
                    this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
                }
                this.means = algorithmData2.getMatrix("clusters-means");
                this.variances = algorithmData2.getMatrix("clusters-variances");
                AlgorithmParameters algorithmParameters2 = algorithmData.getParams();
                GeneralInfo generalInfo = new GeneralInfo();
                generalInfo.clusters = n2;
                generalInfo.time = l2;
                generalInfo.FM = algorithmParameters2.getInt("number-of-fakedMatrix");
                generalInfo.ST = algorithmParameters2.getInt("number-of-swap");
                int n3 = algorithmParameters2.getInt("distance-function");
                generalInfo.function = iFramework.getDistanceMenu().getFunctionName(n3);
                generalInfo.hcl = algorithmParameters2.getBoolean("hierarchical-tree");
                generalInfo.hcl_genes = algorithmParameters2.getBoolean("calculate-genes");
                generalInfo.hcl_samples = algorithmParameters2.getBoolean("calculate-experiments");
                if (generalInfo.hcl) {
                    generalInfo.hcl_method = algorithmParameters2.getInt("method-linkage");
                }
                defaultMutableTreeNode = this.createResultTree(cluster, generalInfo);
                Object var21_19 = null;
                if (this.algorithm == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var21_20 = null;
                    if (this.algorithm == null) break block6;
                    this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                }
                throw throwable;
            }
            this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode createResultTree(Cluster cluster, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.clusterGenes ? new DefaultMutableTreeNode("GSH - genes") : new DefaultMutableTreeNode("GSH - samples");
        this.addResultNodes(defaultMutableTreeNode, cluster, generalInfo);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        this.addExpressionImages(defaultMutableTreeNode);
        this.addHierarchicalTrees(defaultMutableTreeNode, cluster, generalInfo);
        this.addCentroidViews(defaultMutableTreeNode);
        this.addTableViews(defaultMutableTreeNode);
        this.addClusterInfo(defaultMutableTreeNode);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addTableViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Table views");
        Object object = this.clusterGenes ? new ClusterTableViewer(this.experiment, this.clusters, this.data) : new ExperimentClusterTableViewer(this.experiment, this.clusters, this.data);
        for (n = 0; n < this.clusters.length - 1; ++n) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1), (IViewer)object, (Object)new Integer(n))));
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned ", (IViewer)object, (Object)new Integer(n))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        Object object = this.clusterGenes ? new GSHExperimentViewer(this.experiment, this.clusters) : new GSHExperimentClusterViewer(this.experiment, this.clusters);
        for (n = 0; n < this.clusters.length - 1; ++n) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1), (IViewer)object, (Object)new Integer(n))));
        }
        if (this.clusterGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Genes", (IViewer)object, (Object)new Integer(n))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Experiments", (IViewer)object, (Object)new Integer(n))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        int n;
        if (!generalInfo.hcl) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = cluster.getNodeList();
        Object object = null;
        int n2 = this.clusters.length;
        if (!this.clusterGenes) {
            object = new int[n2][];
            for (n = 0; n < n2; ++n) {
                object[n] = nodeList.getNode(n).getFeaturesIndexes();
            }
            if (generalInfo.hcl_samples) {
                object = this.getOrderedIndices(nodeList, (int[][])object, generalInfo.hcl_genes);
            }
        }
        for (n = 0; n < nodeList.getSize() - 1; ++n) {
            if (this.clusterGenes) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1), this.createHCLViewer(nodeList.getNode(n), generalInfo, null))));
                continue;
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1), this.createHCLViewer(nodeList.getNode(n), generalInfo, (int[][])object), (Object)new Integer(n))));
        }
        if (this.clusterGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Genes", this.createHCLViewer(nodeList.getNode(nodeList.getSize() - 1), generalInfo, null))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Experiments", this.createHCLViewer(nodeList.getNode(nodeList.getSize() - 1), generalInfo, (int[][])object), (Object)new Integer(nodeList.getSize() - 1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private IViewer createHCLViewer(Node node, GeneralInfo generalInfo, int[][] nArray) {
        HCLTreeData hCLTreeData;
        HCLTreeData hCLTreeData2;
        HCLTreeData hCLTreeData3 = hCLTreeData2 = generalInfo.hcl_genes ? this.getResult(node, 0) : null;
        HCLTreeData hCLTreeData4 = generalInfo.hcl_samples ? this.getResult(node, generalInfo.hcl_genes ? 4 : 0) : (hCLTreeData = null);
        if (this.clusterGenes) {
            return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData);
        }
        return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData, nArray, true);
    }

    private HCLTreeData getResult(Node node, int n) {
        HCLTreeData hCLTreeData = new HCLTreeData();
        NodeValueList nodeValueList = node.getValues();
        hCLTreeData.child_1_array = (int[])nodeValueList.getNodeValue((int)n).value;
        hCLTreeData.child_2_array = (int[])nodeValueList.getNodeValue((int)(n + 1)).value;
        hCLTreeData.node_order = (int[])nodeValueList.getNodeValue((int)(n + 2)).value;
        hCLTreeData.height = (float[])nodeValueList.getNodeValue((int)(n + 3)).value;
        return hCLTreeData;
    }

    private void addClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        if (this.clusterGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Clusters (#,%)", (IViewer)new GSHInfoViewer(this.clusters, this.experiment.getNumberOfGenes()))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Samples in Clusters (#,%)", (IViewer)new GSHInfoViewer(this.clusters, this.experiment.getNumberOfSamples(), false))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        if (this.clusterGenes) {
            GSHCentroidViewer gSHCentroidViewer = new GSHCentroidViewer(this.experiment, this.clusters);
            gSHCentroidViewer.setMeans(this.means.A);
            gSHCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length - 1; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)gSHCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)gSHCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Genes ", (IViewer)gSHCentroidViewer, (Object)new CentroidUserObject(this.clusters.length - 1, 0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Genes ", (IViewer)gSHCentroidViewer, (Object)new CentroidUserObject(this.clusters.length - 1, 1))));
            GSHCentroidsViewer gSHCentroidsViewer = new GSHCentroidsViewer(this.experiment, this.clusters);
            gSHCentroidsViewer.setMeans(this.means.A);
            gSHCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)gSHCentroidsViewer, (Object)new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)gSHCentroidsViewer, (Object)new Integer(1))));
        } else {
            GSHExperimentCentroidViewer gSHExperimentCentroidViewer = new GSHExperimentCentroidViewer(this.experiment, this.clusters);
            gSHExperimentCentroidViewer.setMeans(this.means.A);
            gSHExperimentCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length - 1; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)gSHExperimentCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)gSHExperimentCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Experiments", (IViewer)gSHExperimentCentroidViewer, (Object)new CentroidUserObject(this.clusters.length - 1, 0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Experiments", (IViewer)gSHExperimentCentroidViewer, (Object)new CentroidUserObject(this.clusters.length - 1, 1))));
            GSHExperimentCentroidsViewer gSHExperimentCentroidsViewer = new GSHExperimentCentroidsViewer(this.experiment, this.clusters);
            gSHExperimentCentroidsViewer.setMeans(this.means.A);
            gSHExperimentCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)gSHExperimentCentroidsViewer, (Object)new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)gSHExperimentCentroidsViewer, (Object)new Integer(1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Clusters: " + String.valueOf(generalInfo.clusters)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Faked_Matrix: " + String.valueOf(generalInfo.FM)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Swap_Time: " + String.valueOf(generalInfo.ST)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("HCL: " + generalInfo.getMethodName()));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.function));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private int[][] getOrderedIndices(NodeList nodeList, int[][] nArray, boolean bl) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i].length <= 0) continue;
            HCLTreeData hCLTreeData = this.getResult(nodeList.getNode(i), bl ? 4 : 0);
            nArray[i] = this.getSampleOrder(hCLTreeData, nArray[i]);
        }
        return nArray;
    }

    private int[] getSampleOrder(HCLTreeData hCLTreeData, int[] nArray) {
        return this.getLeafOrder(hCLTreeData.node_order, hCLTreeData.child_1_array, hCLTreeData.child_2_array, nArray);
    }

    private int[] getLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = new int[nArray.length];
        Arrays.fill(nArray5, -1);
        this.fillLeafOrder(nArray5, nArray2, nArray3, 0, nArray2.length - 2, nArray4);
        return nArray5;
    }

    private int fillLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int[] nArray4) {
        if (nArray2[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray2[n2], nArray4);
        }
        if (nArray3[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray3[n2], nArray4);
        } else {
            nArray[n] = nArray4 == null ? n2 : nArray4[n2];
            ++n;
        }
        return n;
    }

    private class GeneralInfo {
        public int clusters;
        public long time;
        public String function;
        public int FM;
        public int ST;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            switch (algorithmEvent.getId()) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                GSHGUI.this.algorithm.abort();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            GSHGUI.this.algorithm.abort();
        }
    }
}

