/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMAnnotationSizeDialog;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMBorderColorDialog;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMColorScaleDialog;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMColorSelectionDialog;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMElementSizeDialog;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMGeneHeader;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMGeneSpotInfoDisplay;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMMemberSelectionDialog;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMResultSelectionDialog;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMScaleListener;
import org.tigr.microarray.util.SlideDataSorter;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class GDMGeneViewer
extends JPanel
implements IViewer,
Serializable {
    public static final long serialVersionUID = 202004020001L;
    private JPanel content;
    private GDMGeneHeader geneColumnHeaderSP;
    private GDMGeneHeader geneRowHeaderSP;
    private JScrollBar upperRightCornerSB;
    private JScrollBar lowerLeftCornerSB;
    private FloatMatrix geneDistMatrix;
    private FloatMatrix rawMatrix;
    private IData expData;
    private String[] fieldNames;
    private IFramework framework;
    private JFrame mainframe;
    private static final int TRACE_SPACE = 50;
    private static final int MAX_MATRIX_WIDTH = 400;
    private static final int MAX_COL_WIDTH = 400;
    private static final int MAX_COL_HEIGHT = 500;
    private static final int MAX_ROW_WIDTH = 500;
    private static final int MAX_ROW_HEIGHT = 400;
    private static final int NOT_UPDATE_ANNOTATION_SIZE = -1;
    private int num_genes;
    private int maxGeneNameLength;
    private int probes;
    private int featuresCount;
    private int[] indices;
    private int label;
    private int[] clusterlength;
    private Insets insets;
    private int elementWidth;
    private int paletteStyle;
    private int labelIndex = -1;
    private int maxLabelWidth = 0;
    private boolean isGRScale;
    private boolean isDrawBorders;
    private boolean isDrawClusterBorders = true;
    private boolean isAntiAliasing = true;
    private boolean isTracing = false;
    private int tracespace;
    private int xWidth;
    private int xHeight;
    private Dimension elementSize = new Dimension(10, 10);
    private boolean sortByGeneProximity = true;
    private boolean imposeClusterOrder = false;
    public static Color zeroColor = Color.black;
    public static Color NaNColor = Color.gray;
    public static Color diagColor = Color.white;
    private float maxValue;
    private float minValue;
    private float origMaxValue;
    private float origMinValue;
    private int colorScheme = 5;
    private BufferedImage negGreenColorImage = this.createGradientImage(Color.green, Color.black);
    private BufferedImage posRedColorImage = this.createGradientImage(Color.black, Color.red);
    private BufferedImage negBlueColorImage = this.createGradientImage(Color.blue, Color.black);
    private BufferedImage posYellowColorImage = this.createGradientImage(Color.black, Color.yellow);
    private BufferedImage negCustomColorImage;
    private BufferedImage posCustomColorImage;
    private BufferedImage posColorImage = this.posRedColorImage;
    private BufferedImage negColorImage = this.negGreenColorImage;
    private Color borderColor;
    private Color clusterBorderColor;
    private String distanceMetric;
    private JPopupMenu popup;
    private JCheckBoxMenuItem drawClusterBorderItem;
    private JMenu sortMenu;
    private int displayEvery = 1;
    private Experiment experiment;
    private int[][] clusters;
    private int numOfClusters;
    private Listener listener;
    private HashMap actions = new HashMap();
    private static final String PARAMETER = "command-parameter";
    private static final String BORDER_COLOR_CMD = "select-border-color-cmd";
    private static final String COLOR_SCALE_CMD = "set-color-scale-cmd";
    private static final String GREEN_RED_COLOR_SCHEME_CMD = "display-green-red-scheme-cmd";
    private static final String BLUE_YELLOW_COLOR_SCHEME_CMD = "display-blue-yellow-scheme-cmd";
    private static final String NO_LABEL = "No Label";
    private static final String LABEL_BY = "Label by ";
    private static final String DISPLAY_LABEL_ACTION = "display--label-action";
    private static final String DISPLAY_LABEL_CMD = "display-label-cmd";
    private static final String CUSTOM_COLOR_SCHEME_CMD = "display-custom-color-scheme-cmd";
    private static final String DISPLAY_DRAW_BORDERS_CMD = "display-draw-borders-cmd";
    private static final String DISPLAY_2X2_CMD = "display-2x2-cmd";
    private static final String DISPLAY_5X5_CMD = "display-5x5-cmd";
    private static final String DISPLAY_10X10_CMD = "display-10x10-cmd";
    private static final String DISPLAY_15X15_CMD = "display-15x15-cmd";
    private static final String DISPLAY_OTHER_CMD = "display-other-cmd";
    private static final String SET_CLUSTER_BORDER_CMD = "set-cluster-border-cmd";
    private static final String SORT_BY = "Sort by ";
    private static final String SORT_BY_CLUSTER_ORDER_CMD = "sort-by-cluster-order-cmd";
    private static final String SORT_BY_LOCATION_CMD = "sort-by-location-cmd";
    private static final String SORT_BY_RATIO_CMD = "sort-by-ratio-cmd";
    private static final String SORT_LABEL_ACTION = "sort-label-action";
    private static final String SORT_LABEL_CMD = "sort-label-cmd";
    public static final String SORT_BY_GENE_PROXIMITY_CMD = "sort-by-gene-proximity-cmd";
    private static final String ANNOTATION_WIDTH_ACTION = "annotation-width-action";
    private static final String ANNOTATION_WIDTH_CMD = "annotation-width-cmd";
    private static final String CHANGE_ANNOTATION_WIDTH = "Change Annotation Width";
    private static final String TOGGLE_PROXIMITY_SORT_CMD = "Toggle-proximity-cmd";
    private static final String SAVE_NEIGHBORS_CMD = "Save-neighbors-cmd";

    public GDMGeneViewer(IFramework iFramework, AlgorithmData algorithmData, String string, int n, int[][] nArray, int n2) {
        this.setBackground(Color.white);
        this.framework = iFramework;
        this.distanceMetric = string;
        IDisplayMenu iDisplayMenu = this.framework.getDisplayMenu();
        this.setElementWidth(this.elementSize.width);
        this.expData = iFramework.getData();
        this.fieldNames = this.expData.getFieldNames();
        this.experiment = this.expData.getExperiment();
        this.probes = this.expData.getFeaturesSize();
        this.featuresCount = this.expData.getFeaturesCount();
        this.geneDistMatrix = algorithmData.getMatrix("gdMatrix");
        this.rawMatrix = algorithmData.getMatrix("rawMatrix");
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.minValue = algorithmParameters.getFloat("minDist");
        this.origMaxValue = this.maxValue;
        this.origMinValue = this.minValue;
        this.displayEvery = n;
        this.clusters = nArray;
        this.numOfClusters = n2;
        this.maxValue = algorithmParameters.getFloat("maxDist");
        this.maxGeneNameLength = algorithmParameters.getInt("maxGeneNameLength");
        this.num_genes = this.geneDistMatrix.getRowDimension() / n;
        this.borderColor = Color.black;
        this.clusterBorderColor = Color.white;
        this.insets = new Insets(1, 1, 1, 1);
        this.xWidth = this.getXSize();
        this.xHeight = this.getYSize();
        if (this.displayEvery == 1) {
            this.setIndices(this.createIndices());
        } else if (this.displayEvery > 1) {
            this.setIndices(this.createIndices(this.displayEvery));
        }
        this.listener = new Listener();
        this.addMouseMotionListener(this.listener);
        this.addKeyListener(this.listener);
        this.initLabelActions(this.expData.getFieldNames());
        this.initSortActions(this.expData.getFieldNames());
        this.initAnnotationWidthActions();
        this.geneColumnHeaderSP = this.createHeader(50, true, this.xWidth, 500, this.elementSize, this.experiment);
        this.geneColumnHeaderSP.setBorder(BorderFactory.createLineBorder(Color.white));
        this.geneRowHeaderSP = this.createHeader(50, false, 500, this.xHeight, this.elementSize, this.experiment);
        this.content = this.createContent(400, 400, this.listener);
        this.geneColumnHeaderSP.setMatrixListener(this.listener);
        this.geneRowHeaderSP.setMatrixListener(this.listener);
        this.upperRightCornerSB = this.createScrollBar(1);
        this.lowerLeftCornerSB = this.createScrollBar(0);
        this.setMaxWidth(this.content, this.geneColumnHeaderSP);
        this.setMaxHeight(this.content, this.geneRowHeaderSP);
        this.geneColumnHeaderSP.setPosColorImages(this.posColorImage);
        this.geneRowHeaderSP.setPosColorImages(this.posColorImage);
        this.geneColumnHeaderSP.setIndices(this.indices);
        this.geneRowHeaderSP.setIndices(this.indices);
        this.add(this.content);
        this.popup = this.createJPopupMenu(this.listener);
        this.getContentComponent().addMouseListener(this.listener);
        this.setBackground(Color.white);
        this.setOpaque(true);
    }

    public GDMGeneViewer() {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.distanceMetric);
        objectOutputStream.writeInt(this.elementWidth);
        objectOutputStream.writeObject(this.elementSize);
        objectOutputStream.writeObject(this.experiment);
        objectOutputStream.writeInt(this.probes);
        objectOutputStream.writeInt(this.featuresCount);
        objectOutputStream.writeObject(this.geneDistMatrix);
        objectOutputStream.writeObject(this.rawMatrix);
        objectOutputStream.writeFloat(this.minValue);
        objectOutputStream.writeFloat(this.origMaxValue);
        objectOutputStream.writeFloat(this.origMinValue);
        objectOutputStream.writeInt(this.displayEvery);
        objectOutputStream.writeObject(this.clusters);
        objectOutputStream.writeObject(this.indices);
        objectOutputStream.writeInt(this.numOfClusters);
        objectOutputStream.writeFloat(this.maxValue);
        objectOutputStream.writeInt(this.maxGeneNameLength);
        objectOutputStream.writeInt(this.num_genes);
        objectOutputStream.writeObject(this.borderColor);
        objectOutputStream.writeObject(this.clusterBorderColor);
        objectOutputStream.writeObject(this.insets);
        objectOutputStream.writeInt(this.xWidth);
        objectOutputStream.writeInt(this.xHeight);
        objectOutputStream.writeObject(this.fieldNames);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.distanceMetric = (String)objectInputStream.readObject();
        this.elementWidth = objectInputStream.readInt();
        this.elementSize = (Dimension)objectInputStream.readObject();
        this.setElementWidth(this.elementSize.width);
        this.experiment = (Experiment)objectInputStream.readObject();
        this.probes = objectInputStream.readInt();
        this.featuresCount = objectInputStream.readInt();
        this.geneDistMatrix = (FloatMatrix)objectInputStream.readObject();
        this.rawMatrix = (FloatMatrix)objectInputStream.readObject();
        this.minValue = objectInputStream.readFloat();
        this.origMaxValue = objectInputStream.readFloat();
        this.origMinValue = objectInputStream.readFloat();
        this.displayEvery = objectInputStream.readInt();
        this.clusters = (int[][])objectInputStream.readObject();
        this.indices = (int[])objectInputStream.readObject();
        this.numOfClusters = objectInputStream.readInt();
        this.maxValue = objectInputStream.readFloat();
        this.maxGeneNameLength = objectInputStream.readInt();
        this.num_genes = objectInputStream.readInt();
        this.borderColor = (Color)objectInputStream.readObject();
        this.clusterBorderColor = (Color)objectInputStream.readObject();
        this.insets = (Insets)objectInputStream.readObject();
        this.xWidth = objectInputStream.readInt();
        this.xHeight = objectInputStream.readInt();
        this.fieldNames = (String[])objectInputStream.readObject();
        this.colorScheme = 5;
        this.negGreenColorImage = this.createGradientImage(Color.green, Color.black);
        this.posRedColorImage = this.createGradientImage(Color.black, Color.red);
        this.negBlueColorImage = this.createGradientImage(Color.blue, Color.black);
        this.posYellowColorImage = this.createGradientImage(Color.black, Color.yellow);
        this.posColorImage = this.posRedColorImage;
        this.negColorImage = this.negGreenColorImage;
        this.actions = new HashMap();
        if (this.displayEvery == 1) {
            this.setIndices(this.createIndices());
        } else if (this.displayEvery > 1) {
            this.setIndices(this.createIndices(this.displayEvery));
        }
        this.listener = new Listener();
        this.addMouseMotionListener(this.listener);
        this.addKeyListener(this.listener);
        this.initLabelActions(this.fieldNames);
        this.initSortActions(this.fieldNames);
        this.initAnnotationWidthActions();
        this.geneColumnHeaderSP = this.createHeader(50, true, this.xWidth, 500, this.elementSize, this.experiment);
        this.geneColumnHeaderSP.setBorder(BorderFactory.createLineBorder(Color.white));
        this.geneRowHeaderSP = this.createHeader(50, false, 500, this.xHeight, this.elementSize, this.experiment);
        this.content = this.createContent(400, 400, this.listener);
        this.geneColumnHeaderSP.setMatrixListener(this.listener);
        this.geneRowHeaderSP.setMatrixListener(this.listener);
        this.upperRightCornerSB = this.createScrollBar(1);
        this.lowerLeftCornerSB = this.createScrollBar(0);
        this.setMaxWidth(this.content, this.geneColumnHeaderSP);
        this.setMaxHeight(this.content, this.geneRowHeaderSP);
        this.geneColumnHeaderSP.setPosColorImages(this.posColorImage);
        this.geneRowHeaderSP.setPosColorImages(this.posColorImage);
        this.geneColumnHeaderSP.setIndices(this.indices);
        this.geneRowHeaderSP.setIndices(this.indices);
        this.add(this.content);
        this.popup = this.createJPopupMenu(this.listener);
        this.getContentComponent().addMouseListener(this.listener);
        this.setBackground(Color.white);
        this.setOpaque(true);
    }

    private void initLabelActions(String[] stringArray) {
        DefaultAction defaultAction = new DefaultAction(NO_LABEL, DISPLAY_LABEL_CMD);
        defaultAction.putValue(PARAMETER, String.valueOf(-1));
        this.actions.put(DISPLAY_LABEL_ACTION + String.valueOf(-1), defaultAction);
        for (int i = 0; i < stringArray.length; ++i) {
            defaultAction = new DefaultAction(LABEL_BY + stringArray[i], DISPLAY_LABEL_CMD);
            defaultAction.putValue(PARAMETER, String.valueOf(i));
            this.actions.put(DISPLAY_LABEL_ACTION + String.valueOf(i), defaultAction);
        }
    }

    private void initSortActions(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            DefaultAction defaultAction = new DefaultAction(SORT_BY + stringArray[i], SORT_LABEL_CMD);
            defaultAction.putValue(PARAMETER, String.valueOf(i));
            this.actions.put(SORT_LABEL_ACTION + String.valueOf(i), defaultAction);
        }
    }

    private void initAnnotationWidthActions() {
        DefaultAction defaultAction = new DefaultAction(CHANGE_ANNOTATION_WIDTH, ANNOTATION_WIDTH_CMD);
        defaultAction.putValue(PARAMETER, String.valueOf(-1));
        this.actions.put(ANNOTATION_WIDTH_ACTION + String.valueOf(-1), defaultAction);
    }

    public Action getAction(String string) {
        return (Action)this.actions.get(string);
    }

    public void setMainFrame(JFrame jFrame) {
        this.mainframe = jFrame;
    }

    private void setIndices(int[] nArray) {
        this.indices = nArray;
    }

    private int[] getIndices() {
        return this.indices;
    }

    private int[] createIndices(int n) {
        int n2 = this.num_genes;
        int[] nArray = new int[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n5 = 0; n5 < this.probes; ++n5) {
            if (n4 % this.displayEvery == 0 && n3 < n2) {
                nArray[n3] = n5;
                ++n3;
            }
            ++n4;
        }
        n4 = 0;
        if (this.numOfClusters > 0) {
            this.clusterlength = new int[this.numOfClusters];
            n3 = 0;
            for (int i = 0; i < this.numOfClusters; ++i) {
                for (int j = 0; j < this.clusters[i].length; ++j) {
                    if (n4 % this.displayEvery == 0 && n3 < n2) {
                        nArray[n3] = this.clusters[i][j];
                        ++n3;
                        int n6 = i;
                        this.clusterlength[n6] = this.clusterlength[n6] + 1;
                    }
                    ++n4;
                }
            }
        }
        return nArray;
    }

    private int[] createIndices() {
        int n;
        int[] nArray = new int[this.num_genes];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = n;
        }
        if (this.numOfClusters > 0) {
            this.clusterlength = new int[this.num_genes];
            n = 0;
            for (int i = 0; i < this.numOfClusters; ++i) {
                for (int j = 0; j < this.clusters[i].length; ++j) {
                    nArray[n] = this.clusters[i][j];
                    int n2 = i;
                    this.clusterlength[n2] = this.clusterlength[n2] + 1;
                    ++n;
                }
            }
        }
        return nArray;
    }

    private void setMaxWidth(JComponent jComponent, JComponent jComponent2) {
        int n = jComponent.getPreferredSize().width;
        int n2 = jComponent2.getPreferredSize().width;
        if (n > n2) {
            jComponent2.setPreferredSize(new Dimension(n, jComponent2.getPreferredSize().height));
        } else {
            jComponent.setPreferredSize(new Dimension(n2, jComponent.getPreferredSize().height));
        }
    }

    private void setMaxHeight(JComponent jComponent, JComponent jComponent2) {
        int n = jComponent.getPreferredSize().height;
        int n2 = jComponent2.getPreferredSize().height;
        if (n > n2) {
            jComponent2.setPreferredSize(new Dimension(jComponent2.getPreferredSize().width, n));
        } else {
            jComponent.setPreferredSize(new Dimension(jComponent.getPreferredSize().width, n2));
        }
    }

    public BufferedImage getPosColorImage() {
        return this.posColorImage;
    }

    public BufferedImage getNegColorImage() {
        return this.negColorImage;
    }

    public void setPosColorImage(BufferedImage bufferedImage) {
        this.posColorImage = bufferedImage;
    }

    public void setNegColorImage(BufferedImage bufferedImage) {
        this.negColorImage = bufferedImage;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    private GDMGeneHeader createHeader(int n, boolean bl, int n2, int n3, Dimension dimension, Experiment experiment) {
        GDMGeneHeader gDMGeneHeader = new GDMGeneHeader(this.insets, n, bl, experiment, n2, n3, dimension, this.maxGeneNameLength, this.num_genes, this.getIndices());
        return gDMGeneHeader;
    }

    private JPanel createContent(int n, int n2, Listener listener) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.white);
        this.xWidth = this.getXSize();
        this.xHeight = this.getYSize();
        jPanel.setSize(this.xWidth + 5, this.xHeight + 5);
        jPanel.setPreferredSize(new Dimension(this.xWidth + 5, this.xHeight + 5));
        jPanel.setOpaque(true);
        jPanel.setVisible(true);
        return jPanel;
    }

    private JScrollBar createScrollBar(int n) {
        JScrollBar jScrollBar = new JScrollBar(n);
        if (n == 1) {
            jScrollBar.setModel(this.geneColumnHeaderSP.getVerticalScrollBar().getModel());
        } else {
            jScrollBar.setModel(this.geneRowHeaderSP.getHorizontalScrollBar().getModel());
        }
        return jScrollBar;
    }

    private int getTopIndex(int n) {
        if (n < 0) {
            return 0;
        }
        return (n - this.insets.top) / this.elementSize.height;
    }

    private int getLeftIndex(int n) {
        if (n < 0) {
            return 0;
        }
        return (n - this.insets.left) / (this.elementSize.width + this.getSpacing());
    }

    private int getRightIndex(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = (n - this.insets.left) / (this.elementSize.width + this.getSpacing()) + 1;
        return n3 > n2 ? n2 : n3;
    }

    private int getBottomIndex(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = (n - this.insets.top) / this.elementSize.height + 1;
        return n3 > n2 ? n2 : n3;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.num_genes == 0 || this.framework == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.drawColumns(graphics2D);
        if (this.isDrawClusterBorders && this.numOfClusters > 0) {
            this.drawClusterBorder(graphics2D);
        }
        this.drawPerimeter(graphics2D);
    }

    private void drawClusterBorder(Graphics2D graphics2D) {
        int n = this.insets.left;
        int n2 = this.insets.top;
        int n3 = 0;
        int n4 = 0;
        Graphics2D graphics2D2 = graphics2D;
        graphics2D2.setColor(this.clusterBorderColor);
        for (int i = 0; i < this.numOfClusters; ++i) {
            n4 = this.clusterlength[i] * (this.elementSize.height + this.getSpacing());
            n = this.insets.left;
            for (int j = 0; j < this.numOfClusters; ++j) {
                n3 = this.clusterlength[j] * (this.elementSize.width + this.getSpacing());
                graphics2D2.drawRect(n, n2, n3, n4);
                n += n3;
            }
            n2 += n4;
        }
    }

    private void drawColumns(Graphics2D graphics2D) {
        Rectangle rectangle = graphics2D.getClipBounds();
        int n = this.getTopIndex(rectangle.y);
        int n2 = this.getLeftIndex(rectangle.x);
        int n3 = 0;
        int n4 = 0;
        n3 = this.getBottomIndex(rectangle.y + rectangle.height, this.num_genes);
        n4 = this.getRightIndex(rectangle.x + rectangle.width, this.num_genes);
        for (int i = n2; i < n4; ++i) {
            this.drawColumn(graphics2D, i, n, n3);
        }
    }

    private void drawPerimeter(Graphics2D graphics2D) {
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.black);
        if (this.isDrawClusterBorders && this.numOfClusters > 0) {
            graphics2D.drawRect(0, 0, this.getXSize() - this.insets.right + 1, this.getYSize() - this.insets.bottom + 1);
        } else {
            graphics2D.drawRect(0, 0, this.getXSize() - this.insets.right, this.getYSize() - this.insets.bottom);
        }
        graphics2D.setColor(color);
    }

    private void drawColumn(Graphics2D graphics2D, int n, int n2, int n3) {
        for (int i = n2; i < n3; ++i) {
            this.drawSlideDataElement(graphics2D, i, n);
        }
    }

    private void drawSlideDataElement(Graphics graphics, int n, int n2) {
        float f = this.geneDistMatrix.get(this.indices[n], this.indices[n2]);
        Color color = Float.isNaN(f) ? NaNColor : (f == 0.0f && n == n2 ? diagColor : (f == 0.0f && n != n2 ? zeroColor : this.getColor(f)));
        graphics.setColor(color);
        graphics.fillRect(this.getXPos(n2), this.getYPos(n), this.elementSize.width, this.elementSize.height);
        if (this.isDrawBorders && this.elementSize.width > 2) {
            graphics.setColor(this.borderColor);
            graphics.drawRect(this.getXPos(n2), this.getYPos(n), this.elementSize.width - 1, this.elementSize.height - 1);
        }
    }

    private BufferedImage createGradientImage(Color color, Color color2) {
        BufferedImage bufferedImage = new BufferedImage(256, 1, 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 255.0f, 0.0f, color2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.drawRect(0, 0, 255, 1);
        return bufferedImage;
    }

    private Color getColor(float f) {
        if (Float.isNaN(f) || this.posColorImage == null || this.negColorImage == null) {
            return NaNColor;
        }
        int n = (int)(255.0f * (f - this.minValue) / this.maxValue);
        if (n > 255) {
            n = 255;
        }
        if (n < 0) {
            n = 0;
        }
        int n2 = f < 0.0f ? this.negColorImage.getRGB(255 - n, 0) : this.posColorImage.getRGB(n, 0);
        return new Color(n2);
    }

    private void setFontSize(int n) {
        if (n > 12) {
            n = 12;
        }
        this.setFont(new Font("monspaced", 0, n));
    }

    public void setElementWidth(int n) {
        this.elementWidth = n;
        this.setFontSize(n);
    }

    public int getElementWidth() {
        return this.elementWidth;
    }

    void setTracing(boolean bl) {
        this.isTracing = bl;
    }

    private int getSpacing() {
        if (this.isTracing) {
            return this.tracespace;
        }
        return 0;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return this.geneColumnHeaderSP;
    }

    public JComponent getColumnHeaderComponent() {
        return this.geneColumnHeaderSP;
    }

    public JComponent getRowHeaderComponent() {
        return this.geneRowHeaderSP;
    }

    public JComponent getUpperRightCornerSB() {
        return this.upperRightCornerSB;
    }

    public JComponent getLowerLeftCornerSB() {
        return this.lowerLeftCornerSB;
    }

    private int getXSize() {
        int n = 0;
        n = this.num_genes * this.elementSize.width + (this.num_genes - 1) * this.getSpacing() + this.insets.left + this.insets.right;
        return n;
    }

    private int getYSize() {
        int n = 0;
        n = this.num_genes * this.elementSize.height + ((this.num_genes - 1) * this.getSpacing() + this.insets.top + this.insets.bottom);
        return n;
    }

    private int getMaxGeneNameLength() {
        return this.maxGeneNameLength;
    }

    private void updateSize(int n) {
        int n2 = this.getXSize();
        int n3 = this.getYSize();
        this.setSize(n2, n3);
        this.setPreferredSize(new Dimension(n2, n3));
        this.geneColumnHeaderSP.setNumGenes(this.num_genes);
        this.geneColumnHeaderSP.updateSize(n);
        this.geneRowHeaderSP.setNumGenes(this.num_genes);
        this.geneRowHeaderSP.updateSize(n);
        this.setMaxWidth(this.content, this.geneColumnHeaderSP);
        this.setMaxHeight(this.content, this.geneRowHeaderSP);
        this.geneColumnHeaderSP.setPosColorImages(this.posColorImage);
        this.geneRowHeaderSP.setPosColorImages(this.posColorImage);
        this.repaint();
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.expData = iFramework.getData();
        this.probes = this.expData.getFeaturesSize();
        this.featuresCount = this.expData.getFeaturesCount();
        this.num_genes = this.geneDistMatrix.getRowDimension() / this.displayEvery;
        IDisplayMenu iDisplayMenu = iFramework.getDisplayMenu();
        this.setFontSize(this.elementSize.width);
        this.xWidth = this.getXSize();
        this.xHeight = this.getYSize();
        this.geneColumnHeaderSP.setData(this.expData);
        this.geneColumnHeaderSP.setContentWidth(this.xWidth + 10);
        this.geneColumnHeaderSP.setElementWidth(this.elementSize.width);
        this.geneRowHeaderSP.setData(this.expData);
        this.geneRowHeaderSP.setContentHeight(this.xHeight + 10);
        this.geneRowHeaderSP.setElementHeight(this.elementSize.height);
        this.geneColumnHeaderSP.repaint();
        this.geneRowHeaderSP.repaint();
        this.onMenuChanged(iDisplayMenu);
        this.onDataChanged(this.expData);
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.probes = this.expData.getFeaturesSize();
        this.featuresCount = this.expData.getFeaturesCount();
        this.num_genes = this.geneDistMatrix.getRowDimension() / this.displayEvery;
        this.paletteStyle = iDisplayMenu.getPaletteStyle();
        this.isGRScale = iDisplayMenu.isGRScale();
        if (iDisplayMenu.isTracing() == this.isTracing && this.labelIndex == iDisplayMenu.getLabelIndex() && this.isAntiAliasing == iDisplayMenu.isAntiAliasing()) {
            return;
        }
        this.isAntiAliasing = iDisplayMenu.isAntiAliasing();
        this.geneColumnHeaderSP.setAntiAliasing(this.isAntiAliasing);
        this.geneRowHeaderSP.setAntiAliasing(this.isAntiAliasing);
        this.labelIndex = iDisplayMenu.getLabelIndex();
        this.isTracing = iDisplayMenu.isTracing();
        this.setFont(new Font("monospaced", 1, this.elementSize.height));
        this.xWidth = this.getXSize();
        this.xHeight = this.getYSize();
        this.geneColumnHeaderSP.setContentWidth(this.xWidth);
        this.geneColumnHeaderSP.setElementWidth(this.elementSize.width);
        this.geneColumnHeaderSP.setTracing(this.isTracing);
        this.geneRowHeaderSP.setContentHeight(this.xHeight);
        this.geneRowHeaderSP.setElementHeight(this.elementSize.height);
        this.geneRowHeaderSP.setTracing(this.isTracing);
        this.geneColumnHeaderSP.repaint();
        this.geneRowHeaderSP.repaint();
        this.updateSize(-1);
    }

    public void onDataChanged(IData iData) {
        this.expData = iData;
        this.probes = this.expData.getFeaturesSize();
        this.featuresCount = this.expData.getFeaturesCount();
        this.num_genes = this.geneDistMatrix.getRowDimension() / this.displayEvery;
        this.geneColumnHeaderSP.setData(iData);
        this.geneRowHeaderSP.setData(iData);
        this.updateSize(-1);
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    public BufferedImage getImage() {
        return null;
    }

    private boolean isLegalPosition(int n, int n2) {
        return this.isLegalRow(n) && this.isLegalColumn(n2);
    }

    private boolean isLegalColumn(int n) {
        return n >= 0 && n <= this.num_genes - 1;
    }

    private boolean isLegalRow(int n) {
        return n >= 0 && n <= this.num_genes - 1;
    }

    private int findColumn(int n) {
        int n2 = this.elementSize.width + this.getSpacing();
        if (n > this.num_genes * n2 - this.getSpacing() + this.insets.left || n < this.insets.left) {
            return -1;
        }
        return n / n2;
    }

    private int findRow(int n) {
        int n2 = this.num_genes * this.elementSize.height;
        if (n > n2 + this.insets.top || n < this.insets.top) {
            return -1;
        }
        return n / this.elementSize.height;
    }

    private int getXPos(int n) {
        return n * (this.elementSize.width + this.getSpacing()) + this.insets.left;
    }

    private int getYPos(int n) {
        return n * this.elementSize.height + this.insets.top;
    }

    private void drawColoredBoxAt(Graphics graphics, int n, int n2, Color color) {
        graphics.setColor(color);
        graphics.drawRect(this.insets.left + n2 * (this.elementSize.width + this.getSpacing()), this.insets.top + n * this.elementSize.height, this.elementSize.width - 1, this.elementSize.height - 1);
    }

    public void displayGDMSpotInfo(int n, int n2, int n3, int n4) {
        new GDMGeneSpotInfoDisplay(this.mainframe, this.experiment, this.expData, this.geneDistMatrix, this.rawMatrix, this.distanceMetric, n, n2, n3, n4);
    }

    private JCheckBoxMenuItem createJCheckBoxMenuItem(String string, String string2, Listener listener, boolean bl) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        jCheckBoxMenuItem.setActionCommand(string2);
        jCheckBoxMenuItem.addActionListener(listener);
        jCheckBoxMenuItem.setSelected(bl);
        return jCheckBoxMenuItem;
    }

    private JCheckBoxMenuItem createJCheckBoxMenuItem(String string, String string2, Listener listener) {
        return this.createJCheckBoxMenuItem(string, string2, listener, false);
    }

    private JRadioButtonMenuItem createJRadioButtonMenuItem(String string, String string2, Listener listener, ButtonGroup buttonGroup, boolean bl) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
        jRadioButtonMenuItem.setActionCommand(string2);
        jRadioButtonMenuItem.addActionListener(listener);
        jRadioButtonMenuItem.setSelected(bl);
        if (buttonGroup != null) {
            buttonGroup.add(jRadioButtonMenuItem);
        }
        return jRadioButtonMenuItem;
    }

    private JRadioButtonMenuItem createJRadioButtonMenuItem(String string, String string2, Listener listener, ButtonGroup buttonGroup) {
        return this.createJRadioButtonMenuItem(string, string2, listener, buttonGroup, false);
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    private void addMenuItems(JPopupMenu jPopupMenu, Listener listener) {
        JMenu jMenu = new JMenu("Color Scheme");
        ButtonGroup buttonGroup = new ButtonGroup();
        jMenu.add(this.createJRadioButtonMenuItem("Black/Red Scheme", GREEN_RED_COLOR_SCHEME_CMD, listener, buttonGroup, true));
        jMenu.add(this.createJRadioButtonMenuItem("Black/Yellow Scheme", BLUE_YELLOW_COLOR_SCHEME_CMD, listener, buttonGroup));
        jMenu.add(this.createJRadioButtonMenuItem("Custom Color Scheme", CUSTOM_COLOR_SCHEME_CMD, listener, buttonGroup));
        jPopupMenu.add(jMenu);
        jPopupMenu.addSeparator();
        JMenu jMenu2 = new JMenu("Element Size");
        buttonGroup = new ButtonGroup();
        jMenu2.add(this.createJRadioButtonMenuItem("2 x 2", DISPLAY_2X2_CMD, listener, buttonGroup));
        jMenu2.add(this.createJRadioButtonMenuItem("5 x 5", DISPLAY_5X5_CMD, listener, buttonGroup));
        jMenu2.add(this.createJRadioButtonMenuItem("10 x 10", DISPLAY_10X10_CMD, listener, buttonGroup, true));
        jMenu2.add(this.createJRadioButtonMenuItem("15 x 15", DISPLAY_15X15_CMD, listener, buttonGroup));
        jMenu2.add(this.createJRadioButtonMenuItem("Other", DISPLAY_OTHER_CMD, listener, buttonGroup));
        jPopupMenu.add(jMenu2);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.createJCheckBoxMenuItem("Draw Borders", DISPLAY_DRAW_BORDERS_CMD, listener));
        if (this.numOfClusters > 0) {
            this.drawClusterBorderItem = this.createJCheckBoxMenuItem("Draw Cluster Borders", SET_CLUSTER_BORDER_CMD, listener, true);
            jPopupMenu.add(this.drawClusterBorderItem);
        }
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Select Border Color");
        jMenuItem.setActionCommand(BORDER_COLOR_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Set Color Scale");
        jMenuItem.setActionCommand(COLOR_SCALE_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Toggle Sort on Proximity");
        jMenuItem.setActionCommand(TOGGLE_PROXIMITY_SORT_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save k Neighbors");
        jMenuItem.setActionCommand(SAVE_NEIGHBORS_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        this.sortMenu = new JMenu("Sort");
        buttonGroup = new ButtonGroup();
        if (this.numOfClusters > 0) {
            this.sortMenu.add(this.createJRadioButtonMenuItem("Sort by Location", SORT_BY_LOCATION_CMD, listener, buttonGroup, false));
        } else {
            this.sortMenu.add(this.createJRadioButtonMenuItem("Sort by Location", SORT_BY_LOCATION_CMD, listener, buttonGroup, false));
        }
        this.addSortMenuItems(this.sortMenu, buttonGroup);
        if (this.numOfClusters > 0) {
            this.addSortClusterMenuItems(this.sortMenu, buttonGroup, listener);
        }
        jPopupMenu.add(this.sortMenu);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Impose Cluster Result");
        jMenuItem.setActionCommand("impose-cluster-order");
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        JMenu jMenu3 = new JMenu("Change Annotation");
        buttonGroup = new ButtonGroup();
        this.addLabelMenuItems(jMenu3, buttonGroup);
        jPopupMenu.add(jMenu3);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Change annotation Width");
        jMenuItem.setActionCommand(ANNOTATION_WIDTH_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
    }

    private void addLabelMenuItems(JMenu jMenu, ButtonGroup buttonGroup) {
        Action action;
        int n = -1;
        while ((action = this.getAction(DISPLAY_LABEL_ACTION + String.valueOf(n))) != null) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(action);
            buttonGroup.add(jRadioButtonMenuItem);
            if (n < 1) {
                jRadioButtonMenuItem.setSelected(true);
                String string = (String)action.getValue(PARAMETER);
                this.label = Integer.parseInt(string);
            }
            jMenu.add(jRadioButtonMenuItem);
            ++n;
        }
    }

    private void addSortMenuItems(JMenu jMenu, ButtonGroup buttonGroup) {
        Action action;
        int n = 0;
        while ((action = this.getAction(SORT_LABEL_ACTION + String.valueOf(n))) != null) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(action);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            ++n;
        }
    }

    private void addSortClusterMenuItems(JMenu jMenu, ButtonGroup buttonGroup, Listener listener) {
        jMenu.add(this.createJRadioButtonMenuItem("Sort by Cluster Number", SORT_BY_CLUSTER_ORDER_CMD, listener, buttonGroup, true));
    }

    private void onElementSizeChanged(int n, int n2) {
        this.elementSize = new Dimension(n, n2);
        this.xWidth = this.getXSize();
        this.xHeight = this.getYSize();
        this.geneColumnHeaderSP.setContentWidth(this.xWidth);
        this.geneColumnHeaderSP.setElementWidth(this.elementSize.width);
        this.geneColumnHeaderSP.setElementHeight(this.elementSize.height);
        this.geneRowHeaderSP.setContentHeight(this.xHeight);
        this.geneRowHeaderSP.setElementWidth(this.elementSize.width);
        this.geneRowHeaderSP.setElementHeight(this.elementSize.height);
        this.geneColumnHeaderSP.setPosColorImages(this.posColorImage);
        this.geneRowHeaderSP.setPosColorImages(this.posColorImage);
        this.updateSize(-1);
        this.validate();
    }

    private void onElementSizeChanged() {
        GDMElementSizeDialog gDMElementSizeDialog = new GDMElementSizeDialog(this.mainframe, this.elementSize);
        if (gDMElementSizeDialog.showModal() == 0) {
            Dimension dimension = gDMElementSizeDialog.getElementSize();
            this.onElementSizeChanged(dimension.width, dimension.height);
        }
    }

    private void onDrawBordersChanged(boolean bl) {
        this.isDrawBorders = bl;
        this.geneColumnHeaderSP.repaint();
        this.repaint();
    }

    private void onDrawClusterBorderChange(boolean bl) {
        if (this.numOfClusters > 0) {
            this.isDrawClusterBorders = bl;
            this.geneColumnHeaderSP.repaint();
            this.repaint();
        }
    }

    private void onColorSchemeChange(int n) {
        if (this.colorScheme == n && n != 7) {
            return;
        }
        if (n == 5) {
            this.setPosColorImage(this.posRedColorImage);
            this.colorScheme = n;
        } else if (n == 6) {
            this.setPosColorImage(this.posYellowColorImage);
            this.colorScheme = n;
        } else {
            GDMColorSelectionDialog gDMColorSelectionDialog = new GDMColorSelectionDialog((Frame)this.mainframe, true, this.getPosColorImage());
            if (gDMColorSelectionDialog.showModal() != 0) {
                return;
            }
            this.setPosColorImage(gDMColorSelectionDialog.getPositiveGradient());
            this.colorScheme = n;
        }
        this.geneColumnHeaderSP.setPosColorImages(this.posColorImage);
        this.geneRowHeaderSP.setPosColorImages(this.posColorImage);
        this.geneColumnHeaderSP.repaint();
        this.geneRowHeaderSP.repaint();
        this.repaint();
    }

    private void onBorderColorChanged() {
        GDMBorderColorDialog gDMBorderColorDialog = new GDMBorderColorDialog((Frame)this.mainframe, true, this.borderColor);
        if (gDMBorderColorDialog.showModal() != 0) {
            return;
        }
        this.setBorderColor(gDMBorderColorDialog.getBorderColor());
        this.geneColumnHeaderSP.repaint();
        this.geneRowHeaderSP.repaint();
        this.repaint();
    }

    private void onColorScaleChanged() {
        BufferedImage bufferedImage = this.getPosColorImage();
        Color color = new Color(bufferedImage.getRGB(0, 0));
        Color color2 = new Color(bufferedImage.getRGB(bufferedImage.getWidth() - 1, 0));
        GDMColorScaleDialog gDMColorScaleDialog = new GDMColorScaleDialog(this.mainframe, this.minValue, this.maxValue, this.geneDistMatrix, this.num_genes, color, color2);
        gDMColorScaleDialog.setGDMScaleListener(new ScaleListener());
        int n = gDMColorScaleDialog.showModal();
        this.minValue = gDMColorScaleDialog.getLowerLimit();
        this.maxValue = gDMColorScaleDialog.getUpperLimit();
        this.geneColumnHeaderSP.setValues(this.minValue, this.maxValue);
        this.geneRowHeaderSP.setValues(this.minValue, this.maxValue);
        this.geneColumnHeaderSP.updateSize(-1);
        this.geneRowHeaderSP.updateSize(-1);
        this.revalidate();
    }

    private void onSortByClusterChange() {
        if (this.numOfClusters > 0) {
            this.isDrawClusterBorders = true;
            if (this.displayEvery == 1) {
                this.setIndices(this.createIndices());
            } else if (this.displayEvery > 1) {
                this.setIndices(this.createIndices(this.displayEvery));
            }
            this.geneColumnHeaderSP.setIndices(this.indices);
            this.geneRowHeaderSP.setIndices(this.indices);
            this.onDataChanged(this.expData);
        }
    }

    private void toggleSortByGeneProximity() {
        this.sortByGeneProximity = !this.sortByGeneProximity;
        this.geneColumnHeaderSP.setSortByGeneProximity(this.sortByGeneProximity);
        this.geneRowHeaderSP.setSortByGeneProximity(this.sortByGeneProximity);
    }

    private void onSortByGeneProximity(int n) {
        this.isDrawClusterBorders = false;
        QSort qSort = new QSort(this.geneDistMatrix.A[n]);
        int[] nArray = qSort.getOrigIndx();
        if (nArray[0] != n) {
            boolean bl = true;
            for (int i = 0; i < nArray.length && bl; ++i) {
                if (nArray[i] != n) continue;
                nArray[i] = nArray[0];
                nArray[0] = n;
                bl = false;
            }
        }
        this.setIndices(nArray);
        this.geneColumnHeaderSP.setIndices(nArray);
        this.geneRowHeaderSP.setIndices(nArray);
        this.onDataChanged(this.expData);
        this.validate();
        this.geneColumnHeaderSP.repaint();
        this.geneRowHeaderSP.repaint();
    }

    private void clearSortSelection() {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < this.sortMenu.getMenuComponentCount(); ++i) {
            ((JRadioButtonMenuItem)this.sortMenu.getMenuComponent(i)).setSelected(false);
            buttonGroup.add((JRadioButtonMenuItem)this.sortMenu.getMenuComponent(i));
        }
    }

    private void onSort(Action action) {
        String string = (String)action.getValue(PARAMETER);
        this.isDrawClusterBorders = false;
        this.onSort(Integer.parseInt(string));
    }

    private void onSort(int n) {
        this.setIndices(this.createIndices(this.displayEvery));
        this.isDrawClusterBorders = false;
        if (this.drawClusterBorderItem != null) {
            this.drawClusterBorderItem.setState(false);
        }
        this.sortIndices(n);
        this.onDataChanged(this.expData);
    }

    private void sortIndices(int n) {
        SlideDataSorter slideDataSorter = new SlideDataSorter();
        slideDataSorter.setSlideData(this.expData.getFeature(0));
        int[] nArray = this.getIndices();
        slideDataSorter.sort(nArray, n);
        this.setIndices(nArray);
        this.geneColumnHeaderSP.setIndices(nArray);
        this.geneRowHeaderSP.setIndices(nArray);
        this.geneColumnHeaderSP.setPosColorImages(this.posColorImage);
        this.geneRowHeaderSP.setPosColorImages(this.posColorImage);
    }

    private void onLabelChanged(Action action) {
        String string = (String)action.getValue(PARAMETER);
        this.setLabelIndex(Integer.parseInt(string));
        this.geneColumnHeaderSP.setLabelIndex(this.label);
        this.geneRowHeaderSP.setLabelIndex(this.label);
        this.onDataChanged(this.expData);
        this.geneColumnHeaderSP.setPosColorImages(this.posColorImage);
        this.geneRowHeaderSP.setPosColorImages(this.posColorImage);
        this.geneColumnHeaderSP.updateSize(-1);
        this.geneRowHeaderSP.updateSize(-1);
        this.geneColumnHeaderSP.repaint();
        this.geneRowHeaderSP.repaint();
        this.updateSize(-1);
        this.repaint();
    }

    private void onAnnotationWidthChanged() {
        GDMAnnotationSizeDialog gDMAnnotationSizeDialog = new GDMAnnotationSizeDialog(this.mainframe);
        if (gDMAnnotationSizeDialog.showModal() == 0) {
            int n = gDMAnnotationSizeDialog.getAnnotationSize();
            this.geneColumnHeaderSP.setAnnotationSize(n);
            this.geneRowHeaderSP.setAnnotationSize(n);
            this.geneColumnHeaderSP.setSize(this.geneColumnHeaderSP.getWidth(), n);
            this.geneColumnHeaderSP.setPreferredSize(new Dimension(this.geneColumnHeaderSP.getWidth(), n));
            this.geneRowHeaderSP.setSize(n, this.geneRowHeaderSP.getHeight());
            this.geneRowHeaderSP.setPreferredSize(new Dimension(n, this.geneRowHeaderSP.getHeight()));
            this.geneColumnHeaderSP.repaint();
            this.geneRowHeaderSP.repaint();
            this.updateSize(n);
            this.repaint();
        }
    }

    private void setLabelIndex(int n) {
        this.label = n;
    }

    private void onSaveNeighbors() {
        GDMMemberSelectionDialog gDMMemberSelectionDialog = new GDMMemberSelectionDialog(new JFrame(), this.num_genes);
        if (gDMMemberSelectionDialog.showModal() == 0) {
            int n = gDMMemberSelectionDialog.getK();
            if (n <= 0) {
                return;
            }
            if (n > this.num_genes) {
                n = this.num_genes;
            }
            int[] nArray = this.getRows(n);
            Object[][] objectArray = this.getAuxilaryData(this.num_genes);
            String[] stringArray = new String[]{"Scaled Dist.", "Actual Dist.", "Value Pairs"};
            try {
                ExperimentUtil.saveGeneClusterWithAux((Frame)this.framework.getFrame(), (Experiment)this.experiment, (IData)this.expData, (int[])nArray, (String[])stringArray, (Object[][])objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(this.framework.getFrame(), "Error saving file: " + exception.getMessage(), "Output Error", 2);
            }
        }
    }

    private int[] getIDataRows(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.experiment.getGeneIndexMappedToData(this.indices[i]);
        }
        return nArray;
    }

    private int[] getRows(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.indices[i];
        }
        return nArray;
    }

    private String[][] getAuxilaryData(int n) {
        String[][] stringArray = new String[n][3];
        FloatMatrix floatMatrix = this.experiment.getMatrix();
        for (int i = 0; i < n; ++i) {
            stringArray[i][0] = Float.toString(this.geneDistMatrix.get(this.indices[0], i));
            stringArray[i][1] = Float.toString(this.rawMatrix.get(this.indices[0], i));
            stringArray[i][2] = this.getValuePairCount(floatMatrix, this.indices[0], i);
        }
        return stringArray;
    }

    private String getValuePairCount(FloatMatrix floatMatrix, int n, int n2) {
        int n3 = floatMatrix.getColumnDimension();
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            if (Float.isNaN(floatMatrix.get(n, i)) || Float.isNaN(floatMatrix.get(n2, i))) continue;
            ++n4;
        }
        return Integer.toString(n4);
    }

    private void imposeClusterOrder() {
        Object object;
        Hashtable hashtable = this.getResultHash();
        boolean bl = false;
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        Enumeration enumeration = hashtable.keys();
        String string = "";
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            Object[] objectArray = (Object[])hashtable.get(string);
            if (string.indexOf("HCL") != -1) {
                object = new int[1][];
                object[0] = ((int[][])objectArray[1])[0];
                if (object[0] == null || this.experiment != objectArray[0] || !this.checkClustersSize((int[][])object)) continue;
                hashtable2.put(string, object);
                continue;
            }
            if (this.experiment != objectArray[0] || !this.checkClustersSize((int[][])objectArray[1])) continue;
            hashtable2.put(string, objectArray[1]);
        }
        if (hashtable2.size() > 0) {
            object = new GDMResultSelectionDialog((JFrame)this.framework.getFrame(), hashtable2.keys());
            if (((GDMResultSelectionDialog)object).showModal() == 0) {
                int[][] nArray = (int[][])hashtable2.get(((GDMResultSelectionDialog)object).getSelectedResult());
                this.imposeClusterOrder(nArray);
            }
        } else {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "There are currently no appropriate clustering results to apply to this GDM.", "No Results Available", 1);
        }
    }

    private boolean checkClustersSize(int[][] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i].length;
        }
        return n / this.displayEvery == this.num_genes;
    }

    public Hashtable getResultHash() {
        Hashtable<String, Object[]> hashtable = new Hashtable<String, Object[]>();
        DefaultMutableTreeNode defaultMutableTreeNode = this.framework.getResultTree().getAnalysisNode();
        boolean bl = false;
        int n = defaultMutableTreeNode.getChildCount();
        String string = "";
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            Object object = defaultMutableTreeNode2.getUserObject();
            if (object == null) continue;
            if (object instanceof LeafInfo) {
                string = ((LeafInfo)object).toString();
            } else if (object instanceof String) {
                string = (String)object;
            }
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode2.depthFirstEnumeration();
            while (!bl && enumeration.hasMoreElements()) {
                IViewer iViewer;
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
                if (!(defaultMutableTreeNode3.getUserObject() instanceof LeafInfo) || (iViewer = ((LeafInfo)defaultMutableTreeNode3.getUserObject()).getViewer()) == null) continue;
                Experiment experiment = iViewer.getExperiment();
                int[][] nArray = iViewer.getClusters();
                if (experiment == null || nArray == null) continue;
                Object[] objectArray = new Object[]{experiment, nArray};
                hashtable.put(string, objectArray);
                bl = true;
            }
            bl = false;
        }
        return hashtable;
    }

    private void imposeClusterOrder(int[][] nArray) {
        this.clusters = nArray;
        this.numOfClusters = this.clusters.length;
        this.onSortByClusterChange();
    }

    protected boolean areProbesColored() {
        for (int i = 0; i < this.indices.length; ++i) {
            if (this.expData.getProbeColor(this.indices[i]) == null) continue;
            return true;
        }
        return false;
    }

    public JComponent getCornerComponent(int n) {
        if (n == 1) {
            return this.upperRightCornerSB;
        }
        if (n == 2) {
            return this.lowerLeftCornerSB;
        }
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return 0;
    }

    private class DefaultAction
    extends AbstractAction {
        public DefaultAction(String string, String string2) {
            this(string, string2, null);
        }

        public DefaultAction(String string, String string2, ImageIcon imageIcon) {
            this.putValue("Name", string);
            this.putValue("ShortDescription", string);
            this.putValue("ActionCommandKey", string2);
            this.putValue("SmallIcon", imageIcon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GDMGeneViewer.this.listener.actionPerformed(new ActionEvent(this, actionEvent.getID(), (String)this.getValue("ActionCommandKey")));
        }
    }

    private class ScaleListener
    extends GDMScaleListener {
        private ScaleListener() {
        }

        public void scaleChanged(float f, float f2) {
            GDMGeneViewer.this.minValue = f;
            GDMGeneViewer.this.maxValue = f2;
            GDMGeneViewer.this.geneColumnHeaderSP.setValues(GDMGeneViewer.this.minValue, GDMGeneViewer.this.maxValue);
            GDMGeneViewer.this.geneRowHeaderSP.setValues(GDMGeneViewer.this.minValue, GDMGeneViewer.this.maxValue);
            GDMGeneViewer.this.geneColumnHeaderSP.updateSize(-1);
            GDMGeneViewer.this.geneRowHeaderSP.updateSize(-1);
            GDMGeneViewer.this.geneColumnHeaderSP.validate();
            GDMGeneViewer.this.geneRowHeaderSP.validate();
            GDMGeneViewer.this.validate();
            GDMGeneViewer.this.geneColumnHeaderSP.repaint();
            GDMGeneViewer.this.geneRowHeaderSP.repaint();
            GDMGeneViewer.this.repaint();
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    MouseMotionListener,
    KeyListener,
    WindowListener {
        private int oldRow = -1;
        private int oldColumn = -1;
        private String oldStatusText;

        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(GDMGeneViewer.DISPLAY_LABEL_CMD)) {
                GDMGeneViewer.this.onLabelChanged((Action)actionEvent.getSource());
            } else if (string.equals(GDMGeneViewer.ANNOTATION_WIDTH_CMD)) {
                GDMGeneViewer.this.onAnnotationWidthChanged();
            } else if (string.equals(GDMGeneViewer.DISPLAY_2X2_CMD)) {
                GDMGeneViewer.this.onElementSizeChanged(2, 2);
            } else if (string.equals(GDMGeneViewer.DISPLAY_5X5_CMD)) {
                GDMGeneViewer.this.onElementSizeChanged(5, 5);
            } else if (string.equals(GDMGeneViewer.DISPLAY_10X10_CMD)) {
                GDMGeneViewer.this.onElementSizeChanged(10, 10);
            } else if (string.equals(GDMGeneViewer.DISPLAY_15X15_CMD)) {
                GDMGeneViewer.this.onElementSizeChanged(15, 15);
            } else if (string.equals(GDMGeneViewer.DISPLAY_OTHER_CMD)) {
                GDMGeneViewer.this.onElementSizeChanged();
            } else if (string.equals(GDMGeneViewer.GREEN_RED_COLOR_SCHEME_CMD)) {
                GDMGeneViewer.this.onColorSchemeChange(5);
            } else if (string.equals(GDMGeneViewer.BLUE_YELLOW_COLOR_SCHEME_CMD)) {
                GDMGeneViewer.this.onColorSchemeChange(6);
            } else if (string.equals(GDMGeneViewer.CUSTOM_COLOR_SCHEME_CMD)) {
                GDMGeneViewer.this.onColorSchemeChange(7);
            } else if (string.equals(GDMGeneViewer.DISPLAY_DRAW_BORDERS_CMD)) {
                GDMGeneViewer.this.onDrawBordersChanged(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
            } else if (string.equals(GDMGeneViewer.BORDER_COLOR_CMD)) {
                GDMGeneViewer.this.onBorderColorChanged();
            } else if (string.equals(GDMGeneViewer.COLOR_SCALE_CMD)) {
                GDMGeneViewer.this.onColorScaleChanged();
            } else if (string.equals(GDMGeneViewer.SORT_BY_LOCATION_CMD)) {
                GDMGeneViewer.this.onSort(9000);
            } else if (string.equals(GDMGeneViewer.SORT_BY_RATIO_CMD)) {
                GDMGeneViewer.this.onSort(9001);
            } else if (string.equals(GDMGeneViewer.SORT_LABEL_CMD)) {
                GDMGeneViewer.this.onSort((Action)actionEvent.getSource());
            } else if (string.equals(GDMGeneViewer.SORT_BY_CLUSTER_ORDER_CMD)) {
                GDMGeneViewer.this.onSortByClusterChange();
            } else if (string.equals(GDMGeneViewer.SORT_BY_GENE_PROXIMITY_CMD)) {
                GDMGeneViewer.this.onSortByGeneProximity(actionEvent.getID());
            } else if (string.equals(GDMGeneViewer.TOGGLE_PROXIMITY_SORT_CMD)) {
                GDMGeneViewer.this.toggleSortByGeneProximity();
            } else if (string.equals(GDMGeneViewer.SET_CLUSTER_BORDER_CMD)) {
                GDMGeneViewer.this.onDrawClusterBorderChange(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
            } else if (string.equals(GDMGeneViewer.SAVE_NEIGHBORS_CMD)) {
                GDMGeneViewer.this.onSaveNeighbors();
            } else if (string.equals("impose-cluster-order")) {
                GDMGeneViewer.this.imposeClusterOrder();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            GDMGeneViewer.this.requestFocus();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                int n = GDMGeneViewer.this.findColumn(mouseEvent.getX());
                int n2 = GDMGeneViewer.this.findRow(mouseEvent.getY());
                if (!GDMGeneViewer.this.isLegalPosition(n2, n)) {
                    return;
                }
                GDMGeneViewer.this.displayGDMSpotInfo(GDMGeneViewer.this.indices[n], GDMGeneViewer.this.indices[n2], n, n2);
            } else {
                int n = GDMGeneViewer.this.findColumn(mouseEvent.getX());
                int n3 = GDMGeneViewer.this.findRow(mouseEvent.getY());
                GDMGeneViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (GDMGeneViewer.this.num_genes == 0 || mouseEvent.isShiftDown()) {
                return;
            }
            int n = GDMGeneViewer.this.findColumn(mouseEvent.getX());
            int n2 = GDMGeneViewer.this.findRow(mouseEvent.getY());
            if (this.isCurrentPosition(n2, n)) {
                return;
            }
            Graphics graphics = null;
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (GDMGeneViewer.this.isLegalPosition(n2, n)) {
                graphics = GDMGeneViewer.this.getGraphics();
                GDMGeneViewer.this.drawColoredBoxAt(graphics, n2, n, Color.white);
                GDMGeneViewer.this.framework.setStatusText(" Column: " + (n + 1) + "     " + " Row: " + (n2 + 1) + "     " + " Scaled Distance: " + GDMGeneViewer.this.geneDistMatrix.get(GDMGeneViewer.this.indices[n], GDMGeneViewer.this.indices[n2]) + "     " + " Actual Distance: " + GDMGeneViewer.this.rawMatrix.get(GDMGeneViewer.this.indices[n], GDMGeneViewer.this.indices[n2]));
            } else {
                GDMGeneViewer.this.framework.setStatusText(this.oldStatusText);
            }
            if (GDMGeneViewer.this.isLegalPosition(this.oldRow, this.oldColumn)) {
                graphics2D = graphics != null ? (Graphics2D)graphics : (Graphics2D)GDMGeneViewer.this.getGraphics();
                GDMGeneViewer.this.drawSlideDataElement(graphics2D, this.oldRow, this.oldColumn);
            }
            this.setOldPosition(n2, n);
            if (graphics != null) {
                if (GDMGeneViewer.this.isDrawClusterBorders && GDMGeneViewer.this.numOfClusters > 0) {
                    GDMGeneViewer.this.drawClusterBorder((Graphics2D)graphics);
                }
            } else if (graphics2D != null && GDMGeneViewer.this.isDrawClusterBorders && GDMGeneViewer.this.numOfClusters > 0) {
                GDMGeneViewer.this.drawClusterBorder(graphics2D);
            }
            if (graphics != null) {
                graphics.dispose();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (GDMGeneViewer.this.isLegalPosition(this.oldRow, this.oldColumn)) {
                Graphics graphics = GDMGeneViewer.this.getGraphics();
                Graphics2D graphics2D = (Graphics2D)graphics;
                GDMGeneViewer.this.drawSlideDataElement(graphics2D, this.oldRow, this.oldColumn);
                graphics2D.dispose();
                if (GDMGeneViewer.this.isDrawClusterBorders && GDMGeneViewer.this.numOfClusters > 0) {
                    GDMGeneViewer.this.drawClusterBorder(graphics2D);
                }
            }
            this.setOldPosition(-1, -1);
            GDMGeneViewer.this.framework.setStatusText("  ");
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.oldStatusText = GDMGeneViewer.this.framework.getStatusText();
        }

        private void setOldPosition(int n, int n2) {
            this.oldColumn = n2;
            this.oldRow = n;
        }

        private boolean isCurrentPosition(int n, int n2) {
            return n == this.oldRow && n2 == this.oldColumn;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }
}

