/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphPoint;
import org.tigr.graph.GraphTick;
import org.tigr.graph.GraphViewer;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.util.FloatMatrix;
import org.tigr.util.awt.ActionInfoDialog;
import org.tigr.util.awt.GBA;

public class GDMGeneSpotInfoDisplay
extends ActionInfoDialog {
    private int colIndex;
    private int rowIndex;
    private int colNumber;
    private int rowNumber;
    private FloatMatrix geneDistMatrix;
    private FloatMatrix rawMatrix;
    private int LINEAR = 0;
    private int LOG = 1;
    private String distanceMetric;
    private int vectorSize = 0;
    private int rowMissingValues = 0;
    private int colMissingValues = 0;
    private int distanceBasedOn = 0;
    private IData expData;
    private Experiment experiment;
    private Color rowGeneColor;
    private Color columnGeneColor;
    public static Color zeroColor = Color.black;
    public static Color NaNColor = Color.gray;
    public static Color diagColor = Color.white;
    private boolean haveColor = true;
    FloatMatrix data;

    public GDMGeneSpotInfoDisplay(JFrame jFrame, Experiment experiment, IData iData, FloatMatrix floatMatrix, FloatMatrix floatMatrix2, String string, int n, int n2, int n3, int n4) {
        super(jFrame, false);
        this.expData = iData;
        this.experiment = experiment;
        this.data = this.experiment.getMatrix();
        this.geneDistMatrix = floatMatrix;
        this.rawMatrix = floatMatrix2;
        this.colIndex = n;
        this.rowIndex = n2;
        this.colNumber = n3;
        this.rowNumber = n4;
        this.distanceMetric = string;
        this.vectorSize = this.expData.getFeaturesCount();
        this.rowGeneColor = iData.getProbeColor(experiment.getGeneIndexMappedToData(n2));
        this.columnGeneColor = iData.getProbeColor(experiment.getGeneIndexMappedToData(n));
        if (this.rowGeneColor == null && this.columnGeneColor == null) {
            this.haveColor = false;
        } else {
            if (this.rowGeneColor == null) {
                this.rowGeneColor = new Color(Integer.parseInt("FFFFCC", 16));
            }
            if (this.columnGeneColor == null) {
                this.columnGeneColor = new Color(Integer.parseInt("FFFFCC", 16));
            }
        }
        this.setValues(n, n2);
        this.init();
    }

    private void init() {
        Font font = new Font("monospaced", 0, 10);
        JLabel jLabel = new JLabel(GUIFactory.getIcon("spot.gif"));
        EventListener eventListener = new EventListener();
        JTextPane jTextPane = new JTextPane();
        jTextPane.setContentType("text/html");
        jTextPane.setFont(font);
        jTextPane.setEditable(false);
        jTextPane.setBackground(new Color(Integer.parseInt("FFFFCC", 16)));
        jTextPane.setMargin(new Insets(10, 15, 10, 10));
        jTextPane.setText(this.createMessage());
        jTextPane.setCaretPosition(0);
        jTextPane.addKeyListener(eventListener);
        JButton jButton = new JButton("Close");
        jButton.setActionCommand("close");
        jButton.addActionListener(eventListener);
        jButton.setFocusPainted(false);
        JButton jButton2 = new JButton("Expression Graph");
        jButton2.setActionCommand("show-graph-command");
        jButton2.addActionListener(eventListener);
        jButton2.setFocusPainted(false);
        this.contentPane.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(jTextPane, 20, 30);
        jScrollPane.getViewport().setBackground(Color.white);
        jScrollPane.getVerticalScrollBar().setValues(0, 10, 0, 100);
        GBA gBA = new GBA();
        gBA.add(this.contentPane, (Component)jScrollPane, 0, 0, 3, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.contentPane, (Component)jButton2, 0, 3, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.contentPane, (Component)jButton, 1, 3, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.pack();
        this.setSize(550, 600);
        this.setResizable(true);
        this.setTitle("Gene Distance Spot Information");
        this.setLocation(400, 100);
        this.show();
    }

    private String createMessage() {
        boolean bl = false;
        int n = this.expData.getProbeRow(0, this.colNumber);
        int n2 = this.expData.getProbeColumn(0, this.colNumber);
        int n3 = this.expData.getProbeRow(0, this.rowNumber);
        int n4 = this.expData.getProbeColumn(0, this.rowNumber);
        String[] stringArray = this.expData.getFieldNames();
        int n5 = stringArray.length;
        int n6 = this.rowNumber + 1;
        int n7 = this.colNumber + 1;
        String string = "";
        String string2 = "";
        if (this.haveColor) {
            string = '#' + Integer.toHexString(this.columnGeneColor.getRGB()).substring(2, 8);
            string2 = '#' + Integer.toHexString(this.rowGeneColor.getRGB()).substring(2, 8);
        }
        String string3 = "<h3>Annotation</h3>";
        string3 = string3 + "<table border=2 cellpadding=4 valign=top><tr><td  valign=top></td><td  align=top><b>Column Gene</b></td><td  align=top><b>Row Gene</b></td></tr><tr><td  valign=top><b>Row</b></td><td  valign=top>" + n + "</td><td valign=top>" + n3 + "</td></tr>" + "<tr><td  valign=top><b>Column</b></td><td  valign=top>" + n2 + "</td><td valign=top>" + n4 + "</td></tr>";
        if (this.haveColor) {
            string3 = string3 + "<tr><td valign=top><b>Gene Color</b></td><td   valign=top bgcolor=" + string + "></td><td valign=top bgcolor=" + string2 + "></td></tr>";
        }
        for (int i = 0; i < n5; ++i) {
            string3 = string3 + "<tr><td valign=top><b>" + stringArray[i] + "</b></td><td  valign=top>" + this.expData.getElementAttribute(this.experiment.getGeneIndexMappedToData(this.colIndex), i) + "</td><td valign=top>" + this.expData.getElementAttribute(this.experiment.getGeneIndexMappedToData(this.rowIndex), i) + "</td></tr>";
        }
        string3 = string3 + "</table>";
        string3 = string3 + "<h3>Distance Information</h3><table border=2 cellpadding=4 valign=top><tr><td valign=top><b>GDM Matrix Row</b></td><td valign=top>" + n6 + "</td></tr>" + "<tr><td valign=top><b>GDM Matrix Column</b></td><td valign=top>" + n7 + "</td></tr>" + "<tr><td valign=top><b>Scaled Gene Distance</b></td><td valign=top><b>" + this.geneDistMatrix.get(this.colIndex, this.rowIndex) + "<b></td></tr>" + "<tr><td valign=top><b>Actual Gene Distance</b></td><td valign=top><b>" + this.rawMatrix.get(this.colIndex, this.rowIndex) + "<b></td></tr>" + "<tr><td valign=top><b>Distance Metric</b></td><td valign=top>" + this.distanceMetric + "</td></tr>" + "<tr><td valign=top><b>Vector Size</b></td><td valign=top>" + this.vectorSize + "</td></tr>" + "<tr><td  valign=top><b>Missing Values</b></td><td  valign=top>" + this.colMissingValues + ", " + this.rowMissingValues + "</td></tr>" + "<tr><td valign=top><b>Distance Based on</b></td><td valign=top>" + this.distanceBasedOn + "</td></tr>";
        return string3;
    }

    public void createGeneGraph() {
        GraphTick graphTick;
        GraphLine graphLine;
        int n;
        float[] fArray = this.data.A[this.rowIndex];
        float[] fArray2 = this.data.A[this.colIndex];
        float f = Float.POSITIVE_INFINITY;
        float f2 = Float.NEGATIVE_INFINITY;
        float f3 = Float.POSITIVE_INFINITY;
        float f4 = Float.NEGATIVE_INFINITY;
        int n2 = this.data.getColumnDimension();
        for (n = 0; n < n2; ++n) {
            if (!Float.isNaN(fArray[n])) {
                if (fArray[n] < f) {
                    f = fArray[n];
                }
                if (fArray[n] > f2) {
                    f2 = fArray[n];
                }
            }
            if (Float.isNaN(fArray2[n])) continue;
            if (fArray2[n] < f3) {
                f3 = fArray2[n];
            }
            if (!(fArray2[n] > f4)) continue;
            f4 = fArray2[n];
        }
        f = Math.min(f, f3);
        f2 = Math.max(f2, f4);
        f = (int)(f - 1.0f);
        f2 = (int)(f2 + 1.0f);
        if (f > 0.0f) {
            f = 0.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        JFrame jFrame = new JFrame("Samples vs. Log Ratio");
        GraphViewer graphViewer = new GraphViewer(jFrame, 0, 500, 0, 500, 1.0, (double)n2, (double)f, (double)f2, 100, 100, 100, 100, "Sample vs. Log Ratio", "Sample Name", "Log2 (Cy5 / Cy3)");
        graphViewer.setSubTitle("(red line = row gene, blue line = column gene)");
        graphViewer.setXAxisValue(0.0);
        graphViewer.setYAxisValue(1.0);
        for (n = 1; n <= n2; ++n) {
            graphLine = new GraphLine((double)n, (double)f, (double)n, (double)f2, Color.yellow);
            graphViewer.addGraphElement((GraphElement)graphLine);
        }
        n = (int)f;
        while ((float)n <= f2) {
            if (n != 0) {
                graphLine = new GraphLine(1.0, (double)n, (double)n2, (double)n, Color.yellow);
                graphViewer.addGraphElement((GraphElement)graphLine);
            }
            ++n;
        }
        for (n = 0; n < n2 - 1; ++n) {
            if (!Float.isNaN(fArray[n]) && !Float.isNaN(fArray[n + 1])) {
                graphLine = new GraphLine((double)(n + 1), (double)fArray[n], (double)(n + 2), (double)fArray[n + 1], Color.red);
                graphViewer.addGraphElement((GraphElement)graphLine);
            }
            if (Float.isNaN(fArray2[n]) || Float.isNaN(fArray2[n + 1])) continue;
            graphLine = new GraphLine((double)(n + 1), (double)fArray2[n], (double)(n + 2), (double)fArray2[n + 1], Color.blue);
            graphViewer.addGraphElement((GraphElement)graphLine);
        }
        for (n = 0; n < n2; ++n) {
            GraphPoint graphPoint;
            if (!Float.isNaN(fArray[n])) {
                graphPoint = new GraphPoint((double)(n + 1), (double)fArray[n], Color.blue, 3);
                graphViewer.addGraphElement((GraphElement)graphPoint);
            }
            if (Float.isNaN(fArray2[n])) continue;
            graphPoint = new GraphPoint((double)(n + 1), (double)fArray2[n], Color.red, 3);
            graphViewer.addGraphElement((GraphElement)graphPoint);
        }
        n = (int)f;
        while ((float)n <= f2) {
            graphTick = n == 0 ? new GraphTick((double)n, 8, Color.black, 1, 0, "0", Color.black) : new GraphTick((double)n, 8, Color.black, 1, 0, "" + n, Color.black);
            graphViewer.addGraphElement((GraphElement)graphTick);
            ++n;
        }
        for (n = 1; n <= n2; ++n) {
            graphTick = new GraphTick((double)n, 8, Color.black, 0, 0, this.expData.getSampleName(n - 1), Color.black);
            graphViewer.addGraphElement((GraphElement)graphTick);
        }
        jFrame.setSize(500, 500);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        jFrame.setLocation((int)(dimension.getWidth() / 2.0 - 250.0), (int)(dimension.getHeight() / 2.0 - 250.0));
        graphViewer.setVisible(true);
    }

    private void setValues(int n, int n2) {
        float f;
        int n3;
        int n4 = this.experiment.getNumberOfSamples();
        boolean[] blArray = new boolean[n4];
        boolean[] blArray2 = new boolean[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            blArray[n3] = false;
            blArray2[n3] = false;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            f = this.experiment.get(n2, n3);
            if (!Float.isNaN(f)) continue;
            blArray[n3] = true;
            ++this.rowMissingValues;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            f = this.experiment.get(n, n3);
            if (!Float.isNaN(f)) continue;
            blArray2[n3] = true;
            ++this.colMissingValues;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (blArray[n3] || blArray2[n3] || n2 == n) continue;
            ++this.distanceBasedOn;
        }
    }

    private void drawGeneColor() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            graphics.setColor(this.rowGeneColor);
            graphics.fillRect(0, 0, 10, 10);
            graphics.setColor(this.columnGeneColor);
            graphics.fillRect(20, 0, 10, 10);
        }
    }

    class EventListener
    implements ActionListener,
    KeyListener {
        EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("close")) {
                GDMGeneSpotInfoDisplay.this.dispose();
            } else if (string.equals("show-graph-command")) {
                GDMGeneSpotInfoDisplay.this.createGeneGraph();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                GDMGeneSpotInfoDisplay.this.dispose();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

