/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMExpViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMGeneViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMInitDialog;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class GDMGUI
implements IClusterGUI,
IScriptGUI {
    private Experiment experiment;
    private Algorithm algorithm;
    private Progress progress;
    private IFramework framework;
    private FloatMatrix geneDistanceMatrix;
    private float minDist;
    private float maxDist;
    private int num_genes;
    private int num_experiments;
    private boolean useGenes;
    private int displayInterval;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block10: {
            this.framework = iFramework;
            this.experiment = iFramework.getData().getExperiment();
            GeneralInfo generalInfo = new GeneralInfo();
            Listener listener = new Listener();
            GDMInitDialog gDMInitDialog = new GDMInitDialog(iFramework.getFrame());
            if (gDMInitDialog.showModal() != 0) {
                return null;
            }
            this.useGenes = gDMInitDialog.isUseGenes();
            this.displayInterval = this.useGenes ? gDMInitDialog.getDisplayInterval() : 1;
            try {
                int n;
                this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("GDM");
                this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
                this.progress = new Progress(iFramework.getFrame(), "GDM Training", listener);
                this.progress.show();
                AlgorithmData algorithmData = new AlgorithmData();
                algorithmData.addParam("distance-factor", String.valueOf(1.0f));
                if (this.useGenes) {
                    algorithmData.addMatrix("experiment", iFramework.getData().getExperiment().getMatrix());
                } else {
                    algorithmData.addMatrix("experiment", iFramework.getData().getExperiment().getMatrix().transpose());
                }
                IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
                algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
                int n2 = iDistanceMenu.getDistanceFunction();
                if (n2 == 0) {
                    n2 = 4;
                }
                algorithmData.addParam("distance-function", String.valueOf(n2));
                long l = System.currentTimeMillis();
                AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
                generalInfo.time = System.currentTimeMillis() - l;
                generalInfo.function = iDistanceMenu.getFunctionName(n2);
                if (this.useGenes) {
                    n = this.getMaxGeneNameLength();
                    algorithmData2.addParam("maxGeneNameLength", String.valueOf(n));
                } else {
                    n = this.getMaxExpNameLength();
                    algorithmData2.addParam("maxExpNameLength", String.valueOf(n));
                }
                defaultMutableTreeNode = this.createResultTree(algorithmData2, generalInfo);
                Object var13_12 = null;
                if (this.algorithm == null) break block10;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var13_13 = null;
                    if (this.algorithm != null) {
                        this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                    }
                    if (this.progress == null) break block11;
                    this.progress.dispose();
                }
                throw throwable;
            }
            this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
        }
        if (this.progress != null) {
            this.progress.dispose();
        }
        return defaultMutableTreeNode;
    }

    public AlgorithmData getScriptParameters(IFramework iFramework) {
        this.framework = iFramework;
        this.experiment = iFramework.getData().getExperiment();
        GDMInitDialog gDMInitDialog = new GDMInitDialog(iFramework.getFrame());
        if (gDMInitDialog.showModal() != 0) {
            return null;
        }
        this.useGenes = gDMInitDialog.isUseGenes();
        this.displayInterval = this.useGenes ? gDMInitDialog.getDisplayInterval() : 1;
        AlgorithmData algorithmData = new AlgorithmData();
        algorithmData.addParam("gdm-genes", String.valueOf(this.useGenes));
        algorithmData.addParam("display-interval", String.valueOf(this.displayInterval));
        algorithmData.addParam("distance-factor", String.valueOf(1.0f));
        IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
        algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
        int n = iDistanceMenu.getDistanceFunction();
        if (n == 0) {
            n = 4;
        }
        algorithmData.addParam("distance-function", String.valueOf(n));
        algorithmData.addParam("name", "GDM");
        algorithmData.addParam("alg-type", "data-visualization");
        algorithmData.addParam("output-class", "single-output");
        String[] stringArray = new String[]{"Data Visualization"};
        algorithmData.addStringArray("output-nodes", stringArray);
        return algorithmData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework iFramework, AlgorithmData algorithmData, Experiment experiment) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block8: {
            this.framework = iFramework;
            Listener listener = new Listener();
            this.experiment = experiment;
            this.useGenes = algorithmData.getParams().getBoolean("gdm-genes");
            if (this.useGenes) {
                algorithmData.addMatrix("experiment", experiment.getMatrix());
            } else {
                algorithmData.addMatrix("experiment", experiment.getMatrix().transpose());
            }
            this.displayInterval = algorithmData.getParams().getInt("display-interval");
            int n = algorithmData.getParams().getInt("distance-function");
            try {
                int n2;
                this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("GDM");
                this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
                this.progress = new Progress(iFramework.getFrame(), "GDM Training", listener);
                this.progress.show();
                long l = System.currentTimeMillis();
                AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
                GeneralInfo generalInfo = new GeneralInfo();
                generalInfo.time = System.currentTimeMillis() - l;
                generalInfo.function = iFramework.getDistanceMenu().getFunctionName(n);
                if (this.useGenes) {
                    n2 = this.getMaxGeneNameLength();
                    algorithmData.addMatrix("experiment", experiment.getMatrix());
                    algorithmData2.addParam("maxGeneNameLength", String.valueOf(n2));
                } else {
                    n2 = this.getMaxExpNameLength();
                    algorithmData.addMatrix("experiment", experiment.getMatrix().transpose());
                    algorithmData2.addParam("maxExpNameLength", String.valueOf(n2));
                }
                defaultMutableTreeNode = this.createResultTree(algorithmData2, generalInfo);
                Object var12_11 = null;
                if (this.algorithm == null) break block8;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var12_12 = null;
                    if (this.algorithm != null) {
                        this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                    }
                    if (this.progress == null) break block9;
                    this.progress.dispose();
                }
                throw throwable;
            }
            this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
        }
        if (this.progress != null) {
            this.progress.dispose();
        }
        return defaultMutableTreeNode;
    }

    private int getMaxGeneNameLength() {
        int n = 0;
        int n2 = this.framework.getData().getExperiment().getNumberOfGenes();
        for (int i = 0; i < n2; ++i) {
            String string = this.framework.getData().getGeneName(i);
            n = Math.max(n, string.length());
        }
        return n;
    }

    private int getMaxExpNameLength() {
        int n = 0;
        int n2 = this.framework.getData().getExperiment().getNumberOfSamples();
        for (int i = 0; i < n2; ++i) {
            String string = this.framework.getData().getSampleName(i);
            n = Math.max(n, string.length());
        }
        return n;
    }

    private DefaultMutableTreeNode createResultTree(AlgorithmData algorithmData, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (this.useGenes) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("GDM - genes");
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Matrix View", (IViewer)new GDMGeneViewer(this.framework, algorithmData, generalInfo.function, this.displayInterval, null, 0))));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(generalInfo.function));
        } else {
            defaultMutableTreeNode = new DefaultMutableTreeNode("GDM - samples");
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Matrix View", (IViewer)new GDMExpViewer(this.framework, algorithmData, generalInfo.function, this.displayInterval, null, 0))));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(generalInfo.function));
        }
        return defaultMutableTreeNode;
    }

    private class GeneralInfo {
        public long time;
        public String function;

        private GeneralInfo() {
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            switch (algorithmEvent.getId()) {
                case 1: {
                    GDMGUI.this.progress.setUnits(algorithmEvent.getIntValue());
                    GDMGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 2: {
                    GDMGUI.this.progress.setValue(algorithmEvent.getIntValue());
                    GDMGUI.this.progress.setDescription(algorithmEvent.getDescription());
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                GDMGUI.this.algorithm.abort();
                GDMGUI.this.progress.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            GDMGUI.this.algorithm.abort();
            GDMGUI.this.progress.dispose();
        }
    }
}

