/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.tigr.util.awt.GBA;

public class GDMElementSizeDialog
extends JDialog {
    private int result;
    private Dimension size;
    private JLabel sizeLabel;
    private JTextField sizeTextField;
    private GBA gba;
    private final int maxSize = 30;

    public GDMElementSizeDialog(JFrame jFrame, Dimension dimension) {
        super((Frame)jFrame, true);
        this.setTitle("Set Element Size");
        this.gba = new GBA();
        this.sizeLabel = new JLabel("Element square size (max = 30): ");
        this.sizeTextField = new JTextField(10);
        this.sizeTextField.setText("" + dimension.width);
        JButton jButton = new JButton("Okay");
        jButton.setActionCommand("ok-command");
        jButton.addActionListener(new Listener());
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("cancel-command");
        jButton2.addActionListener(new Listener());
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        this.gba.add(container, (Component)this.sizeLabel, 0, 0, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(container, (Component)this.sizeTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(container, (Component)jButton2, 0, 2, 1, 1, 0, 0, 0, 17, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(container, (Component)jButton, 1, 2, 1, 1, 0, 0, 0, 13, new Insets(5, 5, 5, 5), 0, 0);
        this.setResizable(false);
        this.sizeTextField.grabFocus();
        this.getRootPane().setDefaultButton(jButton);
        this.pack();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public Dimension getElementSize() {
        return this.size;
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                String string2 = GDMElementSizeDialog.this.sizeTextField.getText();
                try {
                    int n = Integer.parseInt(string2);
                    if (n > 30) {
                        n = 30;
                    } else if (n < 1) {
                        n = 1;
                    }
                    GDMElementSizeDialog.this.size = new Dimension(n, n);
                    GDMElementSizeDialog.this.result = 0;
                }
                catch (Exception exception) {
                    GDMElementSizeDialog.this.result = 2;
                }
                GDMElementSizeDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                GDMElementSizeDialog.this.result = 2;
                GDMElementSizeDialog.this.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            GDMElementSizeDialog.this.result = -1;
            GDMElementSizeDialog.this.dispose();
        }
    }
}

