/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ease.gotree;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.LineMetrics;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.impl.ease.gotree.GONode;
import org.tigr.microarray.mev.cluster.gui.impl.ease.gotree.GOTreeViewer;

public class GOTreeHeader
extends JPanel {
    private GONode displayNode;
    private GOTreeViewer parent;
    private double lowerThr = 0.01;
    private double upperThr = 0.05;
    private String lowerStr = "0.01";
    private String upperStr = "0.05";
    private String nonsigStr = "";

    public GOTreeHeader(GONode gONode, GOTreeViewer gOTreeViewer, double d, double d2) {
        super.setBackground(Color.white);
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.displayNode = new GONode(gONode);
        this.displayNode.setRenderingHint(0);
        this.parent = gOTreeViewer;
        this.setThresholds(d, d2);
    }

    public void updateSize(int n, int n2) {
        this.setPreferredSize(new Dimension(n, n2));
        this.setSize(n, n2);
    }

    public void updateInfo(GONode gONode) {
        this.displayNode = gONode;
        this.displayNode.setRenderingHint(0);
        this.updateSize(this.parent.getViewerWidth(), this.displayNode.getHeight() + 10);
        this.repaint();
    }

    public void update() {
        this.displayNode.setRenderingHint(0);
        this.updateSize(this.parent.getViewerWidth(), this.displayNode.getHeight() + 10);
        this.repaint();
    }

    public void setThresholds(double d, double d2) {
        DecimalFormat decimalFormat;
        this.upperThr = d;
        this.lowerThr = d2;
        if (this.upperThr < 1.0E-4) {
            decimalFormat = new DecimalFormat("0.#####E00");
            this.upperStr = decimalFormat.format(this.upperThr);
        } else {
            decimalFormat = new DecimalFormat("0.#####");
            this.upperStr = decimalFormat.format(this.upperThr);
        }
        this.upperStr = "p <= " + this.upperStr + " ";
        if (this.lowerThr < 1.0E-4) {
            decimalFormat = new DecimalFormat("0.#####E00");
            this.lowerStr = decimalFormat.format(this.lowerThr);
        } else {
            decimalFormat = new DecimalFormat("0.#####");
            this.lowerStr = decimalFormat.format(this.lowerThr);
        }
        this.lowerStr = "p <= " + this.lowerStr + " ";
        if (this.upperThr < 1.0E-4) {
            decimalFormat = new DecimalFormat("0.#####E00");
            this.nonsigStr = decimalFormat.format(this.upperThr);
        } else {
            decimalFormat = new DecimalFormat("0.#####");
            this.nonsigStr = decimalFormat.format(this.upperThr);
        }
        this.nonsigStr = "p > " + this.nonsigStr;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = graphics.getClip().getBounds();
        this.displayNode.renderNode(graphics2D, 5, 5, 0);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        LineMetrics lineMetrics = fontMetrics.getLineMetrics(this.lowerStr, graphics);
        graphics.drawRect(5 + this.displayNode.getWidth() + 20, 5 + (int)lineMetrics.getHeight() - (int)lineMetrics.getAscent(), 30, (int)lineMetrics.getAscent());
        graphics.setColor(Color.red);
        graphics.fillRect(5 + this.displayNode.getWidth() + 20 + 1, 5 + (int)lineMetrics.getHeight() - (int)lineMetrics.getAscent() + 1, 29, (int)lineMetrics.getAscent() - 1);
        graphics.setColor(Color.black);
        graphics.drawString(this.lowerStr, 5 + this.displayNode.getWidth() + 55, 5 + (int)lineMetrics.getHeight());
        lineMetrics = fontMetrics.getLineMetrics(this.upperStr, graphics);
        graphics.drawRect(5 + this.displayNode.getWidth() + 20, 5 + 2 * (int)lineMetrics.getHeight() - (int)lineMetrics.getAscent() + 20, 30, (int)lineMetrics.getAscent());
        graphics.setColor(Color.orange);
        graphics.fillRect(5 + this.displayNode.getWidth() + 20 + 1, 5 + 2 * (int)lineMetrics.getHeight() - (int)lineMetrics.getAscent() + 20 + 1, 29, (int)lineMetrics.getAscent() - 1);
        graphics.setColor(Color.black);
        graphics.drawString(this.upperStr, 5 + this.displayNode.getWidth() + 55, 5 + 2 * (int)lineMetrics.getHeight() + 20);
        lineMetrics = fontMetrics.getLineMetrics(this.nonsigStr, graphics);
        graphics.drawRect(5 + this.displayNode.getWidth() + 20, 5 + 3 * (int)lineMetrics.getHeight() - (int)lineMetrics.getAscent() + 40, 30, (int)lineMetrics.getAscent());
        graphics.setColor(Color.green);
        graphics.fillRect(5 + this.displayNode.getWidth() + 20 + 1, 5 + 3 * (int)lineMetrics.getHeight() - (int)lineMetrics.getAscent() + 40 + 1, 29, (int)lineMetrics.getAscent() - 1);
        graphics.setColor(Color.black);
        graphics.drawString(this.nonsigStr, 5 + this.displayNode.getWidth() + 55, 5 + 3 * (int)lineMetrics.getHeight() + 40);
    }
}

