/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ease;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;

public class EASEExperimentViewer
extends ExperimentViewer {
    private JPopupMenu popup;

    public EASEExperimentViewer(Experiment experiment, int[][] nArray) {
        super(experiment, nArray);
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
        this.getHeaderComponent().addMouseListener(listener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
        this.getHeaderComponent().addMouseListener(listener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveClusters(frame);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveCluster(frame);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSetColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color color = JColorChooser.showDialog(frame, "Choose color", CentroidViewer.DEF_CLUSTER_COLOR);
        if (color != null) {
            this.setClusterColor(color);
        }
    }

    private void onSetDefaultColor() {
        this.setClusterColor(null);
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("save-cluster-cmd")) {
                EASEExperimentViewer.this.onSaveCluster();
            } else if (string.equals("save-all-clusters-cmd")) {
                EASEExperimentViewer.this.onSaveClusters();
            } else if (string.equals("store-cluster-cmd")) {
                EASEExperimentViewer.this.storeCluster();
            } else if (string.equals("set-def-color-cmd")) {
                EASEExperimentViewer.this.onSetDefaultColor();
            } else if (string.equals("launch-new-session-cmd")) {
                EASEExperimentViewer.this.launchNewSession();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() || EASEExperimentViewer.this.getCluster() == null || EASEExperimentViewer.this.getCluster().length == 0) {
                return;
            }
            EASEExperimentViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

