/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dialogs.normalization;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class IterativeLogMCNormInitDialog
extends AlgorithmDialog {
    private JComboBox sdComboBox;
    private int result = 2;
    private final String[] SD_VALUES = new String[]{"+/-0.50 SD", "+/-1.00 SD", "+/-1.50 SD", "+/-1.96 SD", "+/-2.00 SD", "+/-2.50 SD", "+/-3.00 SD"};

    public IterativeLogMCNormInitDialog() {
        super(new JFrame(), "Iterative Log Mean Centering Normalization", true);
        this.sdComboBox = new JComboBox<String>(this.SD_VALUES);
        this.sdComboBox.setEditable(false);
        this.sdComboBox.setSelectedIndex(4);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Standard Deviation Range"));
        jPanel.add((Component)this.sdComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(30, 0, 30, 0), 0, 0));
        this.addContent(jPanel);
        this.setActionListeners(new Listener());
        this.setSize(new Dimension(450, 220));
        this.setResizable(false);
        this.pack();
    }

    public float getSD() {
        float f = 0.0f;
        String string = (String)this.sdComboBox.getSelectedItem();
        string = string.substring(3, 7);
        try {
            f = Float.parseFloat(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        this.dispose();
        return this.result;
    }

    public static void main(String[] stringArray) {
        IterativeLogMCNormInitDialog iterativeLogMCNormInitDialog = new IterativeLogMCNormInitDialog();
        iterativeLogMCNormInitDialog.show();
        System.out.println("SD = " + iterativeLogMCNormInitDialog.getSD());
        System.exit(0);
    }

    public class Listener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                IterativeLogMCNormInitDialog.this.result = 0;
                IterativeLogMCNormInitDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                IterativeLogMCNormInitDialog.this.sdComboBox.setSelectedIndex(4);
            } else if (string.equals("cancel-command")) {
                IterativeLogMCNormInitDialog.this.result = 2;
                IterativeLogMCNormInitDialog.this.dispose();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(IterativeLogMCNormInitDialog.this, "Iterative Log Mean Centering Initialization Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(480, 555);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                }
            }
        }
    }
}

