/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.BevelBorder;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;

public class Progress
extends JDialog {
    private JProgressBar progress;
    private JLabel description = new JLabel();
    private static final String DESCRIPTION = "Description: ";

    public Progress(Frame frame, String string, DialogListener dialogListener) {
        super(frame, string);
        this.setDescription("");
        this.progress = new JProgressBar();
        this.progress.setStringPainted(true);
        JPanel jPanel = this.createProgressPanel(this.description, this.progress);
        jPanel.setBackground(Color.white);
        JPanel jPanel2 = this.createBtnsPanel(dialogListener);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)new HeaderImagePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        container.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 0, 3), 0, 0));
        container.add((Component)jPanel2, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(4, 8, 4, 8), 0, 0));
        this.addWindowListener(dialogListener);
        this.setResizable(false);
        this.pack();
    }

    public void show() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.show();
    }

    public void setUnits(int n) {
        this.progress.setMaximum(n);
    }

    public void setValue(int n) {
        this.progress.setValue(n);
    }

    public void setDescription(String string) {
        if (string == null) {
            string = "";
        }
        this.description.setText(DESCRIPTION + string);
    }

    public static void main(String[] stringArray) {
        Progress progress = new Progress(new Frame(), "Test Progress", null);
        progress.show();
    }

    private JPanel createProgressPanel(JLabel jLabel, JProgressBar jProgressBar) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new BevelBorder(1));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jProgressBar, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel.setPreferredSize(new Dimension(400, 65));
        return jPanel;
    }

    private JPanel createBtnsPanel(ActionListener actionListener) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JButton jButton = new JButton("Cancel");
        jButton.setBorder(BorderFactory.createBevelBorder(0, new Color(240, 240, 240), new Color(180, 180, 180), new Color(10, 0, 0), new Color(10, 10, 10)));
        jButton.setPreferredSize(new Dimension(80, 25));
        jButton.setActionCommand("cancel-command");
        jButton.addActionListener(actionListener);
        jButton.setFocusPainted(false);
        jPanel.add((Component)jButton, "Center");
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    public class FillPanel
    extends JPanel {
        GradientPaint gp;
        Color backgroundColor = new Color(25, 25, 169);
        Color fadeColor = new Color(140, 220, 240);

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getSize();
            this.gp = new GradientPaint(0.0f, dimension.height / 2, this.backgroundColor, dimension.width, dimension.height / 2, this.fadeColor);
            graphics2D.setPaint(this.gp);
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
            graphics2D.setColor(Color.black);
        }
    }

    public class HeaderImagePanel
    extends JPanel {
        public HeaderImagePanel() {
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel(GUIFactory.getIcon("dialog_banner2.gif"));
            jLabel.setOpaque(false);
            jLabel.setAlignmentX(0.0f);
            FillPanel fillPanel = new FillPanel();
            fillPanel.setBackground(Color.blue);
            this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)fillPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }
}

