/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DistanceMetricPanel
extends JPanel {
    private JCheckBox absBox;
    private JComboBox metricBox;
    private String globalFunctionName;
    private boolean globalAbsoluteValue;
    private ActionListener listener;

    public DistanceMetricPanel(String string, boolean bl, String string2, String string3, boolean bl2, boolean bl3) {
        super(new GridBagLayout());
        this.globalAbsoluteValue = bl;
        this.globalFunctionName = string;
        if (bl3) {
            this.setBackground(Color.white);
        }
        if (bl2) {
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), "Distance Metric Selection"));
        }
        JLabel jLabel = new JLabel("Current Global Metric: " + string);
        JLabel jLabel2 = new JLabel("Current Metric: ");
        this.absBox = new JCheckBox("Use Absolute Distance", bl);
        this.absBox.setOpaque(false);
        this.absBox.setFocusPainted(false);
        Vector vector = this.buildMetricVector();
        this.metricBox = new JComboBox(vector);
        this.metricBox.addActionListener(new Listener());
        if (string.equals("not defined")) {
            this.setMetricSelection(string2);
        } else {
            this.setMetricSelection(string);
        }
        this.metricBox.addActionListener(new Listener());
        this.enableAbsolute(string);
        JLabel jLabel3 = new JLabel("(The default distance metric for " + string3 + " is " + string2 + ")");
        this.add((Component)jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.metricBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jLabel3, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.absBox, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
    }

    public int getMetricIndex() {
        DistanceMetric distanceMetric = (DistanceMetric)this.metricBox.getSelectedItem();
        return distanceMetric.getIndex();
    }

    public boolean getAbsoluteSelection() {
        return this.absBox.isSelected();
    }

    public void reset() {
        this.setMetricSelection(this.globalFunctionName);
        this.enableAbsolute(this.globalFunctionName);
        this.absBox.setSelected(this.globalAbsoluteValue);
    }

    private Vector buildMetricVector() {
        Vector<DistanceMetric> vector = new Vector<DistanceMetric>();
        vector.addElement(new DistanceMetric("Euclidean Distance", 4));
        vector.addElement(new DistanceMetric("Manhattan Distance", 8));
        vector.addElement(new DistanceMetric("Average Dot Product", 5));
        vector.addElement(new DistanceMetric("Pearson Correlation", 1));
        vector.addElement(new DistanceMetric("Pearson Uncentered", 6));
        vector.addElement(new DistanceMetric("Pearson Squared", 7));
        vector.addElement(new DistanceMetric("Cosine Correlation", 2));
        vector.addElement(new DistanceMetric("Covariance Value", 3));
        vector.addElement(new DistanceMetric("Spearman Rank Correlation", 9));
        vector.addElement(new DistanceMetric("Kendall's Tau", 10));
        vector.addElement(new DistanceMetric("Mutual Information", 11));
        return vector;
    }

    private void enableAbsolute(String string) {
        if (string.equals("Pearson Correlation") || string.equals("Pearson Uncentered") || string.equals("Cosine Correlation") || string.equals("Average Dot Product")) {
            this.absBox.setEnabled(true);
        } else {
            this.absBox.setEnabled(false);
        }
    }

    private void setMetricSelection(String string) {
        for (int i = 0; i < this.metricBox.getItemCount(); ++i) {
            if (!((DistanceMetric)this.metricBox.getItemAt(i)).toString().equals(string)) continue;
            this.metricBox.setSelectedIndex(i);
            break;
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listener = actionListener;
    }

    private void fireActionEvent() {
        ActionEvent actionEvent = new ActionEvent(this, 0, "distance_metric_selection_command");
        this.listener.actionPerformed(actionEvent);
    }

    public static void main(String[] stringArray) {
        DistanceMetricPanel distanceMetricPanel = new DistanceMetricPanel("Pearson Correlation", true, "Euclidean Distance", "HCL", true, true);
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(distanceMetricPanel);
        jFrame.setSize(400, 200);
        jFrame.setVisible(true);
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DistanceMetricPanel.this.enableAbsolute(((DistanceMetric)DistanceMetricPanel.this.metricBox.getSelectedItem()).toString());
            if (DistanceMetricPanel.this.listener != null) {
                DistanceMetricPanel.this.fireActionEvent();
            }
        }
    }

    private class DistanceMetric {
        private String name;
        private int index;

        public DistanceMetric(String string, int n) {
            this.name = string;
            this.index = n;
        }

        public String toString() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

