/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dam;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class DAMProcessInitDialog
extends AlgorithmDialog {
    int result = 2;
    boolean skipGeneScreeningStep = false;
    boolean skipCrossValidationStep = false;
    private SampleSelectionPanel sampleSelectionPanel;
    private JPanel processPanel;
    private JPanel KPanel;
    private JRadioButton defKbutton;
    private JRadioButton calcKbutton;
    private JCheckBox skipGeneScreenBox;
    private JCheckBox skipCrossValBox;
    private ButtonGroup Kselection;

    public DAMProcessInitDialog(Frame frame, boolean bl) {
        super(frame, "DAM Process Initialization", bl);
        this.okButton.setText("Next");
        Listener listener = new Listener();
        this.initComponents(listener);
        this.setActionListeners(listener);
        this.pack();
        this.setResizable(false);
    }

    private void initComponents(Listener listener) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        this.setBackground(Color.lightGray);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DAMProcessInitDialog.this.closeDialog(windowEvent);
            }
        });
        this.processPanel = new JPanel(new GridBagLayout());
        this.processPanel.setBorder(new TitledBorder(new EtchedBorder(0), "DAM Process Selection", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.processPanel.setBackground(Color.white);
        this.skipGeneScreenBox = new JCheckBox("Skip Gene Screening step (ANOVA)");
        this.skipGeneScreenBox.setFocusPainted(false);
        this.skipGeneScreenBox.setBackground(Color.white);
        this.skipGeneScreenBox.setForeground(UIManager.getColor("Label.foreground"));
        this.skipGeneScreenBox.addItemListener(listener);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 60, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.processPanel.add((Component)this.skipGeneScreenBox, gridBagConstraints);
        this.skipCrossValBox = new JCheckBox("Skip Cross Validation step (LOOCV)");
        this.skipCrossValBox.setFocusPainted(false);
        this.skipCrossValBox.setBackground(Color.white);
        this.skipCrossValBox.setForeground(UIManager.getColor("Label.foreground"));
        this.skipCrossValBox.addItemListener(listener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 60, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.processPanel.add((Component)this.skipCrossValBox, gridBagConstraints);
        this.KPanel = new JPanel(new GridBagLayout());
        this.KPanel.setBorder(new TitledBorder(new EtchedBorder(0), "Determining K value", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.KPanel.setBackground(Color.white);
        this.Kselection = new ButtonGroup();
        this.defKbutton = new JRadioButton();
        this.calcKbutton = new JRadioButton();
        this.defKbutton.setToolTipText("Use default K = 3");
        this.defKbutton.setSelected(true);
        this.defKbutton.setText("Default");
        this.defKbutton.setBackground(Color.white);
        this.defKbutton.setForeground(UIManager.getColor("Label.foreground"));
        this.Kselection.add(this.defKbutton);
        this.defKbutton.setFocusPainted(false);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 40, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        this.KPanel.add((Component)this.defKbutton, gridBagConstraints2);
        this.calcKbutton.setToolTipText("Calculate optimum K from loaded data");
        this.calcKbutton.setText("Calculate");
        this.calcKbutton.setBackground(Color.white);
        this.calcKbutton.setForeground(UIManager.getColor("Label.foreground"));
        this.Kselection.add(this.calcKbutton);
        this.calcKbutton.setFocusPainted(false);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 40, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        this.KPanel.add((Component)this.calcKbutton, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(4, 0, 0, 0);
        jPanel.add((Component)this.processPanel, gridBagConstraints3);
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(4, 0, 0, 0);
        jPanel.add((Component)this.KPanel, gridBagConstraints3);
        this.addContent(jPanel);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public static void main(String[] stringArray) {
        new DAMProcessInitDialog((Frame)new JFrame(), true).show();
        System.exit(0);
    }

    public boolean getSkipGeneSelectionValue() {
        return this.skipGeneScreenBox.isSelected();
    }

    public boolean getSkipLOOCVValue() {
        return this.skipCrossValBox.isSelected();
    }

    private class Listener
    extends DialogListener
    implements ItemListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                DAMProcessInitDialog.this.result = 0;
                DAMProcessInitDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                DAMProcessInitDialog.this.result = 2;
                DAMProcessInitDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                DAMProcessInitDialog.this.skipGeneScreeningStep = false;
                DAMProcessInitDialog.this.skipCrossValidationStep = false;
                DAMProcessInitDialog.this.skipGeneScreenBox.setSelected(false);
                DAMProcessInitDialog.this.skipCrossValBox.setSelected(false);
                DAMProcessInitDialog.this.defKbutton.setSelected(true);
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(DAMProcessInitDialog.this, "DAM Process Initialization Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 650);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemSelectable == DAMProcessInitDialog.this.skipGeneScreenBox) {
                DAMProcessInitDialog.this.skipGeneScreeningStep = DAMProcessInitDialog.this.skipGeneScreenBox.isSelected();
            } else if (itemSelectable == DAMProcessInitDialog.this.skipCrossValBox) {
                DAMProcessInitDialog.this.skipCrossValidationStep = DAMProcessInitDialog.this.skipCrossValBox.isSelected();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            DAMProcessInitDialog.this.result = -1;
            DAMProcessInitDialog.this.dispose();
        }
    }
}

