/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dam;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAM3DViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMClassificationEditor;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Logger;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.util.FloatMatrix;

public class DAMGUI
implements IClusterGUI {
    private Experiment experiment;
    private Experiment unusedExperiment;
    private Experiment usedExperiment;
    private Algorithm algorithm;
    private Progress progress;
    private IFramework framework;
    private float minDist;
    private float maxDist;
    private int num_genes;
    private int mode;
    public static int A0 = 0;
    public static int A1 = 1;
    public static int A2 = 2;
    public static int A3 = 3;
    private FloatMatrix matrix3D;
    private FloatMatrix matrixS;
    private Logger logger;
    private int algorithmSelection = 0;
    private int classificationSelection = 0;
    private boolean isPDA;
    private boolean preSelectGenes;
    private int numberOfClasses;
    private int kValue;
    private double alpha;
    private IData iData;
    DAMClassificationEditor damClassEditor;
    Vector[] classificationVector;
    int[] trainingIndices;
    int[] testIndices;
    int[] classes;
    int[] columns;
    int[] rows;
    int[] usedGeneIndices;
    int[] unusedGeneIndices;
    boolean classifyGenes = false;
    private int[][] clusters;
    private int[][] geneClusters;
    private FloatMatrix means;
    private FloatMatrix means_used;
    private FloatMatrix means_unused;
    private FloatMatrix variances;
    private FloatMatrix variances_used;
    private FloatMatrix variances_unused;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Listener listener;
        block29: {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            block28: {
                DefaultMutableTreeNode defaultMutableTreeNode3;
                block26: {
                    block27: {
                        this.framework = iFramework;
                        this.experiment = iFramework.getData().getExperiment();
                        this.iData = iFramework.getData();
                        listener = new Listener();
                        try {
                            int n;
                            int n2;
                            DAMInitDialog dAMInitDialog = new DAMInitDialog(iFramework.getFrame(), true);
                            if (dAMInitDialog.showModal() != 0) {
                                defaultMutableTreeNode3 = null;
                                Object var23_6 = null;
                                if (this.algorithm == null) break block26;
                                break block27;
                            }
                            this.classifyGenes = dAMInitDialog.isEvaluateGenesSelected();
                            this.algorithmSelection = dAMInitDialog.getAssessmentSelection();
                            this.isPDA = dAMInitDialog.isPDASelected();
                            this.numberOfClasses = dAMInitDialog.getNumClasses();
                            this.kValue = dAMInitDialog.getKValue();
                            this.alpha = dAMInitDialog.getAlphaValue();
                            this.preSelectGenes = !dAMInitDialog.getSkipGeneSelectionValue();
                            DAMClassificationEditor dAMClassificationEditor = new DAMClassificationEditor(iFramework, this.classifyGenes, this.numberOfClasses);
                            dAMClassificationEditor.setVisible(true);
                            while (!dAMClassificationEditor.isNextPressed()) {
                                if (!dAMClassificationEditor.isCancelPressed()) continue;
                                defaultMutableTreeNode2 = null;
                                break block28;
                            }
                            AlgorithmData algorithmData = new AlgorithmData();
                            boolean bl = dAMInitDialog.isEvaluateGenesSelected();
                            if (bl) {
                                this.mode = 1;
                                algorithmData.addParam("dam-mode", "1");
                            } else {
                                this.mode = 3;
                                algorithmData.addParam("dam-mode", "3");
                            }
                            this.classificationVector = dAMClassificationEditor.getClassification();
                            this.trainingIndices = new int[this.classificationVector[0].size()];
                            this.classes = new int[this.classificationVector[1].size()];
                            this.testIndices = new int[this.classificationVector[2].size()];
                            for (n2 = 0; n2 < this.trainingIndices.length; ++n2) {
                                this.trainingIndices[n2] = (Integer)this.classificationVector[0].get(n2);
                                this.classes[n2] = (Integer)this.classificationVector[1].get(n2);
                            }
                            for (n2 = 0; n2 < this.testIndices.length; ++n2) {
                                this.testIndices[n2] = (Integer)this.classificationVector[2].get(n2);
                            }
                            this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("DAM");
                            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
                            this.logger = new Logger(iFramework.getFrame(), "DAM Log Window", listener);
                            this.logger.show();
                            this.logger.append("Starting DAM calculation\n");
                            Experiment experiment = iFramework.getData().getExperiment();
                            if (this.classifyGenes) {
                                algorithmData.addMatrix("experiment", experiment.getMatrix().transpose());
                            } else {
                                algorithmData.addMatrix("experiment", experiment.getMatrix());
                            }
                            algorithmData.addParam("distance-factor", String.valueOf(1.0f));
                            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
                            algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
                            algorithmData.addParam("algorithmSelection", String.valueOf(this.algorithmSelection));
                            algorithmData.addParam("isPDA", String.valueOf(this.isPDA));
                            algorithmData.addParam("preSelectGenes", String.valueOf(this.preSelectGenes));
                            algorithmData.addParam("numberOfClasses", String.valueOf(this.numberOfClasses));
                            algorithmData.addParam("kValue", String.valueOf(this.kValue));
                            algorithmData.addParam("alpha", String.valueOf(this.alpha));
                            algorithmData.addIntArray("trainingIndices", this.trainingIndices);
                            algorithmData.addIntArray("classes", this.classes);
                            algorithmData.addIntArray("testIndices", this.testIndices);
                            int n3 = iDistanceMenu.getDistanceFunction();
                            if (n3 == 0) {
                                n3 = 3;
                            }
                            algorithmData.addParam("distance-function", String.valueOf(n3));
                            algorithmData.addParam("dam-mode", String.valueOf(this.mode));
                            AlgorithmData algorithmData2 = null;
                            DefaultMutableTreeNode defaultMutableTreeNode4 = null;
                            long l = System.currentTimeMillis();
                            switch (this.mode) {
                                case 1: {
                                    algorithmData.addParam("distance-function", String.valueOf(n3));
                                    algorithmData2 = this.algorithm.execute(algorithmData);
                                    this.matrixS = algorithmData2.getMatrix("S");
                                    this.matrix3D = algorithmData2.getMatrix("matrix3D");
                                    this.usedGeneIndices = algorithmData2.getIntArray("usedGeneIndices");
                                    this.unusedGeneIndices = algorithmData2.getIntArray("unusedGeneIndices");
                                    defaultMutableTreeNode4 = new DefaultMutableTreeNode("DAM - genes");
                                    break;
                                }
                                case 3: {
                                    algorithmData2 = this.algorithm.execute(algorithmData);
                                    this.matrixS = algorithmData2.getMatrix("S");
                                    this.matrix3D = algorithmData2.getMatrix("matrix3D");
                                    this.usedGeneIndices = algorithmData2.getIntArray("usedGeneIndices");
                                    this.unusedGeneIndices = algorithmData2.getIntArray("unusedGeneIndices");
                                    defaultMutableTreeNode4 = new DefaultMutableTreeNode("DAM - samples");
                                    break;
                                }
                            }
                            Cluster cluster = algorithmData2.getCluster("cluster");
                            NodeList nodeList = cluster.getNodeList();
                            int n4 = this.numberOfClasses * 3;
                            this.clusters = new int[n4][];
                            System.out.println(" ");
                            for (int i = 0; i < n4; ++i) {
                                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
                            }
                            Cluster cluster2 = algorithmData2.getCluster("geneCluster");
                            nodeList = cluster2.getNodeList();
                            this.geneClusters = new int[2][];
                            System.out.println(" ");
                            for (n = 0; n < 2; ++n) {
                                this.geneClusters[n] = nodeList.getNode(n).getFeaturesIndexes();
                            }
                            this.means = algorithmData2.getMatrix("clusters_means");
                            this.variances = algorithmData2.getMatrix("clusters_variances");
                            this.means_used = algorithmData2.getMatrix("clusters_means_used");
                            this.variances_used = algorithmData2.getMatrix("clusters_variances_used");
                            this.means_unused = algorithmData2.getMatrix("clusters_means_unused");
                            this.variances_unused = algorithmData2.getMatrix("clusters_variances_unused");
                            this.columns = new int[experiment.getMatrix().getColumnDimension()];
                            for (n = 0; n < this.columns.length; ++n) {
                                this.columns[n] = n;
                            }
                            this.rows = new int[experiment.getMatrix().getRowDimension()];
                            for (n = 0; n < this.rows.length; ++n) {
                                this.rows[n] = n;
                            }
                            if (this.classifyGenes) {
                                this.usedExperiment = new Experiment(experiment.getMatrix().getMatrix(this.rows, this.usedGeneIndices), this.usedGeneIndices, this.rows);
                                this.unusedExperiment = new Experiment(experiment.getMatrix().getMatrix(this.rows, this.unusedGeneIndices), this.unusedGeneIndices, this.rows);
                            } else {
                                this.usedExperiment = new Experiment(experiment.getMatrix().getMatrix(this.usedGeneIndices, this.columns), this.columns, this.usedGeneIndices);
                                this.unusedExperiment = new Experiment(experiment.getMatrix().getMatrix(this.unusedGeneIndices, this.columns), this.columns, this.unusedGeneIndices);
                            }
                            this.logger.append("Creating the result viewers\n");
                            long l2 = System.currentTimeMillis() - l;
                            if (this.algorithmSelection == A3) {
                                this.addClassificationResultNodes(iFramework.getFrame(), defaultMutableTreeNode4, l2, iDistanceMenu.getFunctionName(n3), experiment);
                            } else {
                                this.addValidationResultNodes(iFramework.getFrame(), defaultMutableTreeNode4, l2, iDistanceMenu.getFunctionName(n3), experiment);
                            }
                            defaultMutableTreeNode = defaultMutableTreeNode4;
                            break block29;
                        }
                        catch (Throwable throwable) {
                            Object var23_9 = null;
                            if (this.algorithm != null) {
                                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                            }
                            if (this.logger == null) throw throwable;
                            this.logger.dispose();
                            throw throwable;
                        }
                    }
                    this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                }
                if (this.logger == null) return defaultMutableTreeNode3;
                this.logger.dispose();
                return defaultMutableTreeNode3;
            }
            Object var23_7 = null;
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.logger == null) return defaultMutableTreeNode2;
            this.logger.dispose();
            return defaultMutableTreeNode2;
        }
        Object var23_8 = null;
        if (this.algorithm != null) {
            this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
        }
        if (this.logger == null) return defaultMutableTreeNode;
        this.logger.dispose();
        return defaultMutableTreeNode;
    }

    private void addClassificationResultNodes(Frame frame, DefaultMutableTreeNode defaultMutableTreeNode, long l, String string, Experiment experiment) {
        this.addExpressionImages(defaultMutableTreeNode);
        this.addCentroidViews(defaultMutableTreeNode);
        this.addTableViews(defaultMutableTreeNode);
        this.add3DViewNode(frame, defaultMutableTreeNode, experiment);
        this.addClusterInfo(defaultMutableTreeNode);
        this.addGeneralInfoNode(defaultMutableTreeNode, l, string);
    }

    private void addValidationResultNodes(Frame frame, DefaultMutableTreeNode defaultMutableTreeNode, long l, String string, Experiment experiment) {
        this.addExpressionImages(defaultMutableTreeNode);
        this.addCentroidViews(defaultMutableTreeNode);
        this.addTableViews(defaultMutableTreeNode);
        this.add3DViewNode(frame, defaultMutableTreeNode, experiment);
        this.addClusterInfo(defaultMutableTreeNode);
        this.addGeneralInfoNode(defaultMutableTreeNode, l, string);
    }

    private void addTableViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Table views");
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[3];
        defaultMutableTreeNodeArray[0] = new DefaultMutableTreeNode("Classifiers");
        if (this.algorithmSelection != A3) {
            defaultMutableTreeNodeArray[1] = new DefaultMutableTreeNode("Initial Classification");
            defaultMutableTreeNodeArray[2] = new DefaultMutableTreeNode("Validation Classification");
        } else {
            defaultMutableTreeNodeArray[1] = new DefaultMutableTreeNode("Classified");
            defaultMutableTreeNodeArray[2] = new DefaultMutableTreeNode("Classifiers + Classified");
        }
        Object object = this.classifyGenes ? new ClusterTableViewer(this.experiment, this.clusters, this.iData) : new ExperimentClusterTableViewer(this.experiment, this.clusters, this.iData);
        for (n = 0; n < this.numberOfClasses; ++n) {
            defaultMutableTreeNodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1), (IViewer)object, (Object)new Integer(n))));
        }
        for (n = this.numberOfClasses; n < 2 * this.numberOfClasses; ++n) {
            defaultMutableTreeNodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - this.numberOfClasses), (IViewer)object, (Object)new Integer(n))));
        }
        for (n = 2 * this.numberOfClasses; n < 3 * this.numberOfClasses; ++n) {
            defaultMutableTreeNodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 2 * this.numberOfClasses), (IViewer)object, (Object)new Integer(n))));
        }
        for (n = 0; n < defaultMutableTreeNodeArray.length; ++n) {
            defaultMutableTreeNode2.add(defaultMutableTreeNodeArray[n]);
        }
        object = this.classifyGenes ? new ClusterTableViewer(this.experiment, this.clusters, this.iData) : new ExperimentClusterTableViewer(this.experiment, this.clusters, this.iData);
        if (this.preSelectGenes) {
            DefaultMutableTreeNode defaultMutableTreeNode3;
            DefaultMutableTreeNode defaultMutableTreeNode4;
            if (this.classifyGenes) {
                ExperimentClusterTableViewer experimentClusterTableViewer = new ExperimentClusterTableViewer(this.experiment, this.geneClusters, this.iData);
                defaultMutableTreeNode4 = new DefaultMutableTreeNode(new LeafInfo("Used Exp Table View", (IViewer)experimentClusterTableViewer, (Object)new Integer(0)));
                defaultMutableTreeNode3 = new DefaultMutableTreeNode(new LeafInfo("Unused Exp Table View", (IViewer)experimentClusterTableViewer, (Object)new Integer(1)));
            } else {
                ClusterTableViewer clusterTableViewer = new ClusterTableViewer(this.experiment, this.geneClusters, this.iData);
                defaultMutableTreeNode4 = new DefaultMutableTreeNode(new LeafInfo("Used Gene Table View", (IViewer)clusterTableViewer, (Object)new Integer(0)));
                defaultMutableTreeNode3 = new DefaultMutableTreeNode(new LeafInfo("Unused Gene Table View", (IViewer)clusterTableViewer, (Object)new Integer(1)));
            }
            defaultMutableTreeNode2.add(defaultMutableTreeNode4);
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void add3DViewNode(Frame frame, DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment) {
        if (this.matrix3D == null || this.matrix3D.getColumnDimension() < 3) {
            return;
        }
        DAM3DViewer dAM3DViewer = this.mode == 1 ? new DAM3DViewer(frame, this.mode, this.matrix3D, experiment, true) : new DAM3DViewer(frame, this.mode, this.matrix3D, experiment, false);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Gene Component 3D view", (IViewer)dAM3DViewer, dAM3DViewer.getJPopupMenu())));
    }

    private void addGeneralInfoNode(DefaultMutableTreeNode defaultMutableTreeNode, long l, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        if (this.matrixS != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Components: " + this.matrixS.getColumnDimension()));
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(l) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(string));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[3];
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray2 = new DefaultMutableTreeNode[3];
        defaultMutableTreeNodeArray[0] = new DefaultMutableTreeNode("Classifiers");
        defaultMutableTreeNodeArray[1] = new DefaultMutableTreeNode("Classified");
        defaultMutableTreeNodeArray[2] = new DefaultMutableTreeNode("Classifiers + Classified");
        defaultMutableTreeNodeArray2[0] = new DefaultMutableTreeNode("Classifiers");
        defaultMutableTreeNodeArray2[1] = new DefaultMutableTreeNode("Classified");
        defaultMutableTreeNodeArray2[2] = new DefaultMutableTreeNode("Classifiers + Classified");
        if (this.classifyGenes) {
            int n;
            DAMCentroidViewer dAMCentroidViewer = new DAMCentroidViewer(this.experiment, this.clusters);
            dAMCentroidViewer.setMeans(this.means.A);
            dAMCentroidViewer.setVariances(this.variances.A);
            for (n = 0; n < this.numberOfClasses; ++n) {
                defaultMutableTreeNodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1), (IViewer)dAMCentroidViewer, (Object)new CentroidUserObject(n, 0))));
                defaultMutableTreeNodeArray2[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1), (IViewer)dAMCentroidViewer, (Object)new CentroidUserObject(n, 1))));
            }
            for (n = this.numberOfClasses; n < 2 * this.numberOfClasses; ++n) {
                defaultMutableTreeNodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - this.numberOfClasses), (IViewer)dAMCentroidViewer, (Object)new CentroidUserObject(n, 0))));
                defaultMutableTreeNodeArray2[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - this.numberOfClasses), (IViewer)dAMCentroidViewer, (Object)new CentroidUserObject(n, 1))));
            }
            for (n = 2 * this.numberOfClasses; n < 3 * this.numberOfClasses; ++n) {
                defaultMutableTreeNodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 2 * this.numberOfClasses), (IViewer)dAMCentroidViewer, (Object)new CentroidUserObject(n, 0))));
                defaultMutableTreeNodeArray2[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 2 * this.numberOfClasses), (IViewer)dAMCentroidViewer, (Object)new CentroidUserObject(n, 1))));
            }
            DAMCentroidsViewer dAMCentroidsViewer = new DAMCentroidsViewer(this.experiment, this.clusters);
            dAMCentroidsViewer.setMeans(this.means.A);
            dAMCentroidsViewer.setVariances(this.variances.A);
            for (int i = 0; i < defaultMutableTreeNodeArray.length; ++i) {
                defaultMutableTreeNode2.add(defaultMutableTreeNodeArray[i]);
                defaultMutableTreeNode3.add(defaultMutableTreeNodeArray2[i]);
            }
            DAMExperimentCentroidViewer dAMExperimentCentroidViewer = new DAMExperimentCentroidViewer(this.experiment, this.geneClusters);
            dAMExperimentCentroidViewer.setMeans(this.means_used.A);
            dAMExperimentCentroidViewer.setVariances(this.variances_used.A);
            if (this.preSelectGenes) {
                DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new LeafInfo("Used Exp Centroid Graph", (IViewer)dAMExperimentCentroidViewer, (Object)new CentroidUserObject(0, 0)));
                DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new LeafInfo("Used Exp Expression Graph ", (IViewer)dAMExperimentCentroidViewer, (Object)new CentroidUserObject(0, 1)));
                DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new LeafInfo("Unused Exp Centroid Graph", (IViewer)dAMExperimentCentroidViewer, (Object)new CentroidUserObject(1, 0)));
                DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(new LeafInfo("Unused Exp Expression Graph ", (IViewer)dAMExperimentCentroidViewer, (Object)new CentroidUserObject(1, 1)));
                defaultMutableTreeNode2.add(defaultMutableTreeNode4);
                defaultMutableTreeNode3.add(defaultMutableTreeNode5);
                defaultMutableTreeNode2.add(defaultMutableTreeNode6);
                defaultMutableTreeNode3.add(defaultMutableTreeNode7);
            }
        } else {
            int n;
            DAMExperimentCentroidViewer dAMExperimentCentroidViewer = new DAMExperimentCentroidViewer(this.experiment, this.clusters);
            dAMExperimentCentroidViewer.setMeans(this.means.A);
            dAMExperimentCentroidViewer.setVariances(this.variances.A);
            for (n = 0; n < this.numberOfClasses; ++n) {
                defaultMutableTreeNodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1), (IViewer)dAMExperimentCentroidViewer, (Object)new CentroidUserObject(n, 0))));
                defaultMutableTreeNodeArray2[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1), (IViewer)dAMExperimentCentroidViewer, (Object)new CentroidUserObject(n, 1))));
            }
            for (n = this.numberOfClasses; n < 2 * this.numberOfClasses; ++n) {
                defaultMutableTreeNodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - this.numberOfClasses), (IViewer)dAMExperimentCentroidViewer, (Object)new CentroidUserObject(n, 0))));
                defaultMutableTreeNodeArray2[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - this.numberOfClasses), (IViewer)dAMExperimentCentroidViewer, (Object)new CentroidUserObject(n, 1))));
            }
            for (n = 2 * this.numberOfClasses; n < 3 * this.numberOfClasses; ++n) {
                defaultMutableTreeNodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 2 * this.numberOfClasses), (IViewer)dAMExperimentCentroidViewer, (Object)new CentroidUserObject(n, 0))));
                defaultMutableTreeNodeArray2[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 2 * this.numberOfClasses), (IViewer)dAMExperimentCentroidViewer, (Object)new CentroidUserObject(n, 1))));
            }
            DAMExperimentCentroidsViewer dAMExperimentCentroidsViewer = new DAMExperimentCentroidsViewer(this.experiment, this.clusters);
            dAMExperimentCentroidsViewer.setMeans(this.means.A);
            dAMExperimentCentroidsViewer.setVariances(this.variances.A);
            for (int i = 0; i < defaultMutableTreeNodeArray.length; ++i) {
                defaultMutableTreeNode2.add(defaultMutableTreeNodeArray[i]);
                defaultMutableTreeNode3.add(defaultMutableTreeNodeArray2[i]);
            }
            DAMCentroidViewer dAMCentroidViewer = new DAMCentroidViewer(this.experiment, this.geneClusters);
            dAMCentroidViewer.setMeans(this.means_used.A);
            dAMCentroidViewer.setVariances(this.variances_used.A);
            if (this.preSelectGenes) {
                DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(new LeafInfo("Used Gene Centroid Graph", (IViewer)dAMCentroidViewer, (Object)new CentroidUserObject(0, 0)));
                DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode(new LeafInfo("Used Gene Expression Graph ", (IViewer)dAMCentroidViewer, (Object)new CentroidUserObject(0, 1)));
                DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode(new LeafInfo("Unused Gene Centroid Graph", (IViewer)dAMCentroidViewer, (Object)new CentroidUserObject(1, 0)));
                DefaultMutableTreeNode defaultMutableTreeNode11 = new DefaultMutableTreeNode(new LeafInfo("Unused Gene Expression Graph ", (IViewer)dAMCentroidViewer, (Object)new CentroidUserObject(1, 1)));
                defaultMutableTreeNode2.add(defaultMutableTreeNode8);
                defaultMutableTreeNode3.add(defaultMutableTreeNode9);
                defaultMutableTreeNode2.add(defaultMutableTreeNode10);
                defaultMutableTreeNode3.add(defaultMutableTreeNode11);
            }
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private void addClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        if (this.classifyGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Classes (#,%)", (IViewer)new DAMInfoViewer(this.clusters, this.experiment.getNumberOfGenes(), this.numberOfClasses, this.usedGeneIndices.length, this.unusedGeneIndices.length, this.alpha, this.algorithmSelection, this.isPDA, this.preSelectGenes))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Samples in Classes (#,%)", (IViewer)new DAMInfoViewer(this.clusters, this.experiment.getNumberOfSamples(), false, this.numberOfClasses, this.usedGeneIndices.length, this.unusedGeneIndices.length, this.alpha, this.algorithmSelection, this.isPDA, this.preSelectGenes))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[]{new DefaultMutableTreeNode("Classifiers"), new DefaultMutableTreeNode("Classified"), new DefaultMutableTreeNode("Classifiers + Classified")};
        Object object = this.classifyGenes ? new DAMExperimentViewer(this.experiment, this.clusters) : new DAMExperimentClusterViewer(this.experiment, this.clusters);
        for (n = 0; n < this.numberOfClasses; ++n) {
            defaultMutableTreeNodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1), (IViewer)object, (Object)new Integer(n))));
        }
        for (n = this.numberOfClasses; n < 2 * this.numberOfClasses; ++n) {
            defaultMutableTreeNodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - this.numberOfClasses), (IViewer)object, (Object)new Integer(n))));
        }
        for (n = 2 * this.numberOfClasses; n < 3 * this.numberOfClasses; ++n) {
            defaultMutableTreeNodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(n + 1 - 2 * this.numberOfClasses), (IViewer)object, (Object)new Integer(n))));
        }
        for (n = 0; n < defaultMutableTreeNodeArray.length; ++n) {
            defaultMutableTreeNode2.add(defaultMutableTreeNodeArray[n]);
        }
        DAMExperimentViewer dAMExperimentViewer = new DAMExperimentViewer(this.unusedExperiment, null);
        DAMExperimentViewer dAMExperimentViewer2 = new DAMExperimentViewer(this.usedExperiment, null);
        if (this.preSelectGenes) {
            if (this.classifyGenes) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Used Exp Expression", (IViewer)dAMExperimentViewer2)));
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unused Exp Expression", (IViewer)dAMExperimentViewer)));
            } else {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Used Gene Expression", (IViewer)dAMExperimentViewer2)));
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unused Gene Expression", (IViewer)dAMExperimentViewer)));
            }
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            DAMGUI.this.logger.append(algorithmEvent.getDescription());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                DAMGUI.this.algorithm.abort();
                DAMGUI.this.logger.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            DAMGUI.this.algorithm.abort();
            DAMGUI.this.logger.dispose();
        }
    }
}

