/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dam;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMSearchDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMSecondDialog;
import org.tigr.util.StringSplitter;

public class DAMClassificationEditor
extends JFrame {
    IFramework framework;
    IData data;
    boolean classifyGenes;
    private boolean stopHere = true;
    private boolean nextPressed = false;
    private boolean cancelPressed = false;
    private boolean incompatible = false;
    private boolean fileSaved = false;
    private boolean fileOpened = false;
    int numberOfClasses;
    String[] fieldNames;
    int numGenes;
    int numExps;
    JTable damClassTable;
    DAMClassTableModel damTabModel;
    JMenuBar menuBar;
    JMenu fileMenu;
    JMenu editMenu;
    JMenu toolsMenu;
    JMenu assignSubMenu;
    JMenu sortAscMenu;
    JMenu sortDescMenu;
    JMenuItem openItem;
    JMenuItem closeItem;
    JMenuItem selectAllItem;
    JMenuItem searchItem;
    JMenuItem sortByClassItem;
    JMenuItem origOrderItem;
    JMenuItem[] classItem;
    JMenuItem[] labelsAscItem;
    JMenuItem[] labelsDescItem;
    JRadioButton saveButton;
    JRadioButton doNotSaveButton;
    JButton nextButton;
    JButton cancelButton;
    JFrame mainFrame;
    DAMSearchDialog searchDialog;
    Object[][] origData;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;

    public DAMClassificationEditor(IFramework iFramework, boolean bl, int n) {
        int n2;
        int n3;
        this.setTitle("DAM Classification Editor");
        this.mainFrame = (JFrame)iFramework.getFrame();
        this.setBounds(0, 0, 550, 800);
        this.setBackground(Color.white);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DAMClassificationEditor.this.closeDialog(windowEvent);
            }
        });
        this.setDefaultCloseOperation(0);
        this.framework = iFramework;
        this.data = iFramework.getData();
        this.numGenes = this.data.getFeaturesSize();
        this.numExps = this.data.getFeaturesCount();
        this.fieldNames = this.data.getFieldNames();
        this.classifyGenes = bl;
        this.numberOfClasses = n;
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout2);
        this.damTabModel = new DAMClassTableModel();
        this.damClassTable = new JTable(this.damTabModel);
        this.damClassTable.setAutoResizeMode(0);
        TableColumn tableColumn = null;
        for (int i = 0; i < this.damTabModel.getColumnCount(); ++i) {
            tableColumn = this.damClassTable.getColumnModel().getColumn(i);
            tableColumn.setMinWidth(30);
        }
        this.damClassTable.setColumnModel(new DAMClassTableColumnModel(this.damClassTable.getColumnModel()));
        this.damClassTable.getModel().addTableModelListener(new ClassSelectionListener());
        this.searchDialog = new DAMSearchDialog(JOptionPane.getFrameForComponent(this), this.damClassTable, n, false);
        JScrollPane jScrollPane = new JScrollPane(this.damClassTable);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 100);
        gridBagLayout2.setConstraints(jScrollPane, gridBagConstraints);
        jPanel2.add(jScrollPane);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 90);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new EtchedBorder());
        jPanel3.setBackground(Color.white);
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout3);
        this.saveButton = new JRadioButton("Save classification to file", true);
        this.saveButton.setBackground(Color.white);
        this.doNotSaveButton = new JRadioButton("Do not save classification to file", false);
        this.doNotSaveButton.setBackground(Color.white);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.saveButton);
        buttonGroup.add(this.doNotSaveButton);
        final JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File("Data"));
        jFileChooser.setDialogTitle("Save classification");
        this.cancelButton = new JButton("Cancel >");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DAMClassificationEditor.this.dispose();
            }
        });
        this.nextButton = new JButton("Next >");
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DAMClassificationEditor.this.doNotSaveButton.isSelected()) {
                    DAMClassificationEditor.this.dispose();
                    DAMClassificationEditor.this.stopHere = false;
                    DAMClassificationEditor.this.nextPressed = true;
                } else {
                    int n = jFileChooser.showSaveDialog(DAMClassificationEditor.this);
                    if (n == 0) {
                        File file = jFileChooser.getSelectedFile();
                        DAMClassificationEditor.this.saveToFile(file);
                        DAMSecondDialog dAMSecondDialog = new DAMSecondDialog(DAMClassificationEditor.this.mainFrame, true);
                        dAMSecondDialog.setVisible(true);
                        if (!dAMSecondDialog.proceed()) {
                            DAMClassificationEditor.this.stopHere = true;
                        } else {
                            DAMClassificationEditor.this.stopHere = false;
                        }
                        DAMClassificationEditor.this.incompatible = false;
                        DAMClassificationEditor.this.fileSaved = true;
                        if (DAMClassificationEditor.this.stopHere) {
                            DAMClassificationEditor.this.nextPressed = false;
                            DAMClassificationEditor.this.setVisible(true);
                        } else {
                            DAMClassificationEditor.this.nextPressed = true;
                            DAMClassificationEditor.this.dispose();
                        }
                    }
                }
            }
        });
        gridBagConstraints.fill = 0;
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 33);
        gridBagLayout3.setConstraints(this.saveButton, gridBagConstraints);
        jPanel3.add(this.saveButton);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 33);
        gridBagLayout3.setConstraints(this.doNotSaveButton, gridBagConstraints);
        jPanel3.add(this.doNotSaveButton);
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 34);
        gridBagLayout3.setConstraints(this.nextButton, gridBagConstraints);
        jPanel3.add(this.nextButton);
        gridBagConstraints.fill = 1;
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 10);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        this.setContentPane(jPanel);
        if (bl) {
            this.labelsAscItem = new JMenuItem[this.fieldNames.length];
            this.labelsDescItem = new JMenuItem[this.fieldNames.length];
            for (n3 = 0; n3 < this.fieldNames.length; ++n3) {
                this.labelsAscItem[n3] = new JMenuItem(this.fieldNames[n3]);
                this.labelsDescItem[n3] = new JMenuItem(this.fieldNames[n3]);
            }
        } else {
            this.labelsAscItem = new JMenuItem[1];
            this.labelsAscItem[0] = new JMenuItem("Sample/Experiment Name");
            this.labelsDescItem = new JMenuItem[1];
            this.labelsDescItem[0] = new JMenuItem("Sample/Experiment Name");
        }
        for (n3 = 0; n3 < this.labelsAscItem.length; ++n3) {
            this.labelsAscItem[n3].addActionListener(new SortListener(true, false));
            this.labelsDescItem[n3].addActionListener(new SortListener(false, false));
        }
        this.classItem = new JMenuItem[n + 1];
        for (n3 = 0; n3 < n; ++n3) {
            this.classItem[n3] = new JMenuItem("Class " + (n3 + 1));
        }
        this.classItem[n] = new JMenuItem("Neutral");
        for (n3 = 0; n3 < this.classItem.length; ++n3) {
            this.classItem[n3].addActionListener(new AssignListener());
        }
        final JFileChooser jFileChooser2 = new JFileChooser();
        jFileChooser2.setCurrentDirectory(new File("Data"));
        jFileChooser2.setDialogTitle("Open Classification");
        this.fileMenu = new JMenu("File");
        this.openItem = new JMenuItem("Apply File");
        this.openItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jFileChooser2.showOpenDialog(DAMClassificationEditor.this);
                if (n == 0) {
                    File file = jFileChooser2.getSelectedFile();
                    DAMClassificationEditor.this.loadFromFile(file);
                    DAMClassificationEditor.this.fileOpened = true;
                    DAMClassificationEditor.this.nextPressed = false;
                }
            }
        });
        this.fileMenu.add(this.openItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu = new JMenu("Edit");
        this.selectAllItem = new JMenuItem("Select all rows");
        this.selectAllItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DAMClassificationEditor.this.damClassTable.selectAll();
            }
        });
        this.editMenu.add(this.selectAllItem);
        this.assignSubMenu = new JMenu("Assign selected rows to");
        for (n2 = 0; n2 < this.classItem.length; ++n2) {
            this.assignSubMenu.add(this.classItem[n2]);
        }
        this.editMenu.add(this.assignSubMenu);
        this.menuBar.add(this.editMenu);
        this.toolsMenu = new JMenu("Tools");
        this.searchItem = new JMenuItem("Search");
        this.searchItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DAMClassificationEditor.this.searchTable();
            }
        });
        this.toolsMenu.add(this.searchItem);
        this.sortAscMenu = new JMenu("Sort ascending by");
        for (n2 = 0; n2 < this.labelsAscItem.length; ++n2) {
            this.sortAscMenu.add(this.labelsAscItem[n2]);
        }
        this.toolsMenu.add(this.sortAscMenu);
        this.sortDescMenu = new JMenu("Sort descending by");
        for (n2 = 0; n2 < this.labelsDescItem.length; ++n2) {
            this.sortDescMenu.add(this.labelsDescItem[n2]);
        }
        this.toolsMenu.add(this.sortDescMenu);
        this.sortByClassItem = new JMenuItem("Sort by classification");
        this.sortByClassItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DAMClassificationEditor.this.sortByClassification();
            }
        });
        this.toolsMenu.add(this.sortByClassItem);
        this.origOrderItem = new JMenuItem("Restore original ordering");
        this.origOrderItem.addActionListener(new SortListener(true, true));
        this.toolsMenu.add(this.origOrderItem);
        this.menuBar.add(this.toolsMenu);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.cancelPressed = true;
        this.dispose();
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
    }

    public void sortByColumn(int n, boolean bl, boolean bl2) {
        int n2;
        int n3;
        if (bl2) {
            int n4;
            int n5;
            Object[][] objectArray = new Object[this.damTabModel.getRowCount()][this.damTabModel.getColumnCount()];
            for (n5 = 0; n5 < objectArray.length; ++n5) {
                for (n4 = 0; n4 < objectArray[0].length; ++n4) {
                    objectArray[n5][n4] = this.origData[n5][n4];
                }
            }
            for (n5 = 0; n5 < objectArray.length; ++n5) {
                for (n4 = 0; n4 < objectArray[0].length; ++n4) {
                    this.damTabModel.setValueAt(objectArray[n5][n4], n5, n4);
                }
                this.validateTable(objectArray, n5);
            }
            return;
        }
        if (n < 0 || n > this.damTabModel.getColumnCount()) {
            return;
        }
        Object[][] objectArray = new Object[this.damTabModel.getRowCount()][this.damTabModel.getColumnCount()];
        Object[] objectArray2 = new SortableField[this.damTabModel.getRowCount()];
        for (int i = 0; i < objectArray2.length; ++i) {
            n3 = (Integer)this.damTabModel.getValueAt(i, 0);
            objectArray2[i] = new SortableField(n3, n);
        }
        Arrays.sort(objectArray2);
        int[] nArray = new int[objectArray2.length];
        for (n3 = 0; n3 < nArray.length; ++n3) {
            nArray[n3] = ((SortableField)objectArray2[n3]).getIndex();
        }
        if (!bl) {
            nArray = this.reverse(nArray);
        }
        for (n3 = 0; n3 < objectArray.length; ++n3) {
            for (n2 = 0; n2 < objectArray[n3].length; ++n2) {
                objectArray[n3][n2] = this.origData[nArray[n3]][n2];
            }
        }
        for (n3 = 0; n3 < objectArray.length; ++n3) {
            for (n2 = 0; n2 < objectArray[n3].length; ++n2) {
                this.damTabModel.setValueAt(objectArray[n3][n2], n3, n2);
            }
            this.validateTable(objectArray, n3);
        }
        this.damClassTable.removeRowSelectionInterval(0, this.damClassTable.getRowCount() - 1);
    }

    private int[] reverse(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        int n2 = nArray.length - 1;
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[n] = nArray[n2];
            ++n;
            --n2;
        }
        return nArray2;
    }

    private void sortByClassification() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Vector[] vectorArray = new Vector[this.numberOfClasses + 1];
        for (n5 = 0; n5 < vectorArray.length; ++n5) {
            vectorArray[n5] = new Vector();
        }
        block1: for (n5 = 0; n5 < this.damTabModel.getRowCount(); ++n5) {
            for (n4 = 1; n4 <= this.numberOfClasses + 1; ++n4) {
                n3 = ((Boolean)this.damTabModel.getValueAt(n5, n4)).booleanValue() ? 1 : 0;
                if (n3 == 0) continue;
                vectorArray[n4 - 1].add(new Integer(n5));
                continue block1;
            }
        }
        int[] nArray = new int[this.damTabModel.getRowCount()];
        n4 = 0;
        for (n3 = 0; n3 < vectorArray.length; ++n3) {
            for (n2 = 0; n2 < vectorArray[n3].size(); ++n2) {
                nArray[n4] = (Integer)vectorArray[n3].get(n2);
                ++n4;
            }
        }
        Object[][] objectArray = new Object[this.damTabModel.getRowCount()][this.damTabModel.getColumnCount()];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            for (n = 0; n < objectArray[0].length; ++n) {
                objectArray[n2][n] = this.damTabModel.getValueAt(nArray[n2], n);
            }
        }
        for (n2 = 0; n2 < this.damTabModel.getRowCount(); ++n2) {
            for (n = 0; n < this.damTabModel.getColumnCount(); ++n) {
                this.damTabModel.setValueAt(objectArray[n2][n], n2, n);
            }
            this.validateTable(objectArray, n2);
        }
        this.damClassTable.removeRowSelectionInterval(0, this.damClassTable.getRowCount() - 1);
    }

    private void validateTable(Object[][] objectArray, int n) {
        for (int i = 1; i <= this.numberOfClasses + 1; ++i) {
            boolean bl = (Boolean)objectArray[n][i];
            if (!bl) continue;
            this.damTabModel.setValueAt(new Boolean(true), n, i);
            break;
        }
    }

    private void searchTable() {
        this.searchDialog.setVisible(true);
        this.searchDialog.toFront();
        this.searchDialog.setLocation(this.getLocation().x + 100, this.getLocation().y + 100);
    }

    private void saveToFile(File file) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            for (int i = 0; i < this.damTabModel.getRowCount(); ++i) {
                int n;
                printWriter.print((Integer)this.damTabModel.getValueAt(i, 0));
                printWriter.print("\t");
                for (n = 1; n <= this.numberOfClasses; ++n) {
                    if (!((Boolean)this.damTabModel.getValueAt(i, n)).booleanValue()) continue;
                    printWriter.print(n);
                    break;
                }
                if (((Boolean)this.damTabModel.getValueAt(i, this.numberOfClasses + 1)).booleanValue()) {
                    printWriter.print(-1);
                }
                for (n = this.numberOfClasses + 2; n < this.damTabModel.getColumnCount(); ++n) {
                    printWriter.print("\t");
                    printWriter.print(this.damTabModel.getValueAt(i, n));
                }
                printWriter.print("\r");
                printWriter.print("\n");
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadFromFile(File file) {
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        this.incompatible = false;
        try {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = new String();
            while ((string = bufferedReader.readLine()) != null) {
                StringSplitter stringSplitter = new StringSplitter('\t');
                stringSplitter.init(string);
                String string2 = stringSplitter.nextToken();
                vector.add(new Integer(string2));
                String string3 = stringSplitter.nextToken();
                vector2.add(new Integer(string3));
            }
            if (vector.size() != this.damTabModel.getRowCount()) {
                JOptionPane.showMessageDialog(this.framework.getFrame(), "Number of rows mismatch!", "Error", 2);
                this.incompatible = true;
                this.setVisible(true);
                return;
            }
            for (n = 0; n < vector.size(); ++n) {
                int n2 = (Integer)vector2.get(n);
                if (n2 <= this.numberOfClasses) continue;
                JOptionPane.showMessageDialog(this.framework.getFrame(), "Class index larger than number of classes!", "Error", 2);
                this.incompatible = true;
                this.setVisible(true);
                return;
            }
            for (n = 0; n < vector.size(); ++n) {
                int n3 = (Integer)vector.get(n);
                int n4 = (Integer)vector2.get(n);
                if (n4 == -1) {
                    this.damTabModel.setValueAt(new Boolean(true), n3, this.numberOfClasses + 1);
                    this.damClassTable.setValueAt(new Boolean(true), n3, this.numberOfClasses + 1);
                    continue;
                }
                this.damTabModel.setValueAt(new Boolean(true), n3, n4);
                this.damClassTable.setValueAt(new Boolean(true), n3, n4);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Incompatible file!", "Error", 2);
            this.incompatible = true;
        }
    }

    public Vector[] getClassification() {
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        Vector<Integer> vector3 = new Vector<Integer>();
        Vector[] vectorArray = new Vector[3];
        for (int i = 0; i < this.damTabModel.getRowCount(); ++i) {
            if (((Boolean)this.damTabModel.getValueAt(i, this.numberOfClasses + 1)).booleanValue()) {
                vector2.add((Integer)this.damTabModel.getValueAt(i, 0));
                continue;
            }
            vector.add((Integer)this.damTabModel.getValueAt(i, 0));
            vector3.add(new Integer(this.getClass(i)));
        }
        vectorArray[0] = vector;
        vectorArray[1] = vector3;
        vectorArray[2] = vector2;
        return vectorArray;
    }

    public boolean isNextPressed() {
        return this.nextPressed;
    }

    public boolean isCancelPressed() {
        return this.cancelPressed;
    }

    private int getClass(int n) {
        int n2;
        for (n2 = 1; n2 <= this.numberOfClasses + 1 && !((Boolean)this.damTabModel.getValueAt(n, n2)).booleanValue(); ++n2) {
        }
        return n2;
    }

    public boolean proceed() {
        return !this.stopHere;
    }

    public boolean fileIsIncompatible() {
        return this.incompatible;
    }

    public void showWarningMessage() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.append("Proceed with this file?");
        jTextArea.append("\n");
        jTextArea.setEditable(false);
        jTextArea.setBackground(Color.gray.brighter());
        JOptionPane.showMessageDialog(this, jTextArea, "Warning", 2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class SortListener
    implements ActionListener {
        boolean asc;
        boolean origOrd;

        public SortListener(boolean bl, boolean bl2) {
            this.asc = bl;
            this.origOrd = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = ((JMenuItem)object).getText();
                int n = DAMClassificationEditor.this.damTabModel.getColumnIndex(string);
                DAMClassificationEditor.this.sortByColumn(n, this.asc, this.origOrd);
            }
        }
    }

    public class AssignListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = ((JMenuItem)object).getText();
                int n = DAMClassificationEditor.this.damTabModel.getColumnIndex(string);
                int[] nArray = DAMClassificationEditor.this.damClassTable.getSelectedRows();
                int[] nArray2 = new int[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    DAMClassificationEditor.this.damTabModel.setValueAt(new Boolean(true), nArray[i], n);
                }
            }
        }
    }

    private class SortableField
    implements Comparable {
        private String field;
        private int index;

        SortableField(int n, int n2) {
            this.index = n;
            this.field = (String)DAMClassificationEditor.this.origData[n][n2];
        }

        public int compareTo(Object object) {
            SortableField sortableField = (SortableField)object;
            return this.field.compareTo(sortableField.getField());
        }

        public int getIndex() {
            return this.index;
        }

        public String getField() {
            return this.field;
        }
    }

    class ClassSelectionListener
    implements TableModelListener {
        ClassSelectionListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            int n = tableModelEvent.getColumn();
            int n2 = tableModelEvent.getFirstRow();
            if (n < 1 || n > DAMClassificationEditor.this.numberOfClasses + 1) {
                return;
            }
            if (this.verifySelected(n2, n)) {
                this.changeNeighbors(n2, n);
            }
            int n3 = (Integer)DAMClassificationEditor.this.damTabModel.getValueAt(n2, 0);
            DAMClassificationEditor.this.origData[n3][n] = new Boolean(true);
            for (int i = 1; i <= DAMClassificationEditor.this.numberOfClasses + 1; ++i) {
                if (i == n) continue;
                DAMClassificationEditor.this.origData[n3][i] = new Boolean(false);
            }
        }

        private void changeNeighbors(int n, int n2) {
            for (int i = 1; i <= DAMClassificationEditor.this.numberOfClasses + 1; ++i) {
                if (i == n2) continue;
                DAMClassificationEditor.this.damClassTable.setValueAt(new Boolean(false), n, i);
            }
        }

        private boolean verifySelected(int n, int n2) {
            int n3;
            int n4;
            boolean bl = (Boolean)DAMClassificationEditor.this.damClassTable.getValueAt(n, n2);
            if (bl) {
                return true;
            }
            Vector<Boolean> vector = new Vector<Boolean>();
            for (n4 = 1; n4 <= DAMClassificationEditor.this.numberOfClasses + 1; ++n4) {
                if (n4 == n2) continue;
                n3 = ((Boolean)DAMClassificationEditor.this.damClassTable.getValueAt(n, n4)).booleanValue() ? 1 : 0;
                vector.add(new Boolean(n3 != 0));
            }
            n4 = 1;
            for (n3 = 0; n3 < vector.size(); ++n3) {
                boolean bl2 = (Boolean)vector.get(n3);
                if (!bl2) continue;
                n4 = 0;
                break;
            }
            if (n4 == 1) {
                DAMClassificationEditor.this.damClassTable.setValueAt(new Boolean(true), n, n2);
            }
            return false;
        }
    }

    class DAMClassTableColumnModel
    implements TableColumnModel {
        TableColumnModel tcm;

        public DAMClassTableColumnModel(TableColumnModel tableColumnModel) {
            this.tcm = tableColumnModel;
        }

        public void addColumn(TableColumn tableColumn) {
            this.tcm.addColumn(tableColumn);
        }

        public void addColumnModelListener(TableColumnModelListener tableColumnModelListener) {
            this.tcm.addColumnModelListener(tableColumnModelListener);
        }

        public TableColumn getColumn(int n) {
            return this.tcm.getColumn(n);
        }

        public int getColumnCount() {
            return this.tcm.getColumnCount();
        }

        public int getColumnIndex(Object object) {
            return this.tcm.getColumnIndex(object);
        }

        public int getColumnIndexAtX(int n) {
            return this.tcm.getColumnIndexAtX(n);
        }

        public int getColumnMargin() {
            return this.tcm.getColumnMargin();
        }

        public boolean getColumnSelectionAllowed() {
            return this.tcm.getColumnSelectionAllowed();
        }

        public Enumeration getColumns() {
            return this.tcm.getColumns();
        }

        public int getSelectedColumnCount() {
            return this.tcm.getSelectedColumnCount();
        }

        public int[] getSelectedColumns() {
            return this.tcm.getSelectedColumns();
        }

        public ListSelectionModel getSelectionModel() {
            return this.tcm.getSelectionModel();
        }

        public int getTotalColumnWidth() {
            return this.tcm.getTotalColumnWidth();
        }

        public void moveColumn(int n, int n2) {
            if (n <= DAMClassificationEditor.this.numberOfClasses + 1 || n2 <= DAMClassificationEditor.this.numberOfClasses + 1) {
                return;
            }
            this.tcm.moveColumn(n, n2);
        }

        public void removeColumn(TableColumn tableColumn) {
            this.tcm.removeColumn(tableColumn);
        }

        public void removeColumnModelListener(TableColumnModelListener tableColumnModelListener) {
            this.tcm.removeColumnModelListener(tableColumnModelListener);
        }

        public void setColumnMargin(int n) {
            this.tcm.setColumnMargin(n);
        }

        public void setColumnSelectionAllowed(boolean bl) {
            this.tcm.setColumnSelectionAllowed(bl);
        }

        public void setSelectionModel(ListSelectionModel listSelectionModel) {
            this.tcm.setSelectionModel(listSelectionModel);
        }
    }

    class DAMClassTableModel
    extends AbstractTableModel {
        String[] columnNames;
        Object[][] tableData;
        int indexLastClass;

        public DAMClassTableModel() {
            int n;
            int n2;
            this.indexLastClass = DAMClassificationEditor.this.numberOfClasses;
            if (DAMClassificationEditor.this.classifyGenes) {
                this.columnNames = new String[DAMClassificationEditor.this.fieldNames.length + DAMClassificationEditor.this.numberOfClasses + 2];
                this.columnNames[0] = "Index";
                for (n2 = 0; n2 < DAMClassificationEditor.this.numberOfClasses; ++n2) {
                    this.columnNames[n2 + 1] = "Class " + (n2 + 1);
                }
                this.columnNames[DAMClassificationEditor.this.numberOfClasses + 1] = "Neutral";
                for (n2 = 0; n2 < DAMClassificationEditor.this.fieldNames.length; ++n2) {
                    this.columnNames[DAMClassificationEditor.this.numberOfClasses + 2 + n2] = DAMClassificationEditor.this.fieldNames[n2];
                }
                this.tableData = new Object[DAMClassificationEditor.this.numGenes][this.columnNames.length];
                for (n2 = 0; n2 < this.tableData.length; ++n2) {
                    for (n = 0; n < this.columnNames.length; ++n) {
                        this.tableData[n2][n] = n == 0 ? new Integer(n2) : (n > 0 && n < DAMClassificationEditor.this.numberOfClasses + 1 ? new Boolean(false) : (n == DAMClassificationEditor.this.numberOfClasses + 1 ? new Boolean(true) : DAMClassificationEditor.this.data.getElementAttribute(n2, n - (DAMClassificationEditor.this.numberOfClasses + 2))));
                    }
                }
            } else {
                this.columnNames = new String[DAMClassificationEditor.this.numberOfClasses + 3];
                this.columnNames[0] = "Index";
                for (n2 = 0; n2 < DAMClassificationEditor.this.numberOfClasses; ++n2) {
                    this.columnNames[n2 + 1] = "Class " + (n2 + 1);
                }
                this.columnNames[DAMClassificationEditor.this.numberOfClasses + 1] = "Neutral";
                this.columnNames[DAMClassificationEditor.this.numberOfClasses + 2] = "Sample/Experiment Name";
                this.tableData = new Object[DAMClassificationEditor.this.numExps][this.columnNames.length];
                for (n2 = 0; n2 < this.tableData.length; ++n2) {
                    for (n = 0; n < this.columnNames.length; ++n) {
                        if (n == 0) {
                            this.tableData[n2][n] = new Integer(n2);
                            continue;
                        }
                        if (n > 0 && n < DAMClassificationEditor.this.numberOfClasses + 1) {
                            this.tableData[n2][n] = new Boolean(false);
                            continue;
                        }
                        if (n == DAMClassificationEditor.this.numberOfClasses + 1) {
                            this.tableData[n2][n] = new Boolean(true);
                            continue;
                        }
                        if (n != DAMClassificationEditor.this.numberOfClasses + 2) continue;
                        this.tableData[n2][n] = DAMClassificationEditor.this.data.getFullSampleName(n2);
                    }
                }
            }
            DAMClassificationEditor.this.origData = new Object[this.tableData.length][this.tableData[0].length];
            for (n2 = 0; n2 < this.tableData.length; ++n2) {
                for (n = 0; n < this.tableData[0].length; ++n) {
                    DAMClassificationEditor.this.origData[n2][n] = this.tableData[n2][n];
                }
            }
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.tableData.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getColumnIndex(String string) {
            int n;
            for (n = 0; n < this.columnNames.length && !this.columnNames[n].equals(string); ++n) {
            }
            if (n < this.columnNames.length) {
                return n;
            }
            return -1;
        }

        public Object getValueAt(int n, int n2) {
            return this.tableData[n][n2];
        }

        public void setValueAt(Object object, int n, int n2) {
            this.tableData[n][n2] = object;
            this.fireTableChanged(new TableModelEvent(this, n, n, n2));
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = DAMClassificationEditor.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            if (n > 0 && n <= DAMClassificationEditor.this.numberOfClasses + 1) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = DAMClassificationEditor.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 > 0 && n2 <= DAMClassificationEditor.this.numberOfClasses + 1;
        }
    }

    class DAMClassifierTable
    extends JTable {
        DAMClassifierTable() {
        }
    }
}

