/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.coa;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;

public class COAInitDialog
extends AlgorithmDialog {
    boolean okPressed = false;
    JTextField numNeighborsField;

    public COAInitDialog(JFrame jFrame, boolean bl) {
        super(jFrame, "COA", bl);
        this.setBounds(0, 0, 600, 200);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setBorder(new EtchedBorder());
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Number for neighbors for KNN imputation :");
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 100);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.numNeighborsField = new JTextField("10", 7);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 100);
        gridBagLayout.setConstraints(this.numNeighborsField, gridBagConstraints);
        jPanel.add(this.numNeighborsField);
        this.addContent(jPanel);
        EventListener eventListener = new EventListener();
        this.setActionListeners(eventListener);
        this.addWindowListener(eventListener);
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public int getNumNeighbors() {
        return Integer.parseInt(this.numNeighborsField.getText());
    }

    public static void main(String[] stringArray) {
        COAInitDialog cOAInitDialog = new COAInitDialog(new JFrame(), true);
        cOAInitDialog.setVisible(true);
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                try {
                    int n = COAInitDialog.this.getNumNeighbors();
                    if (n <= 0) {
                        JOptionPane.showMessageDialog(null, "Invalid number of neighbors", "Error", 0);
                        return;
                    }
                    COAInitDialog.this.okPressed = true;
                    COAInitDialog.this.dispose();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(null, "Invalid number of neighbors", "Error", 0);
                    return;
                }
            } else if (string.equals("reset-command")) {
                COAInitDialog.this.numNeighborsField.setText("10");
            } else if (string.equals("cancel-command")) {
                COAInitDialog.this.okPressed = false;
                COAInitDialog.this.dispose();
            } else if (string.equals("info-command")) {
                // empty if block
            }
        }
    }
}

