/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import java.util.Vector;
import javax.media.jai.ImageJAI;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.MultiResolutionRenderableImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;

public class ImageMIPMap
implements ImageJAI {
    protected RenderedImage highestImage;
    protected RenderedImage currentImage;
    protected int currentLevel;
    protected RenderedOp downSampler;

    protected ImageMIPMap() {
        this.currentLevel = 0;
    }

    public ImageMIPMap(RenderedImage renderedImage, AffineTransform affineTransform, Interpolation interpolation) {
        this.currentLevel = 0;
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(affineTransform);
        parameterBlock.add(interpolation);
        this.downSampler = JAI.create("affine", parameterBlock);
        this.downSampler.removeSources();
        this.currentImage = this.highestImage = renderedImage;
    }

    public ImageMIPMap(RenderedImage renderedImage, RenderedOp renderedOp) {
        this.currentLevel = 0;
        if (renderedImage == null || renderedOp == null) {
            throw new NullPointerException();
        }
        this.currentImage = this.highestImage = renderedImage;
        this.downSampler = renderedOp;
    }

    public ImageMIPMap(RenderedOp renderedOp) {
        block5: {
            Object object;
            this.currentLevel = 0;
            if (renderedOp.getNumSources() == 0) {
                throw new IllegalArgumentException(JaiI18N.getString("ImageMIPMap0"));
            }
            RenderedOp renderedOp2 = renderedOp;
            while ((object = renderedOp2.getNodeSource(0)) instanceof RenderedOp) {
                RenderedOp renderedOp3 = (RenderedOp)object;
                if (renderedOp3.getNumSources() == 0) {
                    this.highestImage = renderedOp3;
                    renderedOp2.removeSources();
                    break block5;
                }
                renderedOp2 = renderedOp3;
            }
            if (object instanceof RenderedImage) {
                this.highestImage = (RenderedImage)object;
                renderedOp2.removeSources();
            } else {
                throw new IllegalArgumentException(JaiI18N.getString("ImageMIPMap1"));
            }
        }
        this.currentImage = this.highestImage;
        this.downSampler = renderedOp;
    }

    protected RenderedOp duplicate(RenderedOp renderedOp, RenderedImage renderedImage) {
        if (renderedImage == null) {
            throw new NullPointerException();
        }
        Vector<RenderedImage> vector = new Vector<RenderedImage>();
        vector.add(renderedImage);
        return this.duplicate(renderedOp, vector);
    }

    protected RenderedOp duplicate(RenderedOp renderedOp, RenderedImage renderedImage, RenderedImage renderedImage2) {
        if (renderedImage == null || renderedImage2 == null) {
            throw new NullPointerException();
        }
        Vector<RenderedImage> vector = new Vector<RenderedImage>();
        vector.add(renderedImage);
        vector.add(renderedImage2);
        return this.duplicate(renderedOp, vector);
    }

    protected RenderedOp duplicate(RenderedOp renderedOp, Vector vector) {
        if (vector == null) {
            throw new NullPointerException();
        }
        renderedOp = new RenderedOp(renderedOp.getRegistry(), renderedOp.getOperationName(), renderedOp.getParameterBlock(), renderedOp.getRenderingHints());
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.setParameters(renderedOp.getParameters());
        Vector vector2 = renderedOp.getSources();
        int n = vector2.size();
        if (n == 0) {
            parameterBlock.setSources(vector);
        } else {
            parameterBlock.addSource(this.duplicate((RenderedOp)vector2.elementAt(0), vector));
            int n2 = 1;
            while (n2 < n) {
                parameterBlock.addSource(vector2.elementAt(n2));
                ++n2;
            }
        }
        renderedOp.setParameterBlock(parameterBlock);
        return renderedOp;
    }

    public RenderableImage getAsRenderable() {
        return this.getAsRenderable(1, 0.0f, 0.0f, 1.0f);
    }

    public RenderableImage getAsRenderable(int n, float f, float f2, float f3) {
        Vector<RenderedImage> vector = new Vector<RenderedImage>();
        vector.add(this.currentImage);
        RenderedImage renderedImage = this.currentImage;
        int n2 = 1;
        while (n2 < n) {
            RenderedOp renderedOp = this.duplicate(this.downSampler, renderedImage);
            renderedImage = renderedOp.getRendering();
            vector.add(renderedImage);
            ++n2;
        }
        return new MultiResolutionRenderableImage(vector, f, f2, f3);
    }

    public RenderedImage getCurrentImage() {
        return this.currentImage;
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public RenderedImage getDownImage() {
        ++this.currentLevel;
        RenderedOp renderedOp = this.duplicate(this.downSampler, this.currentImage);
        this.currentImage = renderedOp.getRendering();
        return this.currentImage;
    }

    public RenderedImage getImage(int n) {
        if (n < 0) {
            return null;
        }
        if (n < this.currentLevel) {
            this.currentImage = this.highestImage;
            this.currentLevel = 0;
        }
        while (this.currentLevel < n) {
            this.getDownImage();
        }
        return this.currentImage;
    }

    public Object getProperty(String string) {
        return Image.UndefinedProperty;
    }

    public String[] getPropertyNames() {
        return null;
    }

    public String[] getPropertyNames(String string) {
        String[] stringArray = this.getPropertyNames();
        return PlanarImage.getPropertyNames(stringArray, string);
    }
}

