/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.TileCache;

final class LookupOpImage
extends PointOpImage {
    protected LookupTableJAI table;

    public LookupOpImage(RenderedImage renderedImage, TileCache tileCache, ImageLayout imageLayout, LookupTableJAI lookupTableJAI) {
        super(renderedImage, tileCache, imageLayout, true);
        this.table = lookupTableJAI;
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (this.sampleModel.getTransferType() != lookupTableJAI.getDataType() || this.sampleModel.getNumBands() != lookupTableJAI.getDestNumBands(sampleModel.getNumBands())) {
            this.sampleModel = lookupTableJAI.getDestSampleModel(sampleModel, this.tileWidth, this.tileHeight);
            this.colorModel = PlanarImage.createColorModel(this.sampleModel);
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        this.table.lookup(rasterArray[0], writableRaster, rectangle);
    }
}

