/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.RasterFactory;
import javax.media.jai.TileCache;
import javax.media.jai.WarpAffine;
import javax.media.jai.WarpOpImage;

class AffineOpImage
extends WarpOpImage {
    protected AffineTransform i_transform;
    protected Interpolation interp;
    private Rectangle srcimg;
    private Rectangle padimg;
    protected BorderExtender extender;
    private Rectangle theDest;
    public float src_rect_x1;
    public float src_rect_y1;
    public float src_rect_x2;
    public float src_rect_y2;
    protected static final int geom_frac_max = 0x100000;
    double m00;
    double m10;
    double flr_m00;
    double flr_m10;
    double fracdx;
    double fracdx1;
    double fracdy;
    double fracdy1;
    int incx;
    int incx1;
    int incy;
    int incy1;
    int ifracdx;
    int ifracdx1;
    int ifracdy;
    int ifracdy1;
    public int lpad;
    public int rpad;
    public int tpad;
    public int bpad;
    protected static final int USHORT_MAX = 65535;
    protected int clipMinX;
    protected int clipMaxX;
    protected int s_ix;
    protected int s_iy;
    protected int ifracx;
    protected int ifracy;

    public AffineOpImage(RenderedImage renderedImage, BorderExtender borderExtender, TileCache tileCache, ImageLayout imageLayout, AffineTransform affineTransform, Interpolation interpolation) {
        super(renderedImage, borderExtender, tileCache, AffineOpImage.layoutHelper(imageLayout, renderedImage, affineTransform), new WarpAffine(affineTransform), interpolation, true);
        this.interp = interpolation;
        this.extender = borderExtender;
        this.lpad = interpolation.getLeftPadding();
        this.rpad = interpolation.getRightPadding();
        this.tpad = interpolation.getTopPadding();
        this.bpad = interpolation.getBottomPadding();
        this.srcimg = new Rectangle(this.source0.getMinX(), this.source0.getMinY(), this.source0.getWidth(), this.source0.getHeight());
        this.padimg = new Rectangle(this.srcimg.x - this.lpad, this.srcimg.y - this.tpad, this.srcimg.width + this.lpad + this.rpad, this.srcimg.height + this.tpad + this.bpad);
        if (borderExtender == null) {
            float f = this.srcimg.x;
            float f2 = this.srcimg.y;
            float f3 = this.srcimg.width;
            float f4 = this.srcimg.height;
            float f5 = this.lpad;
            float f6 = this.rpad;
            float f7 = this.tpad;
            float f8 = this.bpad;
            if (!(interpolation instanceof InterpolationNearest)) {
                f5 = (float)((double)f5 + 0.5);
                f7 = (float)((double)f7 + 0.5);
                f6 = (float)((double)f6 + 0.5);
                f8 = (float)((double)f8 + 0.5);
            }
            Point2D[] point2DArray = new Point2D[]{new Point2D.Float(f += f5, f2 += f7), new Point2D.Float(f + (f3 -= f5 + f6), f2), new Point2D.Float(f + f3, f2 + (f4 -= f7 + f8)), new Point2D.Float(f, f2 + f4)};
            affineTransform.transform(point2DArray, 0, point2DArray, 0, 4);
            float f9 = Float.MAX_VALUE;
            float f10 = Float.MAX_VALUE;
            float f11 = -3.4028235E38f;
            float f12 = -3.4028235E38f;
            int n = 0;
            while (n < 4) {
                float f13 = (float)point2DArray[n].getX();
                float f14 = (float)point2DArray[n].getY();
                f9 = Math.min(f9, f13);
                f10 = Math.min(f10, f14);
                f11 = Math.max(f11, f13);
                f12 = Math.max(f12, f14);
                ++n;
            }
            int n2 = (int)Math.ceil(f9);
            int n3 = (int)Math.ceil(f10);
            int n4 = (int)Math.floor(f11);
            int n5 = (int)Math.floor(f12);
            this.theDest = new Rectangle(n2, n3, n4 - n2, n5 - n3);
        } else {
            this.theDest = this.getBounds();
        }
        try {
            this.i_transform = affineTransform.createInverse();
        }
        catch (Exception exception) {
            throw new RuntimeException(JaiI18N.getString("AffineOpImage0"));
        }
        this.m00 = this.i_transform.getScaleX();
        this.flr_m00 = Math.floor(this.m00);
        this.fracdx = this.m00 - this.flr_m00;
        this.fracdx1 = 1.0 - this.fracdx;
        this.incx = (int)this.flr_m00;
        this.incx1 = this.incx + 1;
        this.ifracdx = (int)Math.round(this.fracdx * 1048576.0);
        this.ifracdx1 = 0x100000 - this.ifracdx;
        this.m10 = this.i_transform.getShearY();
        this.flr_m10 = Math.floor(this.m10);
        this.fracdy = this.m10 - this.flr_m10;
        this.fracdy1 = 1.0 - this.fracdy;
        this.incy = (int)this.flr_m10;
        this.incy1 = this.incy + 1;
        this.ifracdy = (int)Math.round(this.fracdy * 1048576.0);
        this.ifracdy1 = 0x100000 - this.ifracdy;
    }

    protected void advanceToStartOfScanline(int n) {
        int n2 = this.clipMinX - n;
        long l = ((long)this.ifracx + (long)(n2 * this.ifracdx)) / 0x100000L;
        long l2 = ((long)this.ifracy + (long)(n2 * this.ifracdy)) / 0x100000L;
        this.s_ix += n2 * this.incx + (int)l;
        this.s_iy += n2 * this.incy + (int)l2;
        this.ifracx += n2 * this.ifracdx;
        this.ifracx = this.ifracx >= 0 ? (this.ifracx %= 0x100000) : -(-this.ifracx % 0x100000);
        this.ifracy += n2 * this.ifracdy;
        this.ifracy = this.ifracy >= 0 ? (this.ifracy %= 0x100000) : -(-this.ifracy % 0x100000);
    }

    protected int ceilRatio(long l, long l2) {
        if (l2 < 0L) {
            l2 = -l2;
            l = -l;
        }
        if (l >= 0L) {
            return (int)((l + l2 - 1L) / l2);
        }
        return (int)(l / l2);
    }

    public Raster computeTile(int n, int n2) {
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        WritableRaster writableRaster = RasterFactory.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.tileWidth, this.tileHeight);
        Rectangle rectangle2 = rectangle.intersection(this.theDest);
        if (rectangle2.width <= 0 || rectangle2.height <= 0) {
            return writableRaster;
        }
        Rectangle rectangle3 = this.mapDestRect(rectangle2, 0);
        rectangle3 = this.extender == null ? rectangle3.intersection(this.srcimg) : rectangle3.intersection(this.padimg);
        if (rectangle3.width <= 0 || rectangle3.height <= 0) {
            return writableRaster;
        }
        this.src_rect_x1 = rectangle3.x;
        this.src_rect_y1 = rectangle3.y;
        this.src_rect_x2 = rectangle3.x + rectangle3.width;
        this.src_rect_y2 = rectangle3.y + rectangle3.height;
        Raster[] rasterArray = new Raster[]{this.extender == null ? this.source0.getData(rectangle3) : this.source0.getExtendedData(rectangle3, this.extender)};
        this.computeRect(rasterArray, writableRaster, rectangle2);
        return writableRaster;
    }

    protected int floorRatio(long l, long l2) {
        if (l2 < 0L) {
            l2 = -l2;
            l = -l;
        }
        if (l >= 0L) {
            return (int)(l / l2);
        }
        return (int)((l - l2 + 1L) / l2);
    }

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, AffineTransform affineTransform) {
        ImageLayout imageLayout2 = imageLayout != null ? (ImageLayout)imageLayout.clone() : new ImageLayout();
        float f = renderedImage.getMinX();
        float f2 = renderedImage.getMinY();
        float f3 = renderedImage.getWidth();
        float f4 = renderedImage.getHeight();
        Point2D[] point2DArray = new Point2D[]{new Point2D.Float(f, f2), new Point2D.Float(f + f3, f2), new Point2D.Float(f + f3, f2 + f4), new Point2D.Float(f, f2 + f4)};
        affineTransform.transform(point2DArray, 0, point2DArray, 0, 4);
        float f5 = Float.MAX_VALUE;
        float f6 = Float.MAX_VALUE;
        float f7 = -3.4028235E38f;
        float f8 = -3.4028235E38f;
        int n = 0;
        while (n < 4) {
            float f9 = (float)point2DArray[n].getX();
            float f10 = (float)point2DArray[n].getY();
            f5 = Math.min(f5, f9);
            f6 = Math.min(f6, f10);
            f7 = Math.max(f7, f9);
            f8 = Math.max(f8, f10);
            ++n;
        }
        int n2 = (int)(f7 - f5);
        int n3 = (int)(f8 - f6);
        int n4 = (int)Math.floor(f5);
        int n5 = (double)Math.abs(f5 - (float)n4) <= 0.5 ? n4 : (int)Math.ceil(f5);
        int n6 = (int)Math.floor(f6);
        int n7 = (double)Math.abs(f6 - (float)n6) <= 0.5 ? n6 : (int)Math.ceil(f6);
        imageLayout2.setMinX(n5);
        imageLayout2.setMinY(n7);
        imageLayout2.setWidth(n2);
        imageLayout2.setHeight(n3);
        return imageLayout2;
    }

    public void mapDestPoint(Point2D point2D, Point2D point2D2) {
        this.i_transform.transform(point2D, point2D2);
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n) {
        float f = rectangle.x;
        float f2 = rectangle.y;
        float f3 = rectangle.width;
        float f4 = rectangle.height;
        Point2D[] point2DArray = new Point2D[]{new Point2D.Float(f, f2), new Point2D.Float(f + f3, f2), new Point2D.Float(f + f3, f2 + f4), new Point2D.Float(f, f2 + f4)};
        this.i_transform.transform(point2DArray, 0, point2DArray, 0, 4);
        float f5 = Float.MAX_VALUE;
        float f6 = Float.MAX_VALUE;
        float f7 = -3.4028235E38f;
        float f8 = -3.4028235E38f;
        int n2 = 0;
        while (n2 < 4) {
            float f9 = (float)point2DArray[n2].getX();
            float f10 = (float)point2DArray[n2].getY();
            f5 = Math.min(f5, f9);
            f6 = Math.min(f6, f10);
            f7 = Math.max(f7, f9);
            f8 = Math.max(f8, f10);
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (this.interp instanceof InterpolationNearest) {
            n3 = (int)Math.floor(f5);
            n4 = (int)Math.floor(f6);
            n5 = (int)Math.ceil(f7);
            n6 = (int)Math.ceil(f8);
        } else {
            n3 = (int)Math.floor((double)f5 - 0.5);
            n4 = (int)Math.floor((double)f6 - 0.5);
            n5 = (int)Math.ceil(f7);
            n6 = (int)Math.ceil(f8);
            n3 -= this.lpad;
            n4 -= this.tpad;
            n5 += this.rpad;
            n6 += this.bpad;
        }
        return new Rectangle(n3, n4, n5 - n3, n6 - n4);
    }

    protected void performScanlineClipping(int n, int n2, int n3, int n4, int n5, int n6) {
        long l;
        long l2;
        long l3;
        long l4;
        this.clipMinX = n;
        this.clipMaxX = n2;
        long l5 = this.incx * 0x100000 + this.ifracdx;
        if (l5 != 0L) {
            l4 = (long)this.src_rect_x1 + (long)n3;
            l3 = (long)this.src_rect_x2 - (long)n4;
            l2 = (l4 - (long)this.s_ix) * 0x100000L - (long)this.ifracx + (long)n * l5;
            l = (l3 - (long)this.s_ix) * 0x100000L - (long)this.ifracx + (long)n * l5;
            if (l5 < 0L) {
                long l6 = l2;
                l2 = l;
                l = l6;
            }
            int n7 = this.ceilRatio(l2, l5);
            this.clipMinX = Math.max(this.clipMinX, n7);
            int n8 = this.floorRatio(l, l5) + 1;
            this.clipMaxX = Math.min(this.clipMaxX, n8);
        } else if ((float)this.s_ix < this.src_rect_x1 || (float)this.s_ix >= this.src_rect_x2) {
            this.clipMinX = this.clipMaxX = n;
            return;
        }
        l4 = this.incy * 0x100000 + this.ifracdy;
        if (l4 != 0L) {
            l3 = (long)this.src_rect_y1 + (long)n5;
            l2 = (long)this.src_rect_y2 - (long)n6;
            l = (l3 - (long)this.s_iy) * 0x100000L - (long)this.ifracy + (long)n * l4;
            long l7 = (l2 - (long)this.s_iy) * 0x100000L - (long)this.ifracy + (long)n * l4;
            if (l4 < 0L) {
                long l8 = l;
                l = l7;
                l7 = l8;
            }
            int n9 = this.ceilRatio(l, l4);
            this.clipMinX = Math.max(this.clipMinX, n9);
            int n10 = this.floorRatio(l7, l4) + 1;
            this.clipMaxX = Math.min(this.clipMaxX, n10);
        } else if ((float)this.s_iy < this.src_rect_y1 || (float)this.s_iy >= this.src_rect_y2) {
            this.clipMinX = this.clipMaxX = n;
        }
    }
}

