/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibWarpGridOpImage;
import com.sun.media.jai.mlib.MlibWarpPolynomialOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.TileCache;
import javax.media.jai.Warp;
import javax.media.jai.WarpGrid;
import javax.media.jai.WarpPolynomial;

public class MlibWarpRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        TileCache tileCache = RIFUtil.getTileCacheHint(renderingHints);
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout) || !MediaLibAccessor.hasSameNumBands(parameterBlock, imageLayout)) {
            return null;
        }
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        Warp warp = (Warp)parameterBlock.getObjectParameter(0);
        Interpolation interpolation = (Interpolation)parameterBlock.getObjectParameter(1);
        int n = -1;
        if (interpolation instanceof InterpolationNearest) {
            n = 0;
        } else if (interpolation instanceof InterpolationBilinear) {
            n = 1;
        } else if (interpolation instanceof InterpolationBicubic) {
            n = 2;
        } else if (interpolation instanceof InterpolationBicubic2) {
            n = 3;
        } else {
            return null;
        }
        if (warp instanceof WarpGrid) {
            return new MlibWarpGridOpImage(renderedImage, borderExtender, tileCache, imageLayout, (WarpGrid)warp, interpolation, n);
        }
        if (warp instanceof WarpPolynomial) {
            return new MlibWarpPolynomialOpImage(renderedImage, borderExtender, tileCache, imageLayout, (WarpPolynomial)warp, interpolation, n);
        }
        return null;
    }
}

