/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.DateObject;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.Param;
import com.sybase.jdbc2.jdbc.Protocol;
import com.sybase.jdbc2.tds.CapabilitySet;
import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.tds.TdsDataOutputStream;
import com.sybase.jdbc2.tds.TdsJdbcInputStream;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;

public class TdsParam
extends Param {
    private static final String NULL = "null";
    private static final String ZERO = "0";
    private static final String QUOTE = "'";
    private static final String HEX_START = "0x";
    private DataFormat _inDataFmt;
    byte[] _cvtString = null;
    private TdsDataOutputStream _tdos = null;

    public TdsParam(TdsDataOutputStream tdsDataOutputStream) {
        this._tdos = tdsDataOutputStream;
    }

    protected void clear(boolean bl) throws IOException {
        this._sendAsLiteral = false;
        this._cvtString = null;
        if (bl) {
            this._sqlType = -999;
            this._regType = -999;
            this._inValue = null;
            this._scale = -999;
        }
        if (this._outValue != null) {
            ((TdsJdbcInputStream)this._outValue).clear();
            this._outValue = null;
        }
    }

    protected int getCharCount() throws IOException {
        InputStream inputStream = (InputStream)this._inValue;
        int n = this._scale;
        if (this._scale == -1) {
            n = inputStream.available();
            n /= 2;
        }
        return n;
    }

    protected int getLength() {
        if (this._sqlType != -998 && !this._sendAsLiteral) {
            return this._inDataFmt.length();
        }
        return 0;
    }

    protected String getStringFromStream(int n) throws IOException {
        int n2;
        int n3;
        InputStream inputStream = (InputStream)this._inValue;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; (n <= 0 || i <= n) && (n3 = inputStream.read()) != -1 && (n2 = inputStream.read()) != -1; ++i) {
            char c = (char)(n3 << 8 | n2);
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String literalValue(Protocol protocol, int n, int n2) throws IOException {
        Tds tds = (Tds)protocol;
        switch (this._sqlType) {
            case -7: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return (Boolean)this._inValue != false ? "1" : ZERO;
            }
            case -6: 
            case 4: 
            case 5: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return ((Integer)this._inValue).toString();
            }
            case -5: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return ((Long)this._inValue).toString();
            }
            case 2: 
            case 3: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return ((BigDecimal)this._inValue).toString();
            }
            case 7: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return ((Float)this._inValue).toString();
            }
            case 6: 
            case 8: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                StringBuffer stringBuffer = new StringBuffer("convert(float(32), ");
                stringBuffer.append(((Double)this._inValue).toString());
                stringBuffer.append(")");
                return stringBuffer.toString();
            }
            case 91: 
            case 92: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return QUOTE + ((DateObject)this._inValue).format(false) + QUOTE;
            }
            case 93: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return QUOTE + ((DateObject)this._inValue).format(true) + QUOTE;
            }
            case -1: 
            case 1: 
            case 12: {
                int n3;
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                StringBuffer stringBuffer = null;
                if (this._inValue instanceof String) {
                    n3 = ((String)this._inValue).length();
                    if (n2 > 0 && n2 < n3) {
                        n3 = n2;
                    }
                    stringBuffer = new StringBuffer(n3 + 2);
                    stringBuffer.append(QUOTE);
                    stringBuffer.append(((String)this._inValue).substring(0, n3));
                } else if (this._inValue instanceof InputStream) {
                    n3 = this.getCharCount();
                    if (n2 > 0 && n2 < n3) {
                        n3 = n2;
                    }
                    stringBuffer = new StringBuffer(n3 + 2);
                    stringBuffer.append(QUOTE);
                    stringBuffer.append(this.getStringFromStream(n2));
                } else if (this._inValue instanceof Reader) {
                    n3 = this._scale;
                    if (n2 > 0 && (n2 < n3 || n3 < 0)) {
                        n3 = n2;
                    }
                    stringBuffer = new StringBuffer(n3 + 2);
                    stringBuffer.append(QUOTE);
                    char[] cArray = new char[n3 < 0 || n3 > 2048 ? 2048 : n3];
                    while (n3 > 0 || this._scale < 0) {
                        int n4 = ((Reader)this._inValue).read(cArray);
                        if (n4 <= 0) break;
                        stringBuffer.append(cArray, 0, n4);
                        n3 -= n4;
                    }
                }
                n3 = 1;
                int n5 = stringBuffer.length();
                while ((n3 = stringBuffer.toString().indexOf(39, n3)) != -1) {
                    stringBuffer.insert(n3, '\'');
                    if ((n3 += 2) <= ++n5) continue;
                }
                stringBuffer.append(QUOTE);
                return stringBuffer.toString();
            }
            case -4: 
            case -3: 
            case -2: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                if (this._inValue instanceof byte[]) {
                    if (n2 > 0 && n2 < ((byte[])this._inValue).length) {
                        return HEX_START + HexConverts.hexConvert((byte[])this._inValue, n2);
                    }
                    return HEX_START + HexConverts.hexConvert((byte[])this._inValue);
                }
                InputStream inputStream = (InputStream)this._inValue;
                int n6 = this._scale;
                if (this._scale == -1) {
                    n6 = inputStream.available();
                }
                if (n2 > 0 && n2 < n6) {
                    n6 = n2;
                }
                byte[] byArray = new byte[n6];
                int n7 = 0;
                while (n7 < n6) {
                    int n8 = inputStream.read(byArray, n7, n6 - n7);
                    if (n8 == -1) break;
                    n7 += n8;
                }
                return HEX_START + HexConverts.hexConvert(byArray);
            }
        }
        return "@p" + n;
    }

    protected boolean makeFormat(Protocol protocol) throws IOException {
        if (this._sqlType != -998 && !this._sendAsLiteral) {
            this._inDataFmt = new DataFormat(this, ((Tds)protocol)._out);
            return true;
        }
        return false;
    }

    protected void prepareForSend(Protocol protocol, int n, boolean bl) throws SQLException {
        Tds tds = (Tds)protocol;
        CapabilitySet capabilitySet = tds._capT._reqCaps;
        if (this._sqlType == -999) {
            this._inValue = null;
            this._sqlType = this._regType;
        }
        if (this._sqlType == -999) {
            ErrorMessage.raiseError("JZ0SA", String.valueOf(n));
        }
        switch (this._regType) {
            case -4: {
                if (tds._sendLongAnyway) {
                    this._sendAsLiteral = false;
                }
            }
            case -1: {
                this._sqlType = this._regType;
                break;
            }
        }
        if (!bl && tds._sendLiterals) {
            this._sendAsLiteral = true;
            return;
        }
        switch (this._sqlType) {
            case -5: {
                if (capabilitySet.get(51)) break;
                if (this._inValue != null) {
                    long l = (Long)this._inValue;
                    if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                        this._sendAsLiteral = true;
                        break;
                    }
                    this._inValue = new Integer((int)l);
                }
                this._sqlType = 4;
            }
            case 4: {
                if (capabilitySet.get(12)) break;
                this._sendAsLiteral = true;
                break;
            }
            case -7: {
                if (capabilitySet.get(13)) break;
                if (this._inValue != null) {
                    this._inValue = new Integer((Boolean)this._inValue != false ? 1 : 0);
                }
                this._sqlType = -6;
            }
            case -6: {
                if (this._inValue != null && (Integer)this._inValue >= 0 && capabilitySet.get(10)) break;
                this._sqlType = 5;
            }
            case 5: {
                if (capabilitySet.get(11)) break;
                this._sqlType = 4;
                if (capabilitySet.get(12)) break;
                this._sendAsLiteral = true;
                break;
            }
            case -1: {
                if (this._inValue instanceof InputStream && capabilitySet.get(55)) {
                    this._sqlType = 9219;
                    break;
                }
                if (capabilitySet.get(28)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 1: {
                if (capabilitySet.get(14)) break;
                this._sqlType = 12;
            }
            case 12: {
                if (capabilitySet.get(15)) break;
                this._sendAsLiteral = true;
                break;
            }
            case -4: {
                if (this._inValue instanceof InputStream && capabilitySet.get(57)) {
                    this._sqlType = 9220;
                    break;
                }
                if (tds._sendLongAnyway || capabilitySet.get(29)) break;
                this._sendAsLiteral = true;
                break;
            }
            case -2: {
                if (capabilitySet.get(16)) break;
                this._sqlType = -3;
            }
            case -3: {
                if (capabilitySet.get(17)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 3: {
                if (capabilitySet.get(27)) break;
                this._sqlType = 2;
            }
            case 2: {
                if (capabilitySet.get(24)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 7: {
                if (capabilitySet.get(22)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 6: 
            case 8: {
                if (capabilitySet.get(23)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                if (capabilitySet.get(20)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 2000: {
                if (capabilitySet.get(54) && !this._sendAsLiteral) break;
                ErrorMessage.raiseError("JZ0SE");
                break;
            }
        }
        if (bl && this._sendAsLiteral) {
            ErrorMessage.raiseError("JZ0SM");
        }
    }

    protected void send(OutputStream outputStream, int n) throws IOException {
        if (this._sqlType != -998 && !this._sendAsLiteral) {
            ((TdsDataOutputStream)outputStream).writeParam(this, n);
        }
    }

    protected void sendFormat(DataOutput dataOutput) throws IOException {
        if (this._sqlType != -998 && !this._sendAsLiteral) {
            this._inDataFmt.send((TdsOutputStream)dataOutput);
        }
    }
}

