/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.Convert;
import com.sybase.jdbc2.tds.CachedTdsInt;
import com.sybase.jdbc2.tds.TdsDataObject;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;

public class TdsInt
extends TdsDataObject {
    long _value;

    public TdsInt(TdsProtocolContext tdsProtocolContext) throws IOException {
        super(tdsProtocolContext);
    }

    protected void beginRead() throws IOException {
        this.startRead();
        switch (this._state) {
            case 1: {
                if (this._isNull) {
                    this._value = 0L;
                } else {
                    switch (this._dataFmt._datatype) {
                        case 48: {
                            this._value = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            this._value = this.readShort();
                            break;
                        }
                        case 56: {
                            this._value = this.readInt();
                            break;
                        }
                        case 38: {
                            this._value = this.readINTN();
                            break;
                        }
                    }
                }
                this._state = 3;
                break;
            }
        }
    }

    public void cache() throws IOException {
        this.beginRead();
    }

    public void clear() throws IOException {
        if (this._state == 0) {
            this.getSize();
            this.skip(this._dataLength);
        }
        this.initialize();
    }

    protected TdsDataObject createCachedCopy() throws IOException, SQLException {
        return new CachedTdsInt(this);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.doRead();
        BigDecimal bigDecimal = null;
        if (!this._isNull) {
            bigDecimal = new BigDecimal((double)this._value);
        }
        bigDecimal = Convert.setScale(bigDecimal, n);
        return bigDecimal;
    }

    public boolean getBoolean() throws SQLException {
        this.doRead();
        return this._value != 0L;
    }

    public byte getByte() throws SQLException {
        this.doRead();
        Convert.checkByteOflo(this._value);
        return (byte)this._value;
    }

    public double getDouble() throws SQLException {
        this.doRead();
        return this._value;
    }

    public float getFloat() throws SQLException {
        this.doRead();
        return this._value;
    }

    public int getInt() throws SQLException {
        this.doRead();
        Convert.checkIntOflo(this._value);
        return (int)this._value;
    }

    public long getLong() throws SQLException {
        this.doRead();
        return this._value;
    }

    public Object getObject() throws SQLException {
        this.doRead();
        Integer n = null;
        if (!this._isNull) {
            n = new Integer((int)this._value);
        }
        return n;
    }

    public short getShort() throws SQLException {
        this.doRead();
        Convert.checkShortOflo(this._value);
        return (short)this._value;
    }

    public String getString() throws SQLException {
        this.doRead();
        String string = null;
        if (!this._isNull) {
            string = String.valueOf(this._value);
        }
        return string;
    }
}

