/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.CharsetToUniInputStream;
import com.sybase.jdbc2.jdbc.Cursor;
import com.sybase.jdbc2.jdbc.DateObject;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.JdbcDataObject;
import com.sybase.jdbc2.jdbc.Param;
import com.sybase.jdbc2.jdbc.ParamManager;
import com.sybase.jdbc2.jdbc.ProtocolResultSet;
import com.sybase.jdbc2.jdbc.SybResultSet;
import com.sybase.jdbc2.jdbc.SybStatement;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class SybCursorResultSet
extends SybResultSet
implements com.sybase.jdbcx.SybCursorResultSet {
    protected Cursor _cursor;
    private ParamManager _paramMgr;
    private ParamManager _insertParamMgr;
    private boolean _rowDeleted = false;
    private boolean _rowUpdated = false;
    private boolean _rowInserted = false;
    private int _savedCurrentRow = -4;

    protected SybCursorResultSet(SybStatement sybStatement, ProtocolResultSet protocolResultSet) throws SQLException {
        super(sybStatement, protocolResultSet);
        this._cursor = this._statement._cursor;
        this._concurType = this._cursor.getConcurrency();
        if (this._concurType != 1007) {
            int n = protocolResultSet.getMetaData().getColumnCount();
            this._paramMgr = new ParamManager(n, sybStatement._context);
            this._insertParamMgr = new ParamManager(n, sybStatement._context);
        }
    }

    public void cancelRowUpdates() throws SQLException {
        if (this._rowDeleted || this._rowUpdated || this._rowInserted) {
            ErrorMessage.raiseError("JZ0RM");
        }
        try {
            this._paramMgr.clearParamArray(true);
            this._insertParamMgr.clearParamArray(true);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseError("JZ006", iOException.getMessage());
        }
    }

    protected void close(boolean bl) throws SQLException {
        this._cursor.close(true);
        super.close(bl);
    }

    public void deleteRow() throws SQLException {
        if (this._cursor.delete(this._prs) == 1) {
            this._rowDeleted = true;
        }
    }

    public void deleteRow(String string) throws SQLException {
        this._cursor.setTable(string);
        this._cursor.delete(this._prs);
    }

    protected JdbcDataObject getColumn(int n) throws SQLException {
        this.checkResultSet();
        if (this._rowIndex == -3) {
            Param[] paramArray = this._insertParamMgr.getParams();
            if (n < 1 || n > paramArray.length) {
                ErrorMessage.raiseError("JZ008", String.valueOf(n));
            }
            this._currentColumn = paramArray[n - 1]._sqlType == -999 || paramArray[n - 1]._sqlType == -998 ? null : (JdbcDataObject)((Object)paramArray[n - 1]);
        } else if (this._paramMgr != null) {
            Param[] paramArray = this._paramMgr.getParams();
            if (n < 1 || n > paramArray.length) {
                ErrorMessage.raiseError("JZ008", String.valueOf(n));
            }
            if (paramArray[n - 1]._sqlType == -999 || paramArray[n - 1]._sqlType == -998) {
                this._currentColumn = this._prs.getColumn(n);
            } else {
                if (this._rowDeleted) {
                    ErrorMessage.raiseError("JZ0RM");
                }
                this._currentColumn = (JdbcDataObject)((Object)paramArray[n - 1]);
            }
        } else {
            this._currentColumn = this._prs.getColumn(n);
        }
        return this._currentColumn;
    }

    public int getConcurrency() throws SQLException {
        if (this._cursor == null) {
            ErrorMessage.raiseError("JZ00D");
        }
        return this._cursor.getConcurrency();
    }

    public String getCursorName() throws SQLException {
        return this._cursor.getName();
    }

    public int getFetchSize() throws SQLException {
        return this._cursor.getFetchSize();
    }

    public void insertRow() throws SQLException {
        if (this._rowIndex != -3) {
            ErrorMessage.raiseError("JZ0BR", "insertRow()");
        }
        String string = "INSERT INTO " + this._cursor.getTable() + " ";
        ResultSetMetaData resultSetMetaData = this._prs.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        Param[] paramArray = this._insertParamMgr.getParams();
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            if (paramArray[n2]._sqlType != -999) {
                string = !bl ? String.valueOf(string) + ", " : String.valueOf(string) + "( ";
                string = String.valueOf(string) + resultSetMetaData.getColumnName(n2 + 1);
                bl = false;
            }
            ++n2;
        }
        if (!bl) {
            string = String.valueOf(string) + " ) ";
            bl = true;
        }
        string = String.valueOf(string) + "VALUES (";
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n) {
            if (paramArray[n4]._sqlType == -999) {
                paramArray[n4]._sqlType = -998;
            } else {
                if (!bl) {
                    string = String.valueOf(string) + ", ";
                    n3 += 2;
                }
                string = String.valueOf(string) + "?";
                bl = false;
                paramArray[n4]._paramMarkerOffset = n3++;
            }
            ++n4;
        }
        if (this._cursor.insert(this._prs, this._insertParamMgr, string = String.valueOf(string) + ")") == 1) {
            this._rowInserted = true;
        }
    }

    public boolean isLanguageCursor() {
        return this._cursor.isLanguageCursor();
    }

    public void moveToCurrentRow() throws SQLException {
        if (this._rowIndex == -3) {
            this._rowIndex = this._savedCurrentRow;
            this._rowInserted = false;
        }
    }

    public void moveToInsertRow() throws SQLException {
        if (this._concurType == 1008) {
            if (this._rowIndex != -3) {
                this._savedCurrentRow = this._rowIndex;
                this._rowIndex = -3;
                try {
                    this._insertParamMgr.clearParamArray(true);
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseError("JZ006", iOException.getMessage());
                }
            }
        } else {
            ErrorMessage.raiseError("JZ0BT", "moveToInsertRow()", this._concurTypeString);
        }
    }

    public boolean next() throws SQLException {
        this.checkResultSet();
        this.moveToCurrentRow();
        switch (this._rowIndex) {
            case -2: {
                return false;
            }
            case -1: {
                this._rowIndex = 1;
                break;
            }
            default: {
                if (this._rowIndex <= 0) break;
                ++this._rowIndex;
            }
        }
        if (this._paramMgr != null) {
            try {
                this._paramMgr.clearParamArray(true);
            }
            catch (IOException iOException) {}
        }
        this._rowDeleted = false;
        this._rowUpdated = false;
        this._rowInserted = false;
        boolean bl = this._prs.next();
        if (!bl) {
            this._prs.close(false);
            if (this._cm != null) {
                this._cm.doneReading();
            }
            this._prs = this._cursor.fetch();
            bl = this._prs == null ? false : this._prs.next();
        }
        if (!bl) {
            if (this._statement != null && this._prs != null) {
                this._statement.setRowCount(this._prs.getCount());
            }
            if (this._rowIndex == 1) {
                this._rowIndex = -1;
                this._lastRowIndex = 0;
            } else {
                this._lastRowIndex = this._rowIndex - 1;
                this._rowIndex = -2;
            }
        }
        return bl;
    }

    public boolean rowDeleted() throws SQLException {
        return this._rowDeleted;
    }

    public boolean rowInserted() throws SQLException {
        return this._rowInserted;
    }

    public boolean rowUpdated() throws SQLException {
        return this._rowUpdated;
    }

    public void setFetchSize(int n) throws SQLException {
        this._cursor.setFetchSize(n);
    }

    private void setParam(int n, int n2, Object object) throws SQLException {
        this.setParam(n, n2, object, 0);
    }

    private void setParam(int n, int n2, Object object, int n3) throws SQLException {
        this.checkResultSet();
        if (this._paramMgr != null) {
            if (this._rowIndex != -3) {
                this._paramMgr.setParam(n2, n, object, n3);
            } else {
                this._insertParamMgr.setParam(n2, n, object, n3);
                this._rowInserted = false;
            }
        } else {
            ErrorMessage.raiseError("JZ00H");
        }
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            int n3 = n2 != -1 ? n2 : inputStream.available();
            CharsetToUniInputStream charsetToUniInputStream = new CharsetToUniInputStream(inputStream, n3, n3, null, "8859_1");
            this.setParam(-1, n, charsetToUniInputStream, n2);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseError("JZ006", iOException.getMessage());
        }
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.setParam(2, n, bigDecimal);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setParam(-4, n, inputStream, n2);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        Boolean bl2 = new Boolean(bl);
        this.setParam(-7, n, bl2);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        Integer n2 = new Integer(by);
        if (n2 < 0) {
            this.setParam(5, n, n2);
        } else {
            this.setParam(-6, n, n2);
        }
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        int n2 = 0;
        if (byArray != null) {
            n2 = byArray.length;
        }
        if (n2 > 255) {
            this.setParam(-4, n, byArray);
        } else {
            this.setParam(-3, n, byArray);
        }
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.setParam(-1, n, reader, n2);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.setParam(91, n, new DateObject(date));
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        Double d2 = new Double(d);
        this.setParam(8, n, d2);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        Float f2 = new Float(f);
        this.setParam(7, n, f2);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        Integer n3 = new Integer(n2);
        this.setParam(4, n, n3);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        Long l2 = new Long(l);
        this.setParam(-5, n, l2);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateNull(int n) throws SQLException {
        int n2 = this.getMetaData().getColumnType(n);
        this.setParam(n2, n, null);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.updateObject(n, object, 0);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (object == null) {
            this.updateNull(n);
        } else if (object instanceof String) {
            this.updateString(n, (String)object);
        } else if (object instanceof BigDecimal) {
            this.setParam(2, n, object, n2);
        } else if (object instanceof Boolean) {
            this.setParam(-7, n, object, n2);
        } else if (object instanceof Integer) {
            this.setParam(4, n, object, n2);
        } else if (object instanceof Long) {
            this.setParam(-5, n, object, n2);
        } else if (object instanceof Float) {
            this.setParam(7, n, object, n2);
        } else if (object instanceof Double) {
            this.setParam(8, n, object, n2);
        } else if (object instanceof byte[]) {
            this.updateBytes(n, (byte[])object);
        } else if (object instanceof Date) {
            this.updateDate(n, (Date)object);
        } else if (object instanceof Time) {
            this.updateTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.updateTimestamp(n, (Timestamp)object);
        } else if (object instanceof Serializable) {
            this.setParam(2000, n, object, n2);
        } else {
            ErrorMessage.raiseError("JZ0SE");
        }
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object, 0);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateRow() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("UPDATE " + this._cursor.getTable() + " SET ");
        int n = stringBuffer.length();
        ResultSetMetaData resultSetMetaData = this._prs.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        Param[] paramArray = this._paramMgr.getParams();
        boolean bl = true;
        int n3 = 0;
        while (n3 < n2) {
            if (paramArray[n3]._sqlType == -999) {
                paramArray[n3]._sqlType = -998;
            } else if (paramArray[n3]._sqlType != -998) {
                if (!bl) {
                    stringBuffer.append(", ");
                    n += 2;
                }
                String string = resultSetMetaData.getColumnName(n3 + 1);
                n += string.length() + 3;
                stringBuffer.append(String.valueOf(string) + " = ?");
                paramArray[n3]._paramMarkerOffset = n++;
                bl = false;
            }
            ++n3;
        }
        if (bl) {
            ErrorMessage.raiseError("JZ00G");
        }
        if (this._cursor.update(this._prs, this._paramMgr, stringBuffer.toString()) == 1) {
            this._rowUpdated = true;
        }
    }

    public void updateRow(String string) throws SQLException {
        this._cursor.setTable(string);
        this.updateRow();
    }

    public void updateShort(int n, short s) throws SQLException {
        Integer n2 = new Integer(s);
        this.setParam(5, n, n2);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateString(int n, String string) throws SQLException {
        int n2 = 0;
        if (string != null && (n2 = string.length()) == 0) {
            string = new String(" ");
        }
        if (n2 > 255) {
            this.setParam(-1, n, string);
        } else {
            this.setParam(12, n, string);
        }
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.setParam(92, n, new DateObject(time));
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setParam(93, n, new DateObject(timestamp));
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }
}

