/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.tigr.util.swing.FileTransferPanel;

public class FileTransferDialog
extends JDialog {
    private int result;
    private FileTransferPanel transferPanel;

    public FileTransferDialog(JFrame jFrame, String string, FileFilter[] fileFilterArray) {
        super(jFrame, "Select Files", true);
        Listener listener = new Listener();
        this.transferPanel = new FileTransferPanel(string, fileFilterArray);
        JPanel jPanel = this.createBtnsPanel(listener);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)this.transferPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        container.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(4, 8, 4, 8), 0, 0));
        this.addWindowListener(listener);
        this.pack();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public File[] getFiles() {
        return this.transferPanel.getFiles();
    }

    private JPanel createBtnsPanel(ActionListener actionListener) {
        GridLayout gridLayout = new GridLayout();
        JPanel jPanel = new JPanel(gridLayout);
        JButton jButton = new JButton("OK");
        jButton.setActionCommand("ok-command");
        jButton.addActionListener(actionListener);
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("cancel-command");
        jButton2.addActionListener(actionListener);
        gridLayout.setHgap(4);
        jPanel.add(jButton2);
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                FileTransferDialog.this.result = 0;
                FileTransferDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                FileTransferDialog.this.result = 2;
                FileTransferDialog.this.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            FileTransferDialog.this.result = -1;
            FileTransferDialog.this.dispose();
        }
    }
}

