/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.awt;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.tigr.util.awt.Drawable;
import org.tigr.util.awt.GBA;

public class ProgressBar
extends JDialog {
    private JFrame parent;
    private String title;
    private Color barColor1;
    private Color barColor2;
    private Color textColor;
    private int units = 0;
    private int value = 0;
    private Font progressBarFont;
    private ProgressBarCanvas canvas;
    private Container contentPane;
    private GBA gba;

    public ProgressBar(JFrame jFrame, String string, Color color, Color color2, Color color3, int n) {
        super(jFrame, string, false);
        this.parent = jFrame;
        this.title = string;
        this.barColor1 = color;
        this.barColor2 = color2;
        this.textColor = color3;
        this.units = n;
        this.progressBarFont = new Font("monospaced", 1, 20);
        this.contentPane = this.getContentPane();
        this.gba = new GBA();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ProgressBar.this.hide();
            }
        });
        this.canvas = new ProgressBarCanvas(200, 50, 5, 5, 5, 5);
        this.contentPane.setLayout(new GridBagLayout());
        this.gba.add(this.contentPane, this.canvas, 0, 0, 1, 1, 1, 1, 1, 10);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setResizable(true);
        this.pack();
        this.show();
        this.requestFocus();
    }

    public ProgressBar(JFrame jFrame, String string, int n) {
        this(jFrame, string, Color.green, Color.green, Color.black, n);
    }

    public void drawProgressBar() {
        if (this.value < this.units) {
            this.setVisible(true);
        }
    }

    public void increment(int n) {
        if (this.value < this.units) {
            this.value += n;
            if (this.value * 100 / this.units != (this.value - n) * 100 / this.units) {
                this.canvas.paint(this.canvas.getGraphics());
            }
        }
        if (this.value >= this.units) {
            this.complete();
        }
    }

    public void complete() {
        this.hide();
        this.dispose();
    }

    private class ProgressBarCanvas
    extends Drawable {
        private int width;
        private int height;
        private int preXSpacing;
        private int postXSpacing;
        private int preYSpacing;
        private int postYSpacing;

        public ProgressBarCanvas(int n, int n2, int n3, int n4, int n5, int n6) {
            super(0, n3 + n + n4, 0, n5 + n2 + n6);
            this.width = n;
            this.height = n2;
            this.preXSpacing = n3;
            this.postXSpacing = n4;
            this.preYSpacing = n5;
            this.postYSpacing = n6;
            this.setPreferredSize(new Dimension(n3 + n + n4, n5 + n2 + n6));
            this.setBackground(Color.white);
        }

        public void controlPaint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, ProgressBar.this.barColor1, this.width, 0.0f, ProgressBar.this.barColor2));
            graphics2D.fillRect(this.preXSpacing, this.preYSpacing, ProgressBar.this.value * this.width / ProgressBar.this.units, this.height);
            this.drawRect(graphics2D, this.preXSpacing, this.preYSpacing, this.width, this.height, ProgressBar.this.textColor);
            this.drawString(graphics2D, "" + ProgressBar.this.value * 100 / ProgressBar.this.units + "%", 90, 36, ProgressBar.this.textColor, ProgressBar.this.progressBarFont);
        }
    }
}

