/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.terrain;

import javax.vecmath.Tuple2f;
import javax.vecmath.Vector2f;
import org.tigr.microarray.mev.cluster.algorithm.impl.terrain.InterfaceToObjects;
import org.tigr.microarray.mev.cluster.algorithm.impl.terrain.QuadTreeT;
import org.tigr.microarray.mev.cluster.algorithm.impl.util.FloatArray;
import org.tigr.microarray.mev.cluster.algorithm.impl.util.IntArray;

public class FDGLAlgoT {
    public static final float c_AttractiveRadius = 0.0f;
    public static final float c_RepulsiveRadius = 200.0f;
    public static final float c_dblFDGLAlgoThreshold = 1.0f;
    public static final int c_iQuadTreeDepth = 5;
    public static final int c_iHistoryQueueSize = 10;
    private Vector2f[] m_arrPoints;
    private SLink[][] m_arrLinks;
    private Vector2f m_rPt;
    private QuadTreeT m_QTree;
    private InterfaceToObjects m_pInterface;
    private Vector2f[] m_arrForceField;
    private float m_dblMaxForceLength;
    private int m_iDoNotMove;
    private float[] m_arrEnergyHist = new float[]{-1.0f, -1.0f, -1.0f, -1.0f};
    private int m_iEnergyIndex = 0;
    static final float MAX_ENERGY = 100.0f;

    public FDGLAlgoT(InterfaceToObjects interfaceToObjects) {
        this.m_pInterface = interfaceToObjects;
        this.m_QTree = new QuadTreeT(5, interfaceToObjects);
        this.m_rPt = new Vector2f(0.0f, 0.0f);
        this.m_iDoNotMove = -1;
    }

    private void PushEnergy(float f) {
        this.m_arrEnergyHist[3] = this.m_arrEnergyHist[2];
        this.m_arrEnergyHist[2] = this.m_arrEnergyHist[1];
        this.m_arrEnergyHist[1] = this.m_arrEnergyHist[0];
        this.m_arrEnergyHist[0] = f;
    }

    public float getPercentage() {
        return 100.0f * (float)this.m_iEnergyIndex / 100.0f;
    }

    public boolean shouldStop() {
        if ((float)this.m_iEnergyIndex > 100.0f) {
            return true;
        }
        if (this.m_arrEnergyHist[3] < 0.0f) {
            return false;
        }
        return false;
    }

    private static float CalcAttractiveForceFromR2(float f) {
        float f2 = f - 0.0f;
        if (f > 40000.0f) {
            return 40000.0f;
        }
        if (f2 < 0.0f) {
            return 0.0f;
        }
        return f2;
    }

    private static float CalcRepulsiveForceFromR2(float f) {
        float f2 = 40000.0f - f;
        if (f2 < 0.0f) {
            return 0.0f;
        }
        return f2;
    }

    private Vector2f CalcAttractiveForcesAt(int n) {
        SLink[] sLinkArray = this.m_arrLinks[n];
        int n2 = sLinkArray.length;
        Vector2f vector2f = new Vector2f();
        if (n2 > 0) {
            float f = this.m_arrPoints[n].x;
            float f2 = this.m_arrPoints[n].y;
            Vector2f vector2f2 = new Vector2f();
            for (int i = 0; i < n2; ++i) {
                Vector2f vector2f3 = this.m_arrPoints[sLinkArray[i].m_iToId];
                float f3 = sLinkArray[i].m_Weight;
                vector2f2.set(vector2f3.x - f, vector2f3.y - f2);
                float f4 = vector2f2.length();
                if (f4 <= 0.0f) continue;
                float f5 = f4 * f4;
                float f6 = FDGLAlgoT.CalcAttractiveForceFromR2(f5);
                vector2f2.scale(f3 * f6 / f4);
                vector2f.add((Tuple2f)vector2f2);
            }
        }
        return vector2f;
    }

    private Vector2f CalcRepulsiveForcesAtBruteForce(float f, float f2) {
        int n = this.m_arrPoints.length;
        Vector2f vector2f = new Vector2f();
        Vector2f vector2f2 = new Vector2f();
        for (int i = 0; i < n; ++i) {
            vector2f2.set(f - this.m_arrPoints[i].x, f2 - this.m_arrPoints[i].y);
            float f3 = vector2f2.length();
            float f4 = f3 * f3;
            if (f4 <= 0.0f || f3 <= 0.0f) continue;
            float f5 = FDGLAlgoT.CalcRepulsiveForceFromR2(f4);
            vector2f2.scale(f5 / f3);
            vector2f.add((Tuple2f)vector2f2);
        }
        return vector2f;
    }

    protected Vector2f CalcRepulsiveForcesAt(float f, float f2) {
        this.m_rPt.x = f;
        this.m_rPt.y = f2;
        return this.GetRepulsiveForceFrom(0);
    }

    protected Vector2f GetRepulsiveForceFrom(int n) {
        Vector2f vector2f = new Vector2f(0.0f, 0.0f);
        if (n < 0) {
            return vector2f;
        }
        QuadTreeT.SNode sNode = this.m_QTree.m_arrNodes[n];
        if (sNode.m_iPointNumBehind == 0) {
            return vector2f;
        }
        if (sNode.m_iPointNumBehind == 1) {
            vector2f.x = this.m_rPt.x - this.m_arrPoints[sNode.m_arrPointsIds[0]].x;
            vector2f.y = this.m_rPt.y - this.m_arrPoints[sNode.m_arrPointsIds[0]].y;
            float f = vector2f.length();
            if (f <= 0.0f) {
                return vector2f;
            }
            float f2 = f * f;
            float f3 = FDGLAlgoT.CalcRepulsiveForceFromR2(f2);
            vector2f.scale(f3 / f);
            return vector2f;
        }
        boolean bl = sNode.m_Rect.PtInRect(this.m_rPt);
        boolean bl2 = false;
        boolean bl3 = sNode.IsLeaf();
        if (!bl) {
            boolean bl4 = bl2 = sNode.m_Rect.Distance(this.m_rPt) / Math.max(sNode.m_Rect.Width(), sNode.m_Rect.Height()) >= 1.0f;
        }
        if (!bl3 && !bl2) {
            int n2 = this.m_QTree.GetChild(n, 1);
            vector2f = this.GetRepulsiveForceFrom(n2);
            n2 = this.m_QTree.GetChild(n, 2);
            vector2f.add((Tuple2f)this.GetRepulsiveForceFrom(n2));
            n2 = this.m_QTree.GetChild(n, 3);
            vector2f.add((Tuple2f)this.GetRepulsiveForceFrom(n2));
            n2 = this.m_QTree.GetChild(n, 4);
            vector2f.add((Tuple2f)this.GetRepulsiveForceFrom(n2));
            return vector2f;
        }
        if (bl2) {
            vector2f.x = this.m_rPt.x - sNode.m_ptAvg.x;
            vector2f.y = this.m_rPt.y - sNode.m_ptAvg.y;
            float f = vector2f.length();
            if (f <= 0.0f) {
                return vector2f;
            }
            float f4 = f * f;
            float f5 = FDGLAlgoT.CalcRepulsiveForceFromR2(f4);
            if (f5 <= 0.0f) {
                vector2f.x = 0.0f;
                vector2f.y = 0.0f;
                return vector2f;
            }
            vector2f.scale(f5 * (float)sNode.m_iPointNumBehind / f);
            return vector2f;
        }
        Vector2f vector2f2 = new Vector2f();
        int n3 = sNode.m_arrPointsIds.length;
        for (int i = 0; i < n3; ++i) {
            vector2f2.set(this.m_rPt.x - this.m_arrPoints[sNode.m_arrPointsIds[i]].x, this.m_rPt.y - this.m_arrPoints[sNode.m_arrPointsIds[i]].y);
            float f = vector2f2.length();
            if (f <= 0.0f) {
                return vector2f;
            }
            float f6 = f * f;
            float f7 = FDGLAlgoT.CalcRepulsiveForceFromR2(f6);
            vector2f2.scale(f7 / f);
            vector2f.add((Tuple2f)vector2f2);
        }
        return vector2f;
    }

    public void DoNotMove(int n) {
        this.m_iDoNotMove = n;
    }

    public void CalculateForceField() {
        int n = this.m_arrPoints.length;
        this.m_arrForceField = new Vector2f[n];
        this.m_dblMaxForceLength = 0.0f;
        this.m_QTree.Initialize();
        for (int i = 0; i < n; ++i) {
            this.m_arrForceField[i] = this.CalcAttractiveForcesAt(i);
            this.m_arrForceField[i].add((Tuple2f)this.CalcRepulsiveForcesAt(this.m_arrPoints[i].x, this.m_arrPoints[i].y));
            float f = this.m_arrForceField[i].length();
            if (!(this.m_dblMaxForceLength < f)) continue;
            this.m_dblMaxForceLength = f;
        }
    }

    public void MoveSystem() {
        ++this.m_iEnergyIndex;
        if (this.m_dblMaxForceLength <= 0.0f) {
            return;
        }
        float f = (float)Math.sqrt(Math.sqrt(this.m_dblMaxForceLength));
        if (f <= 0.0f) {
            return;
        }
        int n = this.m_arrPoints.length;
        for (int i = 0; i < n; ++i) {
            if (i == this.m_iDoNotMove) continue;
            float f2 = this.m_arrForceField[i].length();
            if (f2 < f) {
                this.m_arrPoints[i].x += this.m_arrForceField[i].x;
                this.m_arrPoints[i].y += this.m_arrForceField[i].y;
                continue;
            }
            this.m_arrPoints[i].x += this.m_arrForceField[i].x / f2 * f;
            this.m_arrPoints[i].y += this.m_arrForceField[i].y / f2 * f;
        }
        this.PushEnergy(this.m_dblMaxForceLength);
    }

    public void UpdateSource() {
        this.m_pInterface.SetObjectGeom(this.m_arrPoints);
    }

    public void InitFromInterface() {
        int[] nArray = this.m_pInterface.GetAllObjectsIds();
        int n = nArray.length;
        this.m_arrLinks = new SLink[n][];
        this.m_arrPoints = new Vector2f[n];
        for (int i = 0; i < this.m_arrPoints.length; ++i) {
            this.m_arrPoints[i] = new Vector2f();
        }
        Vector2f vector2f = new Vector2f();
        for (int i = 0; i < n; ++i) {
            this.m_pInterface.GetObjectGeom(nArray[i], vector2f);
            this.m_arrPoints[i].x = vector2f.x;
            this.m_arrPoints[i].y = vector2f.y;
            FloatArray floatArray = new FloatArray();
            IntArray intArray = new IntArray();
            this.m_pInterface.GetAdjInfoFor(nArray[i], intArray, floatArray);
            int n2 = intArray.getSize();
            this.m_arrLinks[i] = new SLink[n2];
            for (int j = 0; j < n2; ++j) {
                this.m_arrLinks[i][j] = new SLink();
                this.m_arrLinks[i][j].m_iToId = intArray.get(j);
                this.m_arrLinks[i][j].m_Weight = floatArray.get(j);
            }
        }
    }

    public QuadTreeT GetQuadTree() {
        return this.m_QTree;
    }

    public class SLink {
        int m_iToId;
        float m_Weight;
    }
}

