/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.FloatMatrix;

public class SVM
extends AbstractAlgorithm {
    private static final int POSITIVE_DIAGONAL = 0;
    private static final int NEGATIVE_DIAGONAL = 1;
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    private int number_of_genes;
    private int number_of_samples;
    private boolean svmGenes = true;
    private FloatMatrix expMatrix;
    private boolean seenUnderflow = false;
    private float prevObjective;
    private boolean calcHCL = false;
    private boolean calcGeneHCL = false;
    private boolean calcSampleHCL = false;
    private int method = 0;
    private boolean classifyGens = true;

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.function = algorithmParameters.getInt("hcl-distance-function", 4);
        this.factor = algorithmParameters.getFloat("distance-factor", 1.0f);
        this.absolute = algorithmParameters.getBoolean("hcl-distance-absolute", false);
        this.expMatrix = algorithmData.getMatrix("experiment");
        this.number_of_genes = this.expMatrix.getRowDimension();
        this.number_of_samples = this.expMatrix.getColumnDimension();
        this.svmGenes = algorithmParameters.getBoolean("classify-genes", true);
        float f = algorithmParameters.getFloat("constant", 0.0f);
        float f2 = algorithmParameters.getFloat("coefficient", 0.0f);
        float f3 = algorithmParameters.getFloat("power", 0.0f);
        this.calcHCL = algorithmParameters.getBoolean("calculate-hcl", false);
        this.calcGeneHCL = algorithmParameters.getBoolean("calculate-genes-hcl", false);
        this.calcSampleHCL = algorithmParameters.getBoolean("calculate-samples-hcl", false);
        this.method = algorithmParameters.getInt("linkage-method", 0);
        AlgorithmData algorithmData2 = new AlgorithmData();
        boolean bl = algorithmParameters.getBoolean("is-classify", true);
        if (bl) {
            Cluster cluster;
            FloatMatrix floatMatrix = algorithmData.getMatrix("training");
            FloatMatrix floatMatrix2 = algorithmData.getMatrix("weights");
            float[] fArray = floatMatrix2.getColumnPackedCopy();
            FloatMatrix floatMatrix3 = this.classify(floatMatrix, fArray, f2, f, f3);
            int[][] nArrayArray = new int[][]{this.getPositives(floatMatrix3), this.getNegatives(floatMatrix3)};
            if (this.calcHCL) {
                cluster = new Cluster();
                NodeList nodeList = cluster.getNodeList();
                for (int i = 0; i < nArrayArray.length; ++i) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    int[] nArray = nArrayArray[i];
                    Node node = new Node(nArray);
                    nodeList.addNode(node);
                    node.setValues(this.calculateHierarchicalTree(nArray, this.method, this.calcGeneHCL, this.calcSampleHCL));
                }
                algorithmData2.addCluster("cluster", cluster);
            }
            algorithmData2.addMatrix("discriminant", floatMatrix3);
            algorithmData2.addIntArray("positives", this.getPositives(floatMatrix3));
            algorithmData2.addIntArray("negatives", this.getNegatives(floatMatrix3));
            cluster = this.getMeans(floatMatrix3);
            algorithmData2.addMatrix("means", (FloatMatrix)cluster);
            algorithmData2.addMatrix("variances", this.getVariance(floatMatrix3, (FloatMatrix)cluster));
        } else {
            int[] nArray = algorithmData.getIntArray("classes");
            int n = algorithmParameters.getInt("seed", 0);
            boolean bl2 = algorithmParameters.getBoolean("normalize", false);
            boolean bl3 = algorithmParameters.getBoolean("radial", false);
            float f4 = algorithmParameters.getFloat("width-factor", 1.0f);
            float f5 = algorithmParameters.getFloat("positive-diagonal", 0.0f);
            float f6 = algorithmParameters.getFloat("negative-diagonal", 0.0f);
            float f7 = algorithmParameters.getFloat("diagonal-factor", 0.0f);
            float f8 = algorithmParameters.getFloat("positive-constraint", 1.0f);
            float f9 = algorithmParameters.getFloat("negative-constraint", 1.0f);
            float f10 = algorithmParameters.getFloat("convergence-threshold", 1.0E-5f);
            boolean bl4 = algorithmParameters.getBoolean("constrain-weights", true);
            float[] fArray = this.train(this.expMatrix, nArray, n, bl2, bl3, f2, f, f3, f4, f5, f6, f7, f8, f9, f10, bl4);
            algorithmData2.addMatrix("weights", new FloatMatrix(fArray, 1));
        }
        return algorithmData2;
    }

    public void abort() {
        this.stop = true;
    }

    private final void setSeenUnderflow(boolean bl) {
        this.seenUnderflow = bl;
    }

    private final boolean isSeenUnderflow() {
        return this.seenUnderflow;
    }

    private FloatMatrix computeBaseKernelMatrix(FloatMatrix floatMatrix) {
        FloatMatrix floatMatrix2 = new FloatMatrix(this.number_of_genes, this.number_of_genes);
        for (int i = 0; i < this.expMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < floatMatrix.getRowDimension(); ++j) {
                floatMatrix2.set(i, j, ExperimentUtil.geneDistance(this.expMatrix, floatMatrix, i, j, this.function, 1.0f, false));
            }
        }
        return floatMatrix2;
    }

    private FloatMatrix computeNormalizedBaseKernelMatrix(FloatMatrix floatMatrix) {
        int n;
        int n2;
        FloatMatrix floatMatrix2 = new FloatMatrix(this.number_of_genes, this.number_of_samples);
        FloatMatrix floatMatrix3 = new FloatMatrix(this.number_of_genes, this.number_of_genes);
        float f = 0.0f;
        for (n2 = 0; n2 < this.number_of_genes; ++n2) {
            f = 0.0f;
            for (n = 0; n < this.number_of_samples; ++n) {
                float f2 = floatMatrix.get(n2, n);
                if (Float.isNaN(f2)) continue;
                f = (float)((double)f + Math.pow(f2, 2.0));
            }
            if ((double)f == 0.0) continue;
            f = (float)Math.sqrt(f);
            for (n = 0; n < this.number_of_samples; ++n) {
                floatMatrix2.set(n2, n, floatMatrix.get(n2, n) / f);
            }
        }
        n2 = this.expMatrix.getRowDimension();
        n = floatMatrix.getRowDimension();
        for (int i = 0; i < n2; ++i) {
            for (int j = i; j < n; ++j) {
                float f3 = this.geneDotProduct(floatMatrix2, floatMatrix2, i, j);
                floatMatrix3.set(i, j, f3);
                floatMatrix3.set(j, i, f3);
            }
        }
        return floatMatrix3;
    }

    private float[] createSelfKernelValues(FloatMatrix floatMatrix) {
        float[] fArray = new float[floatMatrix.getRowDimension()];
        this.extractSelfKernelValues(floatMatrix, fArray);
        return fArray;
    }

    private void extractSelfKernelValues(FloatMatrix floatMatrix, float[] fArray) {
        int n = floatMatrix.getRowDimension();
        for (int i = 0; i < n; ++i) {
            fArray[i] = floatMatrix.get(i, i);
        }
    }

    private final float polynomialize(float f, float f2, float f3, float f4) {
        f4 += f3;
        return (float)Math.pow(f4 *= f2, f);
    }

    private void polynomializeMatrix(FloatMatrix floatMatrix, float[] fArray, float f, float f2, float f3) {
        int n;
        int n2 = floatMatrix.getRowDimension();
        int n3 = floatMatrix.getColumnDimension();
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                floatMatrix.set(n, i, this.polynomialize(f, f2, f3, floatMatrix.get(n, i)));
            }
        }
        for (n = 0; n < n2; ++n) {
            fArray[n] = this.polynomialize(f, f2, f3, fArray[n]);
        }
    }

    private final float classify(FloatMatrix floatMatrix, float[] fArray, int n) {
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            float f2 = fArray[i];
            if ((double)f2 == 0.0) continue;
            float f3 = floatMatrix.get(n, i);
            f += (f3 *= f2);
        }
        return f;
    }

    private FloatMatrix classifyList(FloatMatrix floatMatrix, float[] fArray) {
        int n = floatMatrix.getRowDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n, 2);
        for (int i = 0; i < n; ++i) {
            float f = this.classify(floatMatrix, fArray, i);
            if ((double)f >= 0.0) {
                floatMatrix2.set(i, 0, 1.0f);
            } else {
                floatMatrix2.set(i, 0, -1.0f);
            }
            floatMatrix2.set(i, 1, f);
        }
        return floatMatrix2;
    }

    private void normalizeKernelMatrix(FloatMatrix floatMatrix, float[] fArray) {
        int n;
        int n2 = floatMatrix.getRowDimension();
        int n3 = floatMatrix.getColumnDimension();
        for (n = 0; n < n2; ++n) {
            float f = (float)Math.sqrt(fArray[n]);
            for (int i = 0; i < n3; ++i) {
                float f2 = (float)Math.sqrt(fArray[i]);
                float f3 = floatMatrix.get(n, i);
                f3 = (float)((double)f3 / ((double)(f * f2) * 1.0));
                floatMatrix.set(n, i, f3);
            }
        }
        for (n = 0; n < n2; ++n) {
            fArray[n] = 1.0f;
        }
    }

    private float computeMedian(float[] fArray) {
        float f;
        Arrays.sort(fArray);
        int n = fArray.length;
        if (n % 2 == 1) {
            f = fArray[n / 2];
        } else {
            f = fArray[n / 2 - 1];
            f += fArray[n / 2];
            f = (float)((double)f / 2.0);
        }
        return f;
    }

    private final float computeSquaredDistance(float f, float f2, float f3) {
        return f - 2.0f * f2 + f3;
    }

    private float computeTwoSquaredWidth(FloatMatrix floatMatrix, int[] nArray, float f) {
        int n;
        int n2 = floatMatrix.getRowDimension();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (nArray[n] != 1) continue;
            ++n3;
        }
        float[] fArray = new float[n3];
        int n4 = -1;
        for (n = 0; n < n2; ++n) {
            if (nArray[n] != 1) continue;
            fArray[++n4] = Float.MAX_VALUE;
            for (int i = 0; i < n2; ++i) {
                float f2;
                if (nArray[i] == 1 || !(fArray[n4] > (f2 = this.computeSquaredDistance(floatMatrix.get(n, n), floatMatrix.get(n, i), floatMatrix.get(i, i))))) continue;
                fArray[n4] = f2;
            }
        }
        float f3 = this.computeMedian(fArray);
        f3 = (float)((double)f3 * (2.0 * (double)f));
        return f3;
    }

    private float radialKernel(float f, float f2, float f3, float f4) {
        float f5 = this.computeSquaredDistance(f2, f3, f4);
        f5 /= f;
        if ((double)(f5 = (float)Math.exp(-f5)) == 0.0 && !this.isSeenUnderflow()) {
            this.setSeenUnderflow(true);
        }
        return f5;
    }

    private void radializeMatrix(FloatMatrix floatMatrix, float[] fArray, float f, float f2) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                float f3 = this.radialKernel(f, fArray[i], floatMatrix.get(i, j), fArray[j]);
                floatMatrix.set(i, j, f3 += f2);
            }
        }
        this.extractSelfKernelValues(floatMatrix, fArray);
    }

    private float[] getDiagonalConstants(float[] fArray, int[] nArray, float f) {
        if (f == 0.0f) {
            return null;
        }
        int n = nArray.length;
        int n2 = 0;
        int n3 = 0;
        float f2 = this.computeMedian(fArray);
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == 1) {
                ++n2;
                continue;
            }
            ++n3;
        }
        float[] fArray2 = new float[]{(float)n2 / (float)n * f * f2, (float)n3 / (float)n * f * f2};
        return fArray2;
    }

    private void addToKernelDiagonal(FloatMatrix floatMatrix, float[] fArray, int[] nArray, float f, float f2, float f3) {
        float[] fArray2 = this.getDiagonalConstants(fArray, nArray, f3);
        if (fArray2 != null) {
            f = fArray2[0];
            f2 = fArray2[1];
        }
        int n = floatMatrix.getRowDimension();
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == 1) {
                floatMatrix.set(i, i, floatMatrix.get(i, i) + f);
                continue;
            }
            floatMatrix.set(i, i, floatMatrix.get(i, i) + f2);
        }
    }

    private float computeDiscriminant(FloatMatrix floatMatrix, float[] fArray, int[] nArray, int n) {
        float f = 0.0f;
        for (int i = 0; i < nArray.length; ++i) {
            if (Float.isNaN(floatMatrix.get(n, i))) continue;
            f += fArray[i] * floatMatrix.get(n, i) * (float)nArray[i];
        }
        return f;
    }

    private boolean converged(AlgorithmEvent algorithmEvent, FloatMatrix floatMatrix, float[] fArray, int[] nArray, float f) {
        float f2 = 0.0f;
        float f3 = this.computeObjective(floatMatrix, fArray, nArray);
        f2 = f3 - this.prevObjective;
        this.prevObjective = f3;
        if (!Float.isNaN(f2) && !Float.isInfinite(f2)) {
            algorithmEvent.setFloatValue(Math.abs(f2));
            this.fireValueChanged(algorithmEvent);
        }
        return Math.abs(f2) < f;
    }

    private float computeObjective(FloatMatrix floatMatrix, float[] fArray, int[] nArray) {
        float f = 0.0f;
        for (int i = 0; i < nArray.length; ++i) {
            f = (float)((double)f + (double)fArray[i] * (2.0 - (double)(this.computeDiscriminant(floatMatrix, fArray, nArray, i) * (float)nArray[i])));
        }
        return f;
    }

    private float updateWeight(FloatMatrix floatMatrix, float[] fArray, int[] nArray, float f, boolean bl, int n) {
        float f2 = this.computeDiscriminant(floatMatrix, fArray, nArray, n);
        float f3 = floatMatrix.get(n, n);
        float f4 = fArray[n];
        float f5 = nArray[n];
        float f6 = 1.0f - f5 * f2 + f4 * f3;
        f6 = (double)f3 == 0.0 ? (f6 /= f6) : (f6 /= f3);
        if ((double)f3 != 0.0) {
            f4 = fArray[n];
            fArray[n] = f6;
            fArray[n] = f6;
            f2 = this.computeDiscriminant(floatMatrix, fArray, nArray, n);
            fArray[n] = f4;
        }
        if (bl && f6 > f) {
            f6 = f;
        } else if ((double)f6 < 0.0) {
            f6 = 0.0f;
        }
        return f6;
    }

    private long optimizeWeights(FloatMatrix floatMatrix, float[] fArray, int[] nArray, int n, float f, float f2, float f3, boolean bl) throws AlgorithmException {
        long l = 0L;
        float f4 = 0.5f;
        float f5 = 0.5f;
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = f5;
        }
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 3);
        this.fireValueChanged(algorithmEvent);
        Random random = new Random(n);
        while (!this.converged(algorithmEvent, floatMatrix, fArray, nArray, f3)) {
            this.isStop();
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = random.nextInt(nArray.length);
                float f6 = nArray[n2] == 1 ? f : f2;
                fArray[n2] = f4 = this.updateWeight(floatMatrix, fArray, nArray, f6, bl, n2);
            }
            if (l > 1000L) {
                if (JOptionPane.showConfirmDialog(null, "                                Warning: 1000 iterations have failed to optimize weights.\nPlease press OK to continue analysis using current weights OR press CANCEL to abort and try new parameters.\n", "Weight Optimization Warning", 2, 2) == 0) break;
                this.stop = true;
            }
            ++l;
        }
        return l + 1L;
    }

    private void signWeights(float[] fArray, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            fArray[i] = fArray[i] * (float)nArray[i];
        }
    }

    private FloatMatrix classify(FloatMatrix floatMatrix, float[] fArray, float f, float f2, float f3) {
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 2, 0);
        this.sendEvent(algorithmEvent, "CLASSIFYING\n");
        algorithmEvent.setDescription("Computing base kernel matrix\n");
        this.fireValueChanged(algorithmEvent);
        FloatMatrix floatMatrix2 = this.computeNormalizedBaseKernelMatrix(floatMatrix);
        float[] fArray2 = this.createSelfKernelValues(floatMatrix2);
        algorithmEvent.setDescription("Polynomializing kernel matrix\n");
        this.fireValueChanged(algorithmEvent);
        this.polynomializeMatrix(floatMatrix2, fArray2, f3, f, f2);
        FloatMatrix floatMatrix3 = this.classifyList(floatMatrix2, fArray);
        return floatMatrix3;
    }

    private float[] train(FloatMatrix floatMatrix, int[] nArray, int n, boolean bl, boolean bl2, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, boolean bl3) throws AlgorithmException {
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 2, 0);
        this.sendEvent(algorithmEvent, "TRAINING SVM\n");
        this.sendEvent(algorithmEvent, "Computing base kernel matrix\n");
        FloatMatrix floatMatrix2 = this.computeNormalizedBaseKernelMatrix(floatMatrix);
        this.sendEvent(algorithmEvent, "Extract the diagonal from the kernel matrix.\n");
        float[] fArray = this.createSelfKernelValues(floatMatrix2);
        this.isStop();
        if (bl) {
            this.sendEvent(algorithmEvent, "Normalizing kernel matrix\n");
            this.normalizeKernelMatrix(floatMatrix2, fArray);
        }
        this.isStop();
        if (!bl2) {
            this.sendEvent(algorithmEvent, "Polynomializing kernel matrix\n");
            this.polynomializeMatrix(floatMatrix2, fArray, f3, f, f2);
        }
        if (bl2) {
            this.sendEvent(algorithmEvent, "Convert to a radial basis kernel.\n");
            float f11 = this.computeTwoSquaredWidth(floatMatrix2, nArray, f4);
            this.radializeMatrix(floatMatrix2, fArray, f11, f2);
        }
        this.isStop();
        this.sendEvent(algorithmEvent, "Adding constants to kernel matrix\n");
        this.addToKernelDiagonal(floatMatrix2, fArray, nArray, f5, f6, f7);
        this.isStop();
        float[] fArray2 = new float[this.number_of_genes];
        this.sendEvent(algorithmEvent, "Optimizing weights\n");
        this.optimizeWeights(floatMatrix2, fArray2, nArray, n, f8, f9, f10, bl3);
        this.sendEvent(algorithmEvent, "Encoding the classifications as the signs of the weights.\n");
        this.signWeights(fArray2, nArray);
        return fArray2;
    }

    private void isStop() throws AbortException {
        if (this.stop) {
            throw new AbortException();
        }
    }

    private void sendEvent(AlgorithmEvent algorithmEvent, String string) {
        algorithmEvent.setDescription(string);
        this.fireValueChanged(algorithmEvent);
    }

    private int[] getPositives(FloatMatrix floatMatrix) {
        int n = 0;
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            if ((double)floatMatrix.get(i, 0) != 1.0) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            if ((double)floatMatrix.get(i, 0) != 1.0) continue;
            nArray[n] = i;
            ++n;
        }
        return nArray;
    }

    private int[] getNegatives(FloatMatrix floatMatrix) {
        int n = 0;
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            if (!(floatMatrix.get(i, 0) <= 0.0f)) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            if (!(floatMatrix.get(i, 0) <= 0.0f)) continue;
            nArray[n] = i;
            ++n;
        }
        return nArray;
    }

    private float geneDotProduct(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2) {
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        int n3 = floatMatrix.getColumnDimension();
        int n4 = 0;
        double d = 0.0;
        for (int i = 0; i < n3; ++i) {
            if (Float.isNaN(floatMatrix.get(n, i)) || Float.isNaN(floatMatrix2.get(n2, i))) continue;
            d += (double)(floatMatrix.get(n, i) * floatMatrix2.get(n2, i));
            ++n4;
        }
        return (float)d;
    }

    private FloatMatrix getMeans(FloatMatrix floatMatrix) {
        int n = this.expMatrix.getColumnDimension();
        int n2 = this.expMatrix.getRowDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(2, n);
        float f = 0.0f;
        float f2 = 0.0f;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                float f3;
                float f4 = floatMatrix.get(j, 0);
                if (f4 == 1.0f) {
                    f3 = this.expMatrix.get(j, i);
                    if (Float.isNaN(f3)) continue;
                    ++n3;
                    f += f3;
                    continue;
                }
                f3 = this.expMatrix.get(j, i);
                if (Float.isNaN(f3)) continue;
                ++n4;
                f2 += f3;
            }
            floatMatrix2.set(0, i, n3 != 0 ? f / (float)n3 : 0.0f);
            floatMatrix2.set(1, i, n4 != 0 ? f2 / (float)n4 : 0.0f);
            n3 = 0;
            n4 = 0;
            f = 0.0f;
            f2 = 0.0f;
        }
        return floatMatrix2;
    }

    private FloatMatrix getVariance(FloatMatrix floatMatrix, FloatMatrix floatMatrix2) {
        int n = this.expMatrix.getColumnDimension();
        int n2 = this.expMatrix.getRowDimension();
        FloatMatrix floatMatrix3 = new FloatMatrix(2, n);
        float f = 0.0f;
        int n3 = 0;
        float f2 = 0.0f;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                float f3;
                float f4 = floatMatrix.get(j, 0);
                if (f4 == 1.0f) {
                    f3 = this.expMatrix.get(j, i);
                    if (Float.isNaN(f3)) continue;
                    f = (float)((double)f + Math.pow(f3 - floatMatrix2.get(0, i), 2.0));
                    ++n3;
                    continue;
                }
                f3 = this.expMatrix.get(j, i);
                if (Float.isNaN(f3)) continue;
                f2 = (float)((double)f2 + Math.pow(f3 - floatMatrix2.get(1, i), 2.0));
                ++n4;
            }
            floatMatrix3.set(0, i, (float)(n3 > 1 ? Math.sqrt(f / (float)(n3 - 1)) : 0.0));
            floatMatrix3.set(1, i, (float)(n4 > 1 ? Math.sqrt(f2 / (float)(n4 - 1)) : 0.0));
            n3 = 0;
            n4 = 0;
            f = 0.0f;
            f2 = 0.0f;
        }
        return floatMatrix3;
    }

    private NodeValueList calculateHierarchicalTree(int[] nArray, int n, boolean bl, boolean bl2) throws AlgorithmException {
        AlgorithmData algorithmData;
        NodeValueList nodeValueList = new NodeValueList();
        AlgorithmData algorithmData2 = new AlgorithmData();
        FloatMatrix floatMatrix = this.svmGenes ? this.getSubExperiment(this.expMatrix, nArray) : this.getSubExperimentReducedCols(this.expMatrix, nArray);
        algorithmData2.addMatrix("experiment", floatMatrix);
        System.out.println("In SVM algorithm , metric for HCL = " + this.function);
        algorithmData2.addParam("hcl-distance-function", String.valueOf(this.function));
        algorithmData2.addParam("hcl-distance-absolute", String.valueOf(this.absolute));
        algorithmData2.addParam("method-linkage", String.valueOf(n));
        HCL hCL = new HCL();
        if (bl) {
            algorithmData2.addParam("calculate-genes", String.valueOf(true));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        if (bl2) {
            algorithmData2.addParam("calculate-genes", String.valueOf(false));
            algorithmData = hCL.execute(algorithmData2);
            int[] nArray2 = algorithmData.getIntArray("node-order");
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        return nodeValueList;
    }

    private void addNodeValues(NodeValueList nodeValueList, AlgorithmData algorithmData) {
        nodeValueList.addNodeValue(new NodeValue("child-1-array", (Object)algorithmData.getIntArray("child-1-array")));
        nodeValueList.addNodeValue(new NodeValue("child-2-array", (Object)algorithmData.getIntArray("child-2-array")));
        nodeValueList.addNodeValue(new NodeValue("node-order", (Object)algorithmData.getIntArray("node-order")));
        nodeValueList.addNodeValue(new NodeValue("height", (Object)algorithmData.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = floatMatrix.A[nArray[i]];
        }
        return floatMatrix2;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = floatMatrix.copy();
        FloatMatrix floatMatrix3 = new FloatMatrix(nArray.length, floatMatrix2.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix3.A[i] = floatMatrix2.A[nArray[i]];
        }
        floatMatrix3 = floatMatrix3.transpose();
        return floatMatrix3;
    }

    private void validate(AlgorithmData algorithmData) throws AlgorithmException {
        if (algorithmData.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (algorithmData.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (algorithmData.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (algorithmData.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(ArrayList arrayList) {
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)((Float)arrayList.get(i)).floatValue();
        }
        return nArray;
    }

    private void printMatrix(String string, FloatMatrix floatMatrix) {
        System.out.println("===== " + string + " =====");
        floatMatrix.print(5, 2);
    }

    private void printFloatArray(String string, float[] fArray) {
        System.out.println("===== " + string + " =====");
        for (int i = 0; i < fArray.length; ++i) {
            System.out.print(fArray[i] + " ");
        }
        System.out.println();
    }

    private void printKernelDiagonal(FloatMatrix floatMatrix) {
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            System.out.println("Kernal diagonal " + floatMatrix.get(i, i));
        }
    }

    private void printWeights(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            System.out.println("Weight = " + fArray[i]);
        }
    }
}

