/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.Vector;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.util.FloatMatrix;
import org.tigr.util.Maths;
import org.tigr.util.QSort;

public class PCA
extends AbstractAlgorithm {
    private boolean stop = false;
    private int numNeighbors;
    private int numGenes;
    private int numExps;
    private float factor;

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        FloatMatrix floatMatrix = algorithmData.getMatrix("experiment");
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        int n6 = algorithmParameters.getInt("distance-function", 3);
        this.factor = algorithmParameters.getFloat("distance-factor", 1.0f);
        boolean bl = algorithmParameters.getBoolean("distance-absolute", false);
        int n7 = algorithmParameters.getInt("pca-mode", 0);
        this.numNeighbors = algorithmParameters.getInt("numNeighbors", 10);
        this.numGenes = floatMatrix.getRowDimension();
        this.numExps = floatMatrix.getColumnDimension();
        int n8 = floatMatrix.getRowDimension();
        int n9 = floatMatrix.getColumnDimension();
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 2, 0);
        int n10 = 0;
        algorithmEvent.setIntValue(n10);
        algorithmEvent.setDescription("Calculate covariance matrix\n");
        this.fireValueChanged(algorithmEvent);
        FloatMatrix floatMatrix2 = this.imputeKNearestMatrix(floatMatrix, this.numNeighbors);
        FloatMatrix floatMatrix3 = null;
        if (n7 == 0) {
            floatMatrix3 = floatMatrix2;
        } else {
            floatMatrix3 = new FloatMatrix(n9, n9);
            for (int i = 0; i < n9; ++i) {
                for (n5 = 0; n5 < n9; ++n5) {
                    floatMatrix3.set(n5, i, ExperimentUtil.distance(floatMatrix2, n5, i, n6, this.factor, bl));
                }
            }
        }
        float[][] fArray = floatMatrix3.getArrayCopy();
        n5 = floatMatrix3.getRowDimension();
        int n11 = floatMatrix3.getColumnDimension();
        int n12 = Math.min(n5, n11);
        float[] fArray2 = new float[Math.min(n5 + 1, n11)];
        int[] nArray = new int[Math.min(n5 + 1, n11)];
        float[][] fArray3 = new float[n5][n12];
        float[][] fArray4 = new float[n11][n11];
        float[] fArray5 = new float[n11];
        float[] fArray6 = new float[n5];
        boolean bl2 = true;
        boolean bl3 = true;
        int n13 = Math.min(n5 - 1, n11);
        int n14 = Math.max(0, Math.min(n11 - 2, n5));
        for (n4 = 0; n4 < Math.min(n5 + 1, n11); ++n4) {
            nArray[n4] = n4;
        }
        algorithmEvent.setIntValue(++n10);
        algorithmEvent.setDescription("Reducing A to bidiagonal form\n");
        this.fireValueChanged(algorithmEvent);
        n4 = 0;
        for (n3 = 0; n3 < Math.max(n13, n14); ++n3) {
            int n15;
            ++n4;
            if (n3 < n13) {
                fArray2[n3] = 0.0f;
                for (n2 = n3; n2 < n5; ++n2) {
                    fArray2[n3] = Maths.hypot((float)fArray2[n3], (float)fArray[n2][n3]);
                }
                if ((double)fArray2[n3] != 0.0) {
                    if ((double)fArray[n3][n3] < 0.0) {
                        fArray2[n3] = -fArray2[n3];
                    }
                    for (n2 = n3; n2 < n5; ++n2) {
                        float[] fArray7 = fArray[n2];
                        int n16 = n3;
                        fArray7[n16] = fArray7[n16] / fArray2[n3];
                    }
                    float[] fArray8 = fArray[n3];
                    int n17 = n3;
                    fArray8[n17] = (float)((double)fArray8[n17] + 1.0);
                }
                fArray2[n3] = -fArray2[n3];
            }
            for (n2 = n3 + 1; n2 < n11; ++n2) {
                if (n3 < n13 & (double)fArray2[n3] != 0.0) {
                    float f = 0.0f;
                    for (n15 = n3; n15 < n5; ++n15) {
                        f += fArray[n15][n3] * fArray[n15][n2];
                    }
                    f = -f / fArray[n3][n3];
                    for (n15 = n3; n15 < n5; ++n15) {
                        float[] fArray9 = fArray[n15];
                        int n18 = n2;
                        fArray9[n18] = fArray9[n18] + f * fArray[n15][n3];
                    }
                }
                fArray5[n2] = fArray[n3][n2];
            }
            if (bl2 & n3 < n13) {
                for (n2 = n3; n2 < n5; ++n2) {
                    fArray3[n2][n3] = fArray[n2][n3];
                }
            }
            if (n3 >= n14) continue;
            fArray5[n3] = 0.0f;
            for (n2 = n3 + 1; n2 < n11; ++n2) {
                fArray5[n3] = Maths.hypot((float)fArray5[n3], (float)fArray5[n2]);
            }
            if ((double)fArray5[n3] != 0.0) {
                if ((double)fArray5[n3 + 1] < 0.0) {
                    fArray5[n3] = -fArray5[n3];
                }
                n2 = n3 + 1;
                while (n2 < n11) {
                    int n19 = n2++;
                    fArray5[n19] = fArray5[n19] / fArray5[n3];
                }
                int n20 = n3 + 1;
                fArray5[n20] = (float)((double)fArray5[n20] + 1.0);
            }
            fArray5[n3] = -fArray5[n3];
            if (n3 + 1 < n5 & (double)fArray5[n3] != 0.0) {
                for (n2 = n3 + 1; n2 < n5; ++n2) {
                    fArray6[n2] = 0.0f;
                }
                for (n2 = n3 + 1; n2 < n11; ++n2) {
                    for (int i = n3 + 1; i < n5; ++i) {
                        int n21 = i;
                        fArray6[n21] = fArray6[n21] + fArray5[n2] * fArray[i][n2];
                    }
                }
                for (n2 = n3 + 1; n2 < n11; ++n2) {
                    float f = -fArray5[n2] / fArray5[n3 + 1];
                    for (n15 = n3 + 1; n15 < n5; ++n15) {
                        float[] fArray10 = fArray[n15];
                        int n22 = n2;
                        fArray10[n22] = fArray10[n22] + f * fArray6[n15];
                    }
                }
            }
            if (!bl3) continue;
            for (n2 = n3 + 1; n2 < n11; ++n2) {
                fArray4[n2][n3] = fArray5[n2];
            }
        }
        n3 = Math.min(n11, n5 + 1);
        if (n13 < n11) {
            fArray2[n13] = fArray[n13][n13];
        }
        if (n5 < n3) {
            fArray2[n3 - 1] = 0.0f;
        }
        if (n14 + 1 < n3) {
            fArray5[n14] = fArray[n14][n3 - 1];
        }
        fArray5[n3 - 1] = 0.0f;
        if (bl2) {
            algorithmEvent.setDescription("Generating Matrix U\n");
            algorithmEvent.setIntValue(++n10);
            this.fireValueChanged(algorithmEvent);
            for (n2 = n13; n2 < n12; ++n2) {
                for (int i = 0; i < n5; ++i) {
                    fArray3[i][n2] = 0.0f;
                }
                fArray3[n2][n2] = 1.0f;
            }
            for (n2 = n13 - 1; n2 >= 0; --n2) {
                int n23;
                if ((double)fArray2[n2] != 0.0) {
                    for (n23 = n2 + 1; n23 < n12; ++n23) {
                        float f = 0.0f;
                        for (n = n2; n < n5; ++n) {
                            f += fArray3[n][n2] * fArray3[n][n23];
                        }
                        f = -f / fArray3[n2][n2];
                        for (n = n2; n < n5; ++n) {
                            float[] fArray11 = fArray3[n];
                            int n24 = n23;
                            fArray11[n24] = fArray11[n24] + f * fArray3[n][n2];
                        }
                    }
                    for (n23 = n2; n23 < n5; ++n23) {
                        fArray3[n23][n2] = -fArray3[n23][n2];
                    }
                    fArray3[n2][n2] = 1.0f + fArray3[n2][n2];
                    for (n23 = 0; n23 < n2 - 1; ++n23) {
                        fArray3[n23][n2] = 0.0f;
                    }
                    continue;
                }
                for (n23 = 0; n23 < n5; ++n23) {
                    fArray3[n23][n2] = 0.0f;
                }
                fArray3[n2][n2] = 1.0f;
            }
        }
        if (bl3) {
            algorithmEvent.setDescription("Generating Matrix V\n");
            algorithmEvent.setIntValue(++n10);
            this.fireValueChanged(algorithmEvent);
            for (n2 = n11 - 1; n2 >= 0; --n2) {
                int n25;
                if (n2 < n14 & (double)fArray5[n2] != 0.0) {
                    for (n25 = n2 + 1; n25 < n12; ++n25) {
                        float f = 0.0f;
                        for (n = n2 + 1; n < n11; ++n) {
                            f += fArray4[n][n2] * fArray4[n][n25];
                        }
                        f = -f / fArray4[n2 + 1][n2];
                        for (n = n2 + 1; n < n11; ++n) {
                            float[] fArray12 = fArray4[n];
                            int n26 = n25;
                            fArray12[n26] = fArray12[n26] + f * fArray4[n][n2];
                        }
                    }
                }
                for (n25 = 0; n25 < n11; ++n25) {
                    fArray4[n25][n2] = 0.0f;
                }
                fArray4[n2][n2] = 1.0f;
            }
        }
        n2 = n3 - 1;
        int n27 = 0;
        float f = (float)Math.pow(2.0, -52.0);
        algorithmEvent.setDescription("Main iteration loop started...\n");
        algorithmEvent.setIntValue(++n10);
        this.fireValueChanged(algorithmEvent);
        n4 = 0;
        while (n3 > 0) {
            float f2;
            int n28;
            int n29;
            if (++n4 == 240) {
                if (this.stop) {
                    throw new AbortException();
                }
                algorithmEvent.setDescription("Main iteration loop.\n");
                algorithmEvent.setIntValue(++n10);
                this.fireValueChanged(algorithmEvent);
                n4 = 0;
            }
            for (n = n3 - 2; n >= -1 && n != -1; --n) {
                if (!(Math.abs(fArray5[n]) <= f * (Math.abs(fArray2[n]) + Math.abs(fArray2[n + 1])))) continue;
                fArray5[n] = 0.0f;
                break;
            }
            if (n == n3 - 2) {
                n29 = 4;
            } else {
                for (n28 = n3 - 1; n28 >= n && n28 != n; --n28) {
                    f2 = (float)((n28 != n3 ? (double)Math.abs(fArray5[n28]) : 0.0) + (n28 != n + 1 ? (double)Math.abs(fArray5[n28 - 1]) : 0.0));
                    if (!(Math.abs(fArray2[n28]) <= f * f2)) continue;
                    fArray2[n28] = 0.0f;
                    break;
                }
                if (n28 == n) {
                    n29 = 3;
                } else if (n28 == n3 - 1) {
                    n29 = 1;
                } else {
                    n29 = 2;
                    n = n28;
                }
            }
            ++n;
            switch (n29) {
                case 1: {
                    float f3;
                    float f4;
                    float f5;
                    float f6 = fArray5[n3 - 2];
                    fArray5[n3 - 2] = 0.0f;
                    for (int i = n3 - 2; i >= n; --i) {
                        f5 = Maths.hypot((float)fArray2[i], (float)f6);
                        f4 = fArray2[i] / f5;
                        f3 = f6 / f5;
                        fArray2[i] = f5;
                        if (i != n) {
                            f6 = -f3 * fArray5[i - 1];
                            fArray5[i - 1] = f4 * fArray5[i - 1];
                        }
                        if (!bl3) continue;
                        for (int j = 0; j < n11; ++j) {
                            f5 = f4 * fArray4[j][i] + f3 * fArray4[j][n3 - 1];
                            fArray4[j][n3 - 1] = -f3 * fArray4[j][i] + f4 * fArray4[j][n3 - 1];
                            fArray4[j][i] = f5;
                        }
                    }
                    break;
                }
                case 2: {
                    float f3;
                    float f4;
                    float f5;
                    float f7 = fArray5[n - 1];
                    fArray5[n - 1] = 0.0f;
                    for (int i = n; i < n3; ++i) {
                        f5 = Maths.hypot((float)fArray2[i], (float)f7);
                        f4 = fArray2[i] / f5;
                        f3 = f7 / f5;
                        fArray2[i] = f5;
                        f7 = -f3 * fArray5[i];
                        fArray5[i] = f4 * fArray5[i];
                        if (!bl2) continue;
                        for (int j = 0; j < n5; ++j) {
                            f5 = f4 * fArray3[j][i] + f3 * fArray3[j][n - 1];
                            fArray3[j][n - 1] = -f3 * fArray3[j][i] + f4 * fArray3[j][n - 1];
                            fArray3[j][i] = f5;
                        }
                    }
                    break;
                }
                case 3: {
                    float f8 = Math.max(Math.max(Math.max(Math.max(Math.abs(fArray2[n3 - 1]), Math.abs(fArray2[n3 - 2])), Math.abs(fArray5[n3 - 2])), Math.abs(fArray2[n])), Math.abs(fArray5[n]));
                    f2 = fArray2[n3 - 1] / f8;
                    float f5 = fArray2[n3 - 2] / f8;
                    float f4 = fArray5[n3 - 2] / f8;
                    float f3 = fArray2[n] / f8;
                    float f9 = fArray5[n] / f8;
                    float f10 = ((f5 + f2) * (f5 - f2) + f4 * f4) / 2.0f;
                    float f11 = f2 * f4 * (f2 * f4);
                    float f12 = 0.0f;
                    if ((double)f10 != 0.0 | (double)f11 != 0.0) {
                        f12 = (float)Math.sqrt(f10 * f10 + f11);
                        if ((double)f10 < 0.0) {
                            f12 = -f12;
                        }
                        f12 = f11 / (f10 + f12);
                    }
                    float f13 = (f3 + f2) * (f3 - f2) + f12;
                    float f14 = f3 * f9;
                    for (int i = n; i < n3 - 1; ++i) {
                        int n30;
                        float f15 = Maths.hypot((float)f13, (float)f14);
                        float f16 = f13 / f15;
                        float f17 = f14 / f15;
                        if (i != n) {
                            fArray5[i - 1] = f15;
                        }
                        f13 = f16 * fArray2[i] + f17 * fArray5[i];
                        fArray5[i] = f16 * fArray5[i] - f17 * fArray2[i];
                        f14 = f17 * fArray2[i + 1];
                        fArray2[i + 1] = f16 * fArray2[i + 1];
                        if (bl3) {
                            for (n30 = 0; n30 < n11; ++n30) {
                                f15 = f16 * fArray4[n30][i] + f17 * fArray4[n30][i + 1];
                                fArray4[n30][i + 1] = -f17 * fArray4[n30][i] + f16 * fArray4[n30][i + 1];
                                fArray4[n30][i] = f15;
                            }
                        }
                        f15 = Maths.hypot((float)f13, (float)f14);
                        f16 = f13 / f15;
                        f17 = f14 / f15;
                        fArray2[i] = f15;
                        f13 = f16 * fArray5[i] + f17 * fArray2[i + 1];
                        fArray2[i + 1] = -f17 * fArray5[i] + f16 * fArray2[i + 1];
                        f14 = f17 * fArray5[i + 1];
                        fArray5[i + 1] = f16 * fArray5[i + 1];
                        if (!bl2 || i >= n5 - 1) continue;
                        for (n30 = 0; n30 < n5; ++n30) {
                            f15 = f16 * fArray3[n30][i] + f17 * fArray3[n30][i + 1];
                            fArray3[n30][i + 1] = -f17 * fArray3[n30][i] + f16 * fArray3[n30][i + 1];
                            fArray3[n30][i] = f15;
                        }
                    }
                    fArray5[n3 - 2] = f13;
                    ++n27;
                    break;
                }
                case 4: {
                    if ((double)fArray2[n] <= 0.0) {
                        float f18 = fArray2[n] = (double)fArray2[n] < 0.0 ? -fArray2[n] : 0.0f;
                        if (bl3) {
                            for (n28 = 0; n28 <= n2; ++n28) {
                                fArray4[n28][n] = -fArray4[n28][n];
                            }
                        }
                    }
                    while (n < n2 && !(fArray2[n] >= fArray2[n + 1])) {
                        int n31;
                        float f19 = fArray2[n];
                        fArray2[n] = fArray2[n + 1];
                        fArray2[n + 1] = f19;
                        int n32 = nArray[n];
                        nArray[n] = nArray[n + 1];
                        nArray[n + 1] = n32;
                        if (bl3 && n < n11 - 1) {
                            for (n31 = 0; n31 < n11; ++n31) {
                                f19 = fArray4[n31][n + 1];
                                fArray4[n31][n + 1] = fArray4[n31][n];
                                fArray4[n31][n] = f19;
                            }
                        }
                        if (bl2 && n < n5 - 1) {
                            for (n31 = 0; n31 < n5; ++n31) {
                                f19 = fArray3[n31][n + 1];
                                fArray3[n31][n + 1] = fArray3[n31][n];
                                fArray3[n31][n] = f19;
                            }
                        }
                        ++n;
                    }
                    n27 = 0;
                    --n3;
                }
            }
        }
        algorithmEvent.setDescription("End SVD calculation.\n");
        algorithmEvent.setIntValue(++n10);
        this.fireValueChanged(algorithmEvent);
        FloatMatrix floatMatrix4 = new FloatMatrix(fArray3, n5, Math.min(n5 + 1, n11));
        FloatMatrix floatMatrix5 = new FloatMatrix(fArray4, n11, n11);
        FloatMatrix floatMatrix6 = new FloatMatrix(n11, n11);
        float[][] fArray13 = floatMatrix6.getArray();
        for (int i = 0; i < n11; ++i) {
            for (int j = 0; j < n11; ++j) {
                fArray13[i][j] = 0.0f;
            }
            fArray13[i][i] = fArray2[i];
        }
        AlgorithmData algorithmData2 = new AlgorithmData();
        switch (n7) {
            case 0: {
                break;
            }
            case 1: {
                algorithmData2.addMatrix("U", floatMatrix2.times(floatMatrix4));
                break;
            }
            case 2: {
                algorithmData2.addMatrix("U", floatMatrix2.transpose().times(floatMatrix4));
                break;
            }
            case 3: {
                FloatMatrix floatMatrix7 = floatMatrix4.copy();
                FloatMatrix floatMatrix8 = floatMatrix6.copy();
                int n33 = floatMatrix8.getRowDimension();
                for (int i = 0; i < n33; ++i) {
                    floatMatrix8.set(i, i, 1.0f / (float)Math.sqrt(floatMatrix8.get(i, i)));
                }
                floatMatrix4 = floatMatrix2.times(floatMatrix7.times(floatMatrix8));
                algorithmData2.addMatrix("U", floatMatrix2.transpose().times(floatMatrix4));
                break;
            }
        }
        algorithmData2.addMatrix("T", floatMatrix4);
        algorithmData2.addMatrix("S", floatMatrix6);
        algorithmData2.addMatrix("V", floatMatrix5);
        return algorithmData2;
    }

    public void abort() {
        this.stop = true;
    }

    private FloatMatrix imputeKNearestMatrix(FloatMatrix floatMatrix, int n) throws AlgorithmException {
        int n2 = floatMatrix.getRowDimension();
        int n3 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n2, n3);
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, this.numGenes);
        algorithmEvent.setDescription("Imputing missing values");
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        for (int i = 0; i < n2; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            if (this.isMissingValues(floatMatrix, i)) {
                Vector<Integer> vector = new Vector<Integer>();
                for (int j = 0; j < n3; ++j) {
                    if (Float.isNaN(floatMatrix.A[i][j])) continue;
                    vector.add(new Integer(j));
                }
                Vector vector2 = this.getValidGenes(i, floatMatrix, vector);
                Vector vector3 = this.getKNearestGenes(i, n, floatMatrix, vector2, vector);
                for (int j = 0; j < n3; ++j) {
                    floatMatrix2.A[i][j] = !Float.isNaN(floatMatrix.A[i][j]) ? floatMatrix.A[i][j] : this.getExptWeightedMean(i, j, vector3, floatMatrix);
                }
                continue;
            }
            for (int j = 0; j < n3; ++j) {
                floatMatrix2.A[i][j] = floatMatrix.A[i][j];
            }
        }
        return this.imputeRowAverageMatrix(floatMatrix2);
    }

    private FloatMatrix imputeRowAverageMatrix(FloatMatrix floatMatrix) throws AlgorithmException {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n, n2);
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, this.numGenes);
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        for (int i = 0; i < n; ++i) {
            int n3;
            if (this.stop) {
                throw new AbortException();
            }
            float[] fArray = new float[n2];
            float[] fArray2 = new float[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                fArray[n3] = floatMatrix.A[i][n3];
                fArray2[n3] = floatMatrix.A[i][n3];
            }
            for (n3 = 0; n3 < n2; ++n3) {
                if (!Float.isNaN(floatMatrix.A[i][n3])) continue;
                fArray[n3] = this.getMean(fArray2);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                floatMatrix2.A[i][n3] = fArray[n3];
            }
        }
        return floatMatrix2;
    }

    private boolean isMissingValues(FloatMatrix floatMatrix, int n) {
        for (int i = 0; i < floatMatrix.getColumnDimension(); ++i) {
            if (!Float.isNaN(floatMatrix.A[n][i])) continue;
            return true;
        }
        return false;
    }

    private Vector getValidGenes(int n, FloatMatrix floatMatrix, Vector vector) {
        int n2;
        Vector<Integer> vector2 = new Vector<Integer>();
        for (n2 = 0; n2 < floatMatrix.getRowDimension(); ++n2) {
            if (!this.hasAllExpts(n2, floatMatrix, vector) || n == n2) continue;
            vector2.add(new Integer(n2));
        }
        if (vector2.size() < this.numNeighbors) {
            n2 = this.numNeighbors - vector2.size();
            Vector vector3 = this.getAdditionalGenes(n, n2, vector2, floatMatrix);
            for (int i = 0; i < vector3.size(); ++i) {
                vector2.add((Integer)vector3.get(i));
            }
        }
        return vector2;
    }

    private Vector getAdditionalGenes(int n, int n2, Vector vector, FloatMatrix floatMatrix) {
        Vector<Integer> vector2 = new Vector<Integer>();
        Vector<Integer> vector3 = new Vector<Integer>();
        Vector<Float> vector4 = new Vector<Float>();
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            if (i == n) continue;
            float f = ExperimentUtil.geneEuclidianDistance(floatMatrix, null, i, n, this.factor);
            vector4.add(new Float(f));
            vector3.add(new Integer(i));
        }
        float[] fArray = new float[vector4.size()];
        for (int i = 0; i < vector4.size(); ++i) {
            float f;
            fArray[i] = f = ((Float)vector4.get(i)).floatValue();
        }
        QSort qSort = new QSort(fArray);
        float[] fArray2 = qSort.getSorted();
        int[] nArray = qSort.getOrigIndx();
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            int n5 = (Integer)vector3.get(n4);
            if (this.belongsIn(vector, n5)) continue;
            vector2.add(new Integer(n5));
            if (++n3 >= n2) break;
        }
        return vector2;
    }

    Vector getKNearestGenes(int n, int n2, FloatMatrix floatMatrix, Vector vector, Vector vector2) {
        float f;
        int n3;
        Vector<Integer> vector3 = new Vector<Integer>();
        Vector<Integer> vector4 = new Vector<Integer>();
        Vector<Float> vector5 = new Vector<Float>();
        for (int i = 0; i < vector.size(); ++i) {
            n3 = (Integer)vector.get(i);
            if (n == n3) continue;
            f = ExperimentUtil.geneEuclidianDistance(floatMatrix, null, n, n3, this.factor);
            vector5.add(new Float(f));
            vector3.add(new Integer(n3));
        }
        float[] fArray = new float[vector5.size()];
        for (n3 = 0; n3 < vector5.size(); ++n3) {
            fArray[n3] = f = ((Float)vector5.get(n3)).floatValue();
        }
        QSort qSort = new QSort(fArray);
        float[] fArray2 = qSort.getSorted();
        int[] nArray = qSort.getOrigIndx();
        for (int i = 0; i < n2; ++i) {
            int n4 = nArray[i];
            int n5 = (Integer)vector3.get(n4);
            vector4.add(new Integer(n5));
        }
        return vector4;
    }

    private float getExptWeightedMean(int n, int n2, Vector vector, FloatMatrix floatMatrix) {
        int n3;
        float f = 0.0f;
        int n4 = 0;
        float f2 = 0.0f;
        float[] fArray = new float[vector.size()];
        for (int i = 0; i < fArray.length; ++i) {
            n3 = (Integer)vector.get(i);
            if (!Float.isNaN(floatMatrix.A[n3][n2])) {
                float f3 = ExperimentUtil.geneEuclidianDistance(floatMatrix, null, n, n3, this.factor);
                if (f3 == 0.0f) {
                    f3 = Float.MIN_VALUE;
                }
                fArray[i] = 1.0f / f3;
                f2 += fArray[i] * floatMatrix.A[n3][n2];
                ++n4;
                continue;
            }
            fArray[i] = 0.0f;
        }
        float f4 = 0.0f;
        for (n3 = 0; n3 < fArray.length; ++n3) {
            f4 += fArray[n3];
        }
        f = f2 / f4;
        return f;
    }

    private float getMean(float[] fArray) {
        float f = 0.0f;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            f += fArray[i];
            ++n;
        }
        if (n == 0) {
            n = 1;
        }
        return f /= (float)n;
    }

    private boolean hasAllExpts(int n, FloatMatrix floatMatrix, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            int n2 = (Integer)vector.get(i);
            if (!Float.isNaN(floatMatrix.A[n][n2])) continue;
            return false;
        }
        return true;
    }

    private boolean belongsIn(Vector vector, int n) {
        for (int i = 0; i < vector.size(); ++i) {
            int n2 = (Integer)vector.get(i);
            if (n != n2) continue;
            return true;
        }
        return false;
    }
}

