/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import javax.swing.JFrame;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.util.FloatMatrix;
import org.tigr.util.awt.ProgressDialog;

public class GDM
extends AbstractAlgorithm {
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    private FloatMatrix expMatrix;
    private FloatMatrix geneDistanceMatrix;
    private FloatMatrix rawMatrix;
    private int num_samples;
    private int num_genes;
    private boolean pearson = false;
    private long StartTime;
    private long CalculationTime;
    private boolean Stop;
    private int DistanceFunction;
    private ProgressDialog PD;
    private double zeroValue;
    private float maxDist;
    private float minDist;

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.function = algorithmParameters.getInt("distance-function", 4);
        this.factor = algorithmParameters.getFloat("distance-factor", 1.0f);
        this.absolute = algorithmParameters.getBoolean("distance-absolute", false);
        this.expMatrix = algorithmData.getMatrix("experiment");
        if (this.expMatrix == null) {
            throw new AlgorithmException("Input data is absent.");
        }
        this.num_genes = this.expMatrix.getRowDimension();
        this.num_samples = this.expMatrix.getColumnDimension();
        this.geneDistanceMatrix = new FloatMatrix(this.num_genes, this.num_genes);
        this.rawMatrix = new FloatMatrix(this.num_genes, this.num_genes);
        JFrame jFrame = new JFrame();
        this.PD = new ProgressDialog(jFrame, "Gene Distance Matrix Progression", false, 4);
        this.generateDistanceMatrix();
        AlgorithmData algorithmData2 = new AlgorithmData();
        algorithmData2.addMatrix("gdMatrix", this.geneDistanceMatrix);
        algorithmData2.addMatrix("rawMatrix", this.rawMatrix);
        algorithmData2.addParam("maxDist", String.valueOf(this.maxDist));
        algorithmData2.addParam("minDist", String.valueOf(this.minDist));
        algorithmData2.addParam("num_genes", String.valueOf(this.num_genes));
        return algorithmData2;
    }

    public void abort() {
        this.stop = true;
    }

    synchronized float getRawDistance(int n, int n2) {
        float f = Float.NaN;
        switch (this.function) {
            case 1: {
                f = ExperimentUtil.genePearson(this.expMatrix, null, n, n2, this.factor);
                break;
            }
            case 2: {
                f = ExperimentUtil.geneCosine(this.expMatrix, null, n, n2, this.factor);
                break;
            }
            case 3: {
                f = ExperimentUtil.geneCovariance(this.expMatrix, null, n, n2, this.factor);
                break;
            }
            case 4: {
                f = ExperimentUtil.geneEuclidianDistance(this.expMatrix, null, n, n2, this.factor);
                break;
            }
            case 5: {
                f = ExperimentUtil.geneDotProduct(this.expMatrix, null, n, n2, this.factor);
                break;
            }
            case 6: {
                f = ExperimentUtil.genePearsonUncentered(this.expMatrix, null, n, n2, this.factor);
                break;
            }
            case 7: {
                f = (float)Math.pow(ExperimentUtil.genePearsonUncentered(this.expMatrix, null, n, n2, this.factor), 2.0) * this.factor;
                break;
            }
            case 8: {
                f = ExperimentUtil.geneManhattan(this.expMatrix, null, n, n2, this.factor);
                break;
            }
            case 9: {
                f = ExperimentUtil.geneSpearmanRank(this.expMatrix, null, n, n2, this.factor);
                break;
            }
            case 10: {
                f = ExperimentUtil.geneKendallsTau(this.expMatrix, null, n, n2, this.factor);
                break;
            }
            case 11: {
                f = ExperimentUtil.geneMutualInformation(this.expMatrix, null, n, n2, this.factor);
                break;
            }
        }
        if (this.absolute) {
            f = Math.abs(f);
        }
        return f;
    }

    synchronized float getScaledDistance(int n, int n2, float f, float f2) {
        float f3 = Float.NaN;
        float f4 = this.rawMatrix.get(n, n2);
        if (Float.isNaN(f4)) {
            return f4;
        }
        switch (this.function) {
            case 4: 
            case 8: {
                f3 = f4 / f;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                if (!this.absolute) {
                    f3 = (1.0f - f4) / 2.0f;
                    break;
                }
                f3 = 1.0f - Math.abs(f4);
                break;
            }
            case 7: {
                float f5 = !this.absolute ? (1.0f - f4) / 2.0f : 1.0f - Math.abs(f4);
                f3 = 1.0f - f5 * f5;
                break;
            }
            case 3: 
            case 5: {
                float f6;
                if (!this.absolute) {
                    f6 = (f - f4) / (f - f2);
                } else {
                    f = Math.abs(f2) > Math.abs(f) ? Math.abs(f2) : Math.abs(f);
                    f6 = Math.abs(f4) / f;
                }
                f3 = 1.0f - f6;
                break;
            }
        }
        return f3;
    }

    synchronized void generateDistanceMatrix() throws AbortException {
        int n;
        int n2;
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, 100, "Construct Distance Matrix");
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        int n3 = 0;
        int n4 = this.num_genes * this.num_genes;
        int n5 = n4 / 100 + 1;
        int n6 = 0;
        this.maxDist = this.minDist = (float)0;
        float f = this.minDist;
        float f2 = this.minDist;
        for (n2 = 0; n2 < this.num_genes; ++n2) {
            ++n3;
            for (n = n2 + 1; n < this.num_genes; ++n) {
                if (this.stop) {
                    throw new AbortException();
                }
                float f3 = this.getRawDistance(n2, n);
                if (Float.isNaN(f3)) continue;
                f2 = Math.max(f2, f3);
                f = Math.min(f, f3);
                if (f3 == 0.0f && n2 != n) {
                    int n7;
                    int n8 = this.expMatrix.getColumnDimension();
                    for (n7 = 0; n7 < n8 && (Float.isNaN(this.expMatrix.get(n2, n7)) || Float.isNaN(this.expMatrix.get(n, n7))); ++n7) {
                    }
                    if (n7 == n8) {
                        f3 = Float.NaN;
                        ++n6;
                    }
                }
                this.rawMatrix.set(n2, n, f3);
                this.rawMatrix.set(n, n2, f3);
                if (++n3 % n5 != 0) continue;
                algorithmEvent.setIntValue(n3 / n5);
                algorithmEvent.setDescription("Construct Distance Matrix");
                this.fireValueChanged(algorithmEvent);
            }
        }
        for (n2 = 0; n2 < this.num_genes; ++n2) {
            ++n3;
            for (n = n2 + 1; n < this.num_genes; ++n) {
                if (this.stop) {
                    throw new AbortException();
                }
                float f4 = this.getScaledDistance(n2, n, f2, f);
                this.maxDist = Math.max(this.maxDist, f4);
                this.minDist = Math.min(this.minDist, f4);
                this.geneDistanceMatrix.set(n2, n, f4);
                this.geneDistanceMatrix.set(n, n2, f4);
                if (++n3 % n5 != 0) continue;
                algorithmEvent.setIntValue(n3 / n5);
                algorithmEvent.setDescription("Construct Distance Matrix");
                this.fireValueChanged(algorithmEvent);
            }
        }
        this.minDist = 0.0f;
        this.maxDist = 1.0f;
    }
}

