/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.FloatMatrix;
import org.tigr.util.awt.ProgressDialog;

public class CastClust
extends AbstractAlgorithm {
    private boolean stop = false;
    public boolean runInside = false;
    private int function;
    private float factor;
    private boolean absolute;
    private boolean castGenes;
    private FloatMatrix expMatrix;
    private FloatMatrix SimMatrix;
    private CTCluster unassigned;
    private CTCluster openCluster;
    private int CurrentCluster;
    private int m;
    private int n;
    private int maxGene;
    private int minGene;
    private float maxA;
    private float minA;
    private int maxIndex;
    private int minIndex;
    public int clusterCount;
    private boolean changesOccur;
    private boolean pearson = false;
    public float threshold = 0.5f;
    private long StartTime;
    private long CalculationTime;
    private boolean Stop;
    private int DistanceFunction;
    private ProgressDialog PD;
    private double zeroValue;
    private int hcl_function;
    private boolean hcl_absolute;
    int validN;

    public CastClust() {
    }

    public CastClust(boolean bl) {
        this.runInside = bl;
    }

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        this.clusterCount = 0;
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.function = algorithmParameters.getInt("distance-function", 4);
        this.factor = algorithmParameters.getFloat("distance-factor", 1.0f);
        this.absolute = algorithmParameters.getBoolean("distance-absolute", false);
        this.threshold = algorithmParameters.getFloat("threshold", 0.5f);
        this.castGenes = algorithmParameters.getBoolean("cast-cluster-genes", true);
        this.hcl_function = algorithmParameters.getInt("hcl-distance-function", 4);
        this.hcl_absolute = algorithmParameters.getBoolean("hcl-distance-absolute", false);
        boolean bl = algorithmParameters.getBoolean("hierarchical-tree", false);
        int n = algorithmParameters.getInt("method-linkage", 0);
        boolean bl2 = algorithmParameters.getBoolean("calculate-genes", false);
        boolean bl3 = algorithmParameters.getBoolean("calculate-experiments", false);
        this.expMatrix = algorithmData.getMatrix("experiment");
        this.n = this.expMatrix.getRowDimension();
        this.m = this.expMatrix.getColumnDimension();
        this.SimMatrix = new FloatMatrix(this.n, this.n);
        JFrame jFrame = new JFrame();
        this.PD = new ProgressDialog(jFrame, "CAST Progression", false, 4);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.PD.setSize(450, 255);
        this.PD.setLocation((dimension.width - this.PD.getWidth()) / 2, (dimension.height - this.PD.getHeight()) / 2);
        JButton jButton = new JButton(" Cancel ");
        jButton.setBorder(BorderFactory.createBevelBorder(0));
        jButton.setFocusPainted(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CastClust.this.stop = true;
                CastClust.this.PD.dismiss();
            }
        });
        JPanel jPanel = this.PD.getLabelPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)jButton, "South");
        this.PD.setMainPanel(jPanel2);
        CTCluster[] cTClusterArray = this.calculate(this.runInside);
        for (int i = 0; i < cTClusterArray.length; ++i) {
            if (cTClusterArray[i] != null) continue;
            System.out.println("Null Cluster: " + i);
        }
        FloatMatrix floatMatrix = this.getMeans(cTClusterArray);
        FloatMatrix floatMatrix2 = this.getVariances(cTClusterArray, floatMatrix);
        AlgorithmEvent algorithmEvent = null;
        if (bl) {
            algorithmEvent = new AlgorithmEvent((Object)this, 1, cTClusterArray.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(algorithmEvent);
            algorithmEvent.setIntValue(0);
            algorithmEvent.setId(2);
            this.fireValueChanged(algorithmEvent);
        }
        Cluster cluster = new Cluster();
        NodeList nodeList = cluster.getNodeList();
        for (int i = 0; i < cTClusterArray.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] nArray = this.convert2int(cTClusterArray[i].genes);
            Node node = new Node(nArray);
            nodeList.addNode(node);
            if (!bl) continue;
            node.setValues(this.calculateHierarchicalTree(nArray, n, bl2, bl3));
            algorithmEvent.setIntValue(i + 1);
            this.fireValueChanged(algorithmEvent);
        }
        AlgorithmData algorithmData2 = new AlgorithmData();
        algorithmData2.addCluster("cluster", cluster);
        algorithmData2.addParam("number-of-clusters", String.valueOf(cTClusterArray.length));
        algorithmData2.addMatrix("clusters_means", floatMatrix);
        algorithmData2.addMatrix("clusters_variances", floatMatrix2);
        return algorithmData2;
    }

    public void abort() {
        this.stop = true;
    }

    CTCluster[] calculate(boolean bl) {
        int n;
        int n2;
        this.StartTime = System.currentTimeMillis();
        if (!bl) {
            this.PD.setMessage(0, this.clusterCount + " clusters created.");
            if (this.castGenes) {
                this.PD.setMessage(1, "0 genes have been assigned to clusters.");
                this.PD.setMessage(2, this.n + " genes left to be assigned to clusters.");
            } else {
                this.PD.setMessage(1, "0 experiments have been assigned to clusters.");
                this.PD.setMessage(2, this.n + " experiments left to be assigned to clusters.");
            }
            this.PD.setTimerLabel(3, "Running for ", " seconds.", 1000);
            this.PD.setVisible(true);
        }
        this.getSimMatrix();
        CTCluster[] cTClusterArray = new CTCluster[this.n];
        this.unassigned = new CTCluster();
        for (n2 = 0; n2 < this.n; ++n2) {
            this.unassigned.add(n2);
        }
        while (this.unassigned.count != 0) {
            this.openCluster = new CTCluster();
            for (n2 = 0; n2 < this.unassigned.count; ++n2) {
                this.unassigned.affinity.set(n2, new Float(0.0f));
            }
            do {
                this.changesOccur = false;
                while (this.getMaxAffinityGene() && this.maxA >= this.threshold * (float)this.openCluster.count) {
                    this.unassigned.move(this.maxIndex, this.openCluster);
                    for (n = 0; n < this.unassigned.count; ++n) {
                        float f = ((Float)this.unassigned.affinity.elementAt(n)).floatValue();
                        this.unassigned.affinity.setElementAt(new Float(f += this.SimMatrix.get(((Integer)this.unassigned.genes.elementAt(n)).intValue(), this.maxGene)), n);
                    }
                    for (n = 0; n < this.openCluster.count; ++n) {
                        float f = ((Float)this.openCluster.affinity.elementAt(n)).floatValue();
                        this.openCluster.affinity.setElementAt(new Float(f += this.SimMatrix.get(((Integer)this.openCluster.genes.elementAt(n)).intValue(), this.maxGene)), n);
                    }
                    this.changesOccur = true;
                    this.getMaxAffinityGene();
                }
                if ((double)this.minA == this.zeroValue) continue;
                while (this.getMinAffinityGene() && this.minA < this.threshold * (float)this.openCluster.count) {
                    this.openCluster.move(this.minIndex, this.unassigned);
                    for (n = 0; n < this.unassigned.count; ++n) {
                        float f = ((Float)this.unassigned.affinity.elementAt(n)).floatValue();
                        this.unassigned.affinity.setElementAt(new Float(f -= this.SimMatrix.get(((Integer)this.unassigned.genes.elementAt(n)).intValue(), this.minGene)), n);
                    }
                    for (n = 0; n < this.openCluster.count; ++n) {
                        float f = ((Float)this.openCluster.affinity.elementAt(n)).floatValue();
                        this.openCluster.affinity.setElementAt(new Float(f -= this.SimMatrix.get(((Integer)this.openCluster.genes.elementAt(n)).intValue(), this.minGene)), n);
                    }
                    this.changesOccur = true;
                    this.getMinAffinityGene();
                }
            } while (this.changesOccur);
            if (!bl) {
                this.PD.setMessage(0, this.clusterCount + " clusters created.");
                if (this.castGenes) {
                    this.PD.setMessage(1, this.n - this.unassigned.count + " genes have been assigned to clusters.");
                    this.PD.setMessage(2, this.unassigned.count + " genes left to be assigned to clusters.");
                } else {
                    this.PD.setMessage(1, this.n - this.unassigned.count + " experiments have been assigned to clusters.");
                    this.PD.setMessage(2, this.unassigned.count + " experiments left to be assigned to clusters.");
                }
            }
            if (this.clusterCount < this.n) {
                cTClusterArray[this.clusterCount++] = this.openCluster;
            }
            this.openCluster = null;
        }
        if (!bl) {
            this.PD.dismiss();
        }
        CTCluster[] cTClusterArray2 = new CTCluster[this.clusterCount];
        for (n = 0; n < this.clusterCount; ++n) {
            cTClusterArray2[n] = cTClusterArray[n];
        }
        this.CalculationTime = System.currentTimeMillis() - this.StartTime;
        return cTClusterArray2;
    }

    private NodeValueList calculateHierarchicalTree(int[] nArray, int n, boolean bl, boolean bl2) throws AlgorithmException {
        AlgorithmData algorithmData;
        NodeValueList nodeValueList = new NodeValueList();
        AlgorithmData algorithmData2 = new AlgorithmData();
        FloatMatrix floatMatrix = this.castGenes ? this.getSubExperiment(this.expMatrix, nArray) : this.getSubExperimentReducedCols(this.expMatrix, nArray);
        algorithmData2.addMatrix("experiment", floatMatrix);
        algorithmData2.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        algorithmData2.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        algorithmData2.addParam("method-linkage", String.valueOf(n));
        HCL hCL = new HCL();
        if (bl) {
            algorithmData2.addParam("calculate-genes", String.valueOf(true));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        if (bl2) {
            algorithmData2.addParam("calculate-genes", String.valueOf(false));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        return nodeValueList;
    }

    private void addNodeValues(NodeValueList nodeValueList, AlgorithmData algorithmData) {
        nodeValueList.addNodeValue(new NodeValue("child-1-array", (Object)algorithmData.getIntArray("child-1-array")));
        nodeValueList.addNodeValue(new NodeValue("child-2-array", (Object)algorithmData.getIntArray("child-2-array")));
        nodeValueList.addNodeValue(new NodeValue("node-order", (Object)algorithmData.getIntArray("node-order")));
        nodeValueList.addNodeValue(new NodeValue("height", (Object)algorithmData.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = floatMatrix.A[nArray[i]];
        }
        return floatMatrix2;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = floatMatrix.copy();
        FloatMatrix floatMatrix3 = new FloatMatrix(nArray.length, floatMatrix2.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix3.A[i] = floatMatrix2.A[nArray[i]];
        }
        floatMatrix3 = floatMatrix3.transpose();
        return floatMatrix3;
    }

    private void validate(AlgorithmData algorithmData) throws AlgorithmException {
        if (algorithmData.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (algorithmData.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (algorithmData.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (algorithmData.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    synchronized float getDistance(int n, int n2) {
        double d = 0.0;
        if (this.function == 0 || this.function == 2 || this.function == 3 || this.function == 4 || this.function == 5 || this.function == 8 || this.function == 9 || this.function == 10 || this.function == 11) {
            d = ExperimentUtil.geneDistance(this.expMatrix, null, n, n2, 4, this.factor, this.absolute);
        } else if (this.function == 1 || this.function == 6 || this.function == 7) {
            d = this.absolute ? (double)Math.abs(ExperimentUtil.geneDistance(this.expMatrix, null, n, n2, 1, this.factor, this.absolute)) : (double)ExperimentUtil.geneDistance(this.expMatrix, null, n, n2, 1, this.factor, this.absolute);
        }
        return (float)d;
    }

    synchronized void getSimMatrix() {
        float f = 0.0f;
        if (this.function == 1 || this.function == 6 || this.function == 7) {
            this.pearson = true;
        }
        this.zeroValue = this.absolute ? 0.0 : 0.5;
        if (this.pearson) {
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < this.n; ++j) {
                    float f2 = this.getDistance(i, j);
                    f2 = !this.absolute ? (float)(1.0 - ((double)f2 + 1.0) / 2.0) : (float)(((double)f2 + 1.0) / 2.0);
                    this.SimMatrix.set(i, j, f2);
                }
            }
        } else {
            float f3;
            int n;
            int n2;
            for (n2 = 0; n2 < this.n; ++n2) {
                for (n = 0; n < this.n; ++n) {
                    f3 = this.getDistance(n2, n);
                    if (!(f3 > f)) continue;
                    f = f3;
                }
            }
            for (n2 = 0; n2 < this.n; ++n2) {
                for (n = 0; n < this.n; ++n) {
                    f3 = this.getDistance(n2, n);
                    f3 = 1.0f - f3 / f;
                    this.SimMatrix.set(n2, n, f3);
                }
            }
        }
    }

    protected boolean getMaxAffinityGene() {
        if (this.unassigned.count == 0) {
            return false;
        }
        this.maxIndex = 0;
        this.maxA = ((Float)this.unassigned.affinity.elementAt(0)).floatValue();
        for (int i = 1; i < this.unassigned.count; ++i) {
            if (!(((Float)this.unassigned.affinity.elementAt(i)).floatValue() > this.maxA)) continue;
            this.maxA = ((Float)this.unassigned.affinity.elementAt(i)).floatValue();
            this.maxIndex = i;
        }
        this.maxGene = (Integer)this.unassigned.genes.elementAt(this.maxIndex);
        return true;
    }

    protected boolean getMinAffinityGene() {
        if (this.openCluster.count == 0) {
            return false;
        }
        this.minIndex = 0;
        this.minA = ((Float)this.openCluster.affinity.elementAt(0)).floatValue();
        for (int i = 1; i < this.openCluster.count; ++i) {
            if (!(((Float)this.openCluster.affinity.elementAt(i)).floatValue() < this.minA)) continue;
            this.minA = ((Float)this.openCluster.affinity.elementAt(i)).floatValue();
            this.minIndex = i;
        }
        this.minGene = (Integer)this.openCluster.genes.elementAt(this.minIndex);
        return true;
    }

    private FloatMatrix getMeans(CTCluster[] cTClusterArray) {
        FloatMatrix floatMatrix = new FloatMatrix(cTClusterArray.length, this.m);
        for (int i = 0; i < cTClusterArray.length; ++i) {
            FloatMatrix floatMatrix2 = cTClusterArray[i].getMean();
            floatMatrix.A[i] = floatMatrix2.A[0];
        }
        return floatMatrix;
    }

    private FloatMatrix getVariances(CTCluster[] cTClusterArray, FloatMatrix floatMatrix) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                floatMatrix2.set(i, j, this.getSampleVariance(cTClusterArray[i], j, floatMatrix.get(i, j)));
            }
        }
        return floatMatrix2;
    }

    private float getSampleNormalizedSum(CTCluster cTCluster, int n, float f) {
        int n2 = cTCluster.genes.size();
        float f2 = 0.0f;
        this.validN = 0;
        for (int i = 0; i < n2; ++i) {
            float f3 = this.expMatrix.get(((Integer)cTCluster.genes.get(i)).intValue(), n);
            if (Float.isNaN(f3)) continue;
            f2 = (float)((double)f2 + Math.pow(f3 - f, 2.0));
            ++this.validN;
        }
        return f2;
    }

    private float getSampleVariance(CTCluster cTCluster, int n, float f) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(cTCluster, n, f) / (float)(this.validN - 1));
    }

    private class CTCluster {
        int count = 0;
        Vector genes = new Vector();
        Vector affinity = new Vector();

        public Vector fGenes() {
            Vector<Float> vector = new Vector<Float>();
            for (int i = 0; i < this.genes.size(); ++i) {
                vector.addElement(new Float(((Integer)this.genes.elementAt(i)).intValue()));
            }
            return vector;
        }

        public void add(int n) {
            this.add(n, 0.0f);
        }

        public void add(int n, float f) {
            this.genes.add(this.count, new Integer(n));
            this.affinity.add(this.count, new Float(f));
            ++this.count;
        }

        public void remove(int n) {
            int n2 = -1;
            for (int i = 1; i <= this.count; ++i) {
                if ((Integer)this.genes.elementAt(i) != n) continue;
                n2 = i;
                break;
            }
            if (n2 == -1) {
                System.err.println("cluster doesn't contain " + n);
                System.exit(1);
            }
            this.removeIndex(n2);
        }

        public void removeIndex(int n) {
            this.genes.remove(n);
            this.affinity.remove(n);
            --this.count;
        }

        public void move(int n, CTCluster cTCluster) {
            cTCluster.add((Integer)this.genes.elementAt(n), ((Float)this.affinity.elementAt(n)).floatValue());
            this.removeIndex(n);
        }

        protected FloatMatrix getMean() {
            FloatMatrix floatMatrix = new FloatMatrix(1, CastClust.this.m);
            int n = this.genes.size();
            for (int i = 0; i < CastClust.this.m; ++i) {
                float f = 0.0f;
                int n2 = 0;
                for (int j = 0; j < n; ++j) {
                    float f2 = CastClust.this.expMatrix.get(((Integer)this.genes.get(j)).intValue(), i);
                    if (Float.isNaN(f2)) continue;
                    f += f2;
                    ++n2;
                }
                floatMatrix.set(0, i, f / (float)n2);
            }
            return floatMatrix;
        }
    }
}

