/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.JdbcDataObject;
import com.sybase.jdbc2.jdbc.ProtocolResultSet;
import com.sybase.jdbc2.jdbc.SybConnection;
import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.RowFormatToken;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.tds.TdsDataObject;
import com.sybase.jdbc2.tds.TdsInt;
import com.sybase.jdbc2.tds.TdsJdbcInputStream;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.tds.TdsReal;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;

public class TdsResultSet
implements ProtocolResultSet {
    protected TdsProtocolContext _tpc = null;
    protected int _rowCount = 0;
    protected boolean _needNext = true;
    protected SQLWarning _warning;
    protected TdsDataObject[] _columns;
    private RowFormatToken _rowfmt;
    private int _totalColumns = -1;
    private Vector _cachedRows = null;
    private int _rowIndex = 0;
    private boolean _dead = false;
    private int _type = 1003;
    private boolean _scrolling = false;
    private TdsDataObject[] _savedCols = null;

    protected TdsResultSet(TdsProtocolContext tdsProtocolContext) throws SQLException {
        this._tpc = tdsProtocolContext;
        this._rowfmt = tdsProtocolContext._paramFmts;
        this._rowfmt.setPc(tdsProtocolContext);
        this._totalColumns = this._rowfmt._numColumns;
        this._columns = new TdsDataObject[this._totalColumns];
        TdsDataObject tdsDataObject = null;
        try {
            int n = 0;
            while (n < this._totalColumns) {
                DataFormat dataFormat = this._rowfmt.getDataFormat(n);
                switch (dataFormat._datatype) {
                    case 38: 
                    case 48: 
                    case 52: 
                    case 56: {
                        this._columns[n] = new TdsInt(tdsProtocolContext);
                        break;
                    }
                    case 59: 
                    case 62: 
                    case 109: {
                        this._columns[n] = new TdsReal(tdsProtocolContext);
                        break;
                    }
                    default: {
                        this._columns[n] = new TdsJdbcInputStream(tdsProtocolContext, (Tds)tdsProtocolContext._protocol);
                    }
                }
                this._columns[n]._dataFmt = dataFormat;
                this._columns[n].setPrevious(tdsDataObject);
                if (tdsDataObject != null) {
                    tdsDataObject.setNext(this._columns[n]);
                }
                tdsDataObject = this._columns[n];
                ++n;
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseError("JZ006", iOException.getMessage());
        }
    }

    public void absolute(int n) {
        if (this._rowIndex != n && n != 0) {
            this._rowIndex = n;
            this._columns = (TdsDataObject[])this._cachedRows.get(this._rowIndex - 1);
        }
    }

    private void cacheCurrentRow() throws SQLException {
        TdsDataObject[] tdsDataObjectArray = new TdsDataObject[this._totalColumns];
        try {
            int n = 0;
            while (n < this._totalColumns) {
                tdsDataObjectArray[n] = this._columns[n].createCachedCopy();
                ++n;
            }
            this._cachedRows.insertElementAt(tdsDataObjectArray, this._rowIndex - 1);
            this._savedCols = this._columns;
            this._columns = tdsDataObjectArray;
        }
        catch (IOException iOException) {
            ErrorMessage.raiseError("JZ006", iOException.getMessage());
        }
    }

    public void clearWarnings() throws SQLException {
        this._warning = null;
    }

    public void close(boolean bl) throws SQLException {
        if (this._dead) {
            return;
        }
        if (this._scrolling) {
            this._scrolling = false;
            this._columns = this._savedCols;
        }
        if (!bl) {
            while (this.next()) {
            }
        }
        this.markDead();
    }

    protected void dump() {
    }

    public int findColumn(String string) throws SQLException {
        int n = 0;
        int n2 = 0;
        while (n2 < this._rowfmt._numColumns) {
            if ((this._rowfmt.getStatus(n2) & 1) == 0) {
                ++n;
                if (this._rowfmt.getName(n2).equalsIgnoreCase(string)) {
                    return n;
                }
            }
            ++n2;
        }
        ErrorMessage.raiseError("S0022", string);
        return -1;
    }

    public JdbcDataObject getColumn(int n) throws SQLException {
        if (this._needNext && !this._scrolling) {
            ErrorMessage.raiseError("JZ0R1");
        }
        int n2 = this._rowfmt.mapColumn(n);
        return this._columns[n2];
    }

    public int getCount() throws SQLException {
        return this._rowCount;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this._rowfmt;
    }

    public int getNumRowsCached() {
        return this._scrolling ? this._cachedRows.size() : 0;
    }

    public int getType() {
        return this._type;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this._warning;
    }

    protected void handleSQLE(SQLException sQLException) throws SQLException {
        boolean bl = SybConnection.thisChainHasAnException(sQLException);
        SQLWarning sQLWarning = null;
        sQLWarning = !bl ? (SQLWarning)sQLException : SybConnection.getAllTheWarnings(sQLException);
        if (sQLWarning != null) {
            if (this._warning == null) {
                this._warning = sQLWarning;
            } else {
                this._warning.setNextWarning(sQLWarning);
            }
        }
        if (bl) {
            throw sQLException;
        }
    }

    protected synchronized void markDead() {
        this._dead = true;
    }

    public boolean next() throws SQLException {
        if (this._scrolling) {
            if (this._rowIndex < this._cachedRows.size()) {
                ++this._rowIndex;
                this._columns = (TdsDataObject[])this._cachedRows.get(this._rowIndex - 1);
                return true;
            }
            if (this._dead) {
                ++this._rowIndex;
                return false;
            }
        }
        if (!this._needNext) {
            this._tpc._lastResult = -1;
            try {
                if (this._scrolling) {
                    this._columns = this._savedCols;
                }
                int n = 0;
                while (n < this._totalColumns) {
                    this._columns[n].clear();
                    ++n;
                }
            }
            catch (IOException iOException) {
                ErrorMessage.raiseError("JZ006", iOException.getMessage());
            }
        }
        int n = this.nextResult();
        switch (n) {
            case 209: {
                ++this._rowIndex;
                ++this._rowCount;
                if (this._scrolling) {
                    this.cacheCurrentRow();
                }
                this._needNext = false;
                return true;
            }
            case 5: {
                this._rowCount = this._tpc._protocol.count(this._tpc);
                ++this._rowIndex;
                this.markDead();
                return false;
            }
        }
        this._tpc._protocol.ungetResult(this._tpc, n);
        this.markDead();
        return false;
    }

    protected int nextResult() throws SQLException {
        int n;
        while (true) {
            try {
                n = this._tpc._protocol.nextResult(this._tpc);
            }
            catch (SQLException sQLException) {
                this.handleSQLE(sQLException);
                continue;
            }
            break;
        }
        return n;
    }

    protected void prepareForNextFetch() {
        this._needNext = true;
        if (this._scrolling) {
            if (this._rowIndex != 0) {
                --this._rowIndex;
            }
            this._dead = false;
        }
    }

    public void previous() {
        --this._rowIndex;
        if (this._rowIndex != 0) {
            this._columns = (TdsDataObject[])this._cachedRows.get(this._rowIndex - 1);
        }
    }

    public void setType(int n) {
        this._type = n;
        if (this._type == 1004) {
            this._cachedRows = new Vector();
            this._scrolling = true;
        }
    }
}

