/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.Cursor;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.MdaManager;
import com.sybase.jdbc2.jdbc.Param;
import com.sybase.jdbc2.jdbc.ParamManager;
import com.sybase.jdbc2.jdbc.Protocol;
import com.sybase.jdbc2.jdbc.ProtocolContext;
import com.sybase.jdbc2.jdbc.ProtocolManager;
import com.sybase.jdbc2.jdbc.ProtocolResultSet;
import com.sybase.jdbc2.jdbc.SybConnection;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.jdbc.SybSQLException;
import com.sybase.jdbc2.jdbc.SybSQLWarning;
import com.sybase.jdbc2.jdbc.TextPointer;
import com.sybase.jdbc2.tds.CapabilityToken;
import com.sybase.jdbc2.tds.CurInfoToken;
import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.DbrpcToken;
import com.sybase.jdbc2.tds.DoneToken;
import com.sybase.jdbc2.tds.DynamicToken;
import com.sybase.jdbc2.tds.EedToken;
import com.sybase.jdbc2.tds.EnvChangeToken;
import com.sybase.jdbc2.tds.Iana;
import com.sybase.jdbc2.tds.KeyToken;
import com.sybase.jdbc2.tds.LanguageToken;
import com.sybase.jdbc2.tds.LoginAckToken;
import com.sybase.jdbc2.tds.LoginToken;
import com.sybase.jdbc2.tds.LogoutToken;
import com.sybase.jdbc2.tds.ParamFormatToken;
import com.sybase.jdbc2.tds.ParamsToken;
import com.sybase.jdbc2.tds.PduOutputFormatter;
import com.sybase.jdbc2.tds.RowFormatToken;
import com.sybase.jdbc2.tds.Slurp;
import com.sybase.jdbc2.tds.TdsConst;
import com.sybase.jdbc2.tds.TdsCursor;
import com.sybase.jdbc2.tds.TdsDataOutputStream;
import com.sybase.jdbc2.tds.TdsEventContext;
import com.sybase.jdbc2.tds.TdsJdbcInputStream;
import com.sybase.jdbc2.tds.TdsParam;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.tds.TdsResultSet;
import com.sybase.jdbc2.tds.TdsUpdateParam;
import com.sybase.jdbc2.timedio.InStreamMgr;
import com.sybase.jdbc2.timedio.OutStreamMgr;
import com.sybase.jdbc2.utils.CacheManager;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbc2.utils.HexConverts;
import com.sybase.jdbc2.utils.SyncObj;
import com.sybase.jdbcx.CharsetConverter;
import com.sybase.jdbcx.SybEventHandler;
import com.sybase.jdbcx.SybMessageHandler;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Hashtable;
import java.util.Vector;

public class Tds
extends TdsConst
implements Protocol {
    protected InStreamMgr _inStreamMgr = null;
    protected OutStreamMgr _outStreamMgr = null;
    private PduOutputFormatter _outFormat = null;
    protected TdsDataOutputStream _out = null;
    protected boolean _sendLiterals = false;
    protected boolean _sendLongAnyway = false;
    protected boolean _stripExec = false;
    private SybProperty _info = null;
    private Hashtable _typeSearchableList = null;
    private TdsProtocolContext _utilContext = null;
    private TdsEventContext _eventCtx = null;
    private int _maxRows = 0;
    private boolean _adjustingMaxRows = false;
    private int _packetSize = 512;
    protected String _charsetName = null;
    private String _serverDefaultCharsetName = null;
    protected CharsetConverter _charsetConverter = null;
    private boolean _inLogin = false;
    private boolean _cancelSent = false;
    protected boolean _gotCancelAck = false;
    private SybConnection _conn;
    protected CapabilityToken _capT = null;
    private int _capsTry = 0;
    private Vector _contexts;
    boolean _bigEndian = true;
    boolean _ignoreDIP = false;
    private static final String COMMIT_QUERY = "commit";
    private static final String ROLLBACK_QUERY = "rollback";
    private static final int[] INFO_MSGNO;
    private static final int WARNING_SEVERITY = 10;

    static {
        ProtocolManager.registerProtocol(new Tds());
        INFO_MSGNO = new int[]{5701, 5703, 5704, 7326};
    }

    private void adjustMaxRows(TdsProtocolContext tdsProtocolContext) throws SQLException {
        if (this._adjustingMaxRows) {
            return;
        }
        this._adjustingMaxRows = true;
        PreparedStatement preparedStatement = null;
        try {
            try {
                if (this._maxRows != tdsProtocolContext._maxRows) {
                    MdaManager mdaManager = this._conn.getMDA(tdsProtocolContext);
                    preparedStatement = mdaManager.getMetaDataAccessor("SET_ROWCOUNT", tdsProtocolContext);
                    preparedStatement.setInt(1, tdsProtocolContext._maxRows);
                    preparedStatement.executeUpdate();
                    preparedStatement.close();
                    this._maxRows = tdsProtocolContext._maxRows;
                }
            }
            catch (SQLException sQLException) {
                tdsProtocolContext._maxRows = this._maxRows;
                throw sQLException;
            }
            Object var4_5 = null;
            this._adjustingMaxRows = false;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this._adjustingMaxRows = false;
            throw throwable;
        }
    }

    public void bulkWrite(TextPointer textPointer, InputStream inputStream, int n, int n2, boolean bl) throws SQLException {
        try {
            if (n2 + n > inputStream.available()) {
                ErrorMessage.raiseError("JZ0J0");
            }
        }
        catch (IOException iOException) {
            this.handleIOE(iOException);
        }
        byte[] byArray = textPointer._textPtr;
        byte[] byArray2 = textPointer._timeStamp;
        String string = textPointer._tableName;
        String string2 = textPointer._columnName;
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)this.getProtocolContext(this._info);
        String string3 = HexConverts.hexConvert(byArray, 16);
        String string4 = HexConverts.hexConvert(byArray2, 8);
        String string5 = "writetext bulk " + string + "." + string2 + " 0x" + string3 + " timestamp = 0x" + string4;
        if (bl) {
            string5 = String.valueOf(string5) + " with log";
        }
        this._outStreamMgr.getSendLock(tdsProtocolContext);
        tdsProtocolContext.setSponsor(tdsProtocolContext);
        this.language(tdsProtocolContext, string5, null);
        try {
            this.getDoneResult(tdsProtocolContext);
        }
        catch (SQLException sQLException) {
            tdsProtocolContext.setSponsor(null);
            this._outStreamMgr.endRequest(tdsProtocolContext);
            this.cancel(tdsProtocolContext, false);
            throw sQLException;
        }
        int n3 = this._packetSize - 8;
        byte[] byArray3 = new byte[n3];
        this._outStreamMgr.beginRequest(tdsProtocolContext);
        try {
            try {
                this._outFormat.setPDUHeader(7, 0);
                int n4 = 0;
                if (n2 == 0) {
                    n2 = inputStream.available();
                } else if (n > 0) {
                    inputStream.skip(n);
                }
                this._out.writeInt(n2);
                while ((n4 = inputStream.read(byArray3, 0, Math.min(n2, byArray3.length))) > 0) {
                    this._outFormat.write(byArray3, n4);
                    n2 -= n4;
                }
                this._outFormat.flush();
                this._outStreamMgr.queueRequest(tdsProtocolContext);
            }
            catch (IOException iOException) {
                this.handleIOE(iOException);
            }
            Object var17_21 = null;
            this._outFormat.setPDUHeader(15, 0);
            tdsProtocolContext.setSponsor(null);
            this._outStreamMgr.endRequest(tdsProtocolContext);
        }
        catch (Throwable throwable) {
            Object var17_22 = null;
            this._outFormat.setPDUHeader(15, 0);
            tdsProtocolContext.setSponsor(null);
            this._outStreamMgr.endRequest(tdsProtocolContext);
            throw throwable;
        }
        try {
            block16: while (true) {
                int n5 = this.nextResult(tdsProtocolContext);
                switch (n5) {
                    case 3: {
                        if (tdsProtocolContext._lastTds == 172) {
                            int n6 = tdsProtocolContext._in.readUnsignedShort();
                            TdsJdbcInputStream tdsJdbcInputStream = new TdsJdbcInputStream(tdsProtocolContext, this);
                            tdsJdbcInputStream._dataFmt = new DataFormat(tdsProtocolContext._in, false);
                            byArray2 = tdsJdbcInputStream.getBytes();
                            System.arraycopy(byArray2, 0, textPointer._timeStamp, 0, byArray2.length);
                            tdsProtocolContext._lastResult = -1;
                            continue block16;
                        }
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0P1");
                        continue block16;
                    }
                    case 0: {
                        return;
                    }
                }
                break;
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (IOException iOException) {
            this.handleIOE(iOException);
            return;
        }
    }

    public void cancel(ProtocolContext protocolContext, boolean bl) throws SQLException {
        TdsProtocolContext tdsProtocolContext;
        TdsProtocolContext tdsProtocolContext2 = (TdsProtocolContext)protocolContext;
        if (this._cancelSent) {
            return;
        }
        if (!tdsProtocolContext2.isCancelNeeded() && !bl) {
            return;
        }
        if (!bl) {
            bl = this._info.getBoolean(23);
        }
        if ((tdsProtocolContext = this.makeCancel(tdsProtocolContext2, bl)) == null) {
            return;
        }
        try {
            try {
                this.sendCancel(tdsProtocolContext);
                this.getCancel(tdsProtocolContext);
            }
            catch (SQLException sQLException) {
                this._conn.markDead();
                throw sQLException;
            }
            Object var6_6 = null;
            this.endCancel(tdsProtocolContext);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.endCancel(tdsProtocolContext);
            throw throwable;
        }
    }

    public int count(ProtocolContext protocolContext) throws SQLException {
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)protocolContext;
        tdsProtocolContext._lastResult = -1;
        return ((DoneToken)tdsProtocolContext._tdsToken)._count;
    }

    /*
     * Unable to fully structure code
     */
    protected void doCommand(String var1_1) throws SQLException {
        var2_2 = null;
        this.language(this._utilContext, var1_1, null);
        var3_3 = -1;
        block5: while (true) lbl-1000:
        // 3 sources

        {
            try {
                var3_3 = this.nextResult(this._utilContext);
                switch (var3_3) {
                    case 1: 
                    case 209: {
                        this.cancel(this._utilContext, false);
                        ErrorMessage.raiseError("JZ0P1");
                        return;
                    }
                    default: {
                        if (var3_3 != 0) continue block5;
                    }
                }
            }
            catch (SQLWarning v0) {
                if (var3_3 != 0) ** GOTO lbl-1000
            }
            break;
        }
    }

    private void doLogin() throws SQLException {
        Object var2_4;
        this._inLogin = true;
        this._utilContext._timeout = DriverManager.getLoginTimeout() * 1000;
        this._outStreamMgr.getSendLock(this._utilContext);
        this._outStreamMgr.beginRequest(this._utilContext);
        try {
            try {
                this._outFormat.setPDUHeader(2, 0);
                LoginToken loginToken = new LoginToken(this._info, this._utilContext);
                loginToken.send(this._out);
                this._capT.send(this._out);
                this._out.flush();
                this._outStreamMgr.queueRequest(this._utilContext);
            }
            catch (IOException iOException) {
                this._outStreamMgr.abortRequest(this._utilContext);
                this.handleIOE(iOException);
            }
            var2_4 = null;
            this._outFormat.setPDUHeader(15, 0);
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this._outFormat.setPDUHeader(15, 0);
            throw throwable;
        }
        try {
            try {
                this.processLoginAckToken();
                if (this._packetSize != 512) {
                    this._outFormat.setNetBufSize(this._packetSize);
                    this._inStreamMgr.setNetBufSize(this._packetSize);
                    this._info.setProperty(12, String.valueOf(this._packetSize));
                }
            }
            catch (SQLException sQLException) {
                sQLException.setNextException(this._conn.getWarnings());
                throw sQLException;
            }
            var2_4 = null;
            this._outStreamMgr.endRequest(this._utilContext);
            this._inLogin = false;
        }
        catch (Throwable throwable) {
            var2_4 = null;
            this._outStreamMgr.endRequest(this._utilContext);
            this._inLogin = false;
            throw throwable;
        }
    }

    public void dump(SyncObj syncObj, SyncObj syncObj2) {
    }

    public void dynamicDeallocate(ProtocolContext protocolContext, String string) throws SQLException {
        DynamicToken dynamicToken = new DynamicToken(4, string, null, false);
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)protocolContext;
        this._outStreamMgr.getSendLock(tdsProtocolContext);
        try {
            this._outStreamMgr.beginRequest(tdsProtocolContext);
            try {
                dynamicToken.send(this._out);
                this._out.flush();
                this._outStreamMgr.queueRequest(tdsProtocolContext);
            }
            catch (IOException iOException) {
                this.handleIOE(iOException);
            }
        }
        catch (SQLException sQLException) {
            this._outStreamMgr.abortRequest(tdsProtocolContext);
            throw sQLException;
        }
        this._outStreamMgr.endRequest(tdsProtocolContext);
        {
            switch (this.nextResult(tdsProtocolContext)) {
                default: {
                    continue block7;
                }
                case 0: 
            }
        }
    }

    private void dynamicExec(ProtocolContext protocolContext, String string, ParamManager paramManager, Vector vector) throws SQLException {
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)protocolContext;
        if (vector != null) {
            paramManager = (ParamManager)vector.firstElement();
        }
        if (paramManager != null) {
            paramManager.checkParams(this, true);
        }
        DynamicToken dynamicToken = new DynamicToken(2, string, null, paramManager.hasInParams());
        boolean bl = this._outStreamMgr.getSendLock(tdsProtocolContext);
        try {
            this.adjustMaxRows(tdsProtocolContext);
            this._outStreamMgr.beginRequest(tdsProtocolContext);
            try {
                if (vector != null) {
                    int n = 0;
                    while (n < vector.size()) {
                        dynamicToken.send(this._out);
                        this.sendParamStream((ParamManager)vector.elementAt(n), this._out);
                        ++n;
                    }
                } else {
                    dynamicToken.send(this._out);
                    this.sendParamStream(paramManager, this._out);
                }
                this._out.flush();
                this._outStreamMgr.queueRequest(tdsProtocolContext);
            }
            catch (IOException iOException) {
                this.handleIOE(iOException);
            }
        }
        catch (SQLException sQLException) {
            bl = true;
            this._outStreamMgr.abortRequest(tdsProtocolContext);
            throw sQLException;
        }
        if (bl) {
            this._outStreamMgr.endRequest(tdsProtocolContext);
        }
    }

    public void dynamicExecute(ProtocolContext protocolContext, String string, ParamManager paramManager) throws SQLException {
        this.dynamicExec(protocolContext, string, paramManager, null);
    }

    public void dynamicExecuteBatch(ProtocolContext protocolContext, String string, Vector vector) throws SQLException {
        this.dynamicExec(protocolContext, string, null, vector);
    }

    public ResultSetMetaData dynamicMetaData(ProtocolContext protocolContext) {
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)protocolContext;
        return tdsProtocolContext._dynamicFmts;
    }

    /*
     * Unable to fully structure code
     */
    public void dynamicPrepare(ProtocolContext var1_1, String var2_2, String var3_3) throws SQLException {
        var5_4 = this._capT._reqCaps;
        if (!var5_4.get(7)) {
            ErrorMessage.raiseError("JZ0PB");
        }
        var4_5 = var5_4.get(48) != false ? "create proc " + var2_2 + " as " + var3_3 : var3_3;
        var6_6 = new DynamicToken(1, var2_2, var4_5, false);
        var7_7 = (TdsProtocolContext)var1_1;
        var7_7._dynamicFmts = null;
        this._outStreamMgr.getSendLock(var7_7);
        try {
            this._outStreamMgr.beginRequest(var7_7);
            try {
                var6_6.send(this._out);
                this._out.flush();
                this._outStreamMgr.queueRequest(var7_7);
            }
            catch (IOException var8_8) {
                this.handleIOE(var8_8);
            }
        }
        catch (SQLException var8_9) {
            this._outStreamMgr.abortRequest(var7_7);
            throw var8_9;
        }
        this._outStreamMgr.endRequest(var7_7);
        {
            switch (this.nextResult(var7_7)) lbl-1000:
            // 3 sources

            {
                default: {
                    continue block9;
                }
                case 1: {
                    var7_7._lastResult = 0;
                    var7_7._dynamicFmts = var7_7._paramFmts;
                    var7_7._dynamicFmts.setPc(var7_7);
                    ** GOTO lbl-1000
                }
                case 3: {
                    var7_7._lastResult = 0;
                    ** GOTO lbl-1000
                }
                case 0: 
            }
        }
    }

    private void endCancel(TdsProtocolContext tdsProtocolContext) {
        this._inStreamMgr.cancelling(false);
        this._cancelSent = false;
        this._outStreamMgr.endRequest(tdsProtocolContext);
    }

    public void endTransaction(boolean bl) throws SQLException {
        if (bl) {
            this.doCommand(COMMIT_QUERY);
        } else {
            this.doCommand(ROLLBACK_QUERY);
        }
    }

    public void freeSendLock(ProtocolContext protocolContext) {
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)protocolContext;
        this._outStreamMgr.endRequest(tdsProtocolContext);
    }

    public boolean getBoolOption(ProtocolContext protocolContext, int n) throws SQLException {
        switch (n) {
            case 12: {
                return this._stripExec;
            }
        }
        PreparedStatement preparedStatement = null;
        MdaManager mdaManager = this._conn.getMDA(protocolContext);
        ResultSet resultSet = null;
        boolean bl = false;
        switch (n) {
            case 1: {
                preparedStatement = mdaManager.getMetaDataAccessor("GET_AUTOCOMMIT", protocolContext);
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                bl = resultSet.getBoolean(1);
                preparedStatement.close();
                return bl ^ true;
            }
            case 3: {
                preparedStatement = mdaManager.getMetaDataAccessor("ISREADONLY", protocolContext);
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                bl = resultSet.getBoolean(1);
                preparedStatement.close();
                return bl;
            }
        }
        ErrorMessage.raiseError("JZ0BD");
        return false;
    }

    private void getCancel(TdsProtocolContext tdsProtocolContext) throws SQLException {
        while (true) {
            int n = this.nextResult(tdsProtocolContext);
            switch (n) {
                case 0: 
                case 5: {
                    tdsProtocolContext._haveDone = false;
                    if ((((DoneToken)tdsProtocolContext._tdsToken)._status & 0x20) == 0) break;
                    return;
                }
            }
            tdsProtocolContext.close(false);
            tdsProtocolContext._chainedSqe = null;
        }
    }

    public Cursor getCursor(ProtocolContext protocolContext, boolean bl) throws SQLException {
        bl = this._info.getBoolean(27);
        if (!bl) {
            bl = this._capT._reqCaps.get(6) ^ true;
        }
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)protocolContext;
        if (!tdsProtocolContext._rereadable) {
            tdsProtocolContext._rereadable = true;
            tdsProtocolContext.setRereadable();
        }
        return new TdsCursor(this, tdsProtocolContext, bl, this.getProtocolContext(this._info));
    }

    protected int getDoneResult(TdsProtocolContext tdsProtocolContext) throws SQLException {
        int n = 0;
        block4: while (true) {
            switch (this.nextResult(tdsProtocolContext)) {
                case 5: {
                    n = ((DoneToken)tdsProtocolContext._tdsToken)._count;
                    this.noop();
                }
                case 0: {
                    if (!tdsProtocolContext._haveDone) continue block4;
                    return n;
                }
            }
            ErrorMessage.raiseError("JZ0P1");
        }
    }

    public int getIntOption(ProtocolContext protocolContext, int n) throws SQLException {
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)protocolContext;
        switch (n) {
            case 2: {
                PreparedStatement preparedStatement = null;
                MdaManager mdaManager = this._conn.getMDA(protocolContext);
                ResultSet resultSet = null;
                preparedStatement = mdaManager.getMetaDataAccessor("GET_ISOLATION", protocolContext);
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                int n2 = resultSet.getInt(1);
                preparedStatement.close();
                switch (n2) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 4;
                    }
                    case 3: {
                        return 8;
                    }
                }
                ErrorMessage.raiseError("JZ0P4");
                return -1;
            }
            case 4: {
                return tdsProtocolContext._maxRows;
            }
        }
        ErrorMessage.raiseError("JZ0BD");
        return 0;
    }

    public Object getObjectOption(ProtocolContext protocolContext, int n) throws SQLException {
        Object object = null;
        switch (n) {
            case 7: {
                object = this._inStreamMgr;
                break;
            }
            case 8: {
                object = this._inStreamMgr.getCapture();
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0BD");
            }
        }
        return object;
    }

    public Protocol getProtocol() {
        return new Tds();
    }

    public ProtocolContext getProtocolContext(SybProperty sybProperty) {
        TdsProtocolContext tdsProtocolContext = new TdsProtocolContext(this, this._inStreamMgr, this._outStreamMgr);
        tdsProtocolContext._conn = this._conn;
        try {
            tdsProtocolContext._rereadable = sybProperty.getBoolean(14);
        }
        catch (SQLException sQLException) {
            tdsProtocolContext._rereadable = true;
        }
        if (tdsProtocolContext._rereadable) {
            tdsProtocolContext.setRereadable();
        } else {
            tdsProtocolContext._cm = null;
        }
        return tdsProtocolContext;
    }

    protected boolean getResultSetResult(TdsProtocolContext tdsProtocolContext, boolean bl) throws SQLException {
        boolean bl2 = false;
        block4: while (true) {
            switch (this.nextResult(tdsProtocolContext)) {
                case 1: {
                    bl2 = true;
                    if (!bl) break block4;
                    tdsProtocolContext._lastResult = -1;
                    continue block4;
                }
                default: {
                    ErrorMessage.raiseError("JZ0P1");
                    continue block4;
                }
                case 0: 
                case 5: 
            }
            break;
        }
        return bl2;
    }

    public boolean getSendLock(ProtocolContext protocolContext) throws SQLException {
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)protocolContext;
        return this._outStreamMgr.getSendLock(tdsProtocolContext);
    }

    public String getStringOption(ProtocolContext protocolContext, int n, String string) throws SQLException {
        String string2 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        MdaManager mdaManager = this._conn.getMDA(protocolContext);
        switch (n) {
            case 5: {
                string2 = this._inStreamMgr.getSessionID();
                break;
            }
            case 10: {
                string2 = mdaManager.getFunctionMap(string, protocolContext);
                break;
            }
            case 9: {
                preparedStatement = mdaManager.getMetaDataAccessor("GET_CATALOG", protocolContext);
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                string2 = resultSet.getString(1);
                preparedStatement.close();
                break;
            }
            case 6: {
                if (this._serverDefaultCharsetName == null) {
                    preparedStatement = mdaManager.getMetaDataAccessor("DEFAULT_CHARSET", protocolContext);
                    resultSet = preparedStatement.executeQuery();
                    resultSet.next();
                    this._serverDefaultCharsetName = resultSet.getString(1);
                    preparedStatement.close();
                }
                string2 = this._serverDefaultCharsetName;
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0BD");
            }
        }
        return string2;
    }

    private void handleIOE(IOException iOException) throws SQLException {
        ErrorMessage.raiseError("JZ006", iOException.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isTypeSearchable(int n) throws SQLException {
        Object object;
        block8: {
            if (this._typeSearchableList == null) {
                object = null;
                try {
                    try {
                        this._typeSearchableList = new Hashtable();
                        object = this._conn.getMetaData().getTypeInfo();
                        while (object.next()) {
                            Integer n2 = new Integer(object.getInt(2));
                            if (this._typeSearchableList.get(n2) != null) continue;
                            this._typeSearchableList.put(n2, new Boolean(object.getInt(9) != 0));
                        }
                    }
                    catch (SQLException sQLException) {
                        this._typeSearchableList = null;
                        throw sQLException;
                    }
                    Object var4_5 = null;
                    if (object == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    if (object != null) {
                        object.close();
                        object = null;
                    }
                    throw throwable;
                }
                object.close();
                object = null;
            }
        }
        if ((object = (Boolean)this._typeSearchableList.get(new Integer(n))) == null) {
            ErrorMessage.raiseError("JZ0P8");
            return false;
        }
        return (Boolean)object;
    }

    public void killEventContext(String string) throws SQLException {
        this._eventCtx.dropHandler(string);
    }

    public void language(ProtocolContext protocolContext, String string, ParamManager paramManager) throws SQLException {
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)protocolContext;
        LanguageToken languageToken = null;
        String string2 = null;
        if (paramManager != null) {
            paramManager.checkParams(this, false);
            string2 = paramManager.processParamMarkers(string);
            if (string2 != null) {
                string = string2;
            }
        }
        languageToken = new LanguageToken(string, string2 != null);
        boolean bl = this._outStreamMgr.getSendLock(tdsProtocolContext);
        try {
            this.adjustMaxRows(tdsProtocolContext);
            this._outStreamMgr.beginRequest(tdsProtocolContext);
            try {
                languageToken.send(this._out);
                this.sendParamStream(paramManager, this._out);
                this._out.flush();
                this._outStreamMgr.queueRequest(tdsProtocolContext);
            }
            catch (IOException iOException) {
                this.handleIOE(iOException);
            }
        }
        catch (SQLException sQLException) {
            bl = true;
            this._outStreamMgr.abortRequest(tdsProtocolContext);
            throw sQLException;
        }
        if (bl) {
            this._outStreamMgr.endRequest(tdsProtocolContext);
        }
    }

    public void login(String string, SybProperty sybProperty, SybConnection sybConnection, boolean bl) throws SQLException {
        SQLWarning sQLWarning = null;
        this._conn = sybConnection;
        this._info = sybProperty;
        this._bigEndian = sybProperty.getBoolean(30) ^ true;
        this._ignoreDIP = sybProperty.getBoolean(32);
        if (bl || this._capT == null) {
            this._capT = new CapabilityToken();
        }
        this._capT.setCapabilities();
        if (this._info.getInteger(22) < 4) {
            this._capT.setCapabilities();
            bl = false;
        }
        boolean bl2 = sybProperty.getString(20) == null;
        String string2 = "";
        int n = 0;
        if (bl2) {
            int n2 = string.indexOf(58);
            if (n2 == -1) {
                ErrorMessage.raiseError("JZ003", string);
            }
            string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1);
            if (string2 == null || string3 == null || string2.equals("") || string3.equals("")) {
                ErrorMessage.raiseError("JZ003", string);
            }
            Object var11_14 = null;
            try {
                n = new Integer(string3);
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMessage.raiseError("JZ0NE", string, numberFormatException.toString());
            }
        }
        this.setCharConvert(sybProperty);
        try {
            this._inStreamMgr = new InStreamMgr(string2, n, sybProperty);
            sQLWarning = this._inStreamMgr.getCaptureWarnings();
            OutputStream outputStream = this._inStreamMgr.getOutputStream();
            this._outFormat = new PduOutputFormatter(outputStream, this._packetSize);
            this._out = new TdsDataOutputStream(this, this._outFormat);
            this._out.setBigEndian(this._bigEndian);
            this._outStreamMgr = new OutStreamMgr(this._inStreamMgr);
            this._utilContext = (TdsProtocolContext)this.getProtocolContext(sybProperty);
            this._utilContext._conn = sybConnection;
            this._eventCtx = new TdsEventContext(this, this._inStreamMgr, this._outStreamMgr);
            this._eventCtx._conn = sybConnection;
        }
        catch (IOException iOException) {
            this.handleIOE(iOException);
        }
        this._sendLiterals = sybProperty.getBoolean(15);
        this._sendLongAnyway = sybProperty.getBoolean(28);
        if (sybProperty.getString(20) == null) {
            try {
                this.doLogin();
            }
            catch (SQLWarning sQLWarning2) {
                if (sQLWarning2.getSQLState().equals("010SM")) {
                    this.logout();
                    this.login(string, sybProperty, sybConnection, false);
                }
                if (sQLWarning == null) {
                    sQLWarning = sQLWarning2;
                }
                sQLWarning.setNextWarning(sQLWarning2);
            }
        }
        if (sQLWarning != null) {
            throw sQLWarning;
        }
    }

    public void logout() throws SQLException {
        LogoutToken logoutToken = new LogoutToken();
        this._inStreamMgr.closing();
        this._outStreamMgr.getSendLock(this._utilContext);
        this._outStreamMgr.beginRequest(this._utilContext);
        try {
            try {
                logoutToken.send(this._out);
                this._out.flush();
            }
            catch (IOException iOException) {
                this.handleIOE(iOException);
            }
            Object var3_3 = null;
            this._inStreamMgr.close();
            this._outStreamMgr.endRequest(this._utilContext);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this._inStreamMgr.close();
            this._outStreamMgr.endRequest(this._utilContext);
            throw throwable;
        }
    }

    private TdsProtocolContext makeCancel(TdsProtocolContext tdsProtocolContext, boolean bl) throws SQLException {
        TdsProtocolContext tdsProtocolContext2 = new TdsProtocolContext(this, this._inStreamMgr, this._outStreamMgr);
        tdsProtocolContext2._conn = this._conn;
        tdsProtocolContext2._timeout = tdsProtocolContext._timeout < 20000 ? 20000 : tdsProtocolContext._timeout;
        tdsProtocolContext2.setSponsor(tdsProtocolContext);
        this._outStreamMgr.getSendLock(tdsProtocolContext2);
        if (!this._outStreamMgr.doCancelRequest(tdsProtocolContext, tdsProtocolContext2, bl)) {
            this._outStreamMgr.abortRequest(tdsProtocolContext2);
            return null;
        }
        return tdsProtocolContext2;
    }

    public void makeEventContext(String string, SybEventHandler sybEventHandler, int n) throws SQLException {
        if (string == null || !(sybEventHandler instanceof SybEventHandler)) {
            ErrorMessage.raiseError("JZ0H0", string);
        }
        this._inStreamMgr.startAsync();
        this._eventCtx.addHandler(string, sybEventHandler, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int nextResult(ProtocolContext protocolContext) throws SQLException {
        Object object;
        TdsProtocolContext tdsProtocolContext;
        block46: {
            tdsProtocolContext = (TdsProtocolContext)protocolContext;
            if (tdsProtocolContext._ungotResult != -1) {
                tdsProtocolContext._lastResult = tdsProtocolContext._ungotResult;
                tdsProtocolContext._ungotResult = -1;
                return tdsProtocolContext._lastResult;
            }
            switch (tdsProtocolContext._lastResult) {
                case 3: {
                    this.slurpParams(tdsProtocolContext);
                    tdsProtocolContext.chainException(ErrorMessage.createWarning("010P4"));
                    break;
                }
                case 1: {
                    this.resultSet(protocolContext);
                }
                case 209: {
                    tdsProtocolContext._trs.close(false);
                    tdsProtocolContext.chainException(ErrorMessage.createWarning("010P6"));
                    break;
                }
            }
            if (tdsProtocolContext._haveDone) {
                tdsProtocolContext._haveDone = false;
                tdsProtocolContext._lastResult = 0;
                return tdsProtocolContext._lastResult;
            }
            try {
                block30: while (true) {
                    try {
                        tdsProtocolContext._lastTds = tdsProtocolContext._in.readUnsignedByte();
                    }
                    catch (IOException iOException) {
                        if (this._cancelSent && iOException instanceof EOFException && tdsProtocolContext._tdsToken != null && (((DoneToken)tdsProtocolContext._tdsToken)._status & 0x20) != 0) {
                            tdsProtocolContext._lastResult = 0;
                            break;
                        }
                        this.handleIOE(iOException);
                    }
                    switch (tdsProtocolContext._lastTds) {
                        case 255: {
                            DoneToken doneToken;
                            if (this._ignoreDIP && !tdsProtocolContext._batch) {
                                doneToken = new DoneToken(tdsProtocolContext._in);
                                break;
                            }
                        }
                        case 253: 
                        case 254: {
                            DoneToken doneToken = new DoneToken(tdsProtocolContext._in);
                            tdsProtocolContext._tdsToken = doneToken;
                            if ((doneToken._status & 0x10) != 0) {
                                tdsProtocolContext._lastResult = 5;
                                if ((doneToken._status & 1) == 0) {
                                    tdsProtocolContext._haveDone = true;
                                }
                                break block46;
                            }
                            if ((doneToken._status & 1) == 0) {
                                tdsProtocolContext._lastResult = 0;
                                tdsProtocolContext._haveDone = true;
                                break block46;
                            }
                            if (tdsProtocolContext._eed) {
                                tdsProtocolContext._lastResult = 229;
                                break block46;
                            } else {
                                if (!tdsProtocolContext._batch || (doneToken._status & 8) != 8) continue block30;
                                tdsProtocolContext._lastResult = 5;
                            }
                            break block46;
                        }
                        case 238: {
                            tdsProtocolContext._paramFmts = new RowFormatToken(tdsProtocolContext._in);
                            tdsProtocolContext._lastResult = 1;
                            break block46;
                        }
                        case 121: {
                            tdsProtocolContext._lastResult = 3;
                            break block46;
                        }
                        case 172: {
                            tdsProtocolContext._lastResult = 3;
                            break block46;
                        }
                        case 226: {
                            this._capT = new CapabilityToken(tdsProtocolContext._in);
                            tdsProtocolContext._lastResult = -1;
                            break;
                        }
                        case 231: {
                            object = new DynamicToken(tdsProtocolContext._in);
                            tdsProtocolContext._lastResult = -1;
                            break;
                        }
                        case 131: {
                            CurInfoToken curInfoToken = new CurInfoToken(tdsProtocolContext);
                            break;
                        }
                        case 229: {
                            EedToken eedToken = new EedToken(tdsProtocolContext._in);
                            tdsProtocolContext._lastResult = 229;
                            if (!this.processEed(tdsProtocolContext, eedToken)) continue block30;
                            break block46;
                        }
                        case 202: {
                            KeyToken keyToken = new KeyToken(tdsProtocolContext._in);
                            break;
                        }
                        case 209: {
                            tdsProtocolContext._lastResult = 209;
                            break block46;
                        }
                        case 236: {
                            tdsProtocolContext._paramFmts = new RowFormatToken(tdsProtocolContext._in);
                            tdsProtocolContext._lastResult = 3;
                            break block46;
                        }
                        case 215: {
                            tdsProtocolContext._lastResult = 3;
                            break block46;
                        }
                        case 227: {
                            Object object2;
                            EnvChangeToken envChangeToken = new EnvChangeToken(tdsProtocolContext._in);
                            if (envChangeToken._packetSize != null) {
                                this._packetSize = Integer.valueOf(envChangeToken._packetSize);
                            }
                            if (envChangeToken._charset != null) {
                                object2 = Iana.lookupIana(envChangeToken._charset);
                                if (object2 != null) {
                                    this._serverDefaultCharsetName = envChangeToken._charset;
                                }
                                String string = this._charsetName;
                                if (object2 != null && !((String)object2).equals(string)) {
                                    this.setCharConvert(envChangeToken._charset);
                                    try {
                                        ErrorMessage.raiseWarning("010TP", string, (String)object2);
                                    }
                                    catch (SQLException sQLException) {
                                        tdsProtocolContext.chainException(sQLException);
                                    }
                                }
                            }
                            tdsProtocolContext._lastResult = -1;
                            break;
                        }
                        case 162: {
                            tdsProtocolContext._lastResult = 3;
                            break block46;
                        }
                        case 168: {
                            this.cancel(tdsProtocolContext, false);
                            ErrorMessage.raiseError("JZ0P9");
                        }
                        case 173: {
                            tdsProtocolContext._lastResult = 173;
                            break block46;
                        }
                        default: {
                            Object object2 = new Slurp(tdsProtocolContext._in, tdsProtocolContext._lastTds);
                            break;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                this.handleIOE(iOException);
            }
        }
        if (tdsProtocolContext._chainedSqe != null && !tdsProtocolContext._eed) {
            int n = tdsProtocolContext._lastResult;
            if (n != 229 && n != 253 && n != 255 && n != 254) {
                this.ungetResult(tdsProtocolContext, n);
            }
            object = tdsProtocolContext._chainedSqe;
            tdsProtocolContext._chainedSqe = null;
            throw object;
        }
        return tdsProtocolContext._lastResult;
    }

    protected int noop() {
        return 1;
    }

    public void param(ParamManager paramManager) throws SQLException {
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)paramManager.getContext();
        int n = paramManager.getNext();
        Param[] paramArray = paramManager.getParams();
        tdsProtocolContext._lastResult = -1;
        TdsJdbcInputStream tdsJdbcInputStream = null;
        try {
            switch (tdsProtocolContext._lastTds) {
                case 121: {
                    tdsJdbcInputStream = new TdsJdbcInputStream(tdsProtocolContext, this);
                    TdsParam tdsParam = null;
                    if (paramArray.length == 0 || paramArray[n]._sqlType != -998) {
                        tdsParam = new TdsParam(this._out);
                        tdsParam._sqlType = -998;
                    } else {
                        tdsParam = (TdsParam)paramArray[n];
                    }
                    tdsParam._outValue = tdsJdbcInputStream;
                    tdsJdbcInputStream._dataFmt = new DataFormat(tdsParam, this._out);
                    paramManager.registerStatus(tdsJdbcInputStream);
                    break;
                }
                case 172: {
                    int n2 = tdsProtocolContext._in.readUnsignedShort();
                    tdsJdbcInputStream = new TdsJdbcInputStream(tdsProtocolContext, this);
                    tdsJdbcInputStream._dataFmt = new DataFormat(tdsProtocolContext._in, false);
                    if ((tdsJdbcInputStream._dataFmt._status & 1) == 1) {
                        n = paramManager.nextOutParam();
                        paramArray[n]._outValue = tdsJdbcInputStream;
                    }
                    paramManager.registerParam(tdsJdbcInputStream);
                    break;
                }
                case 215: {
                    int n3 = 0;
                    while (n3 < tdsProtocolContext._paramFmts._numColumns) {
                        tdsJdbcInputStream = new TdsJdbcInputStream(tdsProtocolContext, this);
                        tdsJdbcInputStream._dataFmt = tdsProtocolContext._paramFmts.getDataFormat(n3++);
                        if ((tdsJdbcInputStream._dataFmt._status & 1) == 1 && (n = paramManager.nextOutParam()) < paramArray.length) {
                            paramArray[n]._outValue = tdsJdbcInputStream;
                        }
                        paramManager.registerParam(tdsJdbcInputStream);
                    }
                    break;
                }
                default: {
                    ErrorMessage.raiseError("JZ0P4");
                    break;
                }
                case 236: {
                    return;
                }
            }
        }
        catch (IOException iOException) {
            this.handleIOE(iOException);
        }
    }

    public Param[] paramArray(int n, CacheManager cacheManager) {
        Param[] paramArray = new TdsUpdateParam[n];
        int n2 = 0;
        while (n2 < n) {
            paramArray[n2] = new TdsUpdateParam(this._out, cacheManager);
            ++n2;
        }
        return paramArray;
    }

    public Param[] paramArray(ProtocolContext protocolContext, int n) {
        Param[] paramArray = new TdsParam[n];
        int n2 = 0;
        while (n2 < n) {
            paramArray[n2] = new TdsParam(this._out);
            ++n2;
        }
        return paramArray;
    }

    private boolean processEed(TdsProtocolContext tdsProtocolContext, EedToken eedToken) {
        int n;
        SQLException sQLException = null;
        int n2 = 0;
        while (n2 < INFO_MSGNO.length) {
            if (eedToken._msgNumber == INFO_MSGNO[n2]) {
                return false;
            }
            ++n2;
        }
        tdsProtocolContext._eed = true;
        if (eedToken._sqlState != null) {
            n = eedToken._sqlState.length();
            if (n > 5) {
                eedToken._sqlState = eedToken._sqlState.substring(0, 5);
            } else if (n < 5) {
                eedToken._sqlState = String.valueOf(eedToken._sqlState) + "     ".substring(0, 5 - n);
            }
        }
        n = (eedToken._status & 1) != 1 ? 0 : 1;
        eedToken._params = n != 0 ? tdsProtocolContext.getParams() : tdsProtocolContext.makeEmptyParams();
        if (eedToken._class == 10 || eedToken._msgNumber == 0 || eedToken._msgNumber == 16511 || this._inLogin) {
            if (eedToken._sqlState != null && !eedToken._sqlState.regionMatches(false, 0, "01", 0, 2)) {
                eedToken._sqlState = "01" + eedToken._sqlState.substring(2, 5);
            }
            sQLException = new SybSQLWarning(eedToken._msg, eedToken._sqlState, eedToken._msgNumber, eedToken._state, eedToken._class, eedToken._serverName, eedToken._procName, eedToken._lineNum, eedToken._params, eedToken._tranState, eedToken._status);
        } else {
            sQLException = new SybSQLException(eedToken._msg, eedToken._sqlState, eedToken._msgNumber, eedToken._state, eedToken._class, eedToken._serverName, eedToken._procName, eedToken._lineNum, eedToken._params, eedToken._tranState, eedToken._status);
        }
        SybMessageHandler sybMessageHandler = tdsProtocolContext.getMessageHandler();
        if (sybMessageHandler != null) {
            sQLException = sybMessageHandler.messageHandler(sQLException);
        }
        if (n != 0) {
            try {
                eedToken._params.close();
            }
            catch (SQLException sQLException2) {}
        }
        tdsProtocolContext.chainException(sQLException);
        tdsProtocolContext._eed = false;
        return tdsProtocolContext._lastResult == 0;
    }

    private void processLoginAckToken() throws SQLException {
        LoginAckToken loginAckToken = null;
        int n = -1;
        block8: while (true) {
            try {
                n = this.nextResult(this._utilContext);
            }
            catch (SQLException sQLException) {
                this._conn.chainWarnings(sQLException);
                String string = sQLException.getSQLState();
                if (string == null) continue;
                if (string.equals("JZ006")) break;
                if (!string.equals("010SM")) continue;
                throw sQLException;
            }
            switch (n) {
                default: {
                    continue block8;
                }
                case 173: {
                    try {
                        loginAckToken = new LoginAckToken(this._utilContext._in);
                    }
                    catch (IOException iOException) {
                        this._conn.chainWarnings(ErrorMessage.createWarning("JZ006", iOException.toString()));
                    }
                }
                continue block8;
                case 0: 
            }
            break;
        }
        if (loginAckToken != null && !loginAckToken.tdsVersionOK()) {
            this._conn.chainWarnings(ErrorMessage.createWarning("0100V", loginAckToken.getTdsVersionString()));
        }
        if (loginAckToken == null || !loginAckToken.loginOK()) {
            ErrorMessage.raiseError("JZ00L");
        }
        if (loginAckToken != null && loginAckToken._progName != null && loginAckToken._progName.equals("OpenServer")) {
            this._inStreamMgr.setSerialize();
        }
        if (loginAckToken != null && loginAckToken._progName != null && loginAckToken._progName.equals("sql server")) {
            this._stripExec = true;
        }
    }

    public ProtocolResultSet resultSet(ProtocolContext protocolContext) throws SQLException {
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)protocolContext;
        tdsProtocolContext._trs = new TdsResultSet(tdsProtocolContext);
        tdsProtocolContext._lastResult = -1;
        return tdsProtocolContext._trs;
    }

    public void resync(ProtocolContext protocolContext) throws SQLException {
        Debug.notImplemented(this, "resync()");
    }

    public void rpc(ProtocolContext protocolContext, String string, ParamManager paramManager) throws SQLException {
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)protocolContext;
        paramManager.checkParams(this, true);
        DbrpcToken dbrpcToken = new DbrpcToken(string, paramManager);
        boolean bl = this._outStreamMgr.getSendLock(tdsProtocolContext);
        try {
            this.adjustMaxRows(tdsProtocolContext);
            this._outStreamMgr.beginRequest(tdsProtocolContext);
            try {
                dbrpcToken.send(this._out);
                this.sendParamStream(paramManager, this._out);
                this._out.flush();
                this._outStreamMgr.queueRequest(tdsProtocolContext);
            }
            catch (IOException iOException) {
                this.handleIOE(iOException);
            }
        }
        catch (SQLException sQLException) {
            bl = true;
            this._outStreamMgr.abortRequest(tdsProtocolContext);
            throw sQLException;
        }
        if (bl) {
            this._outStreamMgr.endRequest(tdsProtocolContext);
        }
    }

    private void sendCancel(TdsProtocolContext tdsProtocolContext) throws SQLException {
        try {
            this._outFormat.setPDUHeader(6, 0);
            this._outFormat.flush();
            this._outStreamMgr.queueRequest(tdsProtocolContext);
            this._inStreamMgr.cancelling(true);
            this._cancelSent = true;
            this._outFormat.setPDUHeader(15, 0);
        }
        catch (IOException iOException) {
            this._outStreamMgr.abortRequest(tdsProtocolContext);
            this.handleIOE(iOException);
        }
    }

    protected void sendParamStream(ParamManager paramManager, TdsDataOutputStream tdsDataOutputStream) throws IOException, SQLException {
        if (paramManager == null) {
            return;
        }
        if (paramManager.hasInParams()) {
            ParamFormatToken paramFormatToken = new ParamFormatToken(paramManager);
            paramFormatToken.send(tdsDataOutputStream);
            ParamsToken paramsToken = new ParamsToken();
            paramsToken.send(tdsDataOutputStream);
        }
        paramManager.send(tdsDataOutputStream);
    }

    public void setCharConvert(SybProperty sybProperty) throws SQLException {
        String string = sybProperty.getString(8);
        this.setCharConvert(string);
    }

    public void setCharConvert(String string) throws SQLException {
        block5: {
            if (this._charsetConverter == null) {
                String string2 = this._info.getString(21);
                try {
                    Class<?> clazz = Class.forName(string2);
                    this._charsetConverter = (CharsetConverter)clazz.newInstance();
                }
                catch (Exception exception) {
                    ErrorMessage.raiseError("JZ0I6", exception.getMessage());
                }
            }
            this._charsetName = string != null ? Iana.lookupIana(string) : null;
            if (this._charsetName == null) break block5;
            try {
                this._charsetConverter.setEncoding(this._charsetName);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                ErrorMessage.raiseError("JZ0I5", string);
            }
        }
    }

    public void setOption(ProtocolContext protocolContext, int n, int n2) throws SQLException {
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)protocolContext;
        switch (n) {
            case 2: {
                int n3 = -1;
                PreparedStatement preparedStatement = null;
                MdaManager mdaManager = this._conn.getMDA(protocolContext);
                switch (n2) {
                    case 1: {
                        n3 = 0;
                        break;
                    }
                    case 2: {
                        n3 = 1;
                        break;
                    }
                    case 4: {
                        n3 = 2;
                        break;
                    }
                    case 8: {
                        n3 = 3;
                        break;
                    }
                    case 0: {
                        ErrorMessage.raiseError("JZ014");
                        break;
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0I3", String.valueOf(n2), "setTransactionIsolation");
                    }
                }
                preparedStatement = mdaManager.getMetaDataAccessor("SET_ISOLATION", " " + n3, protocolContext);
                preparedStatement.executeUpdate();
                preparedStatement.close();
                break;
            }
            case 4: {
                tdsProtocolContext._maxRows = n2;
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0BD");
            }
        }
    }

    public void setOption(ProtocolContext protocolContext, int n, String string) throws SQLException {
        switch (n) {
            case 6: {
                this.setCharConvert(string);
                break;
            }
            case 9: {
                PreparedStatement preparedStatement = null;
                MdaManager mdaManager = this._conn.getMDA(protocolContext);
                preparedStatement = mdaManager.getMetaDataAccessor("SET_CATALOG", protocolContext);
                preparedStatement.setString(1, string);
                preparedStatement.executeUpdate();
                preparedStatement.close();
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0BD");
            }
        }
    }

    public void setOption(ProtocolContext protocolContext, int n, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = null;
        MdaManager mdaManager = this._conn.getMDA(protocolContext);
        switch (n) {
            case 1: {
                if (bl) {
                    preparedStatement = mdaManager.getMetaDataAccessor("SET_AUTOCOMMIT_ON", protocolContext);
                    break;
                }
                preparedStatement = mdaManager.getMetaDataAccessor("SET_AUTOCOMMIT_OFF", protocolContext);
                break;
            }
            case 3: {
                if (bl) {
                    preparedStatement = mdaManager.getMetaDataAccessor("SET_READONLY_TRUE", protocolContext);
                    break;
                }
                preparedStatement = mdaManager.getMetaDataAccessor("SET_READONLY_FALSE", protocolContext);
                break;
            }
            case 11: {
                preparedStatement = mdaManager.getMetaDataAccessor("CONNECTCONFIG", protocolContext);
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0BD");
                return;
            }
        }
        if (preparedStatement != null) {
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
    }

    private void slurpParams(TdsProtocolContext tdsProtocolContext) throws SQLException {
        tdsProtocolContext._lastResult = -1;
        try {
            TdsJdbcInputStream tdsJdbcInputStream = new TdsJdbcInputStream(tdsProtocolContext, this);
            switch (tdsProtocolContext._lastTds) {
                case 121: {
                    TdsParam tdsParam = new TdsParam(this._out);
                    tdsParam._sqlType = -998;
                    tdsJdbcInputStream._dataFmt = new DataFormat(tdsParam, this._out);
                    tdsJdbcInputStream.open(false);
                    tdsJdbcInputStream.resetInputStream(tdsProtocolContext._in);
                    tdsJdbcInputStream.clear();
                    break;
                }
                case 172: {
                    int n = tdsProtocolContext._in.readUnsignedShort();
                    tdsJdbcInputStream._dataFmt = new DataFormat(tdsProtocolContext._in, false);
                    tdsJdbcInputStream.open(false);
                    tdsJdbcInputStream.resetInputStream(tdsProtocolContext._in);
                    tdsJdbcInputStream.clear();
                    break;
                }
                case 236: {
                    try {
                        tdsProtocolContext._lastTds = tdsProtocolContext._in.readUnsignedByte();
                        if (tdsProtocolContext._lastTds != 215) {
                            ErrorMessage.raiseError("JZ0P4");
                        }
                    }
                    catch (IOException iOException) {
                        this.handleIOE(iOException);
                    }
                }
                default: {
                    int n = 0;
                    while (n < tdsProtocolContext._paramFmts._numColumns) {
                        tdsJdbcInputStream._dataFmt = tdsProtocolContext._paramFmts.getDataFormat(n);
                        tdsJdbcInputStream.open(false);
                        tdsJdbcInputStream.resetInputStream(tdsProtocolContext._in);
                        tdsJdbcInputStream.clear();
                        ++n;
                    }
                    break;
                }
            }
        }
        catch (IOException iOException) {
            this.handleIOE(iOException);
        }
    }

    public void ungetResult(ProtocolContext protocolContext, int n) throws SQLException {
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)protocolContext;
        tdsProtocolContext._ungotResult = n;
    }

    public void writePage(TextPointer textPointer, byte[] byArray, String string, int n) throws SQLException {
        String string2 = "dbcc dbrepair (" + string + ", writepage, " + n + ")";
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)this.getProtocolContext(this._info);
        this._outStreamMgr.getSendLock(tdsProtocolContext);
        tdsProtocolContext.setSponsor(tdsProtocolContext);
        this.language(tdsProtocolContext, string2, null);
        try {
            this.getDoneResult(tdsProtocolContext);
        }
        catch (SQLException sQLException) {
            tdsProtocolContext.setSponsor(null);
            this._outStreamMgr.abortRequest(tdsProtocolContext);
            this.cancel(tdsProtocolContext, false);
            throw sQLException;
        }
        this._outStreamMgr.beginRequest(tdsProtocolContext);
        try {
            try {
                this._outFormat.setPDUHeader(7, 0);
                int n2 = 4 + byArray.length;
                this._out.writeInt(n2);
                this._out.writeInt(0);
                this._out.write(byArray);
                this._outFormat.flush();
                this._outStreamMgr.queueRequest(tdsProtocolContext);
            }
            catch (IOException iOException) {
                this.handleIOE(iOException);
            }
            Object var8_12 = null;
            this._outFormat.setPDUHeader(15, 0);
            tdsProtocolContext.setSponsor(null);
            this._outStreamMgr.endRequest(tdsProtocolContext);
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            this._outFormat.setPDUHeader(15, 0);
            tdsProtocolContext.setSponsor(null);
            this._outStreamMgr.endRequest(tdsProtocolContext);
            throw throwable;
        }
        this.getDoneResult(tdsProtocolContext);
    }
}

