/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.MdaManager;
import com.sybase.jdbc2.jdbc.SybConnection;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class SybDatabaseMetaData
implements DatabaseMetaData {
    private SybConnection _conn;
    private MdaManager _mda;
    private int _outerJoinEscapeSupport;
    private int _isCaseSensitive;
    protected static final int UNKNOWN = -1;
    protected static final int NO = 0;
    protected static final int YES = 1;
    private static final String JAVA_OBJECT_NAME = "JAVA_OBJECT";
    private static final String STRUCT_NAME = "STRUCT";
    private static final String DISTINCT_NAME = "DISTINCT";
    private static final String TABLES = "TABLES";
    private static final String COLUMNS = "COLUMNS";
    private static final String ALLPROCSCALLABLE = "ALLPROCSCALLABLE";
    private static final String ALLTABLESSELECTABLE = "ALLTABLESSELECTABLE";
    private static final String ISREADONLY = "ISREADONLY";
    private static final String NULLSORTING = "NULLSORTING";
    private static final String USERNAME = "USERNAME";
    private static final String PRODUCTNAME = "PRODUCTNAME";
    private static final String PRODUCTVERSION = "PRODUCTVERSION";
    private static final String FILEUSAGE = "FILEUSAGE";
    private static final String IDENTIFIERCASES = "IDENTIFIERCASES";
    private static final String IDENTIFIERQUOTE = "IDENTIFIERQUOTE";
    private static final String SQLKEYWORDS = "SQLKEYWORDS";
    private static final String NUMERICFUNCTIONLIST = "NUMERICFUNCTIONLIST";
    private static final String STRINGFUNCTIONLIST = "STRINGFUNCTIONLIST";
    private static final String SYSTEMFUNCTIONLIST = "SYSTEMFUNCTIONLIST";
    private static final String TIMEDATEFUNCTIONLIST = "TIMEDATEFUNCTIONLIST";
    private static final String SEARCHSTRING = "SEARCHSTRING";
    private static final String EXTRANAMECHARS = "EXTRANAMECHARS";
    private static final String ALTERTABLESUPPORT = "ALTERTABLESUPPORT";
    private static final String COLUMNALIASING = "COLUMNALIASING";
    private static final String NULLPLUSNONNULL = "NULLPLUSNONNULL";
    private static final String CONVERTSUPPORT = "CONVERTSUPPORT";
    private static final String CONVERTMAP = "CONVERTMAP";
    private static final String CORRELATIONNAMES = "CORRELATIONNAMES";
    private static final String ORDERBYSUPPORT = "ORDERBYSUPPORT";
    private static final String GROUPBYSUPPORT = "GROUPBYSUPPORT";
    private static final String LIKEESCAPECLAUSE = "LIKEESCAPECLAUSE";
    private static final String MULTIPLERESULTSETS = "MULTIPLERESULTSETS";
    private static final String MULTIPLETRANSACTIONS = "MULTIPLETRANSACTIONS";
    private static final String NONNULLABLECOLUMNS = "NONNULLABLECOLUMNS";
    private static final String SQLGRAMMAR = "SQLGRAMMAR";
    private static final String ANSI92LEVEL = "ANSI92LEVEL";
    private static final String INTEGRITYENHANCEMENT = "INTEGRITYENHANCEMENT";
    private static final String OUTERJOINS = "OUTERJOINS";
    private static final String SCHEMATERM = "SCHEMATERM";
    private static final String PROCEDURETERM = "PROCEDURETERM";
    private static final String CATALOGTERM = "CATALOGTERM";
    private static final String CATALOGSEPARATOR = "CATALOGSEPARATOR";
    private static final String CATALOGATSTART = "CATALOGATSTART";
    private static final String SCHEMASUPPORT = "SCHEMASUPPORT";
    private static final String CATALOGSUPPORT = "CATALOGSUPPORT";
    private static final String POSITIONEDDELETE = "POSITIONEDDELETE";
    private static final String POSITIONEDUPDATE = "POSITIONEDUPDATE";
    private static final String SELECTFORUPDATE = "SELECTFORUPDATE";
    private static final String STOREDPROCEDURES = "STOREDPROCEDURES";
    private static final String SUBQUERIES = "SUBQUERIES";
    private static final String UNIONSUPPORT = "UNIONSUPPORT";
    private static final String CURSORTRANSACTIONS = "CURSORTRANSACTIONS";
    private static final String STATEMENTTRANSACTIONS = "STATEMENTTRANSACTIONS";
    private static final String MAXBINARYLITERALLENGTH = "MAXBINARYLITERALLENGTH";
    private static final String MAXCHARLITERALLENGTH = "MAXCHARLITERALLENGTH";
    private static final String COLUMNINFO = "COLUMNINFO";
    private static final String MAXCONNECTIONS = "MAXCONNECTIONS";
    private static final String MAXINDEXLENGTH = "MAXINDEXLENGTH";
    private static final String MAXNAMELENGTHS = "MAXNAMELENGTHS";
    private static final String ROWINFO = "ROWINFO";
    private static final String STATEMENTINFO = "STATEMENTINFO";
    private static final String TABLEINFO = "TABLEINFO";
    private static final String TRANSACTIONSUPPORT = "TRANSACTIONSUPPORT";
    private static final String TRANSACTIONLEVELDEFAULT = "TRANSACTIONLEVELDEFAULT";
    private static final String TRANSACTIONLEVELS = "TRANSACTIONLEVELS";
    private static final String TRANSACTIONDATADEFINFO = "TRANSACTIONDATADEFINFO";
    private static final String PROCEDURES = "PROCEDURES";
    private static final String PROCEDURECOLUMNS = "PROCEDURECOLUMNS";
    private static final String SCHEMAS = "SCHEMAS";
    private static final String CATALOGS = "CATALOGS";
    private static final String TABLETYPES = "TABLETYPES";
    private static final String COLUMNPRIVILEGES = "COLUMNPRIVILEGES";
    private static final String TABLEPRIVILEGES = "TABLEPRIVILEGES";
    private static final String ROWIDENTIFIERS = "ROWIDENTIFIERS";
    private static final String VERSIONCOLUMNS = "VERSIONCOLUMNS";
    private static final String PRIMARYKEYS = "PRIMARYKEYS";
    private static final String IMPORTEDKEYS = "IMPORTEDKEYS";
    private static final String EXPORTEDKEYS = "EXPORTEDKEYS";
    private static final String KEYCROSSREFERENCE = "KEYCROSSREFERENCE";
    private static final String TYPEINFO = "TYPEINFO";
    private static final String INDEXINFO = "INDEXINFO";
    private static final String OWNUPDATESAREVISIBLE = "OWNUPDATESAREVISIBLE";
    private static final String OWNDELETESAREVISIBLE = "OWNDELETESAREVISIBLE";
    private static final String OWNINSERTSAREVISIBLE = "OWNINSERTSAREVISIBLE";
    private static final String OTHERSUPDATESAREVISIBLE = "OTHERSUPDATESAREVISIBLE";
    private static final String OTHERSDELETESAREVISIBLE = "OTHERSDELETESAREVISIBLE";
    private static final String OTHERSINSERTSAREVISIBLE = "OTHERSINSERTSAREVISIBLE";
    private static final String UPDATESAREDETECTED = "UPDATESAREDETECTED";
    private static final String DELETESAREDETECTED = "DELETESAREDETECTED";
    private static final String INSERTSAREDETECTED = "INSERTSAREDETECTED";
    private static final String SUPPORTSBATCHUPDATES = "SUPPORTSBATCHUPDATES";
    private static final String EXECBATCHUPDATESINLOOP = "EXECBATCHUPDATESINLOOP";
    private static final String SUPPORTSRESULTSETTYPE = "SUPPORTSRESULTSETTYPE";
    private static final String READONLYCONCURRENCY = "READONLYCONCURRENCY";
    private static final String UPDATABLECONCURRENCY = "UPDATABLECONCURRENCY";
    private static final String UDTS = "UDTS";
    protected int _execBatchInLoop = -1;
    protected int _batchSupport = -1;
    private static final String ISCASESENSITIVE = "ISCASESENSITIVE";

    SybDatabaseMetaData(SybConnection sybConnection) throws SQLException {
        this._conn = sybConnection;
        this._mda = sybConnection.getMDA(null);
        this._outerJoinEscapeSupport = -1;
        this._isCaseSensitive = -1;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ALLPROCSCALLABLE);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean allTablesAreSelectable() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ALLTABLESSELECTABLE);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONDATADEFINFO);
        return this.returnBoolean(preparedStatement, 3);
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONDATADEFINFO);
        return this.returnBoolean(preparedStatement, 4);
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        return this.supportForResultSetType(DELETESAREDETECTED, n);
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ROWINFO);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean execBatchUpdatesInLoop() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(EXECBATCHUPDATESINLOOP);
        return this.returnBoolean(preparedStatement, 1);
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ROWIDENTIFIERS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        preparedStatement.setInt(4, n);
        preparedStatement.setBoolean(5, bl);
        return this.returnResults(preparedStatement);
    }

    public String getCatalogSeparator() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSEPARATOR);
        return this.returnString(preparedStatement);
    }

    public String getCatalogTerm() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGTERM);
        return this.returnString(preparedStatement);
    }

    public ResultSet getCatalogs() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGS);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNPRIVILEGES, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        this.setStringParam(preparedStatement, string4, 4);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNS, string);
        this.setStringParam(preparedStatement, string3, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string, 3);
        this.setStringParam(preparedStatement, string4, 4);
        return this.returnResults(preparedStatement);
    }

    public Connection getConnection() throws SQLException {
        return this._conn;
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(KEYCROSSREFERENCE, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        this.setStringParam(preparedStatement, string4, 4);
        this.setStringParam(preparedStatement, string5, 5);
        this.setStringParam(preparedStatement, string6, 6);
        return this.returnResults(preparedStatement);
    }

    public String getDatabaseProductName() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(PRODUCTNAME);
        return this.returnString(preparedStatement);
    }

    public String getDatabaseProductVersion() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(PRODUCTVERSION);
        return this.returnString(preparedStatement);
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONLEVELDEFAULT);
        return this.returnInt(preparedStatement, 1);
    }

    public int getDriverMajorVersion() {
        return 5;
    }

    public int getDriverMinorVersion() {
        return 0;
    }

    public String getDriverName() throws SQLException {
        return "jConnect (TM) for JDBC (TM)";
    }

    public String getDriverVersion() throws SQLException {
        return "jConnect (TM) for JDBC(TM)/5.0(Build 10199)/P/EBF8560/JDK12/Mon Aug  2 14:54:51 1999";
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(EXPORTEDKEYS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        return this.returnResults(preparedStatement);
    }

    public String getExtraNameCharacters() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(EXTRANAMECHARS);
        return this.returnString(preparedStatement);
    }

    public String getIdentifierQuoteString() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERQUOTE);
        return this.returnString(preparedStatement);
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IMPORTEDKEYS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(INDEXINFO, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        preparedStatement.setBoolean(4, bl);
        preparedStatement.setBoolean(5, bl2);
        return this.returnResults(preparedStatement);
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXBINARYLITERALLENGTH);
        return this.returnInt(preparedStatement, 1);
    }

    public int getMaxCatalogNameLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXNAMELENGTHS);
        return this.returnInt(preparedStatement, 5);
    }

    public int getMaxCharLiteralLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXCHARLITERALLENGTH);
        return this.returnInt(preparedStatement, 1);
    }

    public int getMaxColumnNameLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(preparedStatement, 1);
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(preparedStatement, 2);
    }

    public int getMaxColumnsInIndex() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(preparedStatement, 3);
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(preparedStatement, 4);
    }

    public int getMaxColumnsInSelect() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(preparedStatement, 5);
    }

    public int getMaxColumnsInTable() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(preparedStatement, 6);
    }

    public int getMaxConnections() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXCONNECTIONS);
        return this.returnInt(preparedStatement, 1);
    }

    public int getMaxCursorNameLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXNAMELENGTHS);
        return this.returnInt(preparedStatement, 1);
    }

    public int getMaxIndexLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXINDEXLENGTH);
        return this.returnInt(preparedStatement, 1);
    }

    public int getMaxProcedureNameLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXNAMELENGTHS);
        return this.returnInt(preparedStatement, 4);
    }

    public int getMaxRowSize() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ROWINFO);
        return this.returnInt(preparedStatement, 1);
    }

    public int getMaxSchemaNameLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXNAMELENGTHS);
        return this.returnInt(preparedStatement, 3);
    }

    public int getMaxStatementLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(STATEMENTINFO);
        return this.returnInt(preparedStatement, 1);
    }

    public int getMaxStatements() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(STATEMENTINFO);
        return this.returnInt(preparedStatement, 2);
    }

    public int getMaxTableNameLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TABLEINFO);
        return this.returnInt(preparedStatement, 1);
    }

    public int getMaxTablesInSelect() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TABLEINFO);
        return this.returnInt(preparedStatement, 2);
    }

    public int getMaxUserNameLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXNAMELENGTHS);
        return this.returnInt(preparedStatement, 2);
    }

    public PreparedStatement getMetaDataAccessor(String string) throws SQLException {
        return this.getMetaDataAccessor(string, "", null);
    }

    public PreparedStatement getMetaDataAccessor(String string, String string2) throws SQLException {
        return this.getMetaDataAccessor(string, "", string2);
    }

    public PreparedStatement getMetaDataAccessor(String string, String string2, String string3) throws SQLException {
        return this._mda.getMetaDataAccessor(string, string2, string3, null);
    }

    public String getNumericFunctions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(NUMERICFUNCTIONLIST);
        return this.returnString(preparedStatement);
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(PRIMARYKEYS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(PROCEDURECOLUMNS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        this.setStringParam(preparedStatement, string4, 4);
        return this.returnResults(preparedStatement);
    }

    public String getProcedureTerm() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(PROCEDURETERM);
        return this.returnString(preparedStatement);
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(PROCEDURES, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        return this.returnResults(preparedStatement);
    }

    public String getSQLKeywords() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SQLKEYWORDS);
        return this.returnString(preparedStatement);
    }

    public String getSchemaTerm() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMATERM);
        return this.returnString(preparedStatement);
    }

    public ResultSet getSchemas() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMAS);
        return this.returnResults(preparedStatement);
    }

    public String getSearchStringEscape() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SEARCHSTRING);
        return this.returnString(preparedStatement);
    }

    public String getStringFunctions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(STRINGFUNCTIONLIST);
        return this.returnString(preparedStatement);
    }

    public String getSystemFunctions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SYSTEMFUNCTIONLIST);
        return this.returnString(preparedStatement);
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TABLEPRIVILEGES, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getTableTypes() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TABLETYPES);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        StringBuffer stringBuffer;
        if (stringArray == null) {
            stringBuffer = null;
        } else {
            stringBuffer = new StringBuffer("\"");
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] == null || stringArray[n].equals("null")) break;
                stringBuffer.append("'" + stringArray[n] + "'");
                ++n;
            }
            stringBuffer = stringBuffer.append("\"");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TABLES, string);
        this.setStringParam(preparedStatement, string3, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string, 3);
        this.setStringParam(preparedStatement, stringBuffer == null ? null : stringBuffer.toString(), 4);
        return this.returnResults(preparedStatement);
    }

    public String getTimeDateFunctions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TIMEDATEFUNCTIONLIST);
        return this.returnString(preparedStatement);
    }

    public ResultSet getTypeInfo() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TYPEINFO);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        String string4 = null;
        if (nArray != null) {
            string4 = "";
            int n = 0;
            while (n < nArray.length) {
                if (n > 0) {
                    string4 = String.valueOf(string4) + ",";
                }
                switch (nArray[n]) {
                    case 2000: {
                        string4 = String.valueOf(string4) + JAVA_OBJECT_NAME;
                        break;
                    }
                    case 2002: {
                        string4 = String.valueOf(string4) + STRUCT_NAME;
                        break;
                    }
                    case 2001: {
                        string4 = String.valueOf(string4) + DISTINCT_NAME;
                        break;
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0SQ", String.valueOf(nArray[n]));
                    }
                }
                ++n;
            }
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(UDTS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        this.setStringParam(preparedStatement, string4, 4);
        return this.returnResults(preparedStatement);
    }

    public String getURL() throws SQLException {
        return this._conn._url;
    }

    public String getUserName() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(USERNAME);
        return this.returnString(preparedStatement);
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(VERSIONCOLUMNS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        return this.returnResults(preparedStatement);
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        return this.supportForResultSetType(INSERTSAREDETECTED, n);
    }

    public boolean isCaseSensitive() throws SQLException {
        if (this._isCaseSensitive == -1) {
            PreparedStatement preparedStatement = this.getMetaDataAccessor(ISCASESENSITIVE);
            this._isCaseSensitive = this.returnBoolean(preparedStatement, 1) ? 1 : 0;
        }
        return this._isCaseSensitive == 1;
    }

    public boolean isCatalogAtStart() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGATSTART);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean isReadOnly() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ISREADONLY);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(NULLPLUSNONNULL);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(NULLSORTING);
        return this.returnBoolean(preparedStatement, 4);
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(NULLSORTING);
        return this.returnBoolean(preparedStatement, 3);
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(NULLSORTING);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean nullsAreSortedLow() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(NULLSORTING);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return this.supportForResultSetType(OTHERSDELETESAREVISIBLE, n);
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return this.supportForResultSetType(OTHERSINSERTSAREVISIBLE, n);
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return this.supportForResultSetType(OTHERSUPDATESAREVISIBLE, n);
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return this.supportForResultSetType(OWNDELETESAREVISIBLE, n);
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return this.supportForResultSetType(OWNINSERTSAREVISIBLE, n);
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return this.supportForResultSetType(OWNUPDATESAREVISIBLE, n);
    }

    private boolean returnBoolean(PreparedStatement preparedStatement, int n) throws SQLException {
        ResultSet resultSet = null;
        boolean bl = false;
        SQLException sQLException = null;
        try {
            try {
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                bl = resultSet.getBoolean(n);
                resultSet.close();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            preparedStatement.close();
            if (sQLException != null) {
                throw sQLException;
            }
            throw throwable;
        }
        preparedStatement.close();
        if (sQLException != null) {
            throw sQLException;
        }
        return bl;
    }

    private int returnInt(PreparedStatement preparedStatement, int n) throws SQLException {
        ResultSet resultSet = null;
        int n2 = -1;
        SQLException sQLException = null;
        try {
            try {
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                n2 = resultSet.getInt(n);
                resultSet.close();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            preparedStatement.close();
            if (sQLException != null) {
                throw sQLException;
            }
            throw throwable;
        }
        preparedStatement.close();
        if (sQLException != null) {
            throw sQLException;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ResultSet returnResults(PreparedStatement preparedStatement) throws SQLException {
        ResultSet resultSet = null;
        SQLException sQLException = null;
        SQLWarning sQLWarning = null;
        try {
            try {
                resultSet = preparedStatement.executeQuery();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                sQLWarning = preparedStatement.getWarnings();
                if (sQLWarning != null) {
                    this._conn.handleSQLE(sQLWarning);
                }
                preparedStatement.close();
            }
            Object var6_6 = null;
            if (sQLException == null) return resultSet;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (sQLException == null) throw throwable;
            throw sQLException;
        }
        throw sQLException;
    }

    private String returnString(PreparedStatement preparedStatement) throws SQLException {
        ResultSet resultSet = null;
        String string = null;
        SQLException sQLException = null;
        try {
            try {
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                string = resultSet.getString(1);
                resultSet.close();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            preparedStatement.close();
            if (sQLException != null) {
                throw sQLException;
            }
            throw throwable;
        }
        preparedStatement.close();
        if (sQLException != null) {
            throw sQLException;
        }
        return string;
    }

    private void setStringParam(PreparedStatement preparedStatement, String string, int n) throws SQLException {
        if (string == null) {
            preparedStatement.setNull(n, 12);
        } else {
            preparedStatement.setString(n, string);
        }
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 3);
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 7);
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 4);
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 8);
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 6);
    }

    private boolean supportForResultSetType(String string, int n) throws SQLException {
        boolean bl = false;
        PreparedStatement preparedStatement = this.getMetaDataAccessor(string);
        switch (n) {
            case 1003: {
                bl = this.returnBoolean(preparedStatement, 1);
                break;
            }
            case 1004: {
                bl = this.returnBoolean(preparedStatement, 2);
                break;
            }
            case 1005: {
                bl = this.returnBoolean(preparedStatement, 3);
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0SP", String.valueOf(n));
            }
        }
        return bl;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ANSI92LEVEL);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ANSI92LEVEL);
        return this.returnBoolean(preparedStatement, 3);
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ANSI92LEVEL);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ALTERTABLESUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ALTERTABLESUPPORT);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsBatchUpdates() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SUPPORTSBATCHUPDATES);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSUPPORT);
        return this.returnBoolean(preparedStatement, 4);
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSUPPORT);
        return this.returnBoolean(preparedStatement, 5);
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSUPPORT);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSUPPORT);
        return this.returnBoolean(preparedStatement, 3);
    }

    public boolean supportsColumnAliasing() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNALIASING);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsConvert() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CONVERTSUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CONVERTMAP);
        preparedStatement.setInt(1, n);
        preparedStatement.setInt(2, n2);
        ResultSet resultSet = preparedStatement.executeQuery();
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SQLGRAMMAR);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SUBQUERIES);
        return this.returnBoolean(preparedStatement, 5);
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONDATADEFINFO);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONDATADEFINFO);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CORRELATIONNAMES);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ORDERBYSUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SQLGRAMMAR);
        return this.returnBoolean(preparedStatement, 3);
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(OUTERJOINS);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsGroupBy() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(GROUPBYSUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(GROUPBYSUPPORT);
        return this.returnBoolean(preparedStatement, 3);
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(GROUPBYSUPPORT);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(INTEGRITYENHANCEMENT);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(LIKEESCAPECLAUSE);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(OUTERJOINS);
        return this.returnBoolean(preparedStatement, 3);
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SQLGRAMMAR);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 5);
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MULTIPLERESULTSETS);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MULTIPLETRANSACTIONS);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(NONNULLABLECOLUMNS);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CURSORTRANSACTIONS);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CURSORTRANSACTIONS);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(STATEMENTTRANSACTIONS);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(STATEMENTTRANSACTIONS);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ORDERBYSUPPORT);
        return this.returnBoolean(preparedStatement, 2);
    }

    protected boolean supportsOuterJoinEscapeSyntax() throws SQLException {
        if (this._mda._version < 1) {
            return this.getDatabaseProductName().equals("Sybase SQL Anywhere");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(OUTERJOINS);
        return this.returnBoolean(preparedStatement, 4);
    }

    public boolean supportsOuterJoins() throws SQLException {
        if (this._outerJoinEscapeSupport == -1) {
            PreparedStatement preparedStatement = this.getMetaDataAccessor(OUTERJOINS);
            this._outerJoinEscapeSupport = this.returnBoolean(preparedStatement, 1) ? 1 : 0;
        }
        return this._outerJoinEscapeSupport == 1;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(POSITIONEDDELETE);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(POSITIONEDUPDATE);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        switch (n2) {
            case 1007: {
                return this.supportForResultSetType(READONLYCONCURRENCY, n);
            }
            case 1008: {
                return this.supportForResultSetType(UPDATABLECONCURRENCY, n);
            }
        }
        ErrorMessage.raiseError("JZ0SO", String.valueOf(n2));
        return false;
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        return this.supportForResultSetType(SUPPORTSRESULTSETTYPE, n);
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMASUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMASUPPORT);
        return this.returnBoolean(preparedStatement, 4);
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMASUPPORT);
        return this.returnBoolean(preparedStatement, 5);
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMASUPPORT);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMASUPPORT);
        return this.returnBoolean(preparedStatement, 3);
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SELECTFORUPDATE);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsStoredProcedures() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(STOREDPROCEDURES);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SUBQUERIES);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SUBQUERIES);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SUBQUERIES);
        return this.returnBoolean(preparedStatement, 3);
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SUBQUERIES);
        return this.returnBoolean(preparedStatement, 4);
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CORRELATIONNAMES);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONLEVELS);
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl = false;
        SQLException sQLException = null;
        try {
            try {
                if (resultSet.next()) {
                    int n2 = resultSet.getMetaData().getColumnCount();
                    int n3 = 1;
                    while (n3 <= n2) {
                        if (resultSet.getInt(n3) == n) {
                            bl = true;
                        }
                        ++n3;
                    }
                }
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            resultSet.close();
            preparedStatement.close();
            throw throwable;
        }
        resultSet.close();
        preparedStatement.close();
        return bl;
    }

    public boolean supportsTransactions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONSUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsUnion() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(UNIONSUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsUnionAll() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(UNIONSUPPORT);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        return this.supportForResultSetType(UPDATESAREDETECTED, n);
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(FILEUSAGE);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean usesLocalFiles() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(FILEUSAGE);
        return this.returnBoolean(preparedStatement, 1);
    }
}

