/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.MetaDataAccessor;
import com.sybase.jdbc2.jdbc.ProtocolContext;
import com.sybase.jdbc2.jdbc.SybCallableStatement;
import com.sybase.jdbc2.jdbc.SybConnection;
import com.sybase.jdbc2.jdbc.SybLiteral;
import com.sybase.jdbc2.jdbc.SybStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Hashtable;

public class MdaManager {
    protected int _prependDBName;
    public static final int MDA_VERSION_REQUEST = 0;
    public static final int MDA_JDBC_FULL_REQUEST = 1;
    public static final int MDA_JDBC_MINIMAL_REQUEST = 2;
    private static final String FUNCTIONCALL = "FUNCTIONCALL";
    public static final String CONNECTCONFIG = "CONNECTCONFIG";
    public static final String SET_CATALOG = "SET_CATALOG";
    public static final String GET_CATALOG = "GET_CATALOG";
    public static final String COLUMNTYPENAME = "COLUMNTYPENAME";
    public static final String GET_AUTOCOMMIT = "GET_AUTOCOMMIT";
    public static final String SET_AUTOCOMMIT_ON = "SET_AUTOCOMMIT_ON";
    public static final String SET_AUTOCOMMIT_OFF = "SET_AUTOCOMMIT_OFF";
    public static final String SET_ISOLATION = "SET_ISOLATION";
    public static final String GET_ISOLATION = "GET_ISOLATION";
    public static final String SET_ROWCOUNT = "SET_ROWCOUNT";
    public static final String GET_READONLY = "GET_READONLY";
    public static final String SET_READONLY_TRUE = "SET_READONLY_TRUE";
    public static final String SET_READONLY_FALSE = "SET_READONLY_FALSE";
    public static final String ISREADONLY = "ISREADONLY";
    public static final String MDAVERSION = "MDAVERSION";
    public static final String PREPEND_DB_NAME = "PREPEND_DB_NAME";
    public static final int BASELINE_VERSION = 0;
    public static final int MDA_VER_COMPLIANT = 4;
    public static final int HIGHEST_VERSION = 6;
    public static final int OUTERJOIN_VERSION = 1;
    public static final String DEFAULT_CHARSET = "DEFAULT_CHARSET";
    private SybConnection _conn;
    private Hashtable _functionMapTable;
    private Hashtable _metaDataAccess;
    protected int _version;
    protected int _requestedVersion;

    MdaManager(SybConnection sybConnection, int n, ProtocolContext protocolContext) throws SQLException {
        block10: {
            this._functionMapTable = null;
            this._metaDataAccess = null;
            this._conn = sybConnection;
            this._version = 0;
            this._requestedVersion = n;
            this._conn._protocol.getSendLock(protocolContext);
            try {
                this.loadMetaData(protocolContext);
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    preparedStatement = this.getMetaDataAccessor(MDAVERSION, protocolContext);
                    resultSet = preparedStatement.executeQuery();
                    resultSet.next();
                    this._version = resultSet.getInt(1);
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
                try {
                    preparedStatement = this.getMetaDataAccessor(PREPEND_DB_NAME, protocolContext);
                    resultSet = preparedStatement.executeQuery();
                    resultSet.next();
                    this._prependDBName = resultSet.getInt(1);
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    this._prependDBName = 0;
                }
                Object var5_7 = null;
                this._conn._protocol.freeSendLock(protocolContext);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this._conn._protocol.freeSendLock(protocolContext);
                throw throwable;
            }
            if (this._version != 0 && (this._requestedVersion < 4 || this._version >= this._requestedVersion)) break block10;
            try {
                ErrorMessage.raiseWarning("010SL");
            }
            catch (SQLWarning sQLWarning) {
                this._conn.handleSQLE(sQLWarning);
            }
        }
    }

    MdaManager(SybConnection sybConnection, ProtocolContext protocolContext) throws SQLException {
        this(sybConnection, 6, protocolContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized String getFunctionMap(String string, ProtocolContext protocolContext) throws SQLException {
        if (this._functionMapTable != null) return (String)this._functionMapTable.get(string);
        this._functionMapTable = new Hashtable();
        Object object = null;
        try {
            try {
                object = this.getMetaDataAccessor(FUNCTIONCALL, protocolContext);
                ResultSet resultSet = object.executeQuery();
                while (resultSet.next()) {
                    String string2 = resultSet.getString(1).trim();
                    String string3 = resultSet.getString(2).trim();
                    this._functionMapTable.put(string2, string3);
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                ErrorMessage.raiseError("JZ0SH");
            }
            Object var5_8 = null;
            if (object == null) return (String)this._functionMapTable.get(string);
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (object == null) throw throwable;
            object.close();
            throw throwable;
        }
        object.close();
        return (String)this._functionMapTable.get(string);
    }

    public PreparedStatement getMetaDataAccessor(String string, ProtocolContext protocolContext) throws SQLException {
        return this.getMetaDataAccessor(string, "", protocolContext);
    }

    public PreparedStatement getMetaDataAccessor(String string, String string2, ProtocolContext protocolContext) throws SQLException {
        return this.getMetaDataAccessor(string, string2, null, protocolContext);
    }

    public PreparedStatement getMetaDataAccessor(String string, String string2, String string3, ProtocolContext protocolContext) throws SQLException {
        MetaDataAccessor metaDataAccessor;
        if (this._metaDataAccess == null) {
            ErrorMessage.raiseError("JZ0SJ");
        }
        if ((metaDataAccessor = (MetaDataAccessor)this._metaDataAccess.get(string)) == null) {
            ErrorMessage.raiseError("JZ0SJ");
        }
        if (metaDataAccessor._queryType == 3) {
            ErrorMessage.raiseWarning("010SK", string);
        }
        PreparedStatement preparedStatement = null;
        switch (metaDataAccessor._queryType) {
            case 1: {
                if (string3 != null && this._prependDBName == 1) {
                    preparedStatement = this._conn.prepareCall("{call " + string3 + ".." + metaDataAccessor._query + "}" + string2);
                    break;
                }
                preparedStatement = this._conn.prepareCall("{call " + metaDataAccessor._query + "}" + string2);
                break;
            }
            case 2: {
                preparedStatement = this._conn.prepareStatement(String.valueOf(metaDataAccessor._query) + string2, false);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                preparedStatement = new SybLiteral(metaDataAccessor._query, metaDataAccessor._queryType);
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0SJ");
            }
        }
        if (!(preparedStatement instanceof SybLiteral)) {
            SybStatement sybStatement = (SybStatement)((Object)preparedStatement);
            sybStatement._context.setSponsor(protocolContext);
        }
        return preparedStatement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadMetaData(ProtocolContext protocolContext) throws SQLException {
        if (this._metaDataAccess == null) {
            this._metaDataAccess = new Hashtable();
        }
        SybCallableStatement sybCallableStatement = null;
        try {
            try {
                ResultSet resultSet;
                sybCallableStatement = (SybCallableStatement)this._conn.prepareCall("{call sp_mda(?,?)}");
                sybCallableStatement._context.setSponsor(protocolContext);
                sybCallableStatement.setInt(1, 1);
                sybCallableStatement.setInt(2, this._requestedVersion);
                try {
                    resultSet = sybCallableStatement.executeQuery();
                }
                catch (SQLException sQLException) {
                    if (sybCallableStatement != null) {
                        sybCallableStatement.close();
                    }
                    sybCallableStatement = (SybCallableStatement)this._conn.prepareCall("{call dba.sp_mda(?,?)}");
                    sybCallableStatement._context.setSponsor(protocolContext);
                    sybCallableStatement.setInt(1, 1);
                    sybCallableStatement.setInt(2, this._requestedVersion);
                    resultSet = sybCallableStatement.executeQuery();
                }
                while (resultSet.next()) {
                    String string = resultSet.getString(1).trim();
                    int n = resultSet.getInt(2);
                    String string2 = resultSet.getString(3);
                    MetaDataAccessor metaDataAccessor = new MetaDataAccessor(n, string2);
                    this._metaDataAccess.put(string, metaDataAccessor);
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                ErrorMessage.raiseError("JZ0SJ");
            }
            Object var4_9 = null;
            if (sybCallableStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            if (sybCallableStatement == null) throw throwable;
            sybCallableStatement.close();
            throw throwable;
        }
        sybCallableStatement.close();
    }
}

