/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers.ktree;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.util.Vector;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.helpers.ktree.ITreeNode;
import org.tigr.microarray.mev.cluster.gui.helpers.ktree.ITreeNodeRenderer;

public class Ktree
extends JPanel {
    private ITreeNode[][] nodes;
    private ITreeNode root;
    private int xMargin = 15;
    private int yMargin = 15;
    private int maxWidth = 0;
    private int interNodeHeight = 40;
    private int interNodeWidth = 15;
    private boolean nodeSelected = false;
    private boolean isStraitConnector = false;
    Vector selectedPathNodes;
    ITreeNode selectedNode;
    boolean isNodeSelected;

    public Ktree(ITreeNode iTreeNode) {
        this.nodes = new ITreeNode[1][1];
        this.nodes[0][0] = iTreeNode;
        this.root = iTreeNode;
        this.selectedPathNodes = new Vector();
        this.init();
    }

    public Ktree(ITreeNode[][] iTreeNodeArray) {
        this.nodes = iTreeNodeArray;
        this.root = this.nodes[0][0];
        this.selectedPathNodes = new Vector();
        this.init();
    }

    public Ktree(Vector[] vectorArray) {
        this.init();
        this.selectedPathNodes = new Vector();
    }

    private void init() {
        this.setBackground(Color.white);
        this.updateSize();
    }

    public boolean addNode(ITreeNode[] iTreeNodeArray, ITreeNode iTreeNode, int n) {
        return true;
    }

    public boolean deleteNode(ITreeNode iTreeNode) {
        return true;
    }

    public void setNodes(ITreeNode[][] iTreeNodeArray) {
        this.nodes = iTreeNodeArray;
    }

    private void minimizeBranchingOverlap() {
    }

    public ITreeNode getRoot() {
        return this.root;
    }

    public int getMaxLevelWidth() {
        int n = -1;
        for (int i = 0; i < this.nodes.length; ++i) {
            n = Math.max(n, this.nodes[i].length);
        }
        this.maxWidth = n;
        return n;
    }

    public Vector getSelectedPathNodes() {
        return this.selectedPathNodes;
    }

    public int getTreePixelWidth() {
        int n = this.getMaxLevelWidth();
        int n2 = 2 * this.xMargin + n * (this.interNodeWidth + this.nodes[0][0].getWidth()) - this.interNodeWidth;
        return n2;
    }

    public int getTreePixelHeight() {
        int n = this.nodes.length;
        int n2 = 2 * this.xMargin + n * (this.interNodeHeight + this.nodes[0][0].getHeight()) - this.interNodeHeight;
        return n2;
    }

    public void setStraitConnectorStyle(boolean bl) {
        this.isStraitConnector = bl;
    }

    public void setInterNodeHeight(int n) {
        this.interNodeHeight = n;
    }

    public void setInterNodeWidth(int n) {
        this.interNodeWidth = n;
    }

    public void setSelectedNode(ITreeNode iTreeNode) {
        this.selectedNode = iTreeNode;
        this.isNodeSelected = true;
    }

    public void setSelectionPaths(Vector vector) {
        this.selectedPathNodes = vector;
    }

    public void clearSelection() {
        this.isNodeSelected = false;
        this.selectedPathNodes = new Vector();
    }

    public boolean checkSelection(int n, int n2, int n3) {
        this.selectedNode = this.getSelectedNode(n, n2);
        if (this.selectedNode == null) {
            this.clearSelection();
            return false;
        }
        this.isNodeSelected = true;
        this.setSelectionPaths(this.getPathNodes(this.selectedNode, n3));
        return true;
    }

    public ITreeNode getSelectedNode() {
        return this.selectedNode;
    }

    private ITreeNode getSelectedNode(int n, int n2) {
        ITreeNode iTreeNode = null;
        int n3 = (n2 - this.yMargin) / (this.interNodeHeight + this.nodes[0][0].getHeight());
        if (n3 < 0 || n3 >= this.nodes.length) {
            return null;
        }
        for (int i = 0; i < this.nodes[n3].length; ++i) {
            if (!this.nodes[n3][i].contains(n, n2)) continue;
            iTreeNode = this.nodes[n3][i];
            break;
        }
        return iTreeNode;
    }

    public Vector getPathNodes(ITreeNode iTreeNode, int n) {
        if (n == 0) {
            Vector<ITreeNode> vector = new Vector<ITreeNode>();
            Vector vector2 = new Vector();
            vector.addElement(iTreeNode);
            iTreeNode.getAncestors(vector);
            iTreeNode.getSuccessors(vector2);
            for (int i = 0; i < vector2.size(); ++i) {
                vector.addElement((ITreeNode)vector2.elementAt(i));
            }
            return vector;
        }
        if (n == 1) {
            Vector<ITreeNode> vector = new Vector<ITreeNode>();
            vector.addElement(iTreeNode);
            iTreeNode.getAncestors(vector);
            return vector;
        }
        if (n == 2) {
            Vector<ITreeNode> vector = new Vector<ITreeNode>();
            vector.addElement(iTreeNode);
            iTreeNode.getSuccessors(vector);
            return vector;
        }
        return new Vector();
    }

    public void updateSize() {
        int n = this.getTreePixelWidth();
        int n2 = this.getTreePixelHeight();
        this.setPreferredSize(new Dimension(n, n2));
        this.setSize(n, n2);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.root.getWidth();
        int n2 = this.root.getHeight();
        int n3 = this.maxWidth * (n + this.interNodeWidth) - this.interNodeWidth;
        int n4 = this.xMargin + (n3 - n) / 2;
        int n5 = this.yMargin;
        boolean bl = false;
        if (this.selectedNode != null && this.selectedNode == this.nodes[0][0]) {
            ((ITreeNodeRenderer)((Object)this.nodes[0][0])).renderNode(graphics2D, n4, n5, 1);
        } else if (this.selectedPathNodes.contains(this.nodes[0][0])) {
            ((ITreeNodeRenderer)((Object)this.nodes[0][0])).renderNode(graphics2D, n4, n5, 2);
        } else if (this.selectedNode != null) {
            ((ITreeNodeRenderer)((Object)this.nodes[0][0])).renderNode(graphics2D, n4, n5, 3);
        } else {
            ((ITreeNodeRenderer)((Object)this.nodes[0][0])).renderNode(graphics2D, n4, n5, 0);
        }
        for (int i = 1; i < this.nodes.length; ++i) {
            n5 += n2 + this.interNodeHeight;
            int n6 = this.nodes[i].length * (n + this.interNodeWidth) - this.interNodeWidth;
            n4 = this.xMargin + (n3 - n6) / 2;
            for (int j = 0; j < this.nodes[i].length; ++j) {
                if (this.selectedNode != null && this.selectedNode == this.nodes[i][j]) {
                    ((ITreeNodeRenderer)((Object)this.nodes[i][j])).renderNode(graphics2D, n4, n5, 1);
                } else if (this.selectedPathNodes.contains(this.nodes[i][j])) {
                    ((ITreeNodeRenderer)((Object)this.nodes[i][j])).renderNode(graphics2D, n4, n5, 2);
                } else if (this.selectedNode != null) {
                    ((ITreeNodeRenderer)((Object)this.nodes[i][j])).renderNode(graphics2D, n4, n5, 3);
                } else {
                    ((ITreeNodeRenderer)((Object)this.nodes[i][j])).renderNode(graphics2D, n4, n5, 0);
                }
                n4 += n + this.interNodeWidth;
            }
        }
        this.renderConnectors(graphics);
    }

    private void renderConnectors(Graphics graphics) {
        boolean bl = false;
        Color color = graphics.getColor();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        for (int i = 0; i < this.nodes.length; ++i) {
            ITreeNode iTreeNode;
            ITreeNode[] iTreeNodeArray;
            for (int j = 0; j < this.nodes[i].length && (iTreeNodeArray = (iTreeNode = this.nodes[i][j]).getChildren()) != null; ++j) {
                Point point = iTreeNode.getBottomAnchorPoint();
                for (int k = 0; k < iTreeNodeArray.length; ++k) {
                    Object object;
                    bl = false;
                    if (this.selectedPathNodes.contains(iTreeNode) && this.selectedPathNodes.contains(iTreeNodeArray[k])) {
                        bl = true;
                        graphics.setColor(Color.blue);
                    } else if (this.selectedPathNodes.size() != 0) {
                        object = AlphaComposite.getInstance(3, 0.3f);
                        graphics2D.setComposite((Composite)object);
                    }
                    Point point2 = iTreeNodeArray[k].getTopAnchorPoint();
                    if (!this.isStraitConnector) {
                        object = new CubicCurve2D.Double(point.x, point.y, point.x, point.y + 15, point2.x, point2.y - 15, point2.x, point2.y);
                        graphics2D.draw((Shape)object);
                        if (bl) {
                            object = new CubicCurve2D.Double(point.x + 1, point.y, point.x + 1, point.y + 16, point2.x + 1, point2.y - 16, point2.x + 1, point2.y);
                            graphics2D.draw((Shape)object);
                        }
                    } else {
                        graphics.drawLine(point.x, point.y, point2.x, point2.y);
                        if (bl) {
                            graphics.drawLine(point.x + 1, point.y, point2.x + 1, point2.y);
                        }
                    }
                    if (bl) {
                        graphics.setColor(color);
                    }
                    graphics2D.setComposite(composite);
                }
            }
        }
    }

    public static void main(String[] stringArray) {
    }
}

