/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.AnnotationURLLinkDialog;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileFilter;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileView;
import org.tigr.util.BrowserLauncher;
import org.tigr.util.StringSplitter;

public class ExperimentUtil {
    public static final int INTEGER_TYPE = 10;
    public static final int FLOAT_TYPE = 11;
    public static final int DOUBLE_TYPE = 12;
    public static final int STRING_TYPE = 13;
    public static final int BOOLEAN_TYPE = 14;
    public static int[] lastSelectedAnnotationIndices = new int[]{0, 0};

    public static void saveExperiment(Frame frame, Experiment experiment, IData iData) throws Exception {
        ExperimentUtil.saveExperiment(frame, experiment, iData, ExperimentUtil.createDefaultRows(experiment.getNumberOfGenes()));
    }

    public static void saveExperiment(Frame frame, IData iData, int[] nArray) throws Exception {
        ExperimentUtil.saveExperiment(frame, iData.getExperiment(), iData, nArray);
    }

    public static void saveExperiment(Frame frame, Experiment experiment, IData iData, int[] nArray) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            ExperimentUtil.saveCluster(file, experiment, iData, nArray);
        }
    }

    public static void saveExperiment(Frame frame, Experiment experiment, IData iData, int[][] nArray) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            String string = file.getPath();
            int n = string.lastIndexOf(".txt");
            if (n > 0) {
                string = string.substring(0, n);
                file = new File(string);
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == null || nArray[i].length == 0) continue;
                File file2 = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                ExperimentUtil.saveCluster(file2, experiment, iData, nArray[i]);
            }
        }
    }

    public static void saveAllGeneClustersWithAux(Frame frame, Experiment experiment, IData iData, int[][] nArray, String[] stringArray, Object[][] objectArray) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == null || nArray[i].length == 0) continue;
                File file2 = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                ExperimentUtil.saveGeneClusterWithAux(file2, experiment, iData, nArray[i], stringArray, objectArray);
            }
        }
    }

    private static void saveGeneClusterWithAux(File file, Experiment experiment, IData iData, int[] nArray, String[] stringArray, Object[][] objectArray) throws Exception {
        int n;
        int n2;
        int[] nArray2 = ExperimentUtil.getTypes(objectArray);
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        String[] stringArray2 = iData.getFieldNames();
        if (stringArray2 == null) {
            return;
        }
        printWriter.print("Original row");
        printWriter.print("\t");
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            printWriter.print(stringArray2[n2]);
            if (n2 >= stringArray2.length - 1) continue;
            printWriter.print("\t");
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            printWriter.print("\t" + stringArray[n2]);
        }
        for (n2 = 0; n2 < experiment.getNumberOfSamples(); ++n2) {
            printWriter.print("\t");
            printWriter.print(iData.getSampleAnnotation(n2, "Default Slide Name"));
        }
        printWriter.print("\n");
        Vector vector = iData.getSampleAnnotationFieldNames();
        for (n = 1; n < vector.size(); ++n) {
            int n3;
            String string = new String();
            for (n3 = 0; n3 < stringArray2.length + stringArray.length; ++n3) {
                string = string + "\t";
            }
            String string2 = (String)vector.elementAt(n);
            string = string + string2 + "\t";
            for (n3 = 0; n3 < iData.getFeaturesCount(); ++n3) {
                string = string + iData.getSampleAnnotation(n3, string2);
                string = n3 != iData.getFeaturesCount() - 1 ? string + "\t" : string + "\n";
            }
            printWriter.print(string);
        }
        for (n = 0; n < nArray.length; ++n) {
            int n4;
            printWriter.print(Integer.toString(experiment.getGeneIndexMappedToData(nArray[n]) + 1));
            printWriter.print("\t");
            for (n4 = 0; n4 < stringArray2.length; ++n4) {
                printWriter.print(iData.getElementAttribute(experiment.getGeneIndexMappedToData(nArray[n]), n4));
                if (n4 >= stringArray2.length - 1) continue;
                printWriter.print("\t");
            }
            for (n4 = 0; n4 < objectArray[0].length; ++n4) {
                printWriter.print("\t");
                ExperimentUtil.printDataType(printWriter, objectArray[nArray[n]][n4], nArray2[n4]);
            }
            for (n4 = 0; n4 < experiment.getNumberOfSamples(); ++n4) {
                printWriter.print("\t");
                printWriter.print(Float.toString(experiment.get(nArray[n], n4)));
            }
            printWriter.print("\n");
        }
        printWriter.flush();
        printWriter.close();
    }

    private static File getFile(Frame frame) {
        String string = TMEV.getDataPath();
        File file = TMEV.getFile((String)"data/");
        if (string != null) {
            file = new File(string);
            if (!file.exists()) {
                file = TMEV.getFile((String)"data/");
            }
        } else {
            System.out.println("null data path");
        }
        File file2 = null;
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.addChoosableFileFilter(new ExpressionFileFilter());
        jFileChooser.setFileView(new ExpressionFileView());
        int n = jFileChooser.showSaveDialog(frame);
        if (n != 0) {
            return null;
        }
        file2 = jFileChooser.getSelectedFile();
        String string2 = file2.getName();
        int n2 = string2.lastIndexOf(".");
        if (n2 < 0 || string2.length() - 1 - n2 != 3) {
            file2 = new File(file2.getPath() + ".txt");
        }
        TMEV.updateDataPath((String)ExperimentUtil.formatDataPath(file2.getPath()));
        TMEV.setDataPath((String)file2.getParent());
        return file2;
    }

    private static String formatDataPath(String string) {
        if (string == null) {
            return " ";
        }
        String string2 = "/";
        String string3 = new String();
        String string4 = System.getProperty("file.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string4);
        String string5 = new String();
        while (stringTokenizer.hasMoreTokens() && stringTokenizer.countTokens() > 1) {
            String string6 = stringTokenizer.nextToken();
            string3 = string3 + string6 + string2;
            string5 = string5 + string6 + string4;
        }
        return string3;
    }

    public static void saveGeneCluster(Frame frame, IData iData, int[] nArray) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            ExperimentUtil.saveGeneCluster(file, iData, nArray);
        }
    }

    private static void saveGeneCluster(File file, IData iData, int[] nArray) throws Exception {
        int n;
        int n2;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        String[] stringArray = iData.getFieldNames();
        if (stringArray == null) {
            return;
        }
        printWriter.print("Original row");
        printWriter.print("\t");
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            printWriter.print(stringArray[n2]);
            if (n2 >= stringArray.length - 1) continue;
            printWriter.print("\t");
        }
        for (n2 = 0; n2 < iData.getFeaturesCount(); ++n2) {
            printWriter.print("\t");
            printWriter.print(iData.getSampleAnnotation(n2, "Default Slide Name"));
        }
        printWriter.print("\n");
        Vector vector = iData.getSampleAnnotationFieldNames();
        for (n = 1; n < vector.size(); ++n) {
            int n3;
            String string = new String();
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                string = string + "\t";
            }
            String string2 = (String)vector.elementAt(n);
            string = string + string2 + "\t";
            for (n3 = 0; n3 < iData.getFeaturesCount(); ++n3) {
                string = string + iData.getSampleAnnotation(n3, string2);
                string = n3 != iData.getFeaturesCount() - 1 ? string + "\t" : string + "\n";
            }
            printWriter.print(string);
        }
        for (n = 0; n < nArray.length; ++n) {
            int n4;
            printWriter.print(Integer.toString(nArray[n] + 1));
            printWriter.print("\t");
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                printWriter.print(iData.getElementAttribute(nArray[n], n4));
                if (n4 >= stringArray.length - 1) continue;
                printWriter.print("\t");
            }
            for (n4 = 0; n4 < iData.getFeaturesCount(); ++n4) {
                printWriter.print("\t");
                printWriter.print(Float.toString(iData.getRatio(n4, nArray[n], 1)));
            }
            printWriter.print("\n");
        }
        printWriter.flush();
        printWriter.close();
    }

    public static void saveGeneClusterWithAux(Frame frame, Experiment experiment, IData iData, int[] nArray, String[] stringArray, Object[][] objectArray) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            ExperimentUtil.saveGeneClusterWithAux(file, experiment, iData, nArray, stringArray, objectArray);
        }
    }

    private static void saveCluster(File file, Experiment experiment, IData iData, int[] nArray) throws Exception {
        int n;
        int n2;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        String[] stringArray = iData.getFieldNames();
        if (stringArray == null) {
            return;
        }
        printWriter.print("Original row");
        printWriter.print("\t");
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            printWriter.print(stringArray[n2]);
            if (n2 >= stringArray.length - 1) continue;
            printWriter.print("\t");
        }
        for (n2 = 0; n2 < experiment.getNumberOfSamples(); ++n2) {
            printWriter.print("\t");
            printWriter.print(iData.getSampleAnnotation(n2, "Default Slide Name"));
        }
        printWriter.print("\n");
        Vector vector = iData.getSampleAnnotationFieldNames();
        for (n = 1; n < vector.size(); ++n) {
            int n3;
            String string = new String();
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                string = string + "\t";
            }
            String string2 = (String)vector.elementAt(n);
            string = string + string2 + "\t";
            for (n3 = 0; n3 < iData.getFeaturesCount(); ++n3) {
                string = string + iData.getSampleAnnotation(n3, string2);
                string = n3 != iData.getFeaturesCount() - 1 ? string + "\t" : string + "\n";
            }
            printWriter.print(string);
        }
        for (n = 0; n < nArray.length; ++n) {
            int n4;
            printWriter.print(Integer.toString(experiment.getGeneIndexMappedToData(nArray[n]) + 1));
            printWriter.print("\t");
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                printWriter.print(iData.getElementAttribute(experiment.getGeneIndexMappedToData(nArray[n]), n4));
                if (n4 >= stringArray.length - 1) continue;
                printWriter.print("\t");
            }
            for (n4 = 0; n4 < experiment.getNumberOfSamples(); ++n4) {
                printWriter.print("\t");
                printWriter.print(Float.toString(experiment.get(nArray[n], n4)));
            }
            printWriter.print("\n");
        }
        printWriter.flush();
        printWriter.close();
    }

    public static void saveExperimentCluster(Frame frame, Experiment experiment, IData iData, int[] nArray) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            ExperimentUtil.saveExperimentCluster(file, experiment, iData, nArray);
        }
    }

    public static void saveAllExperimentClusters(Frame frame, Experiment experiment, IData iData, int[][] nArray) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == null || nArray[i].length == 0) continue;
                File file2 = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                ExperimentUtil.saveExperimentCluster(file2, experiment, iData, nArray[i]);
            }
        }
    }

    public static void saveAllExperimentClustersWithAux(Frame frame, Experiment experiment, IData iData, int[][] nArray, String[] stringArray, Object[][] objectArray) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == null || nArray[i].length == 0) continue;
                File file2 = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                ExperimentUtil.saveExperimentClusterWithAux(file2, experiment, iData, nArray[i], stringArray, objectArray);
            }
        }
    }

    public static void saveExperimentClusterWithAux(Frame frame, Experiment experiment, IData iData, int[] nArray, String[] stringArray, Object[][] objectArray) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            ExperimentUtil.saveExperimentClusterWithAux(file, experiment, iData, nArray, stringArray, objectArray);
        }
    }

    private static void saveExperimentClusterWithAux(File file, Experiment experiment, IData iData, int[] nArray, String[] stringArray, Object[][] objectArray) throws Exception {
        int n;
        int n2;
        int[] nArray2 = ExperimentUtil.getTypes(objectArray);
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        String[] stringArray2 = iData.getFieldNames();
        int n3 = experiment.getNumberOfGenes();
        printWriter.print("Original row");
        printWriter.print("\t");
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            printWriter.print(stringArray2[n2]);
            if (n2 >= stringArray2.length - 1) continue;
            printWriter.print("\t");
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            printWriter.print("\t");
            printWriter.print(iData.getSampleAnnotation(experiment.getSampleIndex(nArray[n2]), "Default Slide Name"));
        }
        printWriter.print("\n");
        Vector vector = iData.getSampleAnnotationFieldNames();
        for (n = 1; n < vector.size(); ++n) {
            int n4;
            String string = new String();
            for (n4 = 0; n4 < stringArray2.length; ++n4) {
                string = string + "\t";
            }
            String string2 = (String)vector.elementAt(n);
            string = string + string2 + "\t";
            for (n4 = 0; n4 < nArray.length; ++n4) {
                string = string + iData.getSampleAnnotation(experiment.getSampleIndex(nArray[n4]), string2);
                string = n4 != nArray.length - 1 ? string + "\t" : string + "\n";
            }
            printWriter.print(string);
        }
        for (n = 0; n < stringArray.length; ++n) {
            int n5;
            printWriter.print(stringArray[n] + "\t");
            for (n5 = 0; n5 < stringArray2.length; ++n5) {
                printWriter.print("\t");
            }
            for (n5 = 0; n5 < nArray.length; ++n5) {
                ExperimentUtil.printDataType(printWriter, objectArray[nArray[n5]][n], nArray2[n]);
                if (n5 >= nArray.length - 1) continue;
                printWriter.print("\t");
            }
            printWriter.print("\n");
        }
        for (n = 0; n < n3; ++n) {
            int n6;
            printWriter.print(Integer.toString(experiment.getGeneIndexMappedToData(n) + 1));
            printWriter.print("\t");
            for (n6 = 0; n6 < stringArray2.length; ++n6) {
                printWriter.print(iData.getElementAttribute(experiment.getGeneIndexMappedToData(n), n6));
                if (n6 >= stringArray2.length - 1) continue;
                printWriter.print("\t");
            }
            for (n6 = 0; n6 < nArray.length; ++n6) {
                printWriter.print("\t");
                printWriter.print(Float.toString(experiment.get(n, experiment.getSampleIndex(nArray[n6]))));
            }
            printWriter.print("\n");
        }
        printWriter.flush();
        printWriter.close();
    }

    private static void saveExperimentCluster(File file, Experiment experiment, IData iData, int[] nArray) throws Exception {
        int n;
        int n2;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        String[] stringArray = iData.getFieldNames();
        int n3 = experiment.getNumberOfGenes();
        printWriter.print("Original row");
        printWriter.print("\t");
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            printWriter.print(stringArray[n2]);
            if (n2 >= stringArray.length - 1) continue;
            printWriter.print("\t");
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            printWriter.print("\t");
            printWriter.print(iData.getSampleAnnotation(experiment.getSampleIndex(nArray[n2]), "Default Slide Name"));
        }
        printWriter.print("\n");
        Vector vector = iData.getSampleAnnotationFieldNames();
        for (n = 1; n < vector.size(); ++n) {
            int n4;
            String string = new String();
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                string = string + "\t";
            }
            String string2 = (String)vector.elementAt(n);
            string = string + string2 + "\t";
            for (n4 = 0; n4 < nArray.length; ++n4) {
                string = string + iData.getSampleAnnotation(experiment.getSampleIndex(nArray[n4]), string2);
                string = n4 != nArray.length - 1 ? string + "\t" : string + "\n";
            }
            printWriter.print(string);
        }
        for (n = 0; n < n3; ++n) {
            int n5;
            printWriter.print(Integer.toString(experiment.getGeneIndexMappedToData(n) + 1));
            printWriter.print("\t");
            for (n5 = 0; n5 < stringArray.length; ++n5) {
                printWriter.print(iData.getElementAttribute(experiment.getGeneIndexMappedToData(n), n5));
                if (n5 >= stringArray.length - 1) continue;
                printWriter.print("\t");
            }
            for (n5 = 0; n5 < nArray.length; ++n5) {
                printWriter.print("\t");
                printWriter.print(Float.toString(experiment.get(n, experiment.getSampleIndex(nArray[n5]))));
            }
            printWriter.print("\n");
        }
        printWriter.flush();
        printWriter.close();
    }

    public static void linkToURL(JFrame jFrame, Experiment experiment, IData iData, int n) {
        try {
            File file = TMEV.getConfigurationFile((String)"annotation_URLs.txt");
            AnnotationURLLinkDialog annotationURLLinkDialog = new AnnotationURLLinkDialog(jFrame, false, experiment, iData, n, file);
            annotationURLLinkDialog.setVisible(true);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new JFrame(), "Could not link to URL! Make sure \"annotation_URLs.txt\" file in \"config\" directory is in correct format", "Error", 0);
        }
    }

    public static void linkToURL(JFrame jFrame, Experiment experiment, IData iData, int n, int[] nArray) {
        try {
            File file = TMEV.getConfigurationFile((String)"annotation_URLs.txt");
            System.out.println("Found annotation file");
            AnnotationURLLinkDialog annotationURLLinkDialog = new AnnotationURLLinkDialog(jFrame, false, experiment, iData, n, file, nArray);
            annotationURLLinkDialog.setVisible(true);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new JFrame(), "Could not link to URL! Make sure \"annotation_URLs.txt\" file in \"config\" directory is in correct format", "Error", 0);
        }
    }

    public static void linkToURL(JFrame jFrame, Experiment experiment, IData iData, int n, String string, int[] nArray) {
        try {
            File file = TMEV.getConfigurationFile((String)"annotation_URLs.txt");
            if (string.equalsIgnoreCase("Stored Color")) {
                JOptionPane.showMessageDialog(new JFrame(), "Cannot link stored color to an URL. Pick a different field to link from", "Error", 0);
            } else {
                String[] stringArray = iData.getFieldNames();
                int n2 = -1;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string.equalsIgnoreCase(stringArray[i])) continue;
                    n2 = i;
                    break;
                }
                String[][] stringArray2 = ExperimentUtil.getAnnotationFieldsFromFile(file);
                String[] stringArray3 = stringArray2[0];
                String[] stringArray4 = stringArray2[1];
                if (ExperimentUtil.isFound(string, stringArray4)) {
                    int n3 = -1;
                    for (int i = 0; i < stringArray4.length; ++i) {
                        if (!string.equalsIgnoreCase(stringArray4[i])) continue;
                        n3 = i;
                        break;
                    }
                    String string2 = stringArray3[n3];
                    String string3 = iData.getElementAttribute(n, n2);
                    String string4 = ExperimentUtil.getCurrentURL(string, string3, string2);
                    try {
                        BrowserLauncher.openURL((String)string4);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(new JFrame(), iOException.toString(), "Error", 0);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(new JFrame(), "Browser could not be launched! Possible problem: the annotation format may not be appropriate for this URL type!", "Error", 0);
                    }
                } else {
                    int[] nArray2 = new int[]{n2, nArray[1]};
                    AnnotationURLLinkDialog annotationURLLinkDialog = new AnnotationURLLinkDialog(jFrame, false, experiment, iData, n, file, nArray2);
                    annotationURLLinkDialog.setVisible(true);
                }
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new JFrame(), "Could not open browser! Possible problems: bad URL, or \"annotation_URLs.txt\" file in \"config\" directory is not in correct format", "Error", 0);
        }
    }

    private static String getCurrentURL(String string, String string2, String string3) {
        String string4 = "";
        if (string.equalsIgnoreCase("UniGene")) {
            String[] stringArray = string2.split("\\.");
            String string5 = string3.replaceAll("FIELD1", stringArray[1]);
            string4 = string5.replaceAll("FIELD2", stringArray[0]);
        } else {
            string4 = string3.replaceAll("FIELD1", string2);
        }
        return string4;
    }

    private static boolean isFound(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private static String[][] getAnnotationFieldsFromFile(File file) {
        String[][] stringArray = new String[2][];
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        try {
            int n;
            String[] stringArray2;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            StringSplitter stringSplitter = new StringSplitter('\t');
            boolean bl = false;
            while (!bl) {
                stringArray2 = bufferedReader.readLine();
                if (stringArray2 == null) {
                    bl = true;
                    continue;
                }
                stringSplitter.init((String)stringArray2);
                vector2.add(stringSplitter.nextToken());
                vector3.add(stringSplitter.nextToken());
            }
            bufferedReader.close();
            stringArray2 = new String[vector3.size()];
            String[] stringArray3 = new String[vector2.size()];
            for (n = 0; n < stringArray2.length; ++n) {
                stringArray2[n] = (String)vector3.get(n);
            }
            for (n = 0; n < stringArray3.length; ++n) {
                stringArray3[n] = (String)vector2.get(n);
            }
            stringArray[0] = stringArray2;
            stringArray[1] = stringArray3;
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(new JFrame(), "Could not find \"annotation_URLs.txt\" file in \"config\" directory", "Error", 0);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new JFrame(), "Incompatible \"annotation_URLs.txt\" file in \"config\" directory! Possible issues: extra newline characters, too many or too few tabs per line", "Error", 0);
        }
        return stringArray;
    }

    private static int[] createDefaultRows(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private static void printDataType(PrintWriter printWriter, Object object, int n) {
        switch (n) {
            case 14: {
                printWriter.print((Boolean)object);
                break;
            }
            case 12: {
                printWriter.print((Double)object);
                break;
            }
            case 11: {
                printWriter.print(((Float)object).floatValue());
                break;
            }
            case 10: {
                printWriter.print((Integer)object);
                break;
            }
            case 13: {
                printWriter.print((String)object);
                break;
            }
            default: {
                printWriter.print(object);
            }
        }
    }

    private static int[] getTypes(Object[][] objectArray) {
        int[] nArray = new int[objectArray[0].length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ExperimentUtil.getObjectType(objectArray[0][i]);
        }
        return nArray;
    }

    private static int getObjectType(Object object) {
        int n = -1;
        if (object instanceof Boolean) {
            return 14;
        }
        if (object instanceof Double) {
            return 12;
        }
        if (object instanceof Float) {
            return 11;
        }
        if (object instanceof Integer) {
            return 10;
        }
        if (object instanceof String) {
            return 13;
        }
        return n;
    }
}

